/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StartupUiUtil;
import com.jetbrains.cidr.execution.debugger.CidrFrameTypeDecorator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxFrameTypeDecoratorKt;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameCache;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameRenderOptions;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameStdTypes;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameSugarizeOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxFrameTypeDecorator;", "Lcom/jetbrains/cidr/execution/debugger/CidrFrameTypeDecorator;", "<init>", "()V", "sugarizeOptions", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameSugarizeOptions;", "getSugarizeOptions", "()Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameSugarizeOptions;", "typeIdRenderOptions", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameRenderOptions;", "getTypeIdRenderOptions", "()Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameRenderOptions;", "frameRenderOptions", "getFrameRenderOptions", "getValueDisplayType", "", "value", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue;", "renderForUiLabel", "", "getFrameFunctionColoredText", "Lcom/intellij/ui/ColoredText;", "frame", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "adjustRenderOptions", "options", "intellij.cidr.debugger.core"})
public final class CxxFrameTypeDecorator
implements CidrFrameTypeDecorator {
    @NotNull
    public static final CxxFrameTypeDecorator INSTANCE = new CxxFrameTypeDecorator();

    private CxxFrameTypeDecorator() {
    }

    private final CxxNameSugarizeOptions getSugarizeOptions() {
        return new CxxNameSugarizeOptions(CxxFrameTypeDecoratorKt.access$getSettings().isSugarizeCxxStlTypes(), CxxFrameTypeDecoratorKt.access$getSettings().isSugarizeCxxStlTypes(), false, 4, null);
    }

    private final CxxNameRenderOptions getTypeIdRenderOptions() {
        CxxNameRenderOptions cxxNameRenderOptions = CxxNameStdTypes.TYPE_ID_RENDER_OPTIONS;
        CxxNameRenderOptions.RenderPolicy renderPolicy = CxxFrameTypeDecoratorKt.access$getSettings().isShowTypeTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy2 = CxxFrameTypeDecoratorKt.access$getSettings().isShowTypeTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.FOLD;
        CxxNameRenderOptions.RenderPolicy renderPolicy3 = CxxFrameTypeDecoratorKt.access$getSettings().isShowTypeTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.FOLD;
        CxxNameRenderOptions.RenderPolicy renderPolicy4 = !CxxFrameTypeDecoratorKt.access$getSettings().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy5 = !CxxFrameTypeDecoratorKt.access$getSettings().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy6 = !CxxFrameTypeDecoratorKt.access$getSettings().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy7 = CxxNameRenderOptions.RenderPolicy.HIDE;
        return CxxNameRenderOptions.copy$default(cxxNameRenderOptions, renderPolicy2, renderPolicy, renderPolicy3, null, null, 0, renderPolicy4, renderPolicy5, renderPolicy6, renderPolicy7, false, null, 3128, null);
    }

    private final CxxNameRenderOptions getFrameRenderOptions() {
        CxxNameRenderOptions.RenderPolicy renderPolicy = CxxFrameTypeDecoratorKt.access$getSettings().isShowFrameFunctionParameters() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy2 = CxxFrameTypeDecoratorKt.access$getSettings().isShowFrameFunctionTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy3 = CxxFrameTypeDecoratorKt.access$getSettings().isShowFrameFunctionTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.FOLD;
        CxxNameRenderOptions.RenderPolicy renderPolicy4 = CxxFrameTypeDecoratorKt.access$getSettings().isShowFrameFunctionTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.FOLD;
        CxxNameRenderOptions.RenderPolicy renderPolicy5 = !CxxFrameTypeDecoratorKt.access$getSettings().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy6 = !CxxFrameTypeDecoratorKt.access$getSettings().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy7 = !CxxFrameTypeDecoratorKt.access$getSettings().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy8 = CxxNameRenderOptions.RenderPolicy.HIDE;
        return new CxxNameRenderOptions(renderPolicy3, renderPolicy2, renderPolicy4, renderPolicy, null, 0, renderPolicy5, renderPolicy6, renderPolicy7, renderPolicy8, false, null, 3120, null);
    }

    @Override
    @NotNull
    public String getValueDisplayType(@NotNull CidrPhysicalValue value, boolean renderForUiLabel) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        CxxNameCache cxxNameCache = CxxNameCache.Companion.getInstance();
        String string = value.getPresentationVar().getDisplayType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayType(...)");
        String string2 = cxxNameCache.renderTypeIdString(string, this.getSugarizeOptions(), this.adjustRenderOptions(this.getTypeIdRenderOptions(), renderForUiLabel));
        if (string2 == null) {
            string2 = CidrFrameTypeDecorator.super.getValueDisplayType(value, renderForUiLabel);
        }
        return string2;
    }

    @Override
    @NotNull
    public ColoredText getFrameFunctionColoredText(@NotNull CidrStackFrame frame, @NotNull SimpleTextAttributes attributes, boolean renderForUiLabel) {
        Intrinsics.checkNotNullParameter((Object)((Object)frame), (String)"frame");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        LLFrame lLFrame = frame.getFrame();
        Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"getFrame(...)");
        LLFrame llFrame = lLFrame;
        if (!llFrame.hasSymbolInfo()) {
            return CidrFrameTypeDecorator.super.getFrameFunctionColoredText(frame, attributes, renderForUiLabel);
        }
        CxxNameCache cxxNameCache = CxxNameCache.Companion.getInstance();
        String string = llFrame.getFunction();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFunction(...)");
        ColoredText coloredText = cxxNameCache.renderStackTraceColoredText(string, this.getSugarizeOptions(), this.adjustRenderOptions(this.getFrameRenderOptions(), renderForUiLabel), attributes);
        if (coloredText == null) {
            coloredText = CidrFrameTypeDecorator.super.getFrameFunctionColoredText(frame, attributes, renderForUiLabel);
        }
        return coloredText;
    }

    private final CxxNameRenderOptions adjustRenderOptions(CxxNameRenderOptions options, boolean renderForUiLabel) {
        boolean alternativePunctuationEnabled = renderForUiLabel && Registry.Companion.is("cidr.debugger.frameTypeDecorator.alternativePunctuation", false);
        return CxxNameRenderOptions.copy$default(options, null, null, null, null, null, 0, null, null, null, null, !renderForUiLabel, alternativePunctuationEnabled ? StartupUiUtil.getLabelFont() : null, 1023, null);
    }
}

