/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.lldb.Replacement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002R6\u0010\u0004\u001a*\u0012&\u0012$\u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\u0006j\u0002`\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBErrorBeautifier;", "", "<init>", "()V", "myEvaluateErrorMessageReplacers", "", "Lkotlin/Pair;", "Ljava/util/regex/Pattern;", "Lkotlin/Function2;", "", "Ljava/util/regex/Matcher;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/Replacement;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/Replacer;", "patchEvaluateMessage", "message", "patchLoadValueMessage", "errorMessage", "logPatchedMessage", "", "context", "newMessage", "intellij.cidr.debugger.core"})
public final class LLDBErrorBeautifier {
    @NotNull
    private final List<Pair<Pattern, Function2<String, Matcher, Replacement>>> myEvaluateErrorMessageReplacers;

    public LLDBErrorBeautifier() {
        List replacers = new ArrayList();
        Collection collection = replacers;
        Pattern pattern = Pattern.compile("^warning: Stopped in a C\\+\\+ method, but 'this' isn't available; pretending we are in a generic context\nerror:");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Pair pair = new Pair((Object)pattern, LLDBErrorBeautifier::_init_$lambda$0);
        collection.add(pair);
        collection = replacers;
        Pattern pattern2 = Pattern.compile("^error: invalid use of 'this' outside of a non-static member function\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        pair = new Pair((Object)pattern2, LLDBErrorBeautifier::_init_$lambda$1);
        collection.add(pair);
        collection = replacers;
        Pattern pattern3 = Pattern.compile("^error: Couldn't materialize: couldn't get the value of variable (\\w+): variable not available");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        pair = new Pair((Object)pattern3, LLDBErrorBeautifier::_init_$lambda$2);
        collection.add(pair);
        collection = replacers;
        Pattern pattern4 = Pattern.compile("^error: no member named '(.+)' in '(.+)'\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        pair = new Pair((Object)pattern4, LLDBErrorBeautifier::_init_$lambda$3);
        collection.add(pair);
        collection = replacers;
        Pattern pattern5 = Pattern.compile("^error: use of undeclared identifier '(.+)'\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern5, (String)"compile(...)");
        pair = new Pair((Object)pattern5, LLDBErrorBeautifier::_init_$lambda$4);
        collection.add(pair);
        collection = replacers;
        Pattern pattern6 = Pattern.compile("^expression failed to parse, fixed expression suggested:\n (.+)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern6, (String)"compile(...)");
        pair = new Pair((Object)pattern6, LLDBErrorBeautifier::_init_$lambda$5);
        collection.add(pair);
        collection = replacers;
        Pattern pattern7 = Pattern.compile("(fixed expression suggested:\n )(.+)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern7, (String)"compile(...)");
        pair = new Pair((Object)pattern7, LLDBErrorBeautifier::_init_$lambda$6);
        collection.add(pair);
        this.myEvaluateErrorMessageReplacers = replacers;
    }

    @NotNull
    public final Replacement patchEvaluateMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        for (Pair<Pattern, Function2<String, Matcher, Replacement>> pair : this.myEvaluateErrorMessageReplacers) {
            Pattern pattern = (Pattern)pair.component1();
            Function2 replacer = (Function2)pair.component2();
            Matcher matcher = pattern.matcher(message);
            if (!matcher.find()) continue;
            Intrinsics.checkNotNull((Object)matcher);
            Replacement replaced = (Replacement)replacer.invoke((Object)message, (Object)matcher);
            this.logPatchedMessage("evaluation", message, replaced.getNewMessage());
            return replaced;
        }
        return new Replacement(message, null, 2, null);
    }

    @NotNull
    public final String patchLoadValueMessage(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (Intrinsics.areEqual((Object)errorMessage, (Object)"variable not available")) {
            return "Variable is not available";
        }
        return errorMessage;
    }

    private final void logPatchedMessage(String context, String message, String newMessage) {
        CidrDebuggerLog.LOG.debug("Masking " + context + " error message '" + message + "' as '" + newMessage + "'");
    }

    private static final Replacement _init_$lambda$0(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"<unused var>");
        return new Replacement("'this' is not available, possibly due to compiler optimizations", null, 2, null);
    }

    private static final Replacement _init_$lambda$1(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"<unused var>");
        return new Replacement("'this' is not available outside of a non-static member function", null, 2, null);
    }

    private static final Replacement _init_$lambda$2(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new Replacement("Variable '" + matcher.group(1) + "' is not available, possibly due to compiler optimizations", null, 2, null);
    }

    private static final Replacement _init_$lambda$3(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new Replacement("Identifier '" + matcher.group(1) + "' is not available in '" + matcher.group(2) + "', possibly due to compiler optimizations", null, 2, null);
    }

    private static final Replacement _init_$lambda$4(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new Replacement("Identifier '" + matcher.group(1) + "' is not available, possibly due to compiler optimizations", null, 2, null);
    }

    private static final Replacement _init_$lambda$5(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String string2 = matcher.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
        String fixedExpr = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return ((CharSequence)fixedExpr).length() == 0 ? new Replacement("Expression failed to parse", null, 2, null) : new Replacement("Expression failed to parse, suggested fix: ", fixedExpr);
    }

    private static final Replacement _init_$lambda$6(String message, Matcher matcher) {
        Replacement replacement;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String string = matcher.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        String fixedExpr = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (((CharSequence)fixedExpr).length() == 0) {
            replacement = new Replacement(message, null, 2, null);
        } else {
            String string2;
            int messageEndPos = matcher.start(1);
            if (messageEndPos < 0) {
                string2 = message;
            } else {
                String string3 = message.substring(0, messageEndPos);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            String errorMessage = string2;
            replacement = new Replacement(errorMessage + "suggested fix: ", fixedExpr);
        }
        return replacement;
    }
}

