/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/ShowInMemoryViewAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "perform", "nodeName", "", "intellij.cidr.debugger.core"})
public final class ShowInMemoryViewAction
extends XDebuggerTreeActionBase
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        XDebugSession currentSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        XDebugSession xDebugSession = currentSession;
        e.getPresentation().setVisible((xDebugSession != null ? CidrDebuggerUtilKt.getCidrDebugProcess(xDebugSession) : null) != null);
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!super.isEnabled(node, e)) {
            return false;
        }
        XValueContainer xValueContainer = node.getValueContainer();
        CidrPhysicalValue cidrPhysicalValue = xValueContainer instanceof CidrPhysicalValue ? (CidrPhysicalValue)xValueContainer : null;
        if (cidrPhysicalValue == null) {
            return false;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return false;
        }
        if (!value.canShowInMemoryView()) {
            return false;
        }
        LLValueData lLValueData = value.getPreparedVarData();
        Intrinsics.checkNotNullExpressionValue((Object)lLValueData, (String)"getPreparedVarData(...)");
        LLValueData data = lLValueData;
        return !data.isPointer() || data.isValidPointer();
    }

    protected void perform(@NotNull XValueNodeImpl node, @NotNull String nodeName, @NotNull AnActionEvent e) {
        XDebugSessionTab sessionTab;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XValueContainer xValueContainer = node.getValueContainer();
        CidrPhysicalValue cidrPhysicalValue = xValueContainer instanceof CidrPhysicalValue ? (CidrPhysicalValue)xValueContainer : null;
        if (cidrPhysicalValue == null) {
            return;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return;
        }
        CidrDebugProcess cidrDebugProcess = value.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"getProcess(...)");
        CidrDebugProcess debugProcess = cidrDebugProcess;
        MemoryViewPanel memoryViewPanel = debugProcess.getHexdumpViewPanel();
        if (memoryViewPanel == null) {
            return;
        }
        MemoryViewPanel memoryViewPanel2 = memoryViewPanel;
        GotoAddressPanel gotoAddressPanel = memoryViewPanel2.getGotoAddressPanel();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gotoAddressPanel), (String)"getGotoAddressPanel(...)");
        GotoAddressPanel gotoAddressPanel2 = gotoAddressPanel;
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        XDebugSession debugSession = xDebugSession;
        if (debugSession instanceof XDebugSessionImpl && (sessionTab = ((XDebugSessionImpl)debugSession).getSessionTab()) != null) {
            Content memoryViewContent = sessionTab.getUi().findContent("DEBUGGER_MEMORY_VIEW");
            JComponent memoryViewComponent = memoryViewPanel2.getPreferredFocusableComponent();
            sessionTab.getUi().selectAndFocus(memoryViewContent, true, true).doWhenDone(() -> ShowInMemoryViewAction.perform$lambda$0(memoryViewComponent));
        }
        gotoAddressPanel2.navigateToValue(value, true);
    }

    private static final void perform$lambda$0(JComponent $memoryViewComponent) {
        $memoryViewComponent.requestFocus();
    }
}

