/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.util.Expirable;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.actions.CidrByteArrayImageDescriptor;
import com.jetbrains.cidr.execution.debugger.actions.CidrCreateImageException;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDataType;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDescriptor;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageShape;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewer;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewerKt;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrPointerImageViewer;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewer;", "value", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue;)V", "expression", "", "Lorg/jetbrains/annotations/NotNull;", "getImageDescriptor", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDescriptor;", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "expirable", "Lcom/intellij/openapi/util/Expirable;", "shape", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/intellij/openapi/util/Expirable;Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createImage", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "evalCtx", "Lcom/jetbrains/cidr/execution/debugger/backend/EvaluationContext;", "intellij.cidr.debugger.core"})
public final class CidrPointerImageViewer
implements CidrImageViewer {
    @NotNull
    private final String expression;

    public CidrPointerImageViewer(@NotNull CidrPhysicalValue value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        String string = value.getEvaluationExpression();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEvaluationExpression(...)");
        this.expression = string;
    }

    @Override
    @Nullable
    public Object getImageDescriptor(@NotNull CidrDebugProcess debugProcess, @NotNull Expirable expirable, @NotNull CidrImageShape shape, @NotNull Continuation<? super CidrImageDescriptor> $completion) {
        CidrStackFrame frame = CidrImageViewerKt.getCurrentFrame(debugProcess);
        return debugProcess.getDebuggerCommandExecutor().executeCommandSuspend(false, false, expirable, (Function3)new Function3<CoroutineScope, DebuggerDriver, Continuation<? super CidrImageDescriptor>, Object>(debugProcess, expirable, frame, this, shape, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ CidrDebugProcess $debugProcess;
            final /* synthetic */ Expirable $expirable;
            final /* synthetic */ CidrStackFrame $frame;
            final /* synthetic */ CidrPointerImageViewer this$0;
            final /* synthetic */ CidrImageShape $shape;
            {
                this.$debugProcess = $debugProcess;
                this.$expirable = $expirable;
                this.$frame = $frame;
                this.this$0 = $receiver;
                this.$shape = $shape;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                DebuggerDriver debuggerDriver = (DebuggerDriver)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void driver;
                        ResultKt.throwOnFailure((Object)$result);
                        EvaluationContext evaluationContext = this.$debugProcess.createEvaluationContext((DebuggerDriver)driver, this.$expirable, this.$frame);
                        Intrinsics.checkNotNullExpressionValue((Object)evaluationContext, (String)"createEvaluationContext(...)");
                        EvaluationContext evalCtx = evaluationContext;
                        return CidrPointerImageViewer.access$createImage(this.this$0, (DebuggerDriver)driver, evalCtx, this.$shape);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(CoroutineScope p1, DebuggerDriver p2, Continuation<? super CidrImageDescriptor> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final CidrImageDescriptor createImage(DebuggerDriver driver, EvaluationContext evalCtx, CidrImageShape shape) {
        CidrImageShape cidrImageShape;
        Address startAddress;
        LLValue value;
        block32: {
            String type;
            block31: {
                LLValue lLValue = evalCtx.evaluate(this.expression);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)lLValue), (String)"evaluate(...)");
                value = lLValue;
                LLValueData lLValueData = evalCtx.getData(value);
                Intrinsics.checkNotNullExpressionValue((Object)lLValueData, (String)"getData(...)");
                LLValueData data = lLValueData;
                String string = data.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                String dataAddress = string;
                startAddress = Address.Companion.parseHexString(dataAddress);
                if (Intrinsics.areEqual((Object)shape, (Object)CidrImageShape.Companion.getDEFAULT())) break block31;
                cidrImageShape = shape;
                break block32;
            }
            String string = value.getType();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
            CidrImageDataType imageDataType = switch (type = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)CidrImageViewerKt.access$stripQualifiers(string), (CharSequence)"*"))).toString()) {
                case "char", "int8_t" -> CidrImageDataType.Int8;
                case "int16_t", "short" -> CidrImageDataType.Int16;
                case "uint16_t", "unsigned short" -> CidrImageDataType.Uint16;
                case "int", "int32_t" -> CidrImageDataType.Int32;
                case "float" -> CidrImageDataType.Float32;
                case "double" -> CidrImageDataType.Float64;
                default -> CidrImageDataType.Uint8;
            };
            cidrImageShape = new CidrImageShape(1, 1, 1, imageDataType, null, null, 48, null);
        }
        CidrImageShape actualShape = cidrImageShape;
        List<LLMemoryHunk> list = driver.dumpMemory(AddressUtil.toRange(startAddress, actualShape.getImageSizeBytes()));
        Intrinsics.checkNotNullExpressionValue(list, (String)"dumpMemory(...)");
        List<LLMemoryHunk> memory = list;
        String string = CidrDebuggerBundle.message("action.CIDR.Debugger.ViewAsImage.unsupportedFormat", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String unsupported = string;
        byte[] byArray = CidrImageViewerKt.access$convertToByteArray(memory);
        if (byArray == null) {
            throw new CidrCreateImageException(unsupported);
        }
        byte[] dataBytes = byArray;
        Object[] objectArray = new Object[]{value.getName()};
        String string2 = CidrDebuggerBundle.message("bytearray.image.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String title = string2;
        return new CidrByteArrayImageDescriptor(actualShape, title, startAddress, dataBytes);
    }

    public static final /* synthetic */ CidrImageDescriptor access$createImage(CidrPointerImageViewer $this, DebuggerDriver driver, EvaluationContext evalCtx, CidrImageShape shape) {
        return $this.createImage(driver, evalCtx, shape);
    }
}

