/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToDebuggerConsoleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.cidr.debugger.core"})
public final class CidrJumpToDebuggerConsoleAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> HIDE_SESSION_TAB_ON_NEXT_INVOCATION;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        XDebugSession xDebugSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        CidrDebugProcess debugProcess = xDebugSession != null ? CidrDebuggerUtilKt.getCidrDebugProcess(xDebugSession) : null;
        e.getPresentation().setEnabledAndVisible(debugProcess != null);
        if (debugProcess != null) {
            Object[] objectArray = new Object[]{debugProcess.getDebuggerConsole().getTitle()};
            e.getPresentation().setText(CidrDebuggerBundle.message("debug.console.action.jumpToDebuggerConsole.jumpTo0", objectArray));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = DebuggerUIUtil.getSession((AnActionEvent)e);
        if (object == null || (object = CidrDebuggerUtilKt.getCidrDebugProcess((XDebugSession)object)) == null) {
            return;
        }
        Object debugProcess = object;
        XDebugSession xDebugSession = debugProcess.getSession();
        XDebugSessionImpl xDebugSessionImpl = xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
        if (xDebugSessionImpl == null || (xDebugSessionImpl = xDebugSessionImpl.getSessionTab()) == null) {
            return;
        }
        XDebugSessionImpl sessionTab = xDebugSessionImpl;
        RunnerLayoutUi runnerLayoutUi = sessionTab.getUi();
        Intrinsics.checkNotNullExpressionValue((Object)runnerLayoutUi, (String)"getUi(...)");
        RunnerLayoutUi runnerLayoutUi2 = runnerLayoutUi;
        Content content = sessionTab.findOrRestoreContentIfNeeded("DEBUGGER_BACKEND_CONSOLE");
        if (content == null) {
            return;
        }
        Content debuggerConsoleContent = content;
        Project project = ((CidrDebugProcess)debugProcess).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        ToolWindow toolWindow = CidrJumpToDebuggerConsoleAction.Companion.getToolWindow(project, (XDebugSessionTab)sessionTab);
        if (toolWindow != null && toolWindow.isVisible() && CidrJumpToDebuggerConsoleAction.Companion.getShouldHideSessionTabOnNextInvocation((UserDataHolder)debuggerConsoleContent)) {
            toolWindow.hide(() -> CidrJumpToDebuggerConsoleAction.actionPerformed$lambda$0(debuggerConsoleContent));
            return;
        }
        JComponent jComponent = ((CidrDebugProcess)debugProcess).getDebuggerConsole().getConsoleEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent consoleComponent = jComponent;
        if (toolWindow != null && !toolWindow.isVisible()) {
            toolWindow.show(() -> CidrJumpToDebuggerConsoleAction.actionPerformed$lambda$1(debuggerConsoleContent, consoleComponent));
        }
        runnerLayoutUi2.selectAndFocus(debuggerConsoleContent, true, true).doWhenDone(() -> CidrJumpToDebuggerConsoleAction.actionPerformed$lambda$2(consoleComponent, debuggerConsoleContent));
    }

    private static final void actionPerformed$lambda$0(Content $debuggerConsoleContent) {
        CidrJumpToDebuggerConsoleAction.Companion.setShouldHideSessionTabOnNextInvocation((UserDataHolder)$debuggerConsoleContent, false);
    }

    private static final void actionPerformed$lambda$1(Content $debuggerConsoleContent, JComponent $consoleComponent) {
        CidrJumpToDebuggerConsoleAction.Companion.setShouldHideSessionTabOnNextInvocation((UserDataHolder)$debuggerConsoleContent, true);
        $consoleComponent.requestFocus();
    }

    private static final void actionPerformed$lambda$2(JComponent $consoleComponent, Content $debuggerConsoleContent) {
        $consoleComponent.addFocusListener(new FocusAdapter($consoleComponent, $debuggerConsoleContent){
            final /* synthetic */ JComponent $consoleComponent;
            final /* synthetic */ Content $debuggerConsoleContent;
            {
                this.$consoleComponent = $consoleComponent;
                this.$debuggerConsoleContent = $debuggerConsoleContent;
            }

            public void focusLost(FocusEvent e) {
                this.$consoleComponent.removeFocusListener(this);
                com.jetbrains.cidr.execution.debugger.actions.CidrJumpToDebuggerConsoleAction$Companion.access$setShouldHideSessionTabOnNextInvocation(CidrJumpToDebuggerConsoleAction.Companion, (UserDataHolder)this.$debuggerConsoleContent, false);
            }
        });
        $consoleComponent.requestFocus();
    }

    static {
        Key key = Key.create((String)"HIDE_SESSION_TAB_ON_NEXT_INVOCATION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HIDE_SESSION_TAB_ON_NEXT_INVOCATION = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00068B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToDebuggerConsoleAction$Companion;", "", "<init>", "()V", "HIDE_SESSION_TAB_ON_NEXT_INVOCATION", "Lcom/intellij/openapi/util/Key;", "", "value", "shouldHideSessionTabOnNextInvocation", "Lcom/intellij/openapi/util/UserDataHolder;", "getShouldHideSessionTabOnNextInvocation", "(Lcom/intellij/openapi/util/UserDataHolder;)Z", "setShouldHideSessionTabOnNextInvocation", "(Lcom/intellij/openapi/util/UserDataHolder;Z)V", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "sessionTab", "Lcom/intellij/xdebugger/impl/ui/XDebugSessionTab;", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getShouldHideSessionTabOnNextInvocation(UserDataHolder $this$shouldHideSessionTabOnNextInvocation) {
            return Intrinsics.areEqual((Object)$this$shouldHideSessionTabOnNextInvocation.getUserData(HIDE_SESSION_TAB_ON_NEXT_INVOCATION), (Object)true);
        }

        private final void setShouldHideSessionTabOnNextInvocation(UserDataHolder $this$shouldHideSessionTabOnNextInvocation, boolean value) {
            $this$shouldHideSessionTabOnNextInvocation.putUserData(HIDE_SESSION_TAB_ON_NEXT_INVOCATION, (Object)(value ? Boolean.valueOf(true) : null));
        }

        private final ToolWindow getToolWindow(Project project, XDebugSessionTab sessionTab) {
            RunContentDescriptor runContentDescriptor = sessionTab.getRunContentDescriptor();
            if (runContentDescriptor == null) {
                return null;
            }
            RunContentDescriptor runContentDescriptor2 = runContentDescriptor;
            RunContentManager runContentManager = RunContentManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)runContentManager, (String)"getInstance(...)");
            RunContentManager manager = runContentManager;
            return manager.getToolWindowByDescriptor(runContentDescriptor2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

