/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J(\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/execution/debugger/StackFilteringContainer;", "Lcom/intellij/xdebugger/impl/frame/XStackFrameContainerEx;", "stack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "originalContainer", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "firstFrameIndex", "", "<init>", "(Lcom/intellij/xdebugger/frame/XExecutionStack;Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;I)V", "errorOccurred", "", "errorMessage", "", "filterFrames", "", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frames", "addStackFrames", "stackFrames", "toSelect", "last", "", "isObsolete", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nStackFilteringContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackFilteringContainer.kt\ncom/jetbrains/cidr/execution/debugger/StackFilteringContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n774#2:40\n865#2,2:41\n*S KotlinDebug\n*F\n+ 1 StackFilteringContainer.kt\ncom/jetbrains/cidr/execution/debugger/StackFilteringContainer\n*L\n15#1:40\n15#1:41,2\n*E\n"})
public final class StackFilteringContainer
implements XStackFrameContainerEx {
    @NotNull
    private final XExecutionStack stack;
    @NotNull
    private final XExecutionStack.XStackFrameContainer originalContainer;
    private int firstFrameIndex;

    public StackFilteringContainer(@NotNull XExecutionStack stack, @NotNull XExecutionStack.XStackFrameContainer originalContainer, int firstFrameIndex) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)originalContainer, (String)"originalContainer");
        this.stack = stack;
        this.originalContainer = originalContainer;
        this.firstFrameIndex = firstFrameIndex;
    }

    public void errorOccurred(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.originalContainer.errorOccurred(errorMessage);
    }

    /*
     * WARNING - void declaration
     */
    private final List<XStackFrame> filterFrames(List<? extends XStackFrame> frames2) {
        void $this$filterTo$iv$iv;
        XStackFrame topFrame = this.stack.getTopFrame();
        Iterable $this$filter$iv = frames2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XStackFrame it = (XStackFrame)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof CidrStackFrame && ((CidrStackFrame)it).isUserCode() || Intrinsics.areEqual((Object)it, (Object)topFrame))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect, boolean last) {
        Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
        List<XStackFrame> filteredFrames = this.filterFrames(stackFrames);
        List<XStackFrame> framesToReport = this.firstFrameIndex < filteredFrames.size() ? filteredFrames.subList(this.firstFrameIndex, filteredFrames.size()) : CollectionsKt.emptyList();
        int skippedCount = filteredFrames.size() - framesToReport.size();
        this.firstFrameIndex = RangesKt.coerceAtLeast((int)(this.firstFrameIndex - skippedCount), (int)0);
        if (this.originalContainer instanceof XStackFrameContainerEx) {
            ((XStackFrameContainerEx)this.originalContainer).addStackFrames(framesToReport, toSelect, last);
        } else {
            this.originalContainer.addStackFrames(framesToReport, last);
        }
    }

    public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
        Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
        this.addStackFrames(stackFrames, null, last);
    }

    public boolean isObsolete() {
        return this.originalContainer.isObsolete();
    }
}

