/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u0011J\u0006\u0010\u0012\u001a\u00020\nJ\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0002J6\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u0011H\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrInstructionsPatcher;", "", "<init>", "()V", "myPatchedInstructions", "Ljava/util/HashMap;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "Lcom/jetbrains/cidr/execution/debugger/CidrInstructionsPatcher$PatchedInstruction;", "Lkotlin/collections/HashMap;", "patchInstructionsInMemory", "", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "address", "newInstructions", "", "checkOldInstructions", "Lkotlin/Function1;", "hasPatchedInstructions", "restoreInstructionsInMemory", "", "addresses", "", "restoreAllPatchedInstructions", "doRestoreInstructionInMemory", "instructionsToRestore", "tryReplaceInstructionsInMemory", "PatchedInstruction", "Companion", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrInstructionsPatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrInstructionsPatcher.kt\ncom/jetbrains/cidr/execution/debugger/CidrInstructionsPatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n1#2:117\n1617#3,9:107\n1869#3:116\n1870#3:118\n1626#3:119\n*S KotlinDebug\n*F\n+ 1 CidrInstructionsPatcher.kt\ncom/jetbrains/cidr/execution/debugger/CidrInstructionsPatcher\n*L\n52#1:117\n52#1:107,9\n52#1:116\n52#1:118\n52#1:119\n*E\n"})
public final class CidrInstructionsPatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Address, PatchedInstruction> myPatchedInstructions = new HashMap();
    @NotNull
    private static final byte[] BYTECODE_X86_INT3;
    @NotNull
    private static final byte[] BYTECODE_X86_NOP;
    @NotNull
    private static final byte[] BYTECODE_AARCH64_NOP;
    public static final int BYTECODE_AARCH64_BRK_SIZE = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean patchInstructionsInMemory(@NotNull DebuggerDriver driver, @NotNull Address address, @NotNull byte[] newInstructions, @NotNull Function1<? super byte[], Boolean> checkOldInstructions) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)newInstructions, (String)"newInstructions");
        Intrinsics.checkNotNullParameter(checkOldInstructions, (String)"checkOldInstructions");
        byte[] byArray = this.tryReplaceInstructionsInMemory(driver, address, newInstructions, checkOldInstructions);
        if (byArray == null) {
            return false;
        }
        byte[] original = byArray;
        HashMap<Address, PatchedInstruction> hashMap = this.myPatchedInstructions;
        synchronized (hashMap) {
            boolean bl = false;
            ((Map)this.myPatchedInstructions).put(address, new PatchedInstruction(address, original, newInstructions));
            Unit unit = Unit.INSTANCE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasPatchedInstructions() {
        boolean bl;
        HashMap<Address, PatchedInstruction> hashMap = this.myPatchedInstructions;
        synchronized (hashMap) {
            boolean bl2 = false;
            bl = !((Map)this.myPatchedInstructions).isEmpty();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void restoreInstructionsInMemory(@NotNull DebuggerDriver driver, @NotNull List<Address> addresses) {
        List list;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        HashMap<Address, PatchedInstruction> hashMap = this.myPatchedInstructions;
        synchronized (hashMap) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            boolean bl = false;
            Iterable iterable = addresses;
            HashMap<Address, PatchedInstruction> hashMap2 = this.myPatchedInstructions;
            boolean $i$f$mapNotNull = false;
            void var9_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PatchedInstruction it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Address p0 = (Address)element$iv$iv;
                boolean bl3 = false;
                if (hashMap2.remove(p0) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List removed = list;
        this.doRestoreInstructionInMemory(driver, removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void restoreAllPatchedInstructions(@NotNull DebuggerDriver driver) {
        List list;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        HashMap<Address, PatchedInstruction> hashMap = this.myPatchedInstructions;
        synchronized (hashMap) {
            boolean bl = false;
            Collection<PatchedInstruction> collection = this.myPatchedInstructions.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            List patchedInstructions = CollectionsKt.toList((Iterable)collection);
            this.myPatchedInstructions.clear();
            list = patchedInstructions;
        }
        List allInstructions = list;
        this.doRestoreInstructionInMemory(driver, allInstructions);
    }

    private final void doRestoreInstructionInMemory(DebuggerDriver driver, List<PatchedInstruction> instructionsToRestore) {
        Exception exception = null;
        for (PatchedInstruction instruction : instructionsToRestore) {
            try {
                if (this.tryReplaceInstructionsInMemory(driver, instruction.getAddress(), instruction.getOriginal(), (Function1<? super byte[], Boolean>)((Function1)new Function1<byte[], Boolean>((Object)instruction.getPatched()){

                    public final Boolean invoke(byte[] p0) {
                        return Arrays.equals((byte[])this.receiver, p0);
                    }
                })) != null) continue;
                CidrDebuggerLog.LOG.warn("Failed to restore instruction at address " + instruction.getAddress() + ".");
            }
            catch (Exception e) {
                CidrDebuggerLog.LOG.warnWithDebug("Unable to restore instruction at address " + instruction.getAddress() + ".", (Throwable)e);
                if (exception == null) {
                    exception = e;
                    continue;
                }
                ExceptionsKt.addSuppressed((Throwable)exception, (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private final byte[] tryReplaceInstructionsInMemory(DebuggerDriver driver, Address address, byte[] newInstructions, Function1<? super byte[], Boolean> checkOldInstructions) {
        Object object;
        block6: {
            block5: {
                if (!driver.supportsMemoryWrite()) {
                    return null;
                }
                List<LLMemoryHunk> list = driver.dumpMemory(AddressUtil.toRange(address, newInstructions.length));
                Intrinsics.checkNotNullExpressionValue(list, (String)"dumpMemory(...)");
                List<LLMemoryHunk> dumpedInstructionMemory = list;
                object = (LLMemoryHunk)CollectionsKt.singleOrNull(dumpedInstructionMemory);
                if (object == null || (object = ((LLMemoryHunk)object).getBytes()) == null) break block5;
                byte[] byArray = CollectionsKt.toByteArray((Collection)((Collection)object));
                object = byArray;
                if (byArray != null) break block6;
            }
            return null;
        }
        Object instructionsInMemory = object;
        if (!((Boolean)checkOldInstructions.invoke(instructionsInMemory)).booleanValue()) {
            return null;
        }
        driver.writeMemory(address, newInstructions);
        return instructionsInMemory;
    }

    static {
        byte[] byArray = new byte[]{-52};
        BYTECODE_X86_INT3 = byArray;
        byArray = new byte[]{-112};
        BYTECODE_X86_NOP = byArray;
        byArray = new byte[]{31, 32, 3, -43};
        BYTECODE_AARCH64_NOP = byArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrInstructionsPatcher$Companion;", "", "<init>", "()V", "BYTECODE_X86_INT3", "", "getBYTECODE_X86_INT3", "()[B", "BYTECODE_X86_NOP", "getBYTECODE_X86_NOP", "BYTECODE_AARCH64_NOP", "getBYTECODE_AARCH64_NOP", "BYTECODE_AARCH64_BRK_SIZE", "", "isBytecodeAarch64Brk", "", "bytecode", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getBYTECODE_X86_INT3() {
            return BYTECODE_X86_INT3;
        }

        @NotNull
        public final byte[] getBYTECODE_X86_NOP() {
            return BYTECODE_X86_NOP;
        }

        @NotNull
        public final byte[] getBYTECODE_AARCH64_NOP() {
            return BYTECODE_AARCH64_NOP;
        }

        public final boolean isBytecodeAarch64Brk(@NotNull byte[] bytecode) {
            Intrinsics.checkNotNullParameter((Object)bytecode, (String)"bytecode");
            if (bytecode.length != 4) {
                return false;
            }
            int instruction = 0;
            for (int i = 0; i < 4; ++i) {
                instruction = UInt.constructor-impl((int)(instruction | UInt.constructor-impl((int)(UInt.constructor-impl((int)(UInt.constructor-impl((int)bytecode[i]) & 0xFF)) << 8 * i))));
            }
            return UInt.constructor-impl((int)(instruction & 0xFFE0001F)) == -736100352;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrInstructionsPatcher$PatchedInstruction;", "", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "original", "", "patched", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;[B[B)V", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getOriginal", "()[B", "getPatched", "intellij.cidr.debugger.core"})
    private static final class PatchedInstruction {
        @NotNull
        private final Address address;
        @NotNull
        private final byte[] original;
        @NotNull
        private final byte[] patched;

        public PatchedInstruction(@NotNull Address address, @NotNull byte[] original, @NotNull byte[] patched) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)patched, (String)"patched");
            this.address = address;
            this.original = original;
            this.patched = patched;
        }

        @NotNull
        public final Address getAddress() {
            return this.address;
        }

        @NotNull
        public final byte[] getOriginal() {
            return this.original;
        }

        @NotNull
        public final byte[] getPatched() {
            return this.patched;
        }
    }
}

