/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrRunnerBundle;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CidrBuildConfigurationHelper<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>> {
    @NlsContexts.Label
    @NotNull
    public String getTargetTitle() {
        String string = CidrRunnerBundle.message("build.configuration.target", new Object[0]);
        if (string == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getConfigurationTitle() {
        String string = CidrRunnerBundle.message("build.configuration.configuration", new Object[0]);
        if (string == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean allowEditBuildConfiguration() {
        return true;
    }

    public boolean hasTargetsInSeveralProjects() {
        return false;
    }

    @NotNull
    public abstract List<TARGET> getTargets();

    @NotNull
    public List<BC> getConfigurations(@Nullable TARGET target) {
        List<Object> list = target == null ? Collections.emptyList() : target.getBuildConfigurations();
        if (list == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public BC getDefaultConfiguration(@Nullable TARGET target) {
        return (BC)((CidrBuildConfiguration)ContainerUtil.getFirstItem(this.getConfigurations(target)));
    }

    @NotNull
    public @Unmodifiable List<? extends TARGET> getRunTargets() {
        List list = ContainerUtil.filter(this.getTargets(), target -> target.isExecutable());
        if (list == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<? extends TARGET> getRunTargets(@Nullable TARGET buildTarget) {
        List<TARGET> list = this.getRunTargets();
        if (list == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public TARGET findRunTarget(@Nullable BuildTargetData data) {
        return this.findTarget(data, this.getRunTargets());
    }

    @Nullable
    public TARGET findTarget(@Nullable BuildTargetData targetData) {
        return this.findTarget(targetData, this.getTargets());
    }

    @Contract(value="null, _ -> null")
    public <T extends TARGET> T findTarget(@Nullable BuildTargetData targetData, @NotNull List<? extends T> targets) {
        if (targets == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(5);
        }
        if (targetData == null) {
            return null;
        }
        for (CidrBuildTarget each : targets) {
            if (!each.pairOf(targetData)) continue;
            return (T)each;
        }
        return null;
    }

    @Nullable
    public BC findConfiguration(@Nullable TARGET target, @Nullable String name) {
        if (name == null) {
            return null;
        }
        for (CidrBuildConfiguration each : this.getConfigurations(target)) {
            if (!each.getName().equals(name)) continue;
            return (BC)each;
        }
        return null;
    }

    @Nullable
    public TARGET getDefaultTarget() {
        return (TARGET)((CidrBuildTarget)ContainerUtil.getFirstItem(this.getTargets()));
    }

    @Nullable
    public TARGET findFirstSuitableTarget(@Nullable String targetName) {
        return CidrBuildConfigurationHelper.findFirstSuitableTarget(this.getTargets(), targetName);
    }

    @NlsContexts.Label
    @NotNull
    public String getExecutableTitle() {
        String string = CidrRunnerBundle.message("build.configuration.executable", new Object[0]);
        if (string == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Contract(value="_, null -> null")
    public static <T extends CidrBuildTarget> T findFirstSuitableTarget(@NotNull List<T> targets, @Nullable String targetName) {
        if (targets == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(7);
        }
        if (targetName == null) {
            return null;
        }
        for (CidrBuildTarget each : targets) {
            if (!each.getName().equals(targetName)) continue;
            return (T)each;
        }
        return null;
    }

    @Nullable
    public BuildTargetAndConfigurationData findSimilarValidInTargets(@Nullable TARGET target, @Nullable BC configuration, @NotNull List<TARGET> targetsWithContext) {
        if (targetsWithContext == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(8);
        }
        return targetsWithContext.contains(target) ? new BuildTargetAndConfigurationData((CidrBuildTarget<?>)target, (String)null) : null;
    }

    public static boolean isTargetDetectionEnabled() {
        return Registry.is((String)"cidr.test.framework.targetTypeFromHeaderDetectionEnable");
    }

    @TestOnly
    public static boolean setTargetDetection(boolean value) {
        boolean oldValue = CidrBuildConfigurationHelper.isTargetDetectionEnabled();
        Registry.get((String)"cidr.test.framework.targetTypeFromHeaderDetectionEnable").setValue(value);
        return oldValue;
    }

    @NotNull
    public CommonProgramParametersPanel createCommonPanelForTests() {
        return new CommonProgramParametersPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrBuildConfigurationHelper";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetsWithContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunTargets";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrBuildConfigurationHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableTitle";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTarget";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFirstSuitableTarget";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSimilarValidInTargets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

