/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.colorblindmode;

import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorConstantsKt;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorLut;
import com.android.tools.idea.uibuilder.visual.colorblindmode.Mat3D;
import com.android.tools.idea.uibuilder.visual.colorblindmode.MathUtilKt;
import com.android.tools.idea.uibuilder.visual.colorblindmode.RGB;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\r\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0010\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0016"}, d2={"buildColorLut", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorLut;", "dim", "", "mode", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;", "removeGammaCLut", "", "getMat3D", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/Mat3D;", "convertSingleColor", "color", "lms2lms", "buildGammaCLut", "function", "Ljava/util/function/Function;", "", "removeGamma", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/RGB;", "applyGamma", "gamma", "buildUniformColorLut", "intellij.android.designer"})
public final class ColorUtilKt {
    @NotNull
    public static final ColorLut buildColorLut(int dim, @NotNull ColorBlindMode mode, @NotNull double[] removeGammaCLut) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)removeGammaCLut, (String)"removeGammaCLut");
        int[] ret = new int[dim * dim * dim];
        Mat3D lms2lms = ColorUtilKt.getMat3D(mode);
        int n = ret.length;
        for (int i = 0; i < n; ++i) {
            int converted;
            int ri = i % dim;
            int gi = i / dim % dim;
            int bi = i / (dim * dim);
            int red = ri * 255 / (dim - 1);
            int green = gi * 255 / (dim - 1);
            int blue = bi * 255 / (dim - 1);
            ret[i] = converted = ColorUtilKt.convertSingleColor(MathUtilKt.combine(red, green, blue), lms2lms, removeGammaCLut);
        }
        return new ColorLut(ret, dim);
    }

    private static final Mat3D getMat3D(ColorBlindMode mode) {
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> ColorConstantsKt.getIDENTITY_MATRIX();
            case 2 -> ColorConstantsKt.buildLms2Lmsp$default(0.0, 1, null);
            case 3 -> ColorConstantsKt.buildLms2Lmsp(0.25);
            case 4 -> ColorConstantsKt.buildLms2Lmsd$default(0.0, 1, null);
            case 5 -> ColorConstantsKt.buildLms2Lmsd(0.25);
            case 6 -> ColorConstantsKt.buildLms2Lmst$default(0.0, 1, null);
            case 7 -> ColorConstantsKt.buildLms2Lmst(0.25);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final int convertSingleColor(int color, @NotNull Mat3D lms2lms, @NotNull double[] removeGammaCLut) {
        Intrinsics.checkNotNullParameter((Object)lms2lms, (String)"lms2lms");
        Intrinsics.checkNotNullParameter((Object)removeGammaCLut, (String)"removeGammaCLut");
        RGB color2 = new RGB(MathUtilKt.r(color), MathUtilKt.g(color), MathUtilKt.b(color));
        color2 = ColorUtilKt.removeGamma(color2, removeGammaCLut);
        color2 = ColorConstantsKt.getRGB_TO_LMS().times(color2);
        color2 = lms2lms.times(color2);
        color2 = ColorConstantsKt.getLMS_TO_RGB().times(color2);
        return ColorUtilKt.applyGamma$default(color2, 0.0, 2, null).color();
    }

    @NotNull
    public static final double[] buildGammaCLut(@NotNull Function<Double, Double> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        double[] toReturn = new double[256];
        for (int i = 0; i < 256; ++i) {
            Double d = function.apply(Double.valueOf(i));
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"apply(...)");
            toReturn[i] = ((Number)d).doubleValue();
        }
        return toReturn;
    }

    @NotNull
    public static final RGB removeGamma(@NotNull RGB color, @NotNull double[] removeGammaCLut) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)removeGammaCLut, (String)"removeGammaCLut");
        double r = removeGammaCLut[(int)color.getR()];
        double g = removeGammaCLut[(int)color.getG()];
        double b = removeGammaCLut[(int)color.getB()];
        return new RGB(r, g, b);
    }

    @NotNull
    public static final RGB applyGamma(@NotNull RGB color, double gamma) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        double rg = 255.0 * Math.pow(color.getR(), 1.0 / gamma);
        double gg = 255.0 * Math.pow(color.getG(), 1.0 / gamma);
        double bg = 255.0 * Math.pow(color.getB(), 1.0 / gamma);
        return new RGB(rg, gg, bg);
    }

    public static /* synthetic */ RGB applyGamma$default(RGB rGB, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 2.2;
        }
        return ColorUtilKt.applyGamma(rGB, d);
    }

    @NotNull
    public static final ColorLut buildUniformColorLut(int dim) {
        int[] ret = new int[dim * dim * dim];
        int n = ret.length;
        for (int i = 0; i < n; ++i) {
            int color;
            int ri = i % dim;
            int gi = i / dim % dim;
            int bi = i / (dim * dim);
            int red = ri * 255 / (dim - 1);
            int green = gi * 255 / (dim - 1);
            int blue = bi * 255 / (dim - 1);
            ret[i] = color = red << 16 | green << 8 | blue;
        }
        return new ColorLut(ret, dim);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorBlindMode.values().length];
            try {
                nArray[ColorBlindMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorBlindMode.PROTANOPES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorBlindMode.PROTANOMALY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorBlindMode.DEUTERANOPES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorBlindMode.DEUTERANOMALY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorBlindMode.TRITANOPES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorBlindMode.TRITANOMALY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

