/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.layer;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/uibuilder/surface/layer/OverlayLayer;", "Lcom/android/tools/idea/common/surface/Layer;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "overlayConfiguration", "Lkotlin/Function0;", "Lcom/android/tools/idea/ui/designer/overlays/OverlayConfiguration;", "<init>", "(Lcom/android/tools/idea/common/surface/SceneView;Lkotlin/jvm/functions/Function0;)V", "screenViewSize", "Ljava/awt/Dimension;", "paintPlaceholder", "", "g", "Ljava/awt/Graphics2D;", "paintOverlay", "image", "Ljava/awt/image/BufferedImage;", "paint", "gc", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class OverlayLayer
extends Layer {
    @NotNull
    private final SceneView sceneView;
    @NotNull
    private final Function0<OverlayConfiguration> overlayConfiguration;
    @NotNull
    private Dimension screenViewSize;
    public static final int $stable = 8;

    public OverlayLayer(@NotNull SceneView sceneView, @NotNull Function0<OverlayConfiguration> overlayConfiguration) {
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        Intrinsics.checkNotNullParameter(overlayConfiguration, (String)"overlayConfiguration");
        this.sceneView = sceneView;
        this.overlayConfiguration = overlayConfiguration;
        this.screenViewSize = new Dimension();
    }

    private final void paintPlaceholder(Graphics2D g) {
        g.setComposite(AlphaComposite.SrcOver.derive(0.7f));
        g.setPaint((Paint)JBColor.WHITE);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.sceneView.getScreenShape() != null) {
            g.fill(this.sceneView.getScreenShape());
        } else {
            g.fillRect(this.sceneView.getX(), this.sceneView.getY(), this.screenViewSize.width, this.screenViewSize.height);
        }
        g.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.NORMAL, null));
        g.setPaint((Paint)JBColor.BLACK);
        TextLayout textLayout = new TextLayout("Loading Overlay...", g.getFont(), g.getFontRenderContext());
        double textHeight = textLayout.getBounds().getHeight();
        double textWidth = textLayout.getBounds().getWidth();
        g.drawString("Loading Overlay...", this.sceneView.getX() + this.screenViewSize.width / 2 - (int)textWidth / 2, this.sceneView.getY() + this.screenViewSize.height / 2 + (int)textHeight / 2);
    }

    private final void paintOverlay(Graphics2D g, BufferedImage image) {
        OverlayConfiguration overlayConfiguration = (OverlayConfiguration)this.overlayConfiguration.invoke();
        if (image == null) {
            return;
        }
        g.setComposite(AlphaComposite.SrcOver.derive(overlayConfiguration.getOverlayAlpha()));
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(image, this.sceneView.getX(), this.sceneView.getY(), this.screenViewSize.width, this.screenViewSize.height, null);
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        OverlayConfiguration overlayConfiguration = (OverlayConfiguration)this.overlayConfiguration.invoke();
        if (overlayConfiguration.getOverlayVisibility()) {
            this.screenViewSize = this.sceneView.getScaledContentSize(this.screenViewSize);
            if (overlayConfiguration.isPlaceholderVisible()) {
                this.paintPlaceholder(gc);
            } else {
                this.paintOverlay(gc, overlayConfiguration.getOverlayImage());
            }
        }
    }
}

