/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.interaction;

import com.android.AndroidXConstants;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.ChangeType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DragEnterEvent;
import com.android.tools.idea.common.surface.DragOverEvent;
import com.android.tools.idea.common.surface.DropEvent;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.common.CommonDragHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutGuidelineHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragDropInteraction
implements Interaction {
    private final DesignSurface<?> myDesignSurface;
    private final List<NlComponent> myDraggedComponents;
    private ViewGroupHandler myCurrentHandler;
    private DragHandler myDragHandler;
    private SceneComponent myDragReceiver;
    private DragType myType = DragType.MOVE;
    private SceneView mySceneView;
    private DnDTransferItem myTransferItem;
    SceneComponent myCurrentViewgroup = null;
    private boolean myDoesAcceptDropAtLastPosition = true;
    private InteractionInformation myStartInfo;
    private ViewGroupHandler myCachedHandler;
    private SceneComponent myCachedComponent;

    public DragDropInteraction(@NotNull DesignSurface<?> designSurface2, @NotNull List<NlComponent> dragged) {
        this.myDesignSurface = designSurface2;
        this.myDraggedComponents = dragged;
    }

    public void setType(DragType type) {
        this.myType = type;
        if (this.myDragHandler != null) {
            this.myDragHandler.setDragType(type);
        }
    }

    public void setTransferItem(@NotNull DnDTransferItem item) {
        this.myTransferItem = item;
    }

    @Nullable
    public DnDTransferItem getTransferItem() {
        return this.myTransferItem;
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        assert (event instanceof DragEnterEvent) : "The instance of event should be DragEnterEvent but it is " + String.valueOf(event.getClass()) + "; The dragged component is " + String.valueOf(this.myDraggedComponents) + "; The SceneView is " + String.valueOf(this.mySceneView) + ", start (x, y) = " + event.getInfo().getX() + ", " + event.getInfo().getY() + ", start mask is " + event.getInfo().getModifiersEx();
        this.myStartInfo = event.getInfo();
        DropTargetDragEvent dropEvent = (DropTargetDragEvent)((DragEnterEvent)event).getEventObject();
        this.moveTo(dropEvent.getLocation().x, dropEvent.getLocation().y, event.getInfo().getModifiersEx(), false);
        for (SceneView sceneView : this.myDesignSurface.getSceneViews()) {
            sceneView.onDragStart();
        }
        this.myDesignSurface.repaint();
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        if (event instanceof DragOverEvent) {
            DropTargetDragEvent dragEvent = (DropTargetDragEvent)((DragOverEvent)event).getEventObject();
            Point location = dragEvent.getLocation();
            NlDropEvent nlDropEvent = new NlDropEvent(dragEvent);
            SceneView sceneView = this.myDesignSurface.getSceneViewAtOrPrimary(location.x, location.y);
            if (sceneView == null) {
                nlDropEvent.reject();
                return;
            }
            this.moveTo(location.x, location.y, event.getInfo().getModifiersEx(), false);
            if (this.acceptsDrop()) {
                DragType dragType = dragEvent.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
                this.setType(dragType);
                NlModel model = sceneView.getSceneManager().getModel();
                InsertType insertType = model.getTreeWriter().determineInsertType(dragType, this.getTransferItem(), true, true);
                nlDropEvent.accept(insertType);
            } else {
                nlDropEvent.reject();
            }
        }
    }

    public boolean acceptsDrop() {
        return this.myDoesAcceptDropAtLastPosition;
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        if (!(event instanceof DropEvent)) {
            String errorMessage = "The instance of event should be DropEvent but it is " + String.valueOf(event.getClass()) + "; The dragged component is " + String.valueOf(this.myDraggedComponents) + "; The SceneView is " + String.valueOf(this.mySceneView) + ", start (x, y) = " + this.myStartInfo.getX() + ", " + this.myStartInfo.getY() + ", start mask is " + this.myStartInfo.getModifiersEx();
            Logger.getInstance(this.getClass()).info("Unexpected event type: " + errorMessage);
            this.cancel(event);
            return;
        }
        DropTargetDropEvent dropEvent = (DropTargetDropEvent)((DropEvent)event).getEventObject();
        NlDropEvent nlDropEvent = new NlDropEvent(dropEvent);
        Point location = dropEvent.getLocation();
        InsertType insertType = this.finishDropInteraction(location.x, location.y, dropEvent.getDropAction(), dropEvent.getTransferable());
        if (insertType != null) {
            this.moveTo(dropEvent.getLocation().x, dropEvent.getLocation().y, event.getInfo().getModifiersEx(), true);
            boolean hasDragHandler = this.myDragHandler != null;
            this.mySceneView = this.myDesignSurface.getSceneViewAtOrPrimary(dropEvent.getLocation().x, dropEvent.getLocation().y);
            if (this.mySceneView != null && this.myDragReceiver != null && hasDragHandler) {
                this.mySceneView.getSceneManager().getModel().notifyModified(ChangeType.DND_END);
                this.mySceneView.getSelectionModel().clear();
                this.mySceneView.getSceneManager().update();
                this.myDragReceiver.updateTargets();
            }
            this.stopDragDropInteraction();
            nlDropEvent.accept(insertType);
            nlDropEvent.complete();
        } else {
            this.cancel(event);
            nlDropEvent.reject();
        }
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        this.moveTo(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx(), false);
        this.mySceneView = this.myDesignSurface.getSceneViewAtOrPrimary(event.getInfo().getX(), event.getInfo().getY());
        if (this.myDragHandler != null) {
            this.myDragHandler.cancel();
        }
        this.stopDragDropInteraction();
        if (event instanceof DropEvent) {
            NlDropEvent nlDropEvent = new NlDropEvent((DropTargetDropEvent)((DropEvent)event).getEventObject());
            nlDropEvent.reject();
        }
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    private void stopDragDropInteraction() {
        for (SceneView sceneView : this.myDesignSurface.getSceneViews()) {
            sceneView.onDragEnd();
        }
        this.myDesignSurface.repaint();
    }

    private void moveTo(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean commit) {
        String error;
        SceneComponent viewgroup;
        this.mySceneView = this.myDesignSurface.getSceneViewAtOrPrimary(x, y);
        if (this.mySceneView == null) {
            return;
        }
        this.myDoesAcceptDropAtLastPosition = true;
        this.myDesignSurface.getLayeredPane().scrollRectToVisible(new Rectangle(x - 50, y - 50, 100, 100));
        int ax = Coordinates.getAndroidX(this.mySceneView, x);
        int ay = Coordinates.getAndroidY(this.mySceneView, y);
        Project project = this.mySceneView.getSceneManager().getModel().getProject();
        ViewGroupHandler handler = this.findViewGroupHandlerAt(x, y);
        SceneContext sceneContext = this.mySceneView.getContext();
        for (viewgroup = this.mySceneView.getScene().findComponent(sceneContext, Coordinates.getAndroidXDip(this.mySceneView, x), Coordinates.getAndroidYDip(this.mySceneView, y)); viewgroup != null && !NlComponentHelperKt.isOrHasSuperclass(viewgroup.getNlComponent(), "android.view.ViewGroup"); viewgroup = viewgroup.getParent()) {
        }
        if (!(this.myDragHandler instanceof CommonDragHandler || handler == this.myCurrentHandler && this.myCurrentViewgroup == viewgroup)) {
            if (this.myCurrentViewgroup != null) {
                this.myCurrentViewgroup.setDrawState(SceneComponent.DrawState.NORMAL);
            }
            this.myCurrentViewgroup = viewgroup;
            if (this.myCurrentViewgroup != null) {
                this.myCurrentViewgroup.setDrawState(SceneComponent.DrawState.DRAG);
            }
            if (this.myDragHandler != null) {
                this.myDragHandler.cancel();
                this.myDragHandler = null;
                this.myDesignSurface.repaint();
            }
            this.myCurrentHandler = handler;
            if (this.myCurrentHandler != null) {
                assert (this.myDragReceiver != null);
                error = null;
                ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(project);
                for (NlComponent component : this.myDraggedComponents) {
                    boolean acceptableHandler;
                    boolean constraintHelper = AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_GUIDELINE.isEquals(component.getTagName()) || AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_BARRIER.isEquals(component.getTagName()) || AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_FLOW.isEquals(component.getTagName()) || AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.isEquals(component.getTagName()) || AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_LAYER.isEquals(component.getTagName()) || AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_IMAGE_FILTER_VIEW.isEquals(component.getTagName()) || AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_IMAGE_FILTER_BUTTON.isEquals(component.getTagName()) || AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_MOCK_VIEW.isEquals(component.getTagName());
                    boolean bl = acceptableHandler = this.myCurrentHandler instanceof ConstraintLayoutHandler || this.myCurrentHandler instanceof ConstraintLayoutHandler.ConstraintLayoutSupported;
                    if (constraintHelper && !acceptableHandler) {
                        error = String.format("<%1$s> does not accept <%2$s> as a child", this.myDragReceiver.getNlComponent().getTagName(), component.getTagName());
                        this.myDoesAcceptDropAtLastPosition = false;
                        break;
                    }
                    if (!this.myCurrentHandler.acceptsChild(this.myDragReceiver, component, ax, ay)) {
                        error = String.format("<%1$s> does not accept <%2$s> as a child", this.myDragReceiver.getNlComponent().getTagName(), component.getTagName());
                        this.myDoesAcceptDropAtLastPosition = false;
                        break;
                    }
                    ViewHandler viewHandler = viewHandlerManager.getHandler(component, () -> {});
                    if (viewHandler == null || viewHandler.acceptsParent(this.myDragReceiver.getNlComponent(), component)) continue;
                    error = String.format("<%1$s> does not accept <%2$s> as a parent", component.getTagName(), this.myDragReceiver.getNlComponent().getTagName());
                    this.myDoesAcceptDropAtLastPosition = false;
                    break;
                }
                if (error == null) {
                    ViewEditorImpl editorImpl = new ViewEditorImpl(this.mySceneView);
                    this.myDragHandler = this.myCurrentHandler.createDragHandler(editorImpl, this.myDragReceiver, this.myDraggedComponents, this.myType);
                    if (this.myDragHandler != null) {
                        this.myDragHandler.start(Coordinates.getAndroidXDip(this.mySceneView, this.myStartInfo.getX()), Coordinates.getAndroidYDip(this.mySceneView, this.myStartInfo.getY()), this.myStartInfo.getModifiersEx());
                    }
                } else {
                    this.myCurrentHandler = null;
                }
            }
        }
        if (this.myDragHandler instanceof CommonDragHandler || this.myDragHandler != null && this.myCurrentHandler != null) {
            error = this.myDragHandler.update(Coordinates.pxToDp(this.mySceneView, ax), Coordinates.pxToDp(this.mySceneView, ay), modifiers, sceneContext);
            ArrayList<NlComponent> added = new ArrayList<NlComponent>();
            if (commit && error == null) {
                added.addAll(this.myDraggedComponents);
                NlModel model = this.mySceneView.getSceneManager().getModel();
                InsertType insertType = model.getTreeWriter().determineInsertType(this.myType, this.myTransferItem, false, true);
                this.myDragHandler.commit(ax, ay, modifiers, insertType);
                model.notifyModified(ChangeType.DND_COMMIT);
                this.myDesignSurface.getLayeredPane().requestFocus();
            }
            this.mySceneView.getSurface().repaint();
        }
    }

    @Nullable
    private ViewGroupHandler findViewGroupHandlerAt(int x, int y) {
        SceneView sceneView = this.myDesignSurface.getSceneViewAtOrPrimary(x, y);
        if (sceneView == null) {
            return null;
        }
        SceneComponent component = sceneView.getScene().findComponent(sceneView.getContext(), Coordinates.getAndroidXDip(sceneView, x), Coordinates.getAndroidYDip(sceneView, y));
        if (component == null) {
            component = sceneView.getScene().getRoot();
        }
        if ((component = this.excludeDraggedComponents(component)) == this.myCachedComponent && this.myCachedHandler != null) {
            return this.myCachedHandler;
        }
        this.myCachedComponent = component;
        this.myCachedHandler = null;
        ViewHandlerManager handlerManager = ViewHandlerManager.get(sceneView.getSceneManager().getModel().getFacet());
        while (component != null) {
            ViewGroupHandler handler = NlComponentHelperKt.getViewGroupHandler(component.getNlComponent(), () -> {});
            if (handler != null && this.acceptsDrop(component, handler, x, y)) {
                this.myCachedHandler = handler;
                this.myDragReceiver = component;
                return this.myCachedHandler;
            }
            component = component.getParent();
        }
        return null;
    }

    @Nullable
    private SceneComponent excludeDraggedComponents(@Nullable SceneComponent component) {
        SceneComponent receiver = component;
        while (component != null) {
            if (this.myDraggedComponents.contains(component.getNlComponent())) {
                receiver = component.getParent();
            }
            component = component.getParent();
        }
        return receiver;
    }

    private boolean acceptsDrop(@NotNull SceneComponent parent, @NotNull ViewGroupHandler parentHandler, int x, int y) {
        SceneView view = this.myDesignSurface.getSceneViewAtOrPrimary(x, y);
        assert (view != null);
        ViewHandlerManager manager = ViewHandlerManager.get(view.getSceneManager().getModel().getFacet());
        Predicate<NlComponent> acceptsChild = child -> parentHandler.acceptsChild(parent, (NlComponent)child, Coordinates.getAndroidX(view, x), Coordinates.getAndroidY(view, y));
        Predicate<NlComponent> acceptsParent = child -> {
            ViewHandler childHandler = manager.getHandler((NlComponent)child, () -> {});
            return childHandler != null && childHandler.acceptsParent(parent.getNlComponent(), (NlComponent)child);
        };
        return this.myDraggedComponents.stream().allMatch(acceptsChild.and(acceptsParent));
    }

    @Override
    @NotNull
    public List<Layer> createOverlays() {
        return Collections.singletonList(new DragLayer());
    }

    @NotNull
    public List<NlComponent> getDraggedComponents() {
        return this.myDraggedComponents;
    }

    @Nullable
    public InsertType finishDropInteraction(int mouseX, int mouseY, int dropAction, @Nullable Transferable transferable) {
        List<NlComponent> components;
        if (transferable == null) {
            return null;
        }
        DnDTransferItem item = DnDTransferItem.getTransferItem(transferable, false);
        if (item == null) {
            return null;
        }
        SceneView sceneView = this.myDesignSurface.getSceneViewAtOrPrimary(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        NlModel model = sceneView.getSceneManager().getModel();
        DragType dragType = dropAction == 1 ? DragType.COPY : DragType.MOVE;
        InsertType insertType = model.getTreeWriter().determineInsertType(dragType, item, false, true);
        this.setType(dragType);
        this.setTransferItem(item);
        List<NlComponent> dragged = this.getDraggedComponents();
        if (insertType == InsertType.MOVE) {
            components = this.myDesignSurface.getSelectionModel().getSelection();
        } else {
            components = model.getTreeWriter().createComponents(item, insertType);
            if (components.isEmpty()) {
                return null;
            }
        }
        if (dragged.size() != components.size()) {
            throw new AssertionError((Object)String.format("Problem with drop: dragged.size(%1$d) != components.size(%2$d)", dragged.size(), components.size()));
        }
        for (int index = 0; index < dragged.size(); ++index) {
            if (!NlComponentHelperKt.getHasNlComponentInfo(components.get(index)) || !NlComponentHelperKt.getHasNlComponentInfo(dragged.get(index))) continue;
            NlComponentHelperKt.setX(components.get(index), NlComponentHelperKt.getX(dragged.get(index)));
            NlComponentHelperKt.setY(components.get(index), NlComponentHelperKt.getY(dragged.get(index)));
        }
        this.logFinishDropInteraction(components);
        dragged.clear();
        dragged.addAll(components);
        return insertType;
    }

    private void logFinishDropInteraction(@NotNull List<NlComponent> components) {
        DesignSurface<?> surface2 = this.myDesignSurface;
        if (!(surface2 instanceof NlDesignSurface)) {
            return;
        }
        NlAnalyticsManager manager = (NlAnalyticsManager)surface2.getAnalyticsManager();
        components.forEach(component -> {
            if (AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_GUIDELINE.isEquals(component.getTagName())) {
                if (ConstraintLayoutGuidelineHandler.isVertical(component)) {
                    manager.trackAddVerticalGuideline();
                } else {
                    manager.trackAddHorizontalGuideline();
                }
            }
        });
    }

    private class DragLayer
    extends Layer {
        private DragLayer() {
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (DragDropInteraction.this.myDragHandler != null) {
                DragDropInteraction.this.myDragHandler.paint(new NlGraphics(gc, DragDropInteraction.this.mySceneView));
            }
        }
    }
}

