/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DrawVerticalNotch
extends DrawRegion {
    public DrawVerticalNotch(String s) {
        super(s);
    }

    public DrawVerticalNotch(int x, int y, int height) {
        super(x, y, x, height);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getFrames();
        g.setColor(background);
        Stroke stroke = g.getStroke();
        g.setStroke(DrawConnectionUtils.sDashedStroke);
        g.drawLine(this.x, this.y, this.x, this.y + this.height);
        g.setStroke(stroke);
    }

    public static void add(DisplayList list, SceneContext transform, float left, float top, float bottom) {
        int l = transform.getSwingXDip(left);
        int t = transform.getSwingYDip(top);
        int h = transform.getSwingDimensionDip(bottom - top);
        list.add(new DrawVerticalNotch(l, t, h));
    }
}

