/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.support;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.support.StyleEnumSupport;
import com.android.tools.property.panel.api.EnumValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/uibuilder/property/support/TextAppearanceEnumSupport;", "Lcom/android/tools/idea/uibuilder/property/support/StyleEnumSupport;", "property", "Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;", "<init>", "(Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;)V", "generate", "", "Lcom/android/tools/property/panel/api/EnumValue;", "styleFilter", "", "style", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "includeMaterialStyles", "displayName", "", "findBaseStyle", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "styleName", "Companion", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class TextAppearanceEnumSupport
extends StyleEnumSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;
    private static final ResourceNamespace appcompatNamespace = ResourceNamespace.TODO();
    @NotNull
    private static final Set<String> accepted;

    public TextAppearanceEnumSupport(@NotNull NlPropertyItem property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super(property);
    }

    @Override
    @NotNull
    protected List<EnumValue> generate() {
        ResourceNamespace resourceNamespace = ResourceNamespace.ANDROID;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"ANDROID");
        StyleResourceValue styleResourceValue = this.findBaseStyle(resourceNamespace, "TextAppearance");
        if (styleResourceValue == null) {
            return CollectionsKt.emptyList();
        }
        StyleResourceValue base = styleResourceValue;
        ResourceNamespace resourceNamespace2 = appcompatNamespace;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace2, (String)"appcompatNamespace");
        StyleResourceValue appcompat = this.findBaseStyle(resourceNamespace2, "TextAppearance.AppCompat");
        boolean includeMaterialStyles = appcompat == null;
        Function1 filter2 = arg_0 -> TextAppearanceEnumSupport.generate$lambda$0(this, includeMaterialStyles, arg_0);
        Function1 sortOrder = arg_0 -> TextAppearanceEnumSupport.generate$lambda$1(this, arg_0);
        List<StyleResourceValue> styles = this.getDerivedStyles().find(base, (Function1<? super StyleResourceValue, Boolean>)filter2, sortOrder);
        return this.convertStyles(styles);
    }

    private final boolean styleFilter(StyleResourceValue style, boolean includeMaterialStyles) {
        if (style.isUserDefined()) {
            return true;
        }
        if (includeMaterialStyles && !Intrinsics.areEqual((Object)style.getNamespace(), (Object)ResourceNamespace.ANDROID)) {
            return false;
        }
        if (!includeMaterialStyles && !Intrinsics.areEqual((Object)style.getNamespace(), (Object)ResourceNamespace.TODO())) {
            return false;
        }
        String base = includeMaterialStyles ? "TextAppearance.Material." : "TextAppearance.AppCompat.";
        String string = style.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)base, (boolean)false, (int)2, null)) {
            return false;
        }
        return accepted.contains(StringUtil.trimStart((String)style.getName(), (String)base));
    }

    @Override
    @NotNull
    protected String displayName(@NotNull StyleResourceValue style) {
        String string;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        String name = style.getName();
        Intrinsics.checkNotNull((Object)name);
        if (StringsKt.startsWith$default((String)name, (String)"TextAppearance.AppCompat.", (boolean)false, (int)2, null)) {
            String string2 = StringUtil.trimStart((String)name, (String)"TextAppearance.AppCompat.");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimStart(...)");
        } else if (StringsKt.startsWith$default((String)name, (String)"TextAppearance.Material.", (boolean)false, (int)2, null)) {
            String string3 = StringUtil.trimStart((String)name, (String)"TextAppearance.Material.");
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"trimStart(...)");
        } else if (StringsKt.startsWith$default((String)name, (String)"TextAppearance.", (boolean)false, (int)2, null)) {
            String string4 = StringUtil.trimStart((String)name, (String)"TextAppearance.");
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"trimStart(...)");
        } else {
            string = name;
        }
        return string;
    }

    private final StyleResourceValue findBaseStyle(ResourceNamespace namespace, String styleName) {
        ResourceReference reference = new ResourceReference(namespace, ResourceType.STYLE, styleName);
        ResourceResolver resourceResolver = this.getResolver();
        return resourceResolver != null ? resourceResolver.getStyle(reference) : null;
    }

    private static final boolean generate$lambda$0(TextAppearanceEnumSupport this$0, boolean $includeMaterialStyles, StyleResourceValue style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return this$0.styleFilter(style, $includeMaterialStyles);
    }

    private static final String generate$lambda$1(TextAppearanceEnumSupport this$0, StyleResourceValue style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return this$0.displayName(style);
    }

    static {
        Object[] objectArray = new String[]{"Small", "Medium", "Large", "Body1", "Body2", "Display1", "Display2", "Display3", "Display4"};
        accepted = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/uibuilder/property/support/TextAppearanceEnumSupport$Companion;", "", "<init>", "()V", "appcompatNamespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "kotlin.jvm.PlatformType", "accepted", "", "", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

