/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.support;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.support.CachedEnumSupport;
import com.android.tools.idea.uibuilder.property.support.DerivedStyleFinder;
import com.android.tools.property.panel.api.EnumValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u0018\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u0015H\u0004J\u0012\u0010#\u001a\u00020\u001d2\b\u0010$\u001a\u0004\u0018\u00010\u001dH\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u0006\u0010&\u001a\u00020\u001dH\u0002J&\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020\u001d2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0*H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/uibuilder/property/support/StyleEnumSupport;", "Lcom/android/tools/idea/uibuilder/property/support/CachedEnumSupport;", "property", "Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;", "<init>", "(Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;)V", "getProperty", "()Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "resolver", "Lcom/android/ide/common/resources/ResourceResolver;", "getResolver", "()Lcom/android/ide/common/resources/ResourceResolver;", "derivedStyles", "Lcom/android/tools/idea/uibuilder/property/support/DerivedStyleFinder;", "getDerivedStyles", "()Lcom/android/tools/idea/uibuilder/property/support/DerivedStyleFinder;", "lastResult", "", "Lcom/android/tools/property/panel/api/EnumValue;", "values", "getValues", "()Ljava/util/List;", "cache", "generate", "displayName", "", "kotlin.jvm.PlatformType", "style", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "convertStyles", "styles", "determineHeaderFromLibraryName", "libraryName", "getWidgetBaseStyles", "tagName", "resolve", "qualifiedStyleName", "prefixMap", "", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStyleEnumSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleEnumSupport.kt\ncom/android/tools/idea/uibuilder/property/support/StyleEnumSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1617#2,9:125\n1869#2:134\n1870#2:136\n1626#2:137\n1#3:135\n*S KotlinDebug\n*F\n+ 1 StyleEnumSupport.kt\ncom/android/tools/idea/uibuilder/property/support/StyleEnumSupport\n*L\n109#1:125,9\n109#1:134\n109#1:136\n109#1:137\n109#1:135\n*E\n"})
public class StyleEnumSupport
implements CachedEnumSupport {
    @NotNull
    private final NlPropertyItem property;
    @NotNull
    private final AndroidFacet facet;
    @Nullable
    private final ResourceResolver resolver;
    @NotNull
    private final DerivedStyleFinder derivedStyles;
    @Nullable
    private List<? extends EnumValue> lastResult;
    public static final int $stable = 8;

    public StyleEnumSupport(@NotNull NlPropertyItem property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.property = property;
        this.facet = this.property.getModel().getFacet();
        this.resolver = this.property.getModel().getResolver();
        this.derivedStyles = new DerivedStyleFinder(this.facet, this.resolver);
    }

    @NotNull
    public final NlPropertyItem getProperty() {
        return this.property;
    }

    @NotNull
    protected final AndroidFacet getFacet() {
        return this.facet;
    }

    @Nullable
    protected final ResourceResolver getResolver() {
        return this.resolver;
    }

    @NotNull
    protected final DerivedStyleFinder getDerivedStyles() {
        return this.derivedStyles;
    }

    @NotNull
    public List<EnumValue> getValues() {
        List<EnumValue> list = this.lastResult;
        if (list == null) {
            list = this.cache(this.generate());
        }
        return list;
    }

    private final List<EnumValue> cache(List<? extends EnumValue> values) {
        this.lastResult = values;
        return values;
    }

    @NotNull
    protected List<EnumValue> generate() {
        String tagName = this.property.getTagName();
        if (((CharSequence)tagName).length() == 0) {
            return CollectionsKt.emptyList();
        }
        List<StyleResourceValue> baseStyles = this.getWidgetBaseStyles(tagName);
        List<StyleResourceValue> styles = this.derivedStyles.find(baseStyles, (Function1<? super StyleResourceValue, Boolean>)((Function1)StyleEnumSupport::generate$lambda$0), StyleEnumSupport::generate$lambda$1);
        return this.convertStyles(styles);
    }

    protected String displayName(@NotNull StyleResourceValue style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return style.getName();
    }

    @NotNull
    protected final List<EnumValue> convertStyles(@NotNull List<? extends StyleResourceValue> styles) {
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance((AndroidFacet)this.facet);
        Intrinsics.checkNotNullExpressionValue((Object)studioResourceRepositoryManager, (String)"getInstance(...)");
        StudioResourceRepositoryManager resourceManager = studioResourceRepositoryManager;
        ResourceNamespace resourceNamespace = resourceManager.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"<get-namespace>(...)");
        ResourceNamespace currentNamespace = resourceNamespace;
        ResourceNamespace.Resolver namespaceResolver2 = this.property.getNamespaceResolver();
        StyleResourceValue prev = null;
        List result = new ArrayList();
        for (StyleResourceValue styleResourceValue : styles) {
            String xmlValue;
            Intrinsics.checkNotNullExpressionValue((Object)styleResourceValue.asReference().getRelativeResourceUrl(currentNamespace, namespaceResolver2).toString(), (String)"toString(...)");
            String string = this.displayName(styleResourceValue);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"displayName(...)");
            EnumValue value = EnumValue.Companion.indented(xmlValue, string);
            if (prev != null && Intrinsics.areEqual((Object)styleResourceValue.getNamespace(), (Object)prev.getNamespace()) && Intrinsics.areEqual((Object)styleResourceValue.getLibraryName(), (Object)prev.getLibraryName())) {
                v3 = result.add(value);
            } else {
                String string2;
                ResourceNamespace resourceNamespace2 = styleResourceValue.getNamespace();
                if (Intrinsics.areEqual((Object)resourceNamespace2, (Object)ResourceNamespace.ANDROID)) {
                    string2 = "Android";
                } else if (Intrinsics.areEqual((Object)resourceNamespace2, (Object)ResourceNamespace.TODO())) {
                    string2 = this.determineHeaderFromLibraryName(styleResourceValue.getLibraryName());
                } else {
                    String string3 = styleResourceValue.getNamespace().getPackageName();
                    if (string3 == null) {
                        string3 = "Other";
                    }
                    String string4 = StringUtil.getShortName((String)string3, (char)'.');
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getShortName(...)");
                }
                String header = string2;
                result.add(EnumValue.Companion.header(header));
                v3 = result.add(value);
            }
            prev = styleResourceValue;
        }
        return result;
    }

    private final String determineHeaderFromLibraryName(String libraryName) {
        CharSequence charSequence = libraryName;
        return charSequence == null || charSequence.length() == 0 ? "Project" : (StringsKt.contains$default((CharSequence)libraryName, (CharSequence)"appcompat", (boolean)false, (int)2, null) ? "AppCompat" : "Library");
    }

    /*
     * WARNING - void declaration
     */
    private final List<StyleResourceValue> getWidgetBaseStyles(String tagName) {
        void $this$mapNotNullTo$iv$iv;
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(this.facet);
        Intrinsics.checkNotNullExpressionValue((Object)viewHandlerManager, (String)"get(...)");
        ViewHandlerManager manager = viewHandlerManager;
        ViewHandler viewHandler = manager.getHandler(tagName, StyleEnumSupport::getWidgetBaseStyles$lambda$2);
        if (viewHandler == null) {
            return CollectionsKt.emptyList();
        }
        ViewHandler handler = viewHandler;
        List<String> list = handler.getBaseStyles(tagName);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getBaseStyles(...)");
        List<String> possibleNames = list;
        Map<String, String> map2 = handler.getPrefixToNamespaceMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getPrefixToNamespaceMap(...)");
        Map<String, String> prefixMap = map2;
        Iterable $this$mapNotNull$iv = possibleNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            StyleResourceValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.resolve(it, prefixMap) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final StyleResourceValue resolve(String qualifiedStyleName, Map<String, String> prefixMap) {
        if (this.resolver == null) {
            return null;
        }
        ResourceUrl resourceUrl = ResourceUrl.parseStyleParentReference((String)qualifiedStyleName);
        if (resourceUrl == null) {
            return null;
        }
        ResourceUrl url = resourceUrl;
        ResourceReference resourceReference = url.resolve(ResourceNamespace.ANDROID, arg_0 -> StyleEnumSupport.resolve$lambda$4(prefixMap, arg_0));
        if (resourceReference == null) {
            return null;
        }
        ResourceReference reference = resourceReference;
        return this.resolver.getStyle(reference);
    }

    @NotNull
    public EnumValue createValue(@NotNull String stringValue) {
        return CachedEnumSupport.super.createValue(stringValue);
    }

    @NotNull
    public ListCellRenderer<EnumValue> getRenderer() {
        return CachedEnumSupport.super.getRenderer();
    }

    private static final boolean generate$lambda$0(StyleResourceValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Comparable generate$lambda$1(StyleResourceValue style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        String string = style.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return (Comparable)((Object)string);
    }

    private static final void getWidgetBaseStyles$lambda$2() {
    }

    private static final String resolve$lambda$4(Map $prefixMap, String it) {
        return (String)$prefixMap.get(it);
    }
}

