/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.relative.targets.AlignAttributeRules;
import com.android.tools.idea.uibuilder.model.TextDirection;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0010\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0002*\u00020\u0007H\u0000\u001a(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\"\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0007*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0018\u0010\f\u001a\u00020\u0007*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\"\u0018\u0010\u000e\u001a\u00020\u0007*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\"\u0018\u0010\u0010\u001a\u00020\u0007*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\"\u0018\u0010\u0012\u001a\u00020\u0007*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\"\u0014\u0010\u001c\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0014\u0010\u001f\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001e\"\u0014\u0010!\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0014\u0010#\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001e\"\u0014\u0010%\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001e\"\u0014\u0010'\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001e\"\u0014\u0010)\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001e\"\u0014\u0010+\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001e\"\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.X\u0080\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b/\u00100\"\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u00020.X\u0080\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b3\u00100\"\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020\u00020.X\u0080\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b5\u00100\"\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020.X\u0080\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b7\u00100\"\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u00020.X\u0080\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b9\u00100\"\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020.X\u0080\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b;\u00100\"\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020.X\u0080\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b=\u00100\u00a8\u0006>"}, d2={"getProperAttributesForLayout", "", "", "component", "Lcom/android/tools/idea/common/scene/SceneComponent;", "attribute", "drawLeft", "", "getDrawLeft", "(Lcom/android/tools/idea/common/scene/SceneComponent;)I", "drawTop", "getDrawTop", "drawRight", "getDrawRight", "drawBottom", "getDrawBottom", "drawCenterX", "getDrawCenterX", "drawCenterY", "getDrawCenterY", "toDpString", "updateAlignAttribute", "", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "value", "rules", "Lcom/android/tools/idea/uibuilder/handlers/relative/targets/AlignAttributeRules;", "TOP_ATTRIBUTE_RULES", "getTOP_ATTRIBUTE_RULES", "()Lcom/android/tools/idea/uibuilder/handlers/relative/targets/AlignAttributeRules;", "BOTTOM_ATTRIBUTE_RULES", "getBOTTOM_ATTRIBUTE_RULES", "START_ATTRIBUTE_RULES", "getSTART_ATTRIBUTE_RULES", "RTL_START_ATTRIBUTE_RULES", "getRTL_START_ATTRIBUTE_RULES", "LEFT_ATTRIBUTE_RULES", "getLEFT_ATTRIBUTE_RULES", "END_ATTRIBUTE_RULES", "getEND_ATTRIBUTE_RULES", "RTL_END_ATTRIBUTE_RULES", "getRTL_END_ATTRIBUTE_RULES", "RIGHT_ATTRIBUTE_RULES", "getRIGHT_ATTRIBUTE_RULES", "TOP_ALIGN_ATTRIBUTES", "", "getTOP_ALIGN_ATTRIBUTES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "BOTTOM_ALIGN_ATTRIBUTES", "getBOTTOM_ALIGN_ATTRIBUTES", "START_ALIGN_ATTRIBUTES", "getSTART_ALIGN_ATTRIBUTES", "LEFT_ALIGN_ATTRIBUTES", "getLEFT_ALIGN_ATTRIBUTES", "END_ALIGN_ATTRIBUTES", "getEND_ALIGN_ATTRIBUTES", "RIGHT_ALIGN_ATTRIBUTES", "getRIGHT_ALIGN_ATTRIBUTES", "RELATIVE_LAYOUT_ATTRIBUTES", "getRELATIVE_LAYOUT_ATTRIBUTES", "intellij.android.designer"})
public final class RelativeUtilitiesKt {
    @NotNull
    private static final AlignAttributeRules TOP_ATTRIBUTE_RULES;
    @NotNull
    private static final AlignAttributeRules BOTTOM_ATTRIBUTE_RULES;
    @NotNull
    private static final AlignAttributeRules START_ATTRIBUTE_RULES;
    @NotNull
    private static final AlignAttributeRules RTL_START_ATTRIBUTE_RULES;
    @NotNull
    private static final AlignAttributeRules LEFT_ATTRIBUTE_RULES;
    @NotNull
    private static final AlignAttributeRules END_ATTRIBUTE_RULES;
    @NotNull
    private static final AlignAttributeRules RTL_END_ATTRIBUTE_RULES;
    @NotNull
    private static final AlignAttributeRules RIGHT_ATTRIBUTE_RULES;
    @NotNull
    private static final String[] TOP_ALIGN_ATTRIBUTES;
    @NotNull
    private static final String[] BOTTOM_ALIGN_ATTRIBUTES;
    @NotNull
    private static final String[] START_ALIGN_ATTRIBUTES;
    @NotNull
    private static final String[] LEFT_ALIGN_ATTRIBUTES;
    @NotNull
    private static final String[] END_ALIGN_ATTRIBUTES;
    @NotNull
    private static final String[] RIGHT_ALIGN_ATTRIBUTES;
    @NotNull
    private static final String[] RELATIVE_LAYOUT_ATTRIBUTES;

    @NotNull
    public static final List<String> getProperAttributesForLayout(@NotNull SceneComponent component, @Nullable String attribute) {
        ImmutableList.Builder builder;
        block30: {
            TextDirection rtlDirection;
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            TextDirection textDirection = rtlDirection = component.getScene().isInRTL() ? TextDirection.RIGHT_TO_LEFT : TextDirection.LEFT_TO_RIGHT;
            if (attribute == null) {
                return CollectionsKt.emptyList();
            }
            builder = new ImmutableList.Builder();
            SceneManager sceneManager = component.getScene().getSceneManager();
            Intrinsics.checkNotNull((Object)sceneManager, (String)"null cannot be cast to non-null type com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager");
            ViewEditor viewEditor = ((LayoutlibSceneManager)sceneManager).getViewEditor();
            if (viewEditor.getMinSdkVersion().getApiLevel() < 17) {
                builder.add((Object)attribute);
            }
            if (viewEditor.getTargetSdkVersion().getApiLevel() < 17) break block30;
            String string = switch (attribute) {
                case "layout_alignParentLeft" -> rtlDirection.getAttrAlignParentLeft();
                case "layout_alignParentRight" -> rtlDirection.getAttrAlignParentRight();
                case "layout_alignLeft" -> rtlDirection.getAttrLeft();
                case "layout_alignRight" -> rtlDirection.getAttrRight();
                case "layout_toLeftOf" -> rtlDirection.getAttrLeftOf();
                case "layout_toRightOf" -> rtlDirection.getAttrRightOf();
                case "layout_marginLeft" -> rtlDirection.getAttrMarginLeft();
                case "layout_marginRight" -> rtlDirection.getAttrMarginRight();
                default -> attribute;
            };
            Intrinsics.checkNotNull((Object)string);
            String rtlAttribute = string;
            builder.add((Object)rtlAttribute);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return (List)immutableList;
    }

    public static final int getDrawLeft(@NotNull SceneComponent $this$drawLeft) {
        Intrinsics.checkNotNullParameter((Object)$this$drawLeft, (String)"<this>");
        return $this$drawLeft.getDrawX();
    }

    public static final int getDrawTop(@NotNull SceneComponent $this$drawTop) {
        Intrinsics.checkNotNullParameter((Object)$this$drawTop, (String)"<this>");
        return $this$drawTop.getDrawY();
    }

    public static final int getDrawRight(@NotNull SceneComponent $this$drawRight) {
        Intrinsics.checkNotNullParameter((Object)$this$drawRight, (String)"<this>");
        return $this$drawRight.getDrawX() + $this$drawRight.getDrawWidth();
    }

    public static final int getDrawBottom(@NotNull SceneComponent $this$drawBottom) {
        Intrinsics.checkNotNullParameter((Object)$this$drawBottom, (String)"<this>");
        return $this$drawBottom.getDrawY() + $this$drawBottom.getDrawHeight();
    }

    public static final int getDrawCenterX(@NotNull SceneComponent $this$drawCenterX) {
        Intrinsics.checkNotNullParameter((Object)$this$drawCenterX, (String)"<this>");
        return $this$drawCenterX.getDrawX() + $this$drawCenterX.getDrawWidth() / 2;
    }

    public static final int getDrawCenterY(@NotNull SceneComponent $this$drawCenterY) {
        Intrinsics.checkNotNullParameter((Object)$this$drawCenterY, (String)"<this>");
        return $this$drawCenterY.getDrawY() + $this$drawCenterY.getDrawHeight() / 2;
    }

    @NotNull
    public static final String toDpString(int $this$toDpString) {
        Locale locale = Locale.US;
        String string = "%ddp";
        Object[] objectArray = new Object[]{$this$toDpString};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final void updateAlignAttribute(@NotNull SceneComponent component, @NotNull NlAttributesHolder attributes, int value, @NotNull AlignAttributeRules rules) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
        SceneComponent sceneComponent = component.getParent();
        Intrinsics.checkNotNull((Object)sceneComponent);
        SceneComponent parent = sceneComponent;
        if (Intrinsics.areEqual((Object)attributes.getAndroidAttribute(rules.getAlignParentAttribute()), (Object)"true")) {
            String string = rules.getMarginAttribute();
            Locale locale = Locale.US;
            String string2 = "%ddp";
            Object[] objectArray = new Object[]{rules.getAlignParentRule().invoke((Object)parent, (Object)value)};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            attributes.setAndroidAttribute(string, string3);
            return;
        }
        for (Pair<String, Function2<SceneComponent, Integer, Integer>> pair : rules.getAlignWidgetRules()) {
            String id = (String)pair.component1();
            Function2 rule = (Function2)pair.component2();
            String alignWidget = NlComponent.extractId(attributes.getAndroidAttribute(id));
            if (alignWidget == null) continue;
            SceneComponent sceneComponent2 = parent.getSceneComponent(alignWidget);
            if (sceneComponent2 == null) {
                return;
            }
            SceneComponent alignedComponent = sceneComponent2;
            String string = rules.getMarginAttribute();
            Locale locale = Locale.US;
            String string4 = "%ddp";
            Object[] objectArray = new Object[]{rule.invoke((Object)alignedComponent, (Object)value)};
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            attributes.setAndroidAttribute(string, string5);
            return;
        }
    }

    @NotNull
    public static final AlignAttributeRules getTOP_ATTRIBUTE_RULES() {
        return TOP_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getBOTTOM_ATTRIBUTE_RULES() {
        return BOTTOM_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getSTART_ATTRIBUTE_RULES() {
        return START_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getRTL_START_ATTRIBUTE_RULES() {
        return RTL_START_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getLEFT_ATTRIBUTE_RULES() {
        return LEFT_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getEND_ATTRIBUTE_RULES() {
        return END_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getRTL_END_ATTRIBUTE_RULES() {
        return RTL_END_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getRIGHT_ATTRIBUTE_RULES() {
        return RIGHT_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final String[] getTOP_ALIGN_ATTRIBUTES() {
        return TOP_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getBOTTOM_ALIGN_ATTRIBUTES() {
        return BOTTOM_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getSTART_ALIGN_ATTRIBUTES() {
        return START_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getLEFT_ALIGN_ATTRIBUTES() {
        return LEFT_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getEND_ALIGN_ATTRIBUTES() {
        return END_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getRIGHT_ALIGN_ATTRIBUTES() {
        return RIGHT_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getRELATIVE_LAYOUT_ATTRIBUTES() {
        return RELATIVE_LAYOUT_ATTRIBUTES;
    }

    private static final int TOP_ATTRIBUTE_RULES$lambda$0(SceneComponent parent, int coordinateY) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return coordinateY - RelativeUtilitiesKt.getDrawTop(parent);
    }

    private static final int TOP_ATTRIBUTE_RULES$lambda$1(SceneComponent aligned, int coordinateY) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return coordinateY - RelativeUtilitiesKt.getDrawTop(aligned);
    }

    private static final int TOP_ATTRIBUTE_RULES$lambda$2(SceneComponent aligned, int coordinateY) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return coordinateY - RelativeUtilitiesKt.getDrawBottom(aligned);
    }

    private static final int BOTTOM_ATTRIBUTE_RULES$lambda$3(SceneComponent parent, int coordinateY) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return RelativeUtilitiesKt.getDrawBottom(parent) - coordinateY;
    }

    private static final int BOTTOM_ATTRIBUTE_RULES$lambda$4(SceneComponent aligned, int coordinateY) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return RelativeUtilitiesKt.getDrawBottom(aligned) - coordinateY;
    }

    private static final int BOTTOM_ATTRIBUTE_RULES$lambda$5(SceneComponent aligned, int coordinateY) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return RelativeUtilitiesKt.getDrawTop(aligned) - coordinateY;
    }

    private static final int START_ATTRIBUTE_RULES$lambda$6(SceneComponent parent, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return coordinateX - RelativeUtilitiesKt.getDrawLeft(parent);
    }

    private static final int START_ATTRIBUTE_RULES$lambda$7(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return coordinateX - RelativeUtilitiesKt.getDrawLeft(aligned);
    }

    private static final int START_ATTRIBUTE_RULES$lambda$8(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return coordinateX - RelativeUtilitiesKt.getDrawRight(aligned);
    }

    private static final int RTL_START_ATTRIBUTE_RULES$lambda$9(SceneComponent parent, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return RelativeUtilitiesKt.getDrawRight(parent) - coordinateX;
    }

    private static final int RTL_START_ATTRIBUTE_RULES$lambda$10(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return RelativeUtilitiesKt.getDrawRight(aligned) - coordinateX;
    }

    private static final int RTL_START_ATTRIBUTE_RULES$lambda$11(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return RelativeUtilitiesKt.getDrawLeft(aligned) - coordinateX;
    }

    private static final int LEFT_ATTRIBUTE_RULES$lambda$12(SceneComponent parent, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return coordinateX - RelativeUtilitiesKt.getDrawLeft(parent);
    }

    private static final int LEFT_ATTRIBUTE_RULES$lambda$13(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return coordinateX - RelativeUtilitiesKt.getDrawLeft(aligned);
    }

    private static final int LEFT_ATTRIBUTE_RULES$lambda$14(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return coordinateX - RelativeUtilitiesKt.getDrawRight(aligned);
    }

    private static final int END_ATTRIBUTE_RULES$lambda$15(SceneComponent parent, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return RelativeUtilitiesKt.getDrawRight(parent) - coordinateX;
    }

    private static final int END_ATTRIBUTE_RULES$lambda$16(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return RelativeUtilitiesKt.getDrawRight(aligned) - coordinateX;
    }

    private static final int END_ATTRIBUTE_RULES$lambda$17(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return RelativeUtilitiesKt.getDrawLeft(aligned) - coordinateX;
    }

    private static final int RTL_END_ATTRIBUTE_RULES$lambda$18(SceneComponent parent, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return coordinateX - RelativeUtilitiesKt.getDrawLeft(parent);
    }

    private static final int RTL_END_ATTRIBUTE_RULES$lambda$19(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return coordinateX - RelativeUtilitiesKt.getDrawLeft(aligned);
    }

    private static final int RTL_END_ATTRIBUTE_RULES$lambda$20(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return coordinateX - RelativeUtilitiesKt.getDrawRight(aligned);
    }

    private static final int RIGHT_ATTRIBUTE_RULES$lambda$21(SceneComponent parent, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return RelativeUtilitiesKt.getDrawRight(parent) - coordinateX;
    }

    private static final int RIGHT_ATTRIBUTE_RULES$lambda$22(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return RelativeUtilitiesKt.getDrawRight(aligned) - coordinateX;
    }

    private static final int RIGHT_ATTRIBUTE_RULES$lambda$23(SceneComponent aligned, int coordinateX) {
        Intrinsics.checkNotNullParameter((Object)aligned, (String)"aligned");
        return RelativeUtilitiesKt.getDrawLeft(aligned) - coordinateX;
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"layout_alignTop", RelativeUtilitiesKt::TOP_ATTRIBUTE_RULES$lambda$1), TuplesKt.to((Object)"layout_below", RelativeUtilitiesKt::TOP_ATTRIBUTE_RULES$lambda$2)};
        TOP_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginTop", "layout_alignParentTop", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RelativeUtilitiesKt::TOP_ATTRIBUTE_RULES$lambda$0), (Pair<String, ? extends Function2<? super SceneComponent, ? super Integer, Integer>>[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"layout_alignBottom", RelativeUtilitiesKt::BOTTOM_ATTRIBUTE_RULES$lambda$4), TuplesKt.to((Object)"layout_above", RelativeUtilitiesKt::BOTTOM_ATTRIBUTE_RULES$lambda$5)};
        BOTTOM_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginBottom", "layout_alignParentBottom", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RelativeUtilitiesKt::BOTTOM_ATTRIBUTE_RULES$lambda$3), (Pair<String, ? extends Function2<? super SceneComponent, ? super Integer, Integer>>[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"layout_alignStart", RelativeUtilitiesKt::START_ATTRIBUTE_RULES$lambda$7), TuplesKt.to((Object)"layout_toEndOf", RelativeUtilitiesKt::START_ATTRIBUTE_RULES$lambda$8)};
        START_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginStart", "layout_alignParentStart", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RelativeUtilitiesKt::START_ATTRIBUTE_RULES$lambda$6), (Pair<String, ? extends Function2<? super SceneComponent, ? super Integer, Integer>>[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"layout_alignStart", RelativeUtilitiesKt::RTL_START_ATTRIBUTE_RULES$lambda$10), TuplesKt.to((Object)"layout_toEndOf", RelativeUtilitiesKt::RTL_START_ATTRIBUTE_RULES$lambda$11)};
        RTL_START_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginStart", "layout_alignParentStart", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RelativeUtilitiesKt::RTL_START_ATTRIBUTE_RULES$lambda$9), (Pair<String, ? extends Function2<? super SceneComponent, ? super Integer, Integer>>[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"layout_alignLeft", RelativeUtilitiesKt::LEFT_ATTRIBUTE_RULES$lambda$13), TuplesKt.to((Object)"layout_toRightOf", RelativeUtilitiesKt::LEFT_ATTRIBUTE_RULES$lambda$14)};
        LEFT_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginLeft", "layout_alignParentLeft", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RelativeUtilitiesKt::LEFT_ATTRIBUTE_RULES$lambda$12), (Pair<String, ? extends Function2<? super SceneComponent, ? super Integer, Integer>>[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"layout_alignEnd", RelativeUtilitiesKt::END_ATTRIBUTE_RULES$lambda$16), TuplesKt.to((Object)"layout_toStartOf", RelativeUtilitiesKt::END_ATTRIBUTE_RULES$lambda$17)};
        END_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginEnd", "layout_alignParentEnd", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RelativeUtilitiesKt::END_ATTRIBUTE_RULES$lambda$15), (Pair<String, ? extends Function2<? super SceneComponent, ? super Integer, Integer>>[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"layout_alignEnd", RelativeUtilitiesKt::RTL_END_ATTRIBUTE_RULES$lambda$19), TuplesKt.to((Object)"layout_toStartOf", RelativeUtilitiesKt::RTL_END_ATTRIBUTE_RULES$lambda$20)};
        RTL_END_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginEnd", "layout_alignParentEnd", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RelativeUtilitiesKt::RTL_END_ATTRIBUTE_RULES$lambda$18), (Pair<String, ? extends Function2<? super SceneComponent, ? super Integer, Integer>>[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"layout_alignRight", RelativeUtilitiesKt::RIGHT_ATTRIBUTE_RULES$lambda$22), TuplesKt.to((Object)"layout_toLeftOf", RelativeUtilitiesKt::RIGHT_ATTRIBUTE_RULES$lambda$23)};
        RIGHT_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginRight", "layout_alignParentRight", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RelativeUtilitiesKt::RIGHT_ATTRIBUTE_RULES$lambda$21), (Pair<String, ? extends Function2<? super SceneComponent, ? super Integer, Integer>>[])objectArray);
        objectArray = new String[]{"layout_alignParentTop", "layout_alignTop", "layout_below"};
        TOP_ALIGN_ATTRIBUTES = objectArray;
        objectArray = new String[]{"layout_alignParentBottom", "layout_alignBottom", "layout_above"};
        BOTTOM_ALIGN_ATTRIBUTES = objectArray;
        objectArray = new String[]{"layout_alignParentStart", "layout_alignStart", "layout_toEndOf"};
        START_ALIGN_ATTRIBUTES = objectArray;
        objectArray = new String[]{"layout_alignParentLeft", "layout_alignLeft", "layout_toRightOf"};
        LEFT_ALIGN_ATTRIBUTES = objectArray;
        objectArray = new String[]{"layout_alignParentEnd", "layout_alignEnd", "layout_toStartOf"};
        END_ALIGN_ATTRIBUTES = objectArray;
        objectArray = new String[]{"layout_alignParentRight", "layout_alignRight", "layout_toLeftOf"};
        RIGHT_ALIGN_ATTRIBUTES = objectArray;
        RELATIVE_LAYOUT_ATTRIBUTES = (String[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])TOP_ALIGN_ATTRIBUTES, (Object[])BOTTOM_ALIGN_ATTRIBUTES), (Object[])START_ALIGN_ATTRIBUTES), (Object[])LEFT_ALIGN_ATTRIBUTES), (Object[])END_ALIGN_ATTRIBUTES), (Object[])RIGHT_ALIGN_ATTRIBUTES), (Object)"layout_centerHorizontal"), (Object)"layout_centerVertical"), (Object)"layout_centerInParent");
    }
}

