/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.Region;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.common.CommonDragHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridBarriers;
import com.android.tools.idea.uibuilder.handlers.grid.GridPlaceholder;
import com.android.tools.idea.uibuilder.handlers.grid.GridUtilsKt;
import com.android.tools.idea.uibuilder.handlers.grid.targets.GridResizeTarget;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000f2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0016\u0010'\u001a\u00020\u00142\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0)H\u0002J$\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u000f2\u0006\u0010\u001f\u001a\u00020\r2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/grid/GridLayoutHandler;", "Lcom/android/tools/idea/uibuilder/api/ViewGroupHandler;", "<init>", "()V", "namespace", "", "getNamespace", "()Ljava/lang/String;", "createDragHandler", "Lcom/android/tools/idea/uibuilder/api/DragHandler;", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "layout", "Lcom/android/tools/idea/common/scene/SceneComponent;", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "type", "Lcom/android/tools/idea/common/api/DragType;", "onChildRemoved", "", "newChild", "insertType", "Lcom/android/tools/idea/common/api/InsertType;", "createInteraction", "Lcom/android/tools/idea/common/scene/SceneInteraction;", "screenView", "Lcom/android/tools/idea/uibuilder/surface/ScreenView;", "x", "", "y", "component", "handlesPainting", "", "createChildTargets", "Lcom/android/tools/idea/common/scene/target/Target;", "parentComponent", "childComponent", "shouldAddCommonDragTarget", "createResizeTarget", "listBuilder", "Lcom/google/common/collect/ImmutableList$Builder;", "getPlaceholders", "Lcom/android/tools/idea/common/scene/Placeholder;", "draggedComponents", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGridLayoutHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridLayoutHandler.kt\ncom/android/tools/idea/uibuilder/handlers/grid/GridLayoutHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n11228#2:101\n11563#2,3:102\n*S KotlinDebug\n*F\n+ 1 GridLayoutHandler.kt\ncom/android/tools/idea/uibuilder/handlers/grid/GridLayoutHandler\n*L\n71#1:101\n71#1:102,3\n*E\n"})
public class GridLayoutHandler
extends ViewGroupHandler {
    @NotNull
    private final String namespace;
    public static final int $stable = 8;

    public GridLayoutHandler() {
        this.namespace = "http://schemas.android.com/apk/res/android";
    }

    @NotNull
    protected String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<? extends NlComponent> components, @NotNull DragType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new CommonDragHandler(editor, (ViewGroupHandler)this, layout, components, type);
    }

    @Override
    public void onChildRemoved(@NotNull NlComponent layout, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)newChild, (String)"newChild");
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        newChild.removeAttribute(this.getNamespace(), "layout_row");
        newChild.removeAttribute(this.getNamespace(), "layout_column");
        newChild.removeAttribute(this.getNamespace(), "layout_rowSpan");
        newChild.removeAttribute(this.getNamespace(), "layout_columnSpan");
    }

    @Override
    @NotNull
    public SceneInteraction createInteraction(@NotNull ScreenView screenView, int x, int y, @NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)screenView, (String)"screenView");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return new SceneInteraction(screenView);
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)childComponent, (String)"childComponent");
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        Intrinsics.checkNotNull((Object)listBuilder);
        this.createResizeTarget((ImmutableList.Builder<Target>)listBuilder);
        ImmutableList immutableList = listBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return (List)immutableList;
    }

    @Override
    public boolean shouldAddCommonDragTarget(@NotNull SceneComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void createResizeTarget(ImmutableList.Builder<Target> listBuilder) {
        void $this$mapTo$iv$iv;
        ResizeBaseTarget.Type[] $this$map$iv = ResizeBaseTarget.Type.values();
        boolean $i$f$map = false;
        ResizeBaseTarget.Type[] typeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(listBuilder.add((Object)new GridResizeTarget((ResizeBaseTarget.Type)it)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @NotNull
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component, @NotNull List<? extends SceneComponent> draggedComponents) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(draggedComponents, (String)"draggedComponents");
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        GridBarriers barrier = GridUtilsKt.getGridBarriers(component);
        Iterator<Integer> iterator = barrier.getRowIndices().iterator();
        while (iterator.hasNext()) {
            int row = ((Number)iterator.next()).intValue();
            Iterator<Integer> iterator2 = barrier.getColumnIndices().iterator();
            while (iterator2.hasNext()) {
                Rectangle bounds2;
                int column = ((Number)iterator2.next()).intValue();
                if (barrier.getBounds(row, column) == null || bounds2.width <= 0 || bounds2.height <= 0) continue;
                Region r = new Region(bounds2.x, bounds2.y, bounds2.x + bounds2.width, bounds2.y + bounds2.height, component.getDepth());
                listBuilder.add((Object)new GridPlaceholder(r, row, column, this.getNamespace(), component));
            }
        }
        ImmutableList immutableList = listBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return (List)immutableList;
    }
}

