/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnection;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawConnectionUtils {
    static final int ZIGZAG = JBUI.scale((int)2);
    static final int CENTER_ZIGZAG = JBUI.scale((int)3);
    public static final int MARGIN_SPACING = JBUI.scale((int)3);
    private static final boolean DEBUG = false;
    private static final boolean DRAW_ARROW = false;
    static Font sFont = JBFont.create((Font)new Font("Helvetica", 0, 12));
    static Font sFontReference = JBFont.create((Font)new Font("Helvetica", 3, 12));
    public static Stroke sDashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{JBUI.scale((int)2)}, 0.0f);
    public static final int ARROW_SIDE = JBUI.scale((int)6);
    public static final int CONNECTION_ARROW_SIZE = JBUI.scale((int)5);
    public static final int SMALL_ARROW_SIDE = JBUI.scale((int)4);
    public static final int SMALL_ARROW_SIZE = JBUI.scale((int)3);

    public static void drawRoundRectText(Graphics2D g, Font font, Color textColor, String text, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setFont(font);
        FontMetrics fm = g2.getFontMetrics();
        int padding = JBUI.scale((int)4);
        Rectangle2D bounds2 = fm.getStringBounds(text, g2);
        double th = bounds2.getHeight() + (double)(padding * 2);
        double tw = bounds2.getWidth() + (double)(padding * 2);
        int radius = (int)(Math.min(th, tw) / 3.0);
        g2.fillRoundRect((int)((double)x - tw / 2.0), (int)((double)y - th / 2.0), (int)tw, (int)th, radius, radius);
        g2.setColor(textColor);
        g2.drawString(text, (int)((double)x - tw / 2.0 + (double)padding), (int)((double)y - th / 2.0 + (double)fm.getAscent() + (double)padding));
        g2.dispose();
    }

    public static void drawHorizontalMarginIndicator(Graphics2D g, String text, boolean isMarginReference, int x1, int x2, int y) {
        if (x1 > x2) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (text == null) {
            g.drawLine(x1, y, x2, y);
            g.drawLine(x1, y, x1 + CONNECTION_ARROW_SIZE, y - CONNECTION_ARROW_SIZE);
            g.drawLine(x1, y, x1 + CONNECTION_ARROW_SIZE, y + CONNECTION_ARROW_SIZE);
            g.drawLine(x2, y, x2 - CONNECTION_ARROW_SIZE, y - CONNECTION_ARROW_SIZE);
            g.drawLine(x2, y, x2 - CONNECTION_ARROW_SIZE, y + CONNECTION_ARROW_SIZE);
            return;
        }
        Canvas c = new Canvas();
        Font previousFont = g.getFont();
        Font font = isMarginReference ? sFontReference : sFont;
        FontMetrics fm = c.getFontMetrics(font);
        g.setFont(font);
        int padding = JBUI.scale((int)4);
        Rectangle2D bounds2 = fm.getStringBounds(text, g);
        int tw = (int)bounds2.getWidth();
        int offset = 3 * CONNECTION_ARROW_SIZE;
        int w = (x2 - x1 - (tw + 2 * padding)) / 2;
        if (w <= padding) {
            g.drawLine(x1, y, x2, y);
            g.drawString(text, x1 + w + padding, y + offset);
            g.drawLine(x1, y, x1, y);
            g.drawLine(x2, y, x2, y);
        } else {
            g.drawLine(x1, y, x1 + w, y);
            g.drawLine(x2 - w, y, x2, y);
            g.drawString(text, x1 + w + padding, (int)((double)y + bounds2.getHeight() / 2.0));
            g.drawLine(x1 + 1, y, x1 + 1, y - CONNECTION_ARROW_SIZE);
            g.drawLine(x1 + 1, y, x1 + 1, y + CONNECTION_ARROW_SIZE);
            g.drawLine(x2 - 1, y, x2 - 1, y - CONNECTION_ARROW_SIZE);
            g.drawLine(x2 - 1, y, x2 - 1, y + CONNECTION_ARROW_SIZE);
        }
        g.setFont(previousFont);
    }

    public static void drawVerticalMarginIndicator(Graphics2D g, String text, boolean isMarginReference, int x, int y1, int y2) {
        if (y1 > y2) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (text == null) {
            g.drawLine(x, y1, x, y2);
            g.drawLine(x, y1, x - CONNECTION_ARROW_SIZE, y1);
            g.drawLine(x, y1, x + CONNECTION_ARROW_SIZE, y1);
            g.drawLine(x, y2, x - CONNECTION_ARROW_SIZE, y2);
            g.drawLine(x, y2, x + CONNECTION_ARROW_SIZE, y2);
            return;
        }
        Canvas c = new Canvas();
        Font previousFont = g.getFont();
        Font font = isMarginReference ? sFontReference : sFont;
        FontMetrics fm = c.getFontMetrics(font);
        g.setFont(font);
        int padding = JBUI.scale((int)4);
        Rectangle2D bounds2 = fm.getStringBounds(text, g);
        int th = (int)bounds2.getHeight();
        int offset = 3 * CONNECTION_ARROW_SIZE;
        int h = (y2 - y1 - (th + 2 * padding)) / 2;
        if (h <= padding) {
            g.drawLine(x, y1, x, y2);
            g.drawString(text, (int)((double)x - bounds2.getWidth() / 2.0) + offset, y2 - h - padding);
            g.drawLine(x - CONNECTION_ARROW_SIZE, y1, x + CONNECTION_ARROW_SIZE, y1);
            g.drawLine(x - CONNECTION_ARROW_SIZE, y2, x + CONNECTION_ARROW_SIZE, y2);
        } else {
            g.drawLine(x, y1, x, y1 + h);
            g.drawLine(x, y2 - h, x, y2);
            g.drawString(text, (int)((double)x - bounds2.getWidth() / 2.0), y2 - h - padding);
            g.drawLine(x, y1 + 1, x - CONNECTION_ARROW_SIZE, y1 + 1);
            g.drawLine(x, y1 + 1, x + CONNECTION_ARROW_SIZE, y1 + 1);
            g.drawLine(x, y2 - 1, x - CONNECTION_ARROW_SIZE, y2 - 1);
            g.drawLine(x, y2 - 1, x + CONNECTION_ARROW_SIZE, y2 - 1);
        }
        g.setFont(previousFont);
    }

    public static void getArrow(int direction, int x, int y, int[] xPoints, int[] yPoints) {
        xPoints[0] = x;
        yPoints[0] = y;
        switch (direction) {
            case 3: {
                xPoints[1] = x - CONNECTION_ARROW_SIZE;
                xPoints[2] = x + CONNECTION_ARROW_SIZE;
                yPoints[1] = y + ARROW_SIDE;
                yPoints[2] = y + ARROW_SIDE;
                break;
            }
            case 2: {
                xPoints[1] = x - CONNECTION_ARROW_SIZE;
                xPoints[2] = x + CONNECTION_ARROW_SIZE;
                yPoints[1] = y - ARROW_SIDE;
                yPoints[2] = y - ARROW_SIDE;
                break;
            }
            case 0: {
                xPoints[1] = x - ARROW_SIDE;
                xPoints[2] = x - ARROW_SIDE;
                yPoints[1] = y - CONNECTION_ARROW_SIZE;
                yPoints[2] = y + CONNECTION_ARROW_SIZE;
                break;
            }
            case 1: {
                xPoints[1] = x + ARROW_SIDE;
                xPoints[2] = x + ARROW_SIDE;
                yPoints[1] = y - CONNECTION_ARROW_SIZE;
                yPoints[2] = y + CONNECTION_ARROW_SIZE;
            }
        }
    }

    public static void getSmallArrow(int direction, int x, int y, int[] xPoints, int[] yPoints) {
        xPoints[0] = x;
        yPoints[0] = y;
        switch (direction) {
            case 3: {
                xPoints[1] = x - SMALL_ARROW_SIZE;
                xPoints[2] = x + SMALL_ARROW_SIZE;
                yPoints[1] = y + SMALL_ARROW_SIDE;
                yPoints[2] = y + SMALL_ARROW_SIDE;
                break;
            }
            case 2: {
                xPoints[1] = x - SMALL_ARROW_SIZE;
                xPoints[2] = x + SMALL_ARROW_SIZE;
                yPoints[1] = y - SMALL_ARROW_SIDE;
                yPoints[2] = y - SMALL_ARROW_SIDE;
                break;
            }
            case 0: {
                xPoints[1] = x - SMALL_ARROW_SIDE;
                xPoints[2] = x - SMALL_ARROW_SIDE;
                yPoints[1] = y - SMALL_ARROW_SIZE;
                yPoints[2] = y + SMALL_ARROW_SIZE;
                break;
            }
            case 1: {
                xPoints[1] = x + SMALL_ARROW_SIDE;
                xPoints[2] = x + SMALL_ARROW_SIDE;
                yPoints[1] = y - SMALL_ARROW_SIZE;
                yPoints[2] = y + SMALL_ARROW_SIZE;
            }
        }
    }

    static int removeZigZag(int[] xPoints, int[] yPoints, int length, int distance) {
        int dir1 = -1;
        int dir2 = -1;
        int dir3 = -1;
        int len2 = distance;
        int len3 = distance;
        for (int i = 0; i < length - 1; ++i) {
            int dx = xPoints[i + 1] - xPoints[i];
            int dy = yPoints[i + 1] - yPoints[i];
            int dir4 = dx == 0 ? (dy > 0 ? 0 : 2) : (dx > 0 ? 1 : 3);
            int len4 = Math.abs(dx == 0 ? dy : dx);
            if (dir1 >= 0 && dir1 == dir3 && dir2 == dir4 && distance > len2) {
                if (dir1 == 0 || dir1 == 2) {
                    yPoints[i - 2] = yPoints[i];
                } else {
                    xPoints[i - 2] = xPoints[i];
                }
                for (int j = i + 1; j < length; ++j) {
                    xPoints[j - 2] = xPoints[j];
                    yPoints[j - 2] = yPoints[j];
                }
                return length - 2;
            }
            dir1 = dir2;
            dir2 = dir3;
            dir3 = dir4;
            len2 = len3;
            len3 = len4;
        }
        return length;
    }

    public static void drawRound(Path2D.Float path, int[] xPoints, int[] yPoints, int length, int archLen) {
        int[] arches = new int[xPoints.length - 1];
        Arrays.fill(arches, archLen);
        DrawConnectionUtils.drawRound(path, xPoints, yPoints, length, arches);
    }

    public static void drawPick(ScenePicker.Writer pick, Object obj, int[] xPoints, int[] yPoints, int length, int archLen) {
        int[] arches = new int[xPoints.length - 1];
        Arrays.fill(arches, archLen);
        DrawConnectionUtils.pickRound(pick, obj, xPoints, yPoints, length, arches);
    }

    public static void pickRound(ScenePicker.Writer pick, Object obj, int[] xPoints, int[] yPoints, int length, int[] arches) {
        int p;
        int lastx = xPoints[0];
        int lasty = yPoints[0];
        for (p = 1; p < length - 1; ++p) {
            int dir0;
            int d0x = xPoints[p] - lastx;
            int d0y = yPoints[p] - lasty;
            int d1x = xPoints[p + 1] - xPoints[p];
            int d1y = yPoints[p + 1] - yPoints[p];
            int len0 = Math.abs(d0x) + Math.abs(d0y);
            int len1 = Math.abs(d1x) + Math.abs(d1y);
            int d0xs = Integer.signum(d0x);
            int d0ys = Integer.signum(d0y);
            int d1xs = Integer.signum(d1x);
            int d1ys = Integer.signum(d1y);
            int useArch = Math.min(len0 - 2, Math.min(len1 / 2 - 2, arches[p - 1]));
            if (useArch < 2) {
                pick.addLine(obj, 4, lastx, lasty, xPoints[p], yPoints[p], 4);
                lastx = xPoints[p];
                lasty = yPoints[p];
                continue;
            }
            pick.addLine(obj, 4, lastx, lasty, xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys, 4);
            lastx = xPoints[p] + useArch * d1xs;
            lasty = yPoints[p] + useArch * d1ys;
            int n = d0xs == 0 ? (d0ys < 1 ? 0 : 2) : (dir0 = d0xs > 0 ? 1 : 3);
            int dir1 = d1xs == 0 ? (d1ys < 1 ? 0 : 2) : (d1xs > 0 ? 1 : 3);
            int rot = (4 + dir1 - dir0) % 4;
            boolean dir = rot == 1;
            DrawConnectionUtils.pickArc(pick, obj, xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys, lastx, lasty, useArch, useArch, 0.0f, false, dir);
            pick.addLine(obj, 4, lastx, lasty, xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys, 4);
        }
        pick.addLine(obj, 4, lastx, lasty, xPoints[p], yPoints[p], 4);
    }

    private static void pickArc(ScenePicker.Writer pick, Object obj, float x0, float y0, float x1, float y1, float a, float b, float theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        double cy;
        double cx;
        double thetaD = (double)theta * Math.PI / 180.0;
        double cosTheta = Math.cos(thetaD);
        double sinTheta = Math.sin(thetaD);
        double x0p = ((double)x0 * cosTheta + (double)y0 * sinTheta) / (double)a;
        double y0p = ((double)(-x0) * sinTheta + (double)y0 * cosTheta) / (double)b;
        double x1p = ((double)x1 * cosTheta + (double)y1 * sinTheta) / (double)a;
        double y1p = ((double)(-x1) * sinTheta + (double)y1 * cosTheta) / (double)b;
        double dx = x0p - x1p;
        double dy = y0p - y1p;
        double xm = (x0p + x1p) / 2.0;
        double ym = (y0p + y1p) / 2.0;
        double dsq = dx * dx + dy * dy;
        if (dsq == 0.0) {
            return;
        }
        double disc = 1.0 / dsq - 0.25;
        if (disc < 0.0) {
            float adjust = (float)(Math.sqrt(dsq) / 1.99999);
            DrawConnectionUtils.pickArc(pick, obj, x0, y0, x1, y1, a * adjust, b * adjust, theta, isMoreThanHalf, isPositiveArc);
            return;
        }
        double s = Math.sqrt(disc);
        double sdx = s * dx;
        double sdy = s * dy;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        double eta1 = Math.atan2(y1p - cy, x1p - cx);
        double sweep = eta1 - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= (double)a;
        cx = cx * cosTheta - (cy *= (double)b) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        DrawConnectionUtils.pickArcToBezier(pick, obj, cx, cy, a, b, x0, y0, thetaD, eta0, sweep);
    }

    private static void pickArcToBezier(ScenePicker.Writer pick, Object obj, double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start, double sweep) {
        int numSegments = Math.abs((int)Math.ceil(sweep * 4.0 / Math.PI));
        double eta1 = start;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
        double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
            double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
            double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
            double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / 2.0);
            double alpha = Math.sin(eta2 - eta1) * (Math.sqrt(4.0 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / 3.0;
            double q1x = e1x + alpha * ep1x;
            double q1y = e1y + alpha * ep1y;
            double q2x = e2x - alpha * ep2x;
            double q2y = e2y - alpha * ep2y;
            pick.addCurveTo(obj, 4, (int)e1x, (int)e1y, (int)q1x, (int)q1y, (int)q2x, (int)q2y, (int)e2x, (int)e2y, 4);
            eta1 = eta2;
            e1x = e2x;
            e1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }

    public static void drawRound(Path2D.Float path, int[] xPoints, int[] yPoints, int length, int[] arches) {
        int p;
        int lastx = xPoints[0];
        int lasty = yPoints[0];
        for (p = 1; p < length - 1; ++p) {
            int dir0;
            int d0x = xPoints[p] - lastx;
            int d0y = yPoints[p] - lasty;
            int d1x = xPoints[p + 1] - xPoints[p];
            int d1y = yPoints[p + 1] - yPoints[p];
            int len0 = Math.abs(d0x) + Math.abs(d0y);
            int len1 = Math.abs(d1x) + Math.abs(d1y);
            int d0xs = Integer.signum(d0x);
            int d0ys = Integer.signum(d0y);
            int d1xs = Integer.signum(d1x);
            int d1ys = Integer.signum(d1y);
            int useArch = Math.min(len0 - 2, Math.min(len1 / 2 - 2, arches[p - 1]));
            if (useArch < 2) {
                path.lineTo(xPoints[p], yPoints[p]);
                lastx = xPoints[p];
                lasty = yPoints[p];
                continue;
            }
            path.lineTo(xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys);
            lastx = xPoints[p] + useArch * d1xs;
            lasty = yPoints[p] + useArch * d1ys;
            int n = d0xs == 0 ? (d0ys < 1 ? 0 : 2) : (dir0 = d0xs > 0 ? 1 : 3);
            int dir1 = d1xs == 0 ? (d1ys < 1 ? 0 : 2) : (d1xs > 0 ? 1 : 3);
            int rot = (4 + dir1 - dir0) % 4;
            boolean dir = rot == 1;
            DrawConnectionUtils.drawArc(path, xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys, lastx, lasty, useArch, useArch, 0.0f, false, dir);
            path.lineTo(lastx, lasty);
        }
        path.lineTo(xPoints[p], yPoints[p]);
    }

    private static void drawArc(Path2D p, float x0, float y0, float x1, float y1, float a, float b, float theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        double cy;
        double cx;
        double thetaD = (double)theta * Math.PI / 180.0;
        double cosTheta = Math.cos(thetaD);
        double sinTheta = Math.sin(thetaD);
        double x0p = ((double)x0 * cosTheta + (double)y0 * sinTheta) / (double)a;
        double y0p = ((double)(-x0) * sinTheta + (double)y0 * cosTheta) / (double)b;
        double x1p = ((double)x1 * cosTheta + (double)y1 * sinTheta) / (double)a;
        double y1p = ((double)(-x1) * sinTheta + (double)y1 * cosTheta) / (double)b;
        double dx = x0p - x1p;
        double dy = y0p - y1p;
        double xm = (x0p + x1p) / 2.0;
        double ym = (y0p + y1p) / 2.0;
        double dsq = dx * dx + dy * dy;
        if (dsq == 0.0) {
            return;
        }
        double disc = 1.0 / dsq - 0.25;
        if (disc < 0.0) {
            float adjust = (float)(Math.sqrt(dsq) / 1.99999);
            DrawConnectionUtils.drawArc(p, x0, y0, x1, y1, a * adjust, b * adjust, theta, isMoreThanHalf, isPositiveArc);
            return;
        }
        double s = Math.sqrt(disc);
        double sdx = s * dx;
        double sdy = s * dy;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        double eta1 = Math.atan2(y1p - cy, x1p - cx);
        double sweep = eta1 - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= (double)a;
        cx = cx * cosTheta - (cy *= (double)b) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        DrawConnectionUtils.arcToBezier(p, cx, cy, a, b, x0, y0, thetaD, eta0, sweep);
    }

    private static void arcToBezier(Path2D p, double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start, double sweep) {
        int numSegments = Math.abs((int)Math.ceil(sweep * 4.0 / Math.PI));
        double eta1 = start;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
        double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
            double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
            double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
            double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / 2.0);
            double alpha = Math.sin(eta2 - eta1) * (Math.sqrt(4.0 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / 3.0;
            double q1x = e1x + alpha * ep1x;
            double q1y = e1y + alpha * ep1y;
            double q2x = e2x - alpha * ep2x;
            double q2y = e2y - alpha * ep2y;
            p.curveTo((float)q1x, (float)q1y, (float)q2x, (float)q2y, (float)e2x, (float)e2y);
            eta1 = eta2;
            e1x = e2x;
            e1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }

    public static void drawHorizontalZigZagLine(Path2D.Float path, int x1, int x2, int y) {
        DrawConnectionUtils.drawHorizontalZigZagLine(path, x1, x2, y, CENTER_ZIGZAG, CENTER_ZIGZAG);
    }

    static void drawHorizontalZigZagLine(Path2D.Float path, int x1, int x2, int y, int dY1, int dY2) {
        if (x2 < x1) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        int distance = x2 - x1;
        int step = ZIGZAG * 2 + (dY2 > 0 ? ZIGZAG : 0);
        int count = distance / step - 2;
        int remainings = distance - count * step;
        int x = x1 + remainings / 2;
        path.moveTo(x1, y);
        path.lineTo(x, y);
        for (int i = 0; i < count; ++i) {
            path.lineTo(x + ZIGZAG, y + dY1);
            path.lineTo(x + 2 * ZIGZAG, y - dY2);
            if (dY2 != 0) {
                path.lineTo(x + 3 * ZIGZAG, y);
            }
            x += step;
        }
        path.lineTo(x2, y);
    }

    public static void drawVerticalZigZagLine(Path2D.Float path, int x, int y1, int y2) {
        DrawConnectionUtils.drawVerticalZigZagLine(path, x, y1, y2, CENTER_ZIGZAG, CENTER_ZIGZAG);
    }

    static void drawVerticalZigZagLine(Path2D.Float path, int x, int y1, int y2, int dX1, int dX2) {
        if (y2 < y1) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        int distance = y2 - y1;
        int step = ZIGZAG * 2 + (dX2 > 0 ? ZIGZAG : 0);
        int count = distance / step - 2;
        int remainings = distance - count * step;
        int y = y1 + remainings / 2;
        path.moveTo(x, y1);
        path.lineTo(x, y);
        for (int i = 0; i < count; ++i) {
            path.lineTo(x + dX1, y + ZIGZAG);
            path.lineTo(x - dX2, y + 2 * ZIGZAG);
            if (dX2 != 0) {
                path.lineTo(x, y + 3 * ZIGZAG);
            }
            y += step;
        }
        path.lineTo(x, y2);
    }

    public static int getVerticalMarginGap(Graphics2D g) {
        g.setFont(sFont);
        return g.getFontMetrics().getHeight() + 2 * MARGIN_SPACING;
    }

    public static int getHorizontalMarginGap(Graphics2D g, String string) {
        g.setFont(sFont);
        return (int)(g.getFontMetrics().getStringBounds(string, g).getWidth() + (double)(2 * MARGIN_SPACING));
    }

    public static void drawHorizontalMargin(@NotNull Graphics2D g, @Nullable String string, boolean isReference, int x1, int x2, int y) {
        g.drawLine(x1, y, x2, y);
        DrawConnectionUtils.drawHorizontalMarginString(g, null, string, isReference, x1, x2, y);
    }

    public static void drawHorizontalMarginString(@NotNull Graphics2D g, @Nullable Color stringColor, @Nullable String string, boolean isReference, int x1, int x2, int y) {
        if (stringColor != null) {
            g.setColor(stringColor);
        }
        if (string != null) {
            Font previousFont = g.getFont();
            g.setFont(sFont);
            FontMetrics metrics = g.getFontMetrics();
            Rectangle2D rect = metrics.getStringBounds(string, g);
            float sx = (float)((double)((float)(x1 + x2) / 2.0f) - rect.getWidth() / 2.0);
            float sy = y - MARGIN_SPACING - metrics.getDescent();
            if (isReference) {
                g.setFont(sFontReference);
            }
            g.drawString(string, sx, sy);
            g.setFont(previousFont);
        }
    }

    public static void drawVerticalMargin(@NotNull Graphics2D g, @Nullable String string, boolean isReference, int x, int y1, int y2) {
        g.drawLine(x, y1, x, y2);
        DrawConnectionUtils.drawVerticalMarginString(g, null, string, isReference, x, y1, y2);
    }

    public static void drawVerticalMarginString(@NotNull Graphics2D g, @Nullable Color stringColor, @Nullable String string, boolean isReference, int x, int y1, int y2) {
        if (stringColor != null) {
            g.setColor(stringColor);
        }
        if (string != null) {
            Font previousFont = g.getFont();
            g.setFont(sFont);
            FontMetrics metrics = g.getFontMetrics();
            Rectangle2D rect = metrics.getStringBounds(string, g);
            float sx = x + MARGIN_SPACING;
            float sy = (float)((double)((float)(y2 + y1) / 2.0f) + rect.getHeight() / 2.0 - (double)metrics.getDescent());
            if (isReference) {
                g.setFont(sFontReference);
            }
            g.drawString(string, sx, sy);
            g.setFont(previousFont);
        }
    }

    public static void drawChain(Graphics2D g, boolean hover, int startX, int startY, int endX, int endY, int scaleSource, int scaleDest, int sourceDirection, int destDirection, ScenePicker.Writer picker, Object secondarySelector, ColorSet color, int modeTo) {
        int localDestDirection;
        boolean flipChain = endX + endY > startX + startY;
        GeneralPath path = new GeneralPath();
        int localStartX = flipChain ? endX : startX;
        int localStartY = flipChain ? endY : startY;
        int localEndX = flipChain ? startX : endX;
        int localEndY = flipChain ? startY : endY;
        int localSourceDirection = flipChain ? destDirection : sourceDirection;
        int n = localDestDirection = flipChain ? sourceDirection : destDirection;
        if (hover) {
            GeneralPath hoverPath = new GeneralPath(path);
            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
            Stroke tmpStroke = g.getStroke();
            g.setStroke(DrawConnection.myHoverStroke);
            hoverPath.moveTo(localStartX, localStartY);
            hoverPath.curveTo(localStartX + scaleSource * DrawConnection.dirDeltaX[localSourceDirection], localStartY + scaleSource * DrawConnection.dirDeltaY[localSourceDirection], localEndX + scaleDest * DrawConnection.dirDeltaX[localDestDirection], localEndY + scaleDest * DrawConnection.dirDeltaY[localDestDirection], localEndX, localEndY);
            g.draw(hoverPath);
            hoverPath.reset();
            g.setStroke(tmpStroke);
        }
        float x1 = localStartX;
        float y1 = localStartY;
        path.moveTo(x1, y1);
        float x2 = localStartX + scaleSource * DrawConnection.dirDeltaX[localSourceDirection];
        float y2 = localStartY + scaleSource * DrawConnection.dirDeltaY[localSourceDirection];
        float x3 = localEndX + scaleDest * DrawConnection.dirDeltaX[localDestDirection];
        float y3 = localEndY + scaleDest * DrawConnection.dirDeltaY[localDestDirection];
        float x4 = localEndX;
        float y4 = localEndY;
        path.curveTo(x2, y2, x3, y3, x4, y4);
        if (picker != null && secondarySelector != null) {
            picker.addCurveTo(secondarySelector, 4, (int)x1, (int)y1, (int)x2, (int)y2, (int)x3, (int)y3, (int)x4, (int)y4, 4);
        }
        g.setStroke(DrawConnection.getStroke(DrawConnection.StrokeType.CHAIN, flipChain, modeTo));
        g.draw(path);
    }

    public static Stroke getStroke(DrawConnection.StrokeType strokeType, boolean flip_chain, int mode, Stroke thickChainStroke1, Stroke thickChainStroke2, Stroke chainStroke1, Stroke chainStroke2, Stroke thickSpringStroke, Stroke springStroke, Stroke thickDashStroke, Stroke dashStroke, Stroke thickNormalStroke, Stroke normalStroke) {
        boolean thick = mode == 6 || mode == 5 || mode == 7;
        return switch (strokeType) {
            case DrawConnection.StrokeType.CHAIN -> {
                if (thick) {
                    if (flip_chain) {
                        yield thickChainStroke1;
                    }
                    yield thickChainStroke2;
                }
                if (flip_chain) {
                    yield chainStroke1;
                }
                yield chainStroke2;
            }
            case DrawConnection.StrokeType.SPRING -> {
                if (thick) {
                    yield thickSpringStroke;
                }
                yield springStroke;
            }
            case DrawConnection.StrokeType.DASH -> {
                if (thick) {
                    yield thickDashStroke;
                }
                yield dashStroke;
            }
            default -> thick ? thickNormalStroke : normalStroke;
        };
    }
}

