/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.FancyStroke;
import com.android.tools.idea.uibuilder.handlers.constraint.SecondarySelector;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;

public class DrawConnection
implements DrawCommand {
    public static final int TYPE_NORMAL = 1;
    public static final int TYPE_SPRING = 2;
    public static final int TYPE_CHAIN = 3;
    public static final int TYPE_CENTER = 4;
    public static final int TYPE_BASELINE = 5;
    public static final int TYPE_CENTER_WIDGET = 6;
    public static final int TYPE_ADJACENT = 7;
    private static final long MILISECONDS = 1000000L;
    public static final int MODE_COMPUTED = 7;
    public static final int MODE_SUBDUED = 1;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_WILL_HOVER = 3;
    public static final int MODE_VIEW_SELECTED = 2;
    public static final int MODE_CONSTRAINT_SELECTED = 5;
    public static final int MODE_DELETING = 6;
    public static final int HOVER_FLAG = 256;
    public static final int HOVER_MASK = -257;
    public static final int DIR_LEFT = 0;
    public static final int DIR_RIGHT = 1;
    public static final int DIR_TOP = 2;
    public static final int DIR_BOTTOM = 3;
    private static final int OVER_HANG = 20;
    private static final long TRANSITION_TIME = 1000000000L;
    static GeneralPath ourPath = new GeneralPath();
    static final int[] dirDeltaX = new int[]{-1, 1, 0, 0};
    static final int[] dirDeltaY = new int[]{0, 0, -1, 1};
    static final int[] ourOppositeDirection = new int[]{1, 0, 3, 2};
    public static final int GAP = JBUI.scale((int)10);
    int myConnectionType;
    SecondarySelector mySecondarySelector;
    Rectangle mySource = new Rectangle();
    int mySourceDirection;
    Rectangle myDest = new Rectangle();
    int myDestDirection;
    public static final int DEST_NORMAL = 0;
    public static final int DEST_PARENT = 1;
    public static final int DEST_GUIDELINE = 2;
    int myDestType;
    boolean myShift;
    int myMargin;
    int myMarginDistance;
    boolean myIsMarginReference;
    float myBias;
    int myModeFrom;
    int myModeTo;
    long myStateChangeTime;
    static Stroke myDashStroke = new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{JBUI.scale((int)4), JBUI.scale((int)6)}, 0.0f);
    static Stroke mySpringStroke = new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{JBUI.scale((int)4), JBUI.scale((int)4)}, 0.0f);
    static Stroke myChainStroke1 = new FancyStroke(FancyStroke.Type.HALF_CHAIN1, JBUI.scale((float)2.5f), JBUI.scale((int)9), 1.0f);
    static Stroke myChainStroke2 = new FancyStroke(FancyStroke.Type.HALF_CHAIN2, JBUI.scale((float)2.5f), JBUI.scale((int)9), 1.0f);
    static Stroke myNormalStroke = new BasicStroke(JBUI.scale((int)1));
    public static Stroke myHoverStroke = new BasicStroke(JBUI.scale((int)12), 0, 1);
    static Stroke myThickDashStroke = new BasicStroke(2.0f, 0, 1, 10.0f, new float[]{JBUI.scale((int)4), JBUI.scale((int)6)}, 0.0f);
    static Stroke myThickSpringStroke = new BasicStroke(2.0f, 0, 1, 10.0f, new float[]{JBUI.scale((int)4), JBUI.scale((int)4)}, 0.0f);
    static Stroke myThickChainStroke1 = new FancyStroke(FancyStroke.Type.HALF_CHAIN1, JBUI.scale((float)2.5f), JBUI.scale((int)9), 2.0f);
    static Stroke myThickChainStroke2 = new FancyStroke(FancyStroke.Type.HALF_CHAIN2, JBUI.scale((float)2.5f), JBUI.scale((int)9), 2.0f);
    static Stroke myThickNormalStroke = new BasicStroke(JBUI.scale((int)2));

    @Override
    public int getLevel() {
        switch (this.myModeTo) {
            case 6: {
                return 70;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 60;
            }
        }
        return 10;
    }

    @Override
    public String serialize() {
        return "DrawConnection," + this.myConnectionType + "," + DrawConnection.rectToString(this.mySource) + "," + this.mySourceDirection + "," + DrawConnection.rectToString(this.myDest) + "," + this.myDestDirection + "," + this.myDestType + "," + this.myShift + "," + this.myMargin + "," + this.myMarginDistance + "," + this.myIsMarginReference + "," + this.myBias + "," + this.myModeFrom + "," + this.myModeTo + ",0";
    }

    private static String rectToString(Rectangle r) {
        return r.x + "x" + r.y + "x" + r.width + "x" + r.height;
    }

    private static Rectangle stringToRect(String s) {
        String[] sp = s.split("x");
        int c = 0;
        Rectangle r = new Rectangle();
        r.x = Integer.parseInt(sp[c++]);
        r.y = Integer.parseInt(sp[c++]);
        r.width = Integer.parseInt(sp[c++]);
        r.height = Integer.parseInt(sp[c++]);
        return r;
    }

    public DrawConnection(String s) {
        String[] sp = s.split(",");
        int c = 0;
        this.myConnectionType = Integer.parseInt(sp[c++]);
        this.mySource = DrawConnection.stringToRect(sp[c++]);
        this.mySourceDirection = Integer.parseInt(sp[c++]);
        this.myDest = DrawConnection.stringToRect(sp[c++]);
        this.myDestDirection = Integer.parseInt(sp[c++]);
        this.myDestType = Integer.parseInt(sp[c++]);
        this.myShift = Boolean.parseBoolean(sp[c++]);
        this.myMargin = Integer.parseInt(sp[c++]);
        this.myMarginDistance = Integer.parseInt(sp[c++]);
        this.myIsMarginReference = Boolean.parseBoolean(sp[c++]);
        this.myBias = Float.parseFloat(sp[c++]);
        this.myModeFrom = Integer.parseInt(sp[c++]);
        this.myModeTo = Integer.parseInt(sp[c++]);
        this.myStateChangeTime = Long.parseLong(sp[c++]);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet color = sceneContext.getColorSet();
        SecondarySelector secondarySelector = this.mySecondarySelector;
        g.setColor(color.getConstraints());
        boolean animate = DrawConnection.draw(g, color, sceneContext.getScenePickerForWrite(), secondarySelector, this.myConnectionType, this.mySource, this.mySourceDirection, this.myDest, this.myDestDirection, this.myDestType, this.myMargin, this.myMarginDistance, this.myIsMarginReference, this.myModeFrom, this.myModeTo, this.myStateChangeTime);
        if (animate) {
            sceneContext.repaint();
        }
    }

    public DrawConnection(SecondarySelector selector, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias, int modeFrom, int modeTo, long nanoTime) {
        this.config(selector, connectionType, source, sourceDirection, dest, destDirection, destType, shift, margin, marginDistance, isMarginReference, bias, modeFrom, modeTo, nanoTime);
    }

    public static void buildDisplayList(DisplayList list, SecondarySelector selector, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias, int modeFrom, int modeTo, long nanoTime) {
        list.add(new DrawConnection(selector, connectionType, source, sourceDirection, dest, destDirection, destType, shift, margin, marginDistance, isMarginReference, bias, modeFrom, modeTo, nanoTime));
    }

    public void config(SecondarySelector selector, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias, int modeFrom, int modeTo, long stateChangeTime) {
        this.mySecondarySelector = selector;
        this.mySource.setBounds(source);
        this.myDest.setBounds(dest);
        this.myConnectionType = connectionType;
        this.mySource.setBounds(source);
        this.mySourceDirection = sourceDirection;
        this.myDest.setBounds(dest);
        this.myDestDirection = destDirection;
        this.myDestType = destType;
        this.myShift = shift;
        this.myMargin = margin;
        this.myMarginDistance = marginDistance;
        this.myIsMarginReference = isMarginReference;
        this.myBias = bias.floatValue();
        this.myModeFrom = modeFrom;
        this.myModeTo = modeTo;
        this.myStateChangeTime = stateChangeTime;
    }

    public static Color modeGetConstraintsColor(int mode, ColorSet color) {
        return switch (mode &= 0xFFFFFEFF) {
            case 2, 5 -> color.getSelectedConstraints();
            case 7 -> color.getCreatedConstraints();
            case 6 -> color.getAnchorDisconnectionCircle();
            case 1 -> color.getSubduedConstraints();
            case 3 -> color.getLassoSelectionFill();
            default -> color.getConstraints();
        };
    }

    static Stroke getStroke(StrokeType strokeType, boolean flip_chain, int mode) {
        return DrawConnectionUtils.getStroke(strokeType, flip_chain, mode, myThickChainStroke1, myThickChainStroke2, myChainStroke1, myChainStroke2, myThickSpringStroke, mySpringStroke, myThickDashStroke, myDashStroke, myThickNormalStroke, myNormalStroke);
    }

    public static Color modeGetMarginColor(int mode, ColorSet color) {
        return switch (mode) {
            case 2 -> color.getConstraints();
            case 7 -> color.getHighlightedConstraints();
            case 1 -> color.getSubduedConstraints();
            default -> color.getMargins();
        };
    }

    static Color interpolate(Color fromColor, Color toColor, float percent) {
        int col1 = fromColor.getRGB();
        int col2 = toColor.getRGB();
        int c1 = (int)((float)(col1 >> 0 & 0xFF) * (1.0f - percent) + (float)(col2 >> 0 & 0xFF) * percent);
        int c2 = (int)((float)(col1 >> 8 & 0xFF) * (1.0f - percent) + (float)(col2 >> 8 & 0xFF) * percent);
        int c3 = (int)((float)(col1 >> 16 & 0xFF) * (1.0f - percent) + (float)(col2 >> 16 & 0xFF) * percent);
        return new Color(c3, c2, c1);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean draw(Graphics2D g, ColorSet color, ScenePicker.Writer picker, SecondarySelector secondarySelector, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int myDestType, int margin, int marginDistance, boolean isMarginReference, int modeFrom, int modeTo, long stateChange) {
        block84: {
            animate = false;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            constraintColor = DrawConnection.modeGetConstraintsColor(modeTo, color);
            marginColor = DrawConnection.modeGetMarginColor(modeTo, color);
            timeSince = System.nanoTime() - stateChange;
            hover = (256 & modeTo) > 0 || modeTo == 5;
            modeTo &= -257;
            if (timeSince < 1000000000L) {
                t = (float)((double)timeSince / 1.0E9);
                fromColor = DrawConnection.modeGetConstraintsColor(modeFrom, color);
                toColor = DrawConnection.modeGetConstraintsColor(modeTo, color);
                constraintColor = DrawConnection.interpolate(fromColor, toColor, t);
                animate = true;
            }
            if (connectionType == 5) {
                hoverColor = DrawConnection.modeGetConstraintsColor(3, color);
                DrawConnection.drawBaseLine(g, source, dest, constraintColor, hoverColor, picker, secondarySelector, hover);
                return animate;
            }
            startx = DrawConnection.getConnectionX(sourceDirection, source);
            starty = DrawConnection.getConnectionY(sourceDirection, source);
            endx = DrawConnection.getConnectionX(destDirection, dest);
            endy = DrawConnection.getConnectionY(destDirection, dest);
            dx = DrawConnection.getDestinationDX(destDirection);
            dy = DrawConnection.getDestinationDY(destDirection);
            manhattanDistance = Math.abs(startx - endx) + Math.abs(starty - endy);
            scale_dest = scale_source = Math.min(90, manhattanDistance);
            flip_arrow = false;
            if (myDestType != 0) {
                switch (destDirection) {
                    case 2: 
                    case 3: {
                        endx = startx;
                        break;
                    }
                    case 0: 
                    case 1: {
                        endy = starty;
                    }
                }
            }
            if (sourceDirection != destDirection) break block84;
            block4 : switch (myDestType) {
                case 1: {
                    scale_dest *= -1;
                    flip_arrow = true;
                    switch (destDirection) {
                        case 2: 
                        case 3: {
                            dy *= -1;
                            break;
                        }
                        case 0: 
                        case 1: {
                            dx *= -1;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (destDirection) {
                        case 3: {
                            if (endy - 1 > starty) {
                                scale_dest *= -1;
                                dy *= -1;
                                flip_arrow = true;
                                break block4;
                            }
                            break block84;
                        }
                        case 2: {
                            if (endy < starty) {
                                scale_dest *= -1;
                                dy *= -1;
                                flip_arrow = true;
                                break block4;
                            }
                            break block84;
                        }
                        case 0: {
                            if (endx < startx) {
                                scale_dest *= -1;
                                dx *= -1;
                                flip_arrow = true;
                                break block4;
                            }
                            break block84;
                        }
                        case 1: {
                            if (endx - 1 > startx) {
                                scale_dest *= -1;
                                dx *= -1;
                                flip_arrow = true;
                            } else {
                                ** GOTO lbl75
                            }
                        }
                    }
                }
            }
        }
        xPoints = new int[3];
        yPoints = new int[3];
        dir = flip_arrow != false ? DrawConnection.ourOppositeDirection[destDirection] : destDirection;
        DrawConnection.ourPath.reset();
        DrawConnection.ourPath.moveTo(startx, starty);
        if (manhattanDistance == 0) {
            g.setColor(constraintColor);
            DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
            g.fillPolygon(xPoints, yPoints, 3);
            g.draw(DrawConnection.ourPath);
            DrawConnection.ourPath.reset();
            DrawConnection.ourPath.moveTo(startx, starty);
        }
        defaultStroke = g.getStroke();
        g.setStroke(DrawConnection.getStroke(StrokeType.NORMAL, false, modeTo));
        switch (connectionType) {
            case 3: {
                g.setColor(constraintColor);
                DrawConnectionUtils.drawChain(g, hover, startx, starty, endx, endy, scale_source, scale_dest, sourceDirection, destDirection, picker, secondarySelector, color, modeTo);
                DrawConnectionUtils.drawChain(g, hover, endx, endy, startx, starty, scale_source, scale_dest, destDirection, sourceDirection, picker, secondarySelector, color, modeTo);
                if (modeTo != 6) break;
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                break;
            }
            case 7: {
                g.setColor(constraintColor);
                DrawConnectionUtils.getSmallArrow(dir, startx - dx / 2, starty - dy / 2, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                if (destDirection == 0 || destDirection == 1) {
                    endx = startx = (startx + endx) / 2;
                } else {
                    endy = starty = (starty + endy) / 2;
                }
                g.drawLine(startx, starty, endx, endy);
                if (picker == null || secondarySelector == null) break;
                picker.addLine(secondarySelector, 4, startx, starty, endx, endy, 4);
                break;
            }
            case 2: {
                drawArrow = true;
                springEndX = endx;
                springEndY = endy;
                if (myDestType != 0) {
                    rectGap = JBUI.scale((int)4);
                    rectDim = JBUI.scale((int)9);
                    if (margin != 0) {
                        marginString = Integer.toString(margin);
                        if (destDirection == 0 || destDirection == 1) {
                            gap = Math.max(marginDistance, DrawConnectionUtils.getHorizontalMarginGap(g, marginString));
                            if (Math.abs(startx - endx) < gap) {
                                marginString = null;
                            }
                            marginX = endx - (endx > startx ? gap : -gap);
                            arrow = (endx > startx ? 1 : -1) * DrawConnectionUtils.ARROW_SIDE;
                            if (hover) {
                                g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                                tmpStroke = g.getStroke();
                                g.setStroke(DrawConnection.myHoverStroke);
                                g.drawLine(marginX, endy, endx - arrow, endy);
                                g.setStroke(tmpStroke);
                            }
                            if (picker != null && secondarySelector != null) {
                                picker.addLine(secondarySelector, 8, marginX, endy, endx - arrow, endy, 4);
                            }
                            g.setColor(constraintColor);
                            g.drawLine(marginX, endy, endx - arrow, endy);
                            DrawConnectionUtils.drawHorizontalMarginString(g, marginColor, marginString, isMarginReference, marginX, endx - arrow, endy);
                            springEndX = marginX;
                        } else {
                            gap = Math.max(marginDistance, DrawConnectionUtils.getVerticalMarginGap(g));
                            if (Math.abs(starty - endy) < gap) {
                                marginString = null;
                            }
                            marginY = endy - (endy > starty ? gap : -gap);
                            arrow = (endy > starty ? 1 : -1) * DrawConnectionUtils.ARROW_SIDE;
                            if (hover) {
                                g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                                tmpStroke = g.getStroke();
                                g.setStroke(DrawConnection.myHoverStroke);
                                g.drawLine(endx, marginY, endx, endy - arrow);
                                g.setStroke(tmpStroke);
                            }
                            if (picker != null && secondarySelector != null) {
                                picker.addLine(secondarySelector, 8, endx, marginY, endx, endy - arrow, 4);
                            }
                            g.setColor(constraintColor);
                            g.drawLine(endx, marginY, endx, endy - arrow);
                            DrawConnectionUtils.drawVerticalMarginString(g, marginColor, marginString, isMarginReference, endx, marginY, endy - arrow);
                            springEndY = marginY;
                        }
                    }
                    if (endx == startx) {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            tmpStroke = g.getStroke();
                            g.setStroke(DrawConnection.myHoverStroke);
                            g.drawLine(startx, starty, startx, springEndY);
                            g.setStroke(tmpStroke);
                        }
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawVerticalZigZagLine(DrawConnection.ourPath, startx, starty, springEndY);
                        if (picker != null && secondarySelector != null) {
                            picker.addLine(secondarySelector, 8, startx, starty, startx, springEndY, 4);
                        }
                        g.fillRect(startx - rectGap, springEndY, rectDim, 1);
                    } else {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            tmpStroke = g.getStroke();
                            g.setStroke(DrawConnection.myHoverStroke);
                            g.drawLine(startx, endy, springEndX, endy);
                            g.setStroke(tmpStroke);
                        }
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawHorizontalZigZagLine(DrawConnection.ourPath, startx, springEndX, endy);
                        if (picker != null && secondarySelector != null) {
                            picker.addLine(secondarySelector, 8, startx, endy, springEndX, endy, 4);
                        }
                        g.fillRect(springEndX, endy - rectGap, 1, rectDim);
                    }
                } else {
                    g.setColor(constraintColor);
                    rectGap = JBUI.scale((int)2);
                    rectDim = JBUI.scale((int)5);
                    if (destDirection == 0 || destDirection == 1) {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            tmpStroke = g.getStroke();
                            g.setStroke(DrawConnection.myHoverStroke);
                            hoverPath = new GeneralPath(DrawConnection.ourPath);
                            hoverPath.moveTo(startx, starty);
                            hoverPath.lineTo(endx, starty);
                            hoverPath.lineTo(endx, endy);
                            g.draw(hoverPath);
                            g.setStroke(tmpStroke);
                        }
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawHorizontalZigZagLine(DrawConnection.ourPath, startx, endx, starty);
                        if (picker != null && secondarySelector != null) {
                            picker.addLine(secondarySelector, 8, startx, starty, endx, starty, 4);
                            picker.addLine(secondarySelector, 8, endx, starty, endx, endy, 4);
                        }
                        g.setStroke(DrawConnection.getStroke(StrokeType.SPRING, false, modeTo));
                        drawArrow = false;
                        g.drawLine(endx, starty, endx, endy);
                        g.fillRoundRect(endx - rectGap, endy - rectGap, rectDim, rectDim, rectGap, rectGap);
                    } else {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            tmpStroke = g.getStroke();
                            g.setStroke(DrawConnection.myHoverStroke);
                            hoverPath = new GeneralPath(DrawConnection.ourPath);
                            hoverPath.moveTo(startx, starty);
                            hoverPath.lineTo(startx, endy);
                            hoverPath.lineTo(endx, endy);
                            g.draw(hoverPath);
                            g.setStroke(tmpStroke);
                        }
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawVerticalZigZagLine(DrawConnection.ourPath, startx, starty, endy);
                        if (picker != null && secondarySelector != null) {
                            picker.addLine(secondarySelector, 8, startx, starty, startx, endy, 4);
                            picker.addLine(secondarySelector, 8, startx, endy, endx, endy, 4);
                        }
                        g.setStroke(DrawConnection.getStroke(StrokeType.SPRING, false, modeTo));
                        drawArrow = false;
                        g.drawLine(startx, endy, endx, endy);
                        g.fillRoundRect(endx - rectGap, endy - rectGap, rectDim, rectDim, rectGap, rectGap);
                    }
                }
                g.setStroke(DrawConnection.getStroke(StrokeType.NORMAL, false, modeTo));
                g.setColor(constraintColor);
                g.draw(DrawConnection.ourPath);
                if (!drawArrow) break;
                g.setColor(constraintColor);
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                break;
            }
            case 4: 
            case 6: {
                dir0_x = 0;
                dir0_y = 0;
                dir1_x = 0;
                dir1_y = 0;
                dir2_x = 0;
                dir2_y = 0;
                if (destDirection == 0 || destDirection == 1) {
                    dir0_x = sourceDirection == 0 ? -1 : 1;
                    dir1_y = endy > starty ? 1 : -1;
                    dir2_x = destDirection == 0 ? -1 : 1;
                    p6x = destDirection == 0 ? endx - DrawConnection.GAP * 2 : endx + DrawConnection.GAP * 2;
                    p6y = starty + dir0_y * DrawConnection.GAP + (source.height / 2 + DrawConnection.GAP) * dir1_y;
                    vline_y1 = -1;
                    vline_y2 = -1;
                    if (source.y > dest.y + dest.height) {
                        vline_y1 = dest.y + dest.height;
                        vline_y2 = source.y;
                    }
                    if (source.y + source.height < dest.y) {
                        vline_y1 = source.y + source.height;
                        vline_y2 = dest.y;
                    }
                    if (vline_y1 != -1) {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            tmpStroke = g.getStroke();
                            g.setStroke(DrawConnection.myHoverStroke);
                            xpos = source.x + source.width / 2;
                            g.drawLine(xpos, vline_y1, xpos, vline_y2);
                            g.setStroke(tmpStroke);
                        }
                        g.setStroke(DrawConnection.getStroke(StrokeType.DASH, false, modeTo));
                        xpos = source.x + source.width / 2;
                        g.setColor(constraintColor);
                        g.drawLine(xpos, vline_y1, xpos, vline_y2);
                    }
                } else {
                    dir1_x = endx > startx ? 1 : -1;
                    dir0_y = sourceDirection == 2 ? -1 : 1;
                    dir2_y = destDirection == 2 ? -1 : 1;
                    p6y = destDirection == 2 ? endy - DrawConnection.GAP * 2 : endy + DrawConnection.GAP * 2;
                    p6x = startx + dir0_x * DrawConnection.GAP + (source.width / 2 + DrawConnection.GAP) * dir1_x;
                    vline_x1 = -1;
                    vline_x2 = -1;
                    if (source.x > dest.x + dest.width) {
                        vline_x1 = dest.x + dest.width;
                        vline_x2 = source.x;
                    }
                    if (source.x + source.width < dest.x) {
                        vline_x1 = source.x + source.width;
                        vline_x2 = dest.x;
                    }
                    if (vline_x1 != -1) {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            tmpStroke = g.getStroke();
                            g.setStroke(DrawConnection.myHoverStroke);
                            ypos = source.y + source.height / 2;
                            g.drawLine(vline_x1, ypos, vline_x2, ypos);
                            g.setStroke(tmpStroke);
                        }
                        g.setStroke(DrawConnection.getStroke(StrokeType.DASH, false, modeTo));
                        ypos = source.y + source.height / 2;
                        g.setColor(constraintColor);
                        g.drawLine(vline_x1, ypos, vline_x2, ypos);
                    }
                }
                len = 6;
                px = new int[len];
                py = new int[len];
                px[0] = startx;
                py[0] = starty;
                px[1] = startx + dir0_x * DrawConnection.GAP;
                py[1] = starty + dir0_y * DrawConnection.GAP;
                px[2] = px[1] + (source.width / 2 + DrawConnection.GAP) * dir1_x;
                py[2] = py[1] + (source.height / 2 + DrawConnection.GAP) * dir1_y;
                px[3] = p6x;
                py[3] = p6y;
                px[4] = endx + 2 * dir2_x * DrawConnection.GAP;
                py[4] = endy + 2 * dir2_y * DrawConnection.GAP;
                px[5] = endx;
                py[5] = endy;
                if (6 == connectionType) {
                    len = DrawConnectionUtils.removeZigZag(px, py, len, 50);
                }
                DrawConnectionUtils.drawRound((Path2D.Float)DrawConnection.ourPath, px, py, len, DrawConnection.GAP);
                if (hover) {
                    g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                    tmpStroke = g.getStroke();
                    g.setStroke(DrawConnection.myHoverStroke);
                    g.draw(DrawConnection.ourPath);
                    g.setStroke(tmpStroke);
                }
                if (picker != null && secondarySelector != null) {
                    DrawConnectionUtils.drawPick(picker, secondarySelector, px, py, len, DrawConnection.GAP);
                }
                g.setStroke(DrawConnection.getStroke(StrokeType.NORMAL, false, modeTo));
                g.setColor(constraintColor);
                DrawConnectionUtils.getArrow(destDirection, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(DrawConnection.ourPath);
                break;
            }
            case 1: {
                if (margin > 0) {
                    if (sourceDirection == 1 || sourceDirection == 0) {
                        above = starty < endy;
                        line_y = starty + (above != false ? -1 : 1) * source.height / 4;
                        g.setColor(marginColor);
                        DrawConnectionUtils.drawHorizontalMarginIndicator(g, String.valueOf(margin), isMarginReference, startx, endx, line_y);
                        if (myDestType != 1 || line_y < dest.y || line_y > dest.y + dest.height) {
                            constraintX = destDirection == 0 ? dest.x : dest.x + dest.width;
                            g.setStroke(DrawConnection.getStroke(StrokeType.DASH, false, modeTo));
                            v0 = overlap = above != false ? -20 : 20;
                            if (hover) {
                                g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                                tmpStroke = g.getStroke();
                                g.setStroke(DrawConnection.myHoverStroke);
                                g.drawLine(constraintX, line_y + overlap, constraintX, above != false ? dest.y : dest.y + dest.height);
                                g.setStroke(tmpStroke);
                            }
                            g.setColor(constraintColor);
                            g.drawLine(constraintX, line_y + overlap, constraintX, above != false ? dest.y : dest.y + dest.height);
                        }
                    } else {
                        left = startx < endx;
                        line_x = startx + (left != false ? -1 : 1) * source.width / 4;
                        g.setColor(marginColor);
                        DrawConnectionUtils.drawVerticalMarginIndicator(g, String.valueOf(margin), isMarginReference, line_x, starty, endy);
                        if (myDestType != 1 || line_x < dest.x || line_x > dest.x + dest.width) {
                            constraint_y = destDirection == 2 ? dest.y : dest.y + dest.height;
                            g.setStroke(DrawConnection.getStroke(StrokeType.DASH, false, modeTo));
                            v1 = overlap = left != false ? -20 : 20;
                            if (hover) {
                                g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                                tmpStroke = g.getStroke();
                                g.setStroke(DrawConnection.myHoverStroke);
                                g.drawLine(line_x + overlap, constraint_y, left != false ? dest.x : dest.x + dest.width, constraint_y);
                                g.setStroke(tmpStroke);
                            }
                            g.setColor(constraintColor);
                            g.drawLine(line_x + overlap, constraint_y, left != false ? dest.x : dest.x + dest.width, constraint_y);
                        }
                    }
                }
                g.setStroke(DrawConnection.getStroke(StrokeType.NORMAL, false, modeTo));
                if (startx - endx == 0 && (sourceDirection != destDirection || DrawConnection.dirDeltaX[sourceDirection] == 0)) {
                    scale_source = 0;
                    scale_dest = 0;
                } else if (starty - endy == 0 && (sourceDirection != destDirection || DrawConnection.dirDeltaY[sourceDirection] == 0)) {
                    scale_source = 0;
                    scale_dest = 0;
                }
                if (sourceDirection == destDirection && margin == 0) {
                    scale_source /= 3;
                    scale_dest /= 2;
                }
                x1 = startx;
                y1 = starty;
                if (hover) {
                    g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                    tmpStroke = g.getStroke();
                    g.setStroke(DrawConnection.myHoverStroke);
                    hoverPath = new GeneralPath(DrawConnection.ourPath);
                    hoverPath.curveTo(startx + scale_source * DrawConnection.dirDeltaX[sourceDirection], starty + scale_source * DrawConnection.dirDeltaY[sourceDirection], endx + dx + scale_dest * DrawConnection.dirDeltaX[destDirection], endy + dy + scale_dest * DrawConnection.dirDeltaY[destDirection], endx + dx, endy + dy);
                    g.draw(hoverPath);
                    g.setStroke(tmpStroke);
                }
                g.setColor(constraintColor);
                x2 = startx + scale_source * DrawConnection.dirDeltaX[sourceDirection];
                y2 = starty + scale_source * DrawConnection.dirDeltaY[sourceDirection];
                x3 = endx + dx + scale_dest * DrawConnection.dirDeltaX[destDirection];
                y3 = endy + dy + scale_dest * DrawConnection.dirDeltaY[destDirection];
                x4 = endx + dx;
                y4 = endy + dy;
                DrawConnection.ourPath.curveTo(x2, y2, x3, y3, x4, y4);
                if (picker != null && secondarySelector != null) {
                    picker.addCurveTo(secondarySelector, 4, (int)x1, (int)y1, (int)x2, (int)y2, (int)x3, (int)y3, (int)x4, (int)y4, 4);
                }
                g.setStroke(DrawConnection.getStroke(StrokeType.BACKGROUND, false, modeTo));
                g.setColor(color.getBackground());
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(DrawConnection.ourPath);
                g.setColor(constraintColor);
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(DrawConnection.ourPath);
            }
        }
        g.setStroke(defaultStroke);
        return animate;
    }

    private static void drawBaseLine(Graphics2D g, Rectangle source, Rectangle dest, Color color, Color hoverColor, ScenePicker.Writer picker, SecondarySelector secondarySelector, boolean hover) {
        if (hover) {
            GeneralPath hoverPath = new GeneralPath();
            g.setColor(hoverColor);
            Stroke tmpStroke = g.getStroke();
            g.setStroke(myHoverStroke);
            hoverPath.moveTo((double)source.x + (double)source.width / 2.0, (double)source.y);
            hoverPath.curveTo((double)source.x + (double)source.width / 2.0, (double)(source.y - 40), (double)dest.x + (double)dest.width / 2.0, (double)(dest.y + 40), (double)dest.x + (double)dest.width / 2.0, (double)dest.y);
            g.draw(hoverPath);
            g.setStroke(tmpStroke);
        }
        g.setColor(color);
        ourPath.reset();
        ourPath.moveTo((double)source.x + (double)source.width / 2.0, (double)source.y);
        ourPath.curveTo((double)source.x + (double)source.width / 2.0, (double)(source.y - 40), (double)dest.x + (double)dest.width / 2.0, (double)(dest.y + 40), (double)dest.x + (double)dest.width / 2.0, (double)dest.y);
        if (picker != null && secondarySelector != null) {
            picker.addCurveTo(secondarySelector, 4, (int)((double)source.x + (double)source.width / 2.0), source.y, (int)((double)source.x + (double)source.width / 2.0), source.y - 40, (int)((double)dest.x + (double)dest.width / 2.0), dest.y + 40, (int)((double)dest.x + (double)dest.width / 2.0), dest.y, 4);
        }
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        DrawConnectionUtils.getArrow(3, dest.x + dest.width / 2, dest.y, xPoints, yPoints);
        int inset = source.width / 5;
        g.fillRect(source.x + inset, source.y, source.width - inset * 2, 1);
        inset = dest.width / 5;
        g.fillRect(dest.x + inset, dest.y, dest.width - inset * 2, 1);
        g.fillPolygon(xPoints, yPoints, 3);
        g.draw(ourPath);
    }

    private static int getConnectionX(int side, Rectangle rect) {
        return switch (side) {
            case 0 -> rect.x;
            case 1 -> rect.x + rect.width;
            case 2, 3 -> rect.x + rect.width / 2;
            default -> 0;
        };
    }

    private static int getConnectionY(int side, Rectangle rect) {
        return switch (side) {
            case 0, 1 -> rect.y + rect.height / 2;
            case 2 -> rect.y;
            case 3 -> rect.y + rect.height;
            default -> 0;
        };
    }

    private static int getDestinationDX(int side) {
        return switch (side) {
            case 0 -> -DrawConnectionUtils.ARROW_SIDE;
            case 1 -> DrawConnectionUtils.ARROW_SIDE;
            default -> 0;
        };
    }

    private static int getDestinationDY(int side) {
        return switch (side) {
            case 2 -> -DrawConnectionUtils.ARROW_SIDE;
            case 3 -> DrawConnectionUtils.ARROW_SIDE;
            default -> 0;
        };
    }

    public static enum StrokeType {
        DASH,
        CHAIN,
        SPRING,
        NORMAL,
        BACKGROUND;

    }
}

