/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.AndroidXConstants;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.ChangeType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentReference;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintHelperHandler
extends ViewGroupHandler {
    public static final boolean USE_HELPER_TAGS = false;

    @Override
    public void performDrop(@NotNull NlModel model, @NotNull NlDropEvent event, @NotNull NlComponent receiver, @NotNull List<NlComponent> dragged, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (NlComponentHelperKt.isOrHasSuperclass(receiver, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER)) {
            try {
                ConstraintHelperHandler.addComponentsIds(receiver, dragged);
                if (NlComponentHelperKt.isOrHasSuperclass(receiver, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_FLOW)) {
                    for (NlComponent toDrag : dragged) {
                        if (insertType != InsertType.MOVE || toDrag.getParent() == receiver) continue;
                        AttributesTransaction transaction = toDrag.startAttributeTransaction();
                        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
                        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
                        NlWriteCommandActionUtil.run(toDrag, "", transaction::commit);
                    }
                }
                event.accept(insertType);
                event.complete();
                model.notifyModified(ChangeType.DROP);
            }
            catch (Exception exception) {
                Logger.getInstance(ConstraintHelperHandler.class).warn((Throwable)exception);
                event.reject();
            }
        }
    }

    private static void addComponentsIds(@NotNull NlComponent receiver, @NotNull List<NlComponent> dragged) {
        ArrayList<String> draggedIds = new ArrayList<String>();
        for (NlComponent component : dragged) {
            draggedIds.add(NlComponentHelperKt.ensureLiveId(component));
        }
        ConstraintHelperHandler.addReferencesIds(receiver, draggedIds, null);
    }

    @Override
    public boolean holdsReferences() {
        return true;
    }

    @Override
    public void removeReference(@NotNull NlComponent component, @NotNull String id) {
        this.deleteReferences(component, (List<String>)ImmutableList.of((Object)id));
    }

    @Override
    public void addReferences(@NotNull NlComponent component, @NotNull List<String> ids, @Nullable String before) {
        ConstraintHelperHandler.addReferencesIds(component, ids, before);
    }

    private static void addReferencesIds(@NotNull NlComponent receiver, @NotNull List<String> draggedIds, @Nullable String before) {
        AttributesTransaction transaction = receiver.startAttributeTransaction();
        String originalIdsList = transaction.getAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids");
        String idList = ConstraintHelperHandler.addIds(originalIdsList, draggedIds, before);
        ConstraintHelperHandler.writeIds(receiver, transaction, idList);
    }

    @Nullable
    private static String removeIds(@NotNull String originalIds, @NotNull List<String> toRemove) {
        String[] splitIds = originalIds.split(",");
        ArrayList strings = new ArrayList(splitIds.length);
        Collections.addAll(strings, splitIds);
        strings.removeAll(toRemove);
        return strings.isEmpty() ? null : String.join((CharSequence)",", strings);
    }

    @Nullable
    private static String addIds(@Nullable String ids, @NotNull List<String> newIds, @Nullable String before) {
        int insertionIndex;
        ArrayList<String> idsList;
        if (newIds.isEmpty()) {
            return ids;
        }
        if (ids != null) {
            String[] splitIds = ids.split(",");
            idsList = new ArrayList(splitIds.length);
            Collections.addAll(idsList, splitIds);
            idsList.removeAll(newIds);
        } else {
            idsList = new ArrayList<String>();
        }
        int n = insertionIndex = before == null ? -1 : idsList.indexOf(before);
        if (insertionIndex >= 0) {
            idsList.addAll(insertionIndex, newIds);
        } else {
            idsList.addAll(newIds);
        }
        return String.join((CharSequence)",", new LinkedHashSet(idsList));
    }

    public static void willDelete(@NotNull NlComponent parent, @NotNull String id) {
        for (NlComponent child : parent.getChildren()) {
            String ids;
            if (!NlComponentHelperKt.isOrHasSuperclass(child, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER) || (ids = child.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) == null) continue;
            ids = ConstraintHelperHandler.removeIds(ids, Collections.singletonList(id));
            AttributesTransaction transaction = child.startAttributeTransaction();
            ConstraintHelperHandler.writeIds(child, transaction, ids);
        }
    }

    @Override
    public int getComponentTreeChildCount(@NotNull Object element) {
        String ids;
        NlComponent component;
        if (element instanceof NlComponent && NlComponentHelperKt.isOrHasSuperclass(component = (NlComponent)element, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER) && (ids = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) != null) {
            String[] list = ids.split(",");
            return list.length;
        }
        return 0;
    }

    @Override
    public Object getComponentTreeChild(@NotNull Object element, int i) {
        if (element instanceof NlComponent) {
            String ids;
            NlComponent component = (NlComponent)element;
            if (NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER) && (ids = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) != null) {
                String[] list = ids.split(",");
                return new NlComponentReference(component, list[i]);
            }
            return component.getChild(i);
        }
        return null;
    }

    @Override
    public List<?> getComponentTreeChildren(@NotNull Object element) {
        if (element instanceof NlComponent) {
            String ids;
            NlComponent component = (NlComponent)element;
            if (NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER) && (ids = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) != null) {
                List<String> list = Arrays.asList(ids.split(","));
                return list.stream().map(id -> new NlComponentReference(component, (String)id)).collect(Collectors.toList());
            }
            return component.getChildren();
        }
        return Collections.emptyList();
    }

    private void deleteReferences(@NotNull NlComponent component, @NotNull List<String> ids) {
        String refs = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids");
        if (refs != null) {
            refs = ConstraintHelperHandler.removeIds(refs, ids);
            AttributesTransaction transaction = component.startAttributeTransaction();
            ConstraintHelperHandler.writeIds(component, transaction, refs);
        }
    }

    private static void writeIds(@NotNull NlComponent component, @NotNull AttributesTransaction transaction, @Nullable String idList) {
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids", idList);
        NlWriteCommandActionUtil.run(component, "", transaction::commit);
    }
}

