/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.absolute;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.scene.target.ResizeWithSnapBaseTarget;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class AbsoluteResizeTarget
extends ResizeWithSnapBaseTarget {
    public AbsoluteResizeTarget(@NotNull ResizeBaseTarget.Type type) {
        super(type);
    }

    private static void updateXPos(@NotNull NlAttributesHolder attributes, int x) {
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_x", String.format(Locale.US, "%ddp", Math.max(x, 0)));
    }

    private static void updateYPos(@NotNull NlAttributesHolder attributes, int y) {
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_y", String.format(Locale.US, "%ddp", Math.max(y, 0)));
    }

    protected static void updateWidth(@NotNull NlAttributesHolder attributes, @NotNull String width) {
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", width);
    }

    protected static void updateHeight(@NotNull NlAttributesHolder attributes, @NotNull String height) {
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", height);
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        switch (this.myType) {
            case LEFT: 
            case RIGHT: {
                AbsoluteResizeTarget.updateXPos(attributes, this.getNewXPos(x));
                AbsoluteResizeTarget.updateWidth(attributes, this.getNewWidth(x));
                break;
            }
            case TOP: 
            case BOTTOM: {
                AbsoluteResizeTarget.updateYPos(attributes, this.getNewYPos(y));
                AbsoluteResizeTarget.updateHeight(attributes, this.getNewHeight(y));
                break;
            }
            case LEFT_TOP: 
            case LEFT_BOTTOM: 
            case RIGHT_TOP: 
            case RIGHT_BOTTOM: {
                AbsoluteResizeTarget.updateXPos(attributes, this.getNewXPos(x));
                AbsoluteResizeTarget.updateYPos(attributes, this.getNewYPos(y));
                AbsoluteResizeTarget.updateWidth(attributes, this.getNewWidth(x));
                AbsoluteResizeTarget.updateHeight(attributes, this.getNewHeight(y));
            }
        }
    }
}

