/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.AndroidXConstants;
import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.resources.ResourceType;
import com.android.support.FragmentTagUtil;
import com.android.tools.idea.projectsystem.DependencyType;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.ReplaceTagFix;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.tools.idea.rendering.tokens.BuildSystemFilePreviewServicesKt;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.rendering.HtmlLinkManager;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.android.utils.SdkUtils;
import com.android.utils.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.PsiNavigateUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

public class StudioHtmlLinkManager
implements HtmlLinkManager {
    private static final String URL_SHOW_XML = "action:showXml";
    private static final String URL_RUNNABLE = "runnable:";
    private SparseArray<HtmlLinkManager.Action> myLinkRunnables;
    private int myNextLinkId = 0;
    private static final NotificationGroup NOTIFICATIONS_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Render error panel notifications");

    public void showNotification(@NotNull String content) {
        Notification notification = NOTIFICATIONS_GROUP.createNotification(content, NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification);
        new Alarm().addRequest(() -> ((Notification)notification).expire(), TimeUnit.SECONDS.toMillis(2L));
    }

    public void handleUrl(@NotNull String url, @Nullable Module module, @NotNull PsiFile file2, boolean hasRenderResult, @NotNull HtmlLinkManager.RefreshableSurface surface2) {
        if (url.startsWith("http:") || url.startsWith("https:")) {
            BrowserLauncher.getInstance().browse(url, null, module == null ? null : module.getProject());
        } else if (url.startsWith("file:")) {
            assert (module != null);
            StudioHtmlLinkManager.handleFileUrl(url, module);
        } else if (url.startsWith("replaceTags:")) {
            assert (module != null);
            StudioHtmlLinkManager.handleReplaceTagsUrl(url, module, file2);
        } else if (url.equals("action:buildForRendering")) {
            assert (module != null);
            StudioHtmlLinkManager.handleBuildForRenderingUrl(url, file2);
        } else if (url.equals("action:build")) {
            assert (module != null);
            StudioHtmlLinkManager.handleBuildProjectUrl(url, module.getProject());
        } else if (url.equals("action:sync")) {
            assert (module != null);
            StudioHtmlLinkManager.handleSyncProjectUrl(url, module.getProject());
        } else if (url.equals("action:classpath")) {
            assert (module != null);
            StudioHtmlLinkManager.handleEditClassPathUrl(url, module);
        } else if (url.startsWith("createClass:")) {
            assert (module != null);
            StudioHtmlLinkManager.handleNewClassUrl(url, module);
        } else if (url.startsWith("open:")) {
            assert (module != null);
            StudioHtmlLinkManager.handleOpenStackUrl(url, module);
        } else if (url.startsWith("openClass:")) {
            assert (module != null);
            StudioHtmlLinkManager.handleOpenClassUrl(url, module);
        } else if (url.equals(URL_SHOW_XML)) {
            assert (module != null);
            StudioHtmlLinkManager.handleShowXmlUrl(url, module, file2);
        } else if (url.startsWith("showTag:")) {
            assert (module != null);
            StudioHtmlLinkManager.handleShowTagUrl(url, module, file2);
        } else if (url.startsWith("assignFragmentUrl:")) {
            assert (module != null);
            StudioHtmlLinkManager.handleAssignFragmentUrl(url, module, file2);
        } else if (url.startsWith("assignLayoutUrl:")) {
            assert (module != null);
            StudioHtmlLinkManager.handleAssignLayoutUrl(url, module, file2);
        } else if (url.equals("action:ignoreFragment")) {
            assert (hasRenderResult);
            StudioHtmlLinkManager.handleIgnoreFragments(url, surface2);
        } else if (url.startsWith("editAttribute:")) {
            assert (hasRenderResult);
            if (module != null) {
                StudioHtmlLinkManager.handleEditAttribute(url, module, file2);
            }
        } else if (url.startsWith("replaceAttributeValue:")) {
            assert (hasRenderResult);
            if (module != null) {
                StudioHtmlLinkManager.handleReplaceAttributeValue(url, module, file2);
            }
        } else if (url.startsWith("disableSandbox:")) {
            assert (module != null);
            StudioHtmlLinkManager.handleDisableSandboxUrl(module, surface2);
        } else if (url.startsWith(URL_RUNNABLE)) {
            HtmlLinkManager.Action linkRunnable = this.getLinkRunnable(url);
            if (linkRunnable instanceof ShowExceptionFix) {
                ((ShowExceptionFix)linkRunnable).showException(module, file2, (HtmlLinkManager)this);
            } else if (linkRunnable != null) {
                linkRunnable.actionPerformed(module);
            }
        } else if ((url.startsWith("addDependency:") || url.startsWith("addDebugDependency:")) && module != null) {
            StudioHtmlLinkManager.handleAddDependency(url, module);
            ProjectSystemUtil.getSyncManager((Project)module.getProject()).requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        } else if (url.startsWith("refreshRender")) {
            surface2.handleRefreshRenderUrl();
        } else if (url.startsWith("clearCacheAndNotify")) {
            surface2.handleRefreshRenderUrl();
            this.showNotification("Cache cleared");
        } else assert (false) : "Unexpected URL: " + url;
    }

    private static void handleFileUrl(@NotNull String url, @NotNull Module module) {
        Project project = module.getProject();
        SdkUtils.FileLineColumnUrlData parsed = SdkUtils.parseDecoratedFileUrlString((String)url);
        int line = parsed.line == null ? -1 : parsed.line;
        int column = parsed.column == null ? 0 : parsed.column;
        try {
            File ioFile = SdkUtils.urlToFile((String)parsed.urlString);
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            if (file2 != null) {
                StudioHtmlLinkManager.openEditor(project, file2, line, column);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @NotNull
    public String createCommandLink(@NotNull HtmlLinkManager.CommandLink command) {
        return this.createActionLink(module -> command.executeCommand());
    }

    @NotNull
    public String createActionLink(@NotNull HtmlLinkManager.Action action2) {
        String url = URL_RUNNABLE + this.myNextLinkId;
        if (this.myLinkRunnables == null) {
            this.myLinkRunnables = new SparseArray(5);
        }
        this.myLinkRunnables.put(this.myNextLinkId, (Object)action2);
        ++this.myNextLinkId;
        return url;
    }

    @Nullable
    private HtmlLinkManager.Action getLinkRunnable(String url) {
        if (this.myLinkRunnables != null && url.startsWith(URL_RUNNABLE)) {
            String idString = url.substring(URL_RUNNABLE.length());
            int id = Integer.decode(idString);
            return (HtmlLinkManager.Action)this.myLinkRunnables.get(id);
        }
        return null;
    }

    private static void handleReplaceTagsUrl(@NotNull String url, @NotNull Module module, @NotNull PsiFile file2) {
        assert (url.startsWith("replaceTags:")) : url;
        int start = "replaceTags:".length();
        int delimiterPos = url.indexOf(47, start);
        if (delimiterPos != -1) {
            String wrongTag = url.substring(start, delimiterPos);
            String rightTag = url.substring(delimiterPos + 1);
            new ReplaceTagFix((XmlFile)file2, wrongTag, rightTag).run();
        }
    }

    private static void handleBuildForRenderingUrl(@NotNull String url, @NotNull PsiFile psiFile) {
        assert (url.equals("action:buildForRendering")) : url;
        if (psiFile.getProject().isDisposed()) {
            return;
        }
        BuildSystemFilePreviewServicesKt.requestBuildArtifactsForRendering((Project)psiFile.getProject(), (VirtualFile)psiFile.getVirtualFile());
    }

    private static void handleBuildProjectUrl(@NotNull String url, @NotNull Project project) {
        assert (url.equals("action:build")) : url;
        ProjectSystemUtil.getProjectSystem((Project)project).getBuildManager().compileProject();
    }

    private static void handleSyncProjectUrl(@NotNull String url, @NotNull Project project) {
        assert (url.equals("action:sync")) : url;
        ProjectSystemSyncManager.SyncReason reason = project.isInitialized() ? ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED : ProjectSystemSyncManager.SyncReason.PROJECT_LOADED;
        ProjectSystemUtil.getProjectSystem((Project)project).getSyncManager().requestSyncProject(reason);
    }

    private static void handleEditClassPathUrl(@NotNull String url, @NotNull Module module) {
        assert (url.equals("action:classpath")) : url;
        ProjectSettingsService.getInstance((Project)module.getProject()).openModuleSettings(module);
    }

    private static void handleOpenClassUrl(@NotNull String url, @NotNull Module module) {
        PsiFile containingFile;
        assert (url.startsWith("openClass:")) : url;
        String className = url.substring("openClass:".length());
        Project project = module.getProject();
        PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        if (clz != null && (containingFile = clz.getContainingFile()) != null) {
            StudioHtmlLinkManager.openEditor(project, containingFile, clz.getTextOffset());
        }
    }

    private static void handleShowXmlUrl(@NotNull String url, @NotNull Module module, @NotNull PsiFile file2) {
        assert (url.equals(URL_SHOW_XML)) : url;
        StudioHtmlLinkManager.openEditor(module.getProject(), file2, 0, -1);
    }

    private static void handleShowTagUrl(@NotNull String url, @NotNull Module module, @NotNull PsiFile file2) {
        assert (url.startsWith("showTag:")) : url;
        String tagName = url.substring("showTag:".length());
        XmlTag first = (XmlTag)ApplicationManager.getApplication().runReadAction(() -> {
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlTag.class);
            for (XmlTag tag : xmlTags) {
                if (!tagName.equals(tag.getName())) continue;
                return tag;
            }
            return null;
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first);
        } else {
            StudioHtmlLinkManager.openEditor(module.getProject(), file2, 0, -1);
        }
    }

    private static void handleNewClassUrl(@NotNull String url, @NotNull Module module) {
        PsiFile file2;
        PsiClass newClass;
        PsiDirectory targetDirectory;
        String packageName;
        String className;
        assert (url.startsWith("createClass:")) : url;
        String s = url.substring("createClass:".length());
        Project project = module.getProject();
        String title = "Create Custom View";
        int index = s.lastIndexOf(46);
        if (index == -1) {
            className = s;
            packageName = ProjectSystemUtil.getModuleSystem((Module)module).getPackageName();
            if (packageName == null) {
                return;
            }
        } else {
            packageName = s.substring(0, index);
            className = s.substring(index + 1);
        }
        CreateClassDialog dialog = new CreateClassDialog(project, title, className, packageName, (ClassKind)CreateClassKind.CLASS, true, module){

            protected boolean reportBaseInSourceSelectionInTest() {
                return true;
            }
        };
        dialog.show();
        if (dialog.getExitCode() == 0 && (targetDirectory = dialog.getTargetDirectory()) != null && (newClass = (PsiClass)WriteCommandAction.writeCommandAction((Project)project).withName("Create Class").compute(() -> {
            PsiClass targetClass = JavaDirectoryService.getInstance().createClass(targetDirectory, className);
            PsiManager manager = PsiManager.getInstance((Project)project);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiElementFactory factory = facade.getElementFactory();
            PsiJavaCodeReferenceElement superclassReference = factory.createReferenceElementByFQClassName("android.view.View", targetClass.getResolveScope());
            PsiReferenceList extendsList = targetClass.getExtendsList();
            if (extendsList != null) {
                extendsList.add((PsiElement)superclassReference);
            }
            GlobalSearchScope scope2 = GlobalSearchScope.allScope((Project)project);
            PsiJavaFile javaFile = (PsiJavaFile)targetClass.getContainingFile();
            PsiImportList importList = javaFile.getImportList();
            if (importList != null) {
                PsiClass attributeSetClass;
                PsiClass contextClass = JavaPsiFacade.getInstance((Project)project).findClass("android.content.Context", scope2);
                if (contextClass != null) {
                    importList.add((PsiElement)factory.createImportStatement(contextClass));
                }
                if ((attributeSetClass = JavaPsiFacade.getInstance((Project)project).findClass("android.util.AttributeSet", scope2)) != null) {
                    importList.add((PsiElement)factory.createImportStatement(attributeSetClass));
                }
            }
            PsiMethod constructor1arg = factory.createMethodFromText("public " + className + "(Context context) {\n  this(context, null);\n}\n", (PsiElement)targetClass);
            targetClass.add((PsiElement)constructor1arg);
            PsiMethod constructor2args = factory.createMethodFromText("public " + className + "(Context context, AttributeSet attrs) {\n  this(context, attrs, 0);\n}\n", (PsiElement)targetClass);
            targetClass.add((PsiElement)constructor2args);
            PsiMethod constructor3args = factory.createMethodFromText("public " + className + "(Context context, AttributeSet attrs, int defStyle) {\n  super(context, attrs, defStyle);\n}\n", (PsiElement)targetClass);
            targetClass.add((PsiElement)constructor3args);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
            PsiFile containingFile = targetClass.getContainingFile();
            if (containingFile != null) {
                codeStyleManager.reformat((PsiElement)javaFile);
            }
            return targetClass;
        })) != null && (file2 = newClass.getContainingFile()) != null) {
            StudioHtmlLinkManager.openEditor(project, file2, newClass.getTextOffset());
        }
    }

    @VisibleForTesting
    static void handleOpenStackUrl(@NotNull String url, @NotNull Module module) {
        KtFile containingFile;
        int line;
        String fileName;
        String className;
        assert (url.startsWith("open:")) : url;
        int start = "open:".length();
        int semi = url.indexOf(59, start);
        if (semi != -1) {
            className = url.substring(start, semi);
            int colon = url.indexOf(58, semi + 1);
            if (colon != -1) {
                fileName = url.substring(semi + 1, colon);
                line = Integer.decode(url.substring(colon + 1));
            } else {
                fileName = url.substring(semi + 1);
                line = -1;
            }
        } else {
            className = url.substring(start);
            fileName = null;
            line = -1;
        }
        String method = null;
        int hash = className.indexOf(35);
        if (hash != -1) {
            method = className.substring(hash + 1);
            className = className.substring(0, hash);
        }
        Project project = module.getProject();
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        if (fileName != null && (containingFile = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project, searchScope, JvmClassName.byInternalName((String)className.replace(".", "/")), fileName)) != null) {
            StudioHtmlLinkManager.openEditor(project, (PsiFile)containingFile, line - 1, -1);
            return;
        }
        PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(className, searchScope);
        if (clz != null) {
            String name;
            VirtualFile virtualFile;
            PsiFile containingFile2 = clz.getContainingFile();
            if (fileName != null && containingFile2 != null && line != -1 && (virtualFile = containingFile2.getVirtualFile()) != null && fileName.equals(name = virtualFile.getName())) {
                StudioHtmlLinkManager.openEditor(project, containingFile2, line - 1, -1);
                return;
            }
            if (method != null) {
                PsiMethod[] methodsByName;
                for (PsiMethod psiMethod : methodsByName = clz.findMethodsByName(method, true)) {
                    VirtualFile virtualFile2;
                    PsiFile psiFile = psiMethod.getContainingFile();
                    if (psiFile == null || (virtualFile2 = psiFile.getVirtualFile()) == null) continue;
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile2, psiMethod.getTextOffset());
                    FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
                    return;
                }
            }
            if (fileName != null) {
                PsiFile[] files = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)searchScope);
                for (PsiMethod psiMethod : files) {
                    if (StudioHtmlLinkManager.openEditor(project, (PsiFile)psiMethod, line != -1 ? line - 1 : -1, -1)) break;
                }
            }
        }
    }

    private static boolean openEditor(@NotNull Project project, @NotNull PsiFile psiFile, int line, int column) {
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 != null) {
            return StudioHtmlLinkManager.openEditor(project, file2, line, column);
        }
        return false;
    }

    private static boolean openEditor(@NotNull Project project, @NotNull VirtualFile file2, int line, int column) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file2, line, column);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        if (manager.openTextEditor(descriptor, true) != null) {
            return true;
        }
        return !manager.openEditor(descriptor, true).isEmpty();
    }

    private static boolean openEditor(@NotNull Project project, @NotNull PsiFile psiFile, int offset) {
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 != null) {
            return StudioHtmlLinkManager.openEditor(project, file2, offset);
        }
        return false;
    }

    private static boolean openEditor(@NotNull Project project, @NotNull VirtualFile file2, int offset) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file2, offset);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor, true).isEmpty();
    }

    @NotNull
    private static String getFragmentClass(@NotNull Module module, @NotNull String fqcn) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            String jvmClassName;
            Project project = module.getProject();
            JavaPsiFacade finder = JavaPsiFacade.getInstance((Project)project);
            PsiClass psiClass = finder.findClass(fqcn, module.getModuleScope());
            if (psiClass == null) {
                psiClass = finder.findClass(fqcn, GlobalSearchScope.allScope((Project)project));
            }
            if (psiClass != null && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)psiClass)) != null) {
                return jvmClassName.replace('/', '.');
            }
            return fqcn;
        });
    }

    private static void handleAssignFragmentUrl(@NotNull String url, @NotNull Module module, @NotNull PsiFile file2) {
        assert (url.startsWith("assignFragmentUrl:")) : url;
        String className = ChooseClassDialog.openDialog((Module)module, (String)"Fragments", null, (String[])new String[]{"android.app.Fragment", AndroidXConstants.CLASS_V4_FRAGMENT.oldName(), AndroidXConstants.CLASS_V4_FRAGMENT.newName()});
        if (className == null) {
            return;
        }
        String fragmentClass = StudioHtmlLinkManager.getFragmentClass(module, className);
        int start = "assignFragmentUrl:".length();
        String id = start == url.length() ? null : Lint.stripIdPrefix((String)url.substring(start));
        WriteCommandAction.writeCommandAction((Project)module.getProject(), (PsiFile[])new PsiFile[]{file2}).withName("Assign Fragment").run(() -> {
            Collection tags = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlTag.class);
            for (XmlTag tag : tags) {
                String tagId;
                if (!FragmentTagUtil.isFragmentTag((String)tag.getName()) || id != null && ((tagId = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android")) == null || !tagId.endsWith(id) || !id.equals(Lint.stripIdPrefix((String)tagId))) || tag.getAttribute("name", "http://schemas.android.com/apk/res/android") != null || tag.getAttribute("class") != null) continue;
                tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                return;
            }
            if (id == null) {
                for (XmlTag tag : tags) {
                    if (!FragmentTagUtil.isFragmentTag((String)tag.getName())) continue;
                    tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                    break;
                }
            }
        });
    }

    private static void handleAssignLayoutUrl(@NotNull String url, @NotNull Module module, @NotNull PsiFile file2) {
        assert (url.startsWith("assignLayoutUrl:")) : url;
        int start = "assignLayoutUrl:".length();
        int layoutStart = url.indexOf(58, start + 1);
        Project project = module.getProject();
        XmlFile xmlFile = (XmlFile)file2;
        if (layoutStart == -1) {
            String activityName = url.substring(start);
            StudioHtmlLinkManager.pickLayout(module, xmlFile, activityName);
        } else {
            String activityName = url.substring(start, layoutStart);
            String layoutName = url.substring(layoutStart + 1);
            String layout = "@layout/" + layoutName;
            StudioHtmlLinkManager.assignLayout(project, xmlFile, activityName, layout);
        }
    }

    private static void pickLayout(@NotNull Module module, @NotNull XmlFile file2, @NotNull String activityName) {
        String layout;
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        assert (facet != null);
        ResourcePickerDialog dialog = ResourceChooserHelperKt.createResourcePickerDialog((String)"Choose a Layout", null, (AndroidFacet)facet, EnumSet.of(ResourceType.LAYOUT), null, (boolean)true, (boolean)false, (boolean)true, (VirtualFile)file2.getVirtualFile());
        if (dialog.showAndGet() && !(layout = dialog.getResourceName()).equals("@layout/" + file2.getName())) {
            StudioHtmlLinkManager.assignLayout(module.getProject(), file2, activityName, layout);
        }
    }

    private static void assignLayout(@NotNull Project project, @NotNull XmlFile file2, @NotNull String activityName, @NotNull String layout) {
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).withName("Assign Preview Layout").run(() -> {
            IdeResourcesUtil.ensureNamespaceImported((XmlFile)file2, (String)"http://schemas.android.com/tools", null);
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlTag.class);
            for (XmlTag tag : xmlTags) {
                if (!FragmentTagUtil.isFragmentTag((String)tag.getName())) continue;
                String name = tag.getAttributeValue("class");
                if (name == null || name.isEmpty()) {
                    name = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                }
                if (!activityName.equals(name)) continue;
                tag.setAttribute("layout", "http://schemas.android.com/tools", layout);
            }
        });
    }

    private static void handleIgnoreFragments(@NotNull String url, @NotNull HtmlLinkManager.RefreshableSurface surface2) {
        assert (url.equals("action:ignoreFragment"));
        RenderLogger.ignoreFragments();
        surface2.requestRender();
    }

    private static void handleEditAttribute(@NotNull String url, @NotNull Module module, @NotNull PsiFile file2) {
        assert (url.startsWith("editAttribute:"));
        int attributeStart = "editAttribute:".length();
        int valueStart = url.indexOf(47);
        String attributeName = url.substring(attributeStart, valueStart);
        String value = url.substring(valueStart + 1);
        XmlAttribute first = (XmlAttribute)ApplicationManager.getApplication().runReadAction(() -> {
            Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlAttribute.class);
            for (XmlAttribute attribute : attributes) {
                if (!attributeName.equals(attribute.getLocalName()) || !value.equals(attribute.getValue())) continue;
                return attribute;
            }
            return null;
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first.getValueElement());
        } else {
            StudioHtmlLinkManager.openEditor(module.getProject(), file2, 0, -1);
        }
    }

    private static void handleReplaceAttributeValue(@NotNull String url, @NotNull Module module, @NotNull PsiFile file2) {
        assert (url.startsWith("replaceAttributeValue:"));
        int attributeStart = "replaceAttributeValue:".length();
        int valueStart = url.indexOf(47);
        int newValueStart = url.indexOf(47, valueStart + 1);
        String attributeName = url.substring(attributeStart, valueStart);
        String oldValue = url.substring(valueStart + 1, newValueStart);
        String newValue = url.substring(newValueStart + 1);
        WriteCommandAction.writeCommandAction((Project)module.getProject(), (PsiFile[])new PsiFile[]{file2}).withName("Set Attribute Value").run(() -> {
            Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlAttribute.class);
            int oldValueLen = oldValue.length();
            for (XmlAttribute attribute : attributes) {
                Object attributeValue;
                if (!attributeName.equals(attribute.getLocalName()) || (attributeValue = attribute.getValue()) == null) continue;
                if (oldValue.equals(attributeValue)) {
                    attribute.setValue(newValue);
                    continue;
                }
                int index = ((String)attributeValue).indexOf(oldValue);
                if (index == -1 || index != 0 && ((String)attributeValue).charAt(index - 1) != '|' || index + oldValueLen != ((String)attributeValue).length() && ((String)attributeValue).charAt(index + oldValueLen) != '|') continue;
                attributeValue = ((String)attributeValue).substring(0, index) + newValue + ((String)attributeValue).substring(index + oldValueLen);
                attribute.setValue((String)attributeValue);
            }
        });
    }

    private static void handleDisableSandboxUrl(@NotNull Module module, @Nullable HtmlLinkManager.RefreshableSurface surface2) {
        RenderSecurityManager.sEnabled = false;
        surface2.requestRender();
        Messages.showInfoMessage((Project)module.getProject(), (String)"The custom view rendering sandbox was disabled for this session.\n\nYou can turn it off permanently by adding\nandroid.render.sandbox=false\nto {install}/bin/idea.properties.", (String)"Disabled Rendering Sandbox");
    }

    @UiThread
    @VisibleForTesting
    static void handleAddDependency(@NotNull String url, @NotNull Module module) {
        String coordinateStr;
        DependencyType dependencyType;
        if (url.startsWith("addDependency:")) {
            dependencyType = DependencyType.IMPLEMENTATION;
            coordinateStr = url.substring("addDependency:".length());
        } else if (url.startsWith("addDebugDependency:")) {
            dependencyType = DependencyType.DEBUG_IMPLEMENTATION;
            coordinateStr = url.substring("addDebugDependency:".length());
        } else {
            return;
        }
        GoogleMavenArtifactId id = GoogleMavenArtifactId.find((String)coordinateStr);
        if (id == null) {
            Logger.getInstance(StudioHtmlLinkManager.class).warn("Invalid coordinate " + coordinateStr);
            return;
        }
        if (DependencyManagementUtil.addDependenciesWithUiConfirmation((Module)module, Set.of(id), (boolean)false, (boolean)false, (DependencyType)dependencyType).isEmpty()) {
            return;
        }
        Logger.getInstance(StudioHtmlLinkManager.class).warn("Could not add dependency " + String.valueOf(id));
    }

    static abstract class StudioCommandLink
    implements HtmlLinkManager.CommandLink {
        private final String myCommandName;
        private final PsiFile myFile;

        StudioCommandLink(@NotNull String commandName, @NotNull PsiFile file2) {
            this.myCommandName = commandName;
            this.myFile = file2;
        }

        protected abstract void run();

        public final void executeCommand() {
            WriteCommandAction.writeCommandAction((Project)this.myFile.getProject(), (PsiFile[])new PsiFile[]{this.myFile}).withName(this.myCommandName).run(this::run);
        }
    }
}

