/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview;

import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.util.LogUtilKt;
import com.android.tools.idea.run.util.StopWatch;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderResult;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0007J\u0014\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/preview/PreviewElementDebugLogger;", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "refreshId", "", "stopwatch", "Lcom/android/tools/idea/run/util/StopWatch;", "logPreviewElement", "", "previewElementLogString", "previewXmlContent", "message", "logRenderComplete", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "Lcom/android/tools/idea/uibuilder/scene/LayoutlibSceneManager;", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nPreviewElementDebugLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewElementDebugLogger.kt\ncom/android/tools/idea/preview/PreviewElementDebugLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1869#2,2:73\n*S KotlinDebug\n*F\n+ 1 PreviewElementDebugLogger.kt\ncom/android/tools/idea/preview/PreviewElementDebugLogger\n*L\n54#1:73,2\n*E\n"})
public final class PreviewElementDebugLogger {
    @NotNull
    private final Logger log;
    @NotNull
    private final String refreshId;
    @NotNull
    private final StopWatch stopwatch;

    public PreviewElementDebugLogger(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.refreshId = string;
        this.stopwatch = new StopWatch();
    }

    public final void logPreviewElement(@NotNull String previewElementLogString, @NotNull String previewXmlContent) {
        Intrinsics.checkNotNullParameter((Object)previewElementLogString, (String)"previewElementLogString");
        Intrinsics.checkNotNullParameter((Object)previewXmlContent, (String)"previewXmlContent");
        this.log(StringsKt.trimIndent((String)("Preview found at " + this.stopwatch.getDuration().toMillis() + "ms\n        " + previewElementLogString + "\n\n        " + previewXmlContent + "\n     ")));
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log.debug("[" + this.refreshId + "] " + message);
    }

    public final void logRenderComplete(@NotNull DesignSurface<LayoutlibSceneManager> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        this.log("Render completed in " + this.stopwatch.getDuration().toMillis() + "ms");
        Iterable $this$forEach$iv = surface2.getSceneManagers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RenderLogger renderLogger;
            RenderResult result;
            LayoutlibSceneManager it = (LayoutlibSceneManager)element$iv;
            boolean bl = false;
            String modelName = (String)it.getModel().getDisplaySettings().getModelDisplayName().getValue();
            if (it.getRenderResult() == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)result.getLogger(), (String)"getLogger(...)");
            boolean bl3 = renderLogger.hasErrors();
            Set set = renderLogger.getMissingClasses();
            List list = renderLogger.getMessages();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMessages(...)");
            this.log(StringsKt.trimMargin$default((String)("modelName=\"" + modelName + "\" result\n                  | " + result + "\n                  | hasErrors=" + bl3 + "\n                  | missingClasses=" + set + "\n                  | messages=" + LogUtilKt.asLogString(list) + "\n                  | exceptions=" + renderLogger.getBrokenClasses().values() + "\n                "), null, (int)1, null));
        }
    }
}

