/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.common.SwingPoint;
import com.android.tools.adtui.common.SwingX;
import com.android.tools.adtui.common.SwingY;
import com.android.tools.idea.common.model.AndroidLength;
import com.android.tools.idea.common.model.AndroidLengthKt;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.ScaleKt;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneContextHelperKt;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavColors;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandle;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandleDrag;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.Point2D;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J&\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000eH\u0016J\"\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020\u000bH\u0016J\u001a\u0010(\u001a\n **\u0004\u0018\u00010)0)2\b\b\u0001\u0010'\u001a\u00020\u000bH\u0016J\b\u0010+\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/naveditor/scene/targets/ActionHandleTarget;", "Lcom/android/tools/idea/common/scene/target/BaseTarget;", "component", "Lcom/android/tools/idea/common/scene/SceneComponent;", "<init>", "(Lcom/android/tools/idea/common/scene/SceneComponent;)V", "handleState", "Lcom/android/tools/idea/naveditor/scene/targets/ActionHandleTarget$HandleState;", "isDragging", "", "getPreferenceLevel", "", "layout", "sceneTransform", "Lcom/android/tools/idea/common/scene/SceneContext;", "l", "t", "r", "b", "mouseDown", "", "x", "y", "mouseRelease", "closestTargets", "", "Lcom/android/tools/idea/common/scene/target/Target;", "canChangeSelection", "createAction", "Lcom/android/tools/idea/common/model/NlComponent;", "destination", "render", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "sceneContext", "addHit", "transform", "picker", "Lcom/android/tools/idea/common/scene/ScenePicker$Writer;", "modifiersEx", "getMouseCursor", "Ljava/awt/Cursor;", "kotlin.jvm.PlatformType", "calculateState", "HandleState", "intellij.android.nav.editor"})
public final class ActionHandleTarget
extends BaseTarget {
    @NotNull
    private HandleState handleState;
    private boolean isDragging;

    public ActionHandleTarget(@NotNull SceneComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.handleState = HandleState.INVISIBLE;
        this.setComponent(component);
        this.handleState = this.calculateState();
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        Intrinsics.checkNotNullParameter((Object)sceneTransform, (String)"sceneTransform");
        int centerX = r;
        NlComponent nlComponent = this.getComponent().getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"getNlComponent(...)");
        if (NavComponentHelperKt.isFragment(nlComponent)) {
            centerX += (int)NavDrawHelperKt.getACTION_HANDLE_OFFSET();
        }
        int centerY = t + (b - t) / 2;
        int radius = (int)this.handleState.getOuterRadius-rgmicCE();
        this.myLeft = centerX - radius;
        this.myTop = centerY - radius;
        this.myRight = centerX + radius;
        this.myBottom = centerY + radius;
        return false;
    }

    @Override
    public void mouseDown(int x, int y) {
        Scene scene = this.myComponent.getScene();
        Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"getScene(...)");
        Scene scene2 = scene;
        scene2.getDesignSurface().getSelectionModel().setSelection(CollectionsKt.listOf((Object)this.getComponent().getNlComponent()));
        this.isDragging = true;
        scene2.needsRebuildList();
        Object object = this.myComponent.getParent();
        if (object != null && (object = ((SceneComponent)object).getNlComponent()) != null) {
            ((NlComponent)object).putClientProperty("DRAG_CREATE_IN_PROGRESS", true);
        }
        this.getComponent().setDragging(true);
        scene2.repaint();
    }

    public void mouseRelease(int x, int y, @NotNull List<? extends Target> closestTargets) {
        Intrinsics.checkNotNullParameter(closestTargets, (String)"closestTargets");
        this.isDragging = false;
        Scene scene = this.myComponent.getScene();
        Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"getScene(...)");
        Scene scene2 = scene;
        Object object = this.myComponent.getParent();
        if (object != null && (object = ((SceneComponent)object).getNlComponent()) != null) {
            ((NlComponent)object).removeClientProperty("DRAG_CREATE_IN_PROGRESS");
        }
        this.getComponent().setDragging(false);
        SceneComponent sceneComponent = scene2.findComponent(((SceneView)CollectionsKt.first(this.getComponent().getScene().getSceneManager().getSceneViews())).getContext(), x, y);
        if (sceneComponent != null) {
            CharSequence charSequence;
            SceneComponent closestComponent = sceneComponent;
            boolean bl = false;
            if (closestComponent != this.getComponent().getScene().getRoot() && !((charSequence = (CharSequence)closestComponent.getId()) == null || charSequence.length() == 0)) {
                NlComponent nlComponent = this.createAction(closestComponent);
                if (nlComponent != null) {
                    NlComponent action2 = nlComponent;
                    boolean bl2 = false;
                    NavUsageTracker.Companion.getInstance(action2.getModel()).createEvent(NavEditorEvent.NavEditorEventType.CREATE_ACTION).withActionInfo(action2).withSource(NavEditorEvent.Source.DESIGN_SURFACE).log();
                    this.getComponent().getScene().getDesignSurface().getSelectionModel().setSelection(CollectionsKt.listOf((Object)action2));
                }
            }
        }
        scene2.needsRebuildList();
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    private final NlComponent createAction(SceneComponent destination) {
        if (this.mIsOver) {
            return null;
        }
        NlComponent nlComponent = destination.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"getNlComponent(...)");
        NlComponent destinationNlComponent = nlComponent;
        if (!NavComponentHelperKt.isDestination(destinationNlComponent)) {
            return null;
        }
        NlComponent nlComponent2 = this.getComponent().getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"getNlComponent(...)");
        NlComponent nlComponent3 = nlComponent2;
        return (NlComponent)WriteCommandAction.runWriteCommandAction((Project)nlComponent3.getModel().getProject(), () -> ActionHandleTarget.createAction$lambda$2(nlComponent3, destinationNlComponent));
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        JBColor innerColor;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
        HandleState newState = this.calculateState();
        if (newState == HandleState.INVISIBLE && this.handleState == HandleState.INVISIBLE) {
            return;
        }
        SceneView sceneView = this.myComponent.getScene().getDesignSurface().getFocusedSceneView();
        if (sceneView == null) {
            return;
        }
        SceneView view = sceneView;
        float centerX = SwingX.constructor-impl((float)Coordinates.getSwingXDip(view, this.getCenterX()));
        float centerY = SwingY.constructor-impl((float)Coordinates.getSwingYDip(view, this.getCenterY()));
        Point2D.Float center = SwingPoint.constructor-impl((float)centerX, (float)centerY);
        double scale = SceneContextHelperKt.getInlineScale(sceneContext);
        float initialOuterRadius = ScaleKt.times-qL7Yd1Y(this.handleState.getOuterRadius-rgmicCE(), scale);
        float finalOuterRadius = ScaleKt.times-qL7Yd1Y(newState.getOuterRadius-rgmicCE(), scale);
        float initialInnerRadius = ScaleKt.times-qL7Yd1Y(this.handleState.getInnerRadius-rgmicCE(), scale);
        float finalInnerRadius = ScaleKt.times-qL7Yd1Y(newState.getInnerRadius-rgmicCE(), scale);
        int duration = (int)Math.abs(AndroidLength.div-Nq3xGP8(AndroidLengthKt.times-6F9Ba1U(200, AndroidLength.minus-5e2Jogo(this.handleState.getOuterRadius-rgmicCE(), newState.getOuterRadius-rgmicCE())), NavDrawHelperKt.getOUTER_RADIUS_LARGE()));
        JBColor outerColor = StudioColorsKt.getPrimaryPanelBackground();
        JBColor jBColor = innerColor = this.getComponent().isSelected() ? NavColors.INSTANCE.getSELECTED() : NavColors.INSTANCE.getHIGHLIGHTED_FRAME();
        if (this.isDragging) {
            list.add(new DrawActionHandleDrag(center, initialOuterRadius, finalOuterRadius, finalInnerRadius, duration, null));
        } else {
            list.add(new DrawActionHandle(center, initialOuterRadius, finalOuterRadius, initialInnerRadius, finalInnerRadius, duration, (Color)innerColor, (Color)outerColor, null));
        }
        this.handleState = newState;
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker.Writer picker, @JdkConstants.InputEventMask int modifiersEx) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Intrinsics.checkNotNullParameter((Object)picker, (String)"picker");
        int centerX = transform.getSwingX((int)this.getCenterX());
        int centerY = transform.getSwingY((int)this.getCenterY());
        picker.addCircle(this, 0, centerX, centerY, transform.getSwingDimension(AndroidLength.toInt-impl(NavDrawHelperKt.getOUTER_RADIUS_LARGE())));
    }

    @Override
    public Cursor getMouseCursor(@JdkConstants.InputEventMask int modifiersEx) {
        return Cursor.getPredefinedCursor(12);
    }

    private final HandleState calculateState() {
        return this.isDragging ? HandleState.SMALL : (this.myComponent.getScene().getDesignSurface().getGuiInputHandler().isInteractionInProgress() ? HandleState.INVISIBLE : (this.mIsOver ? HandleState.LARGE : (this.getComponent().getDrawState() == SceneComponent.DrawState.HOVER ? HandleState.SMALL : (this.getComponent().isSelected() && this.myComponent.getScene().getSelection().size() == 1 ? HandleState.SMALL : HandleState.INVISIBLE))));
    }

    private static final NlComponent createAction$lambda$2(NlComponent $nlComponent, NlComponent $destinationNlComponent) {
        return NavComponentHelperKt.createAction$default($nlComponent, $destinationNlComponent.getId(), null, null, 6, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\bj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/naveditor/scene/targets/ActionHandleTarget$HandleState;", "", "innerRadius", "Lcom/android/tools/idea/common/model/AndroidLength;", "outerRadius", "<init>", "(Ljava/lang/String;IFF)V", "getInnerRadius-rgmicCE", "()F", "F", "getOuterRadius-rgmicCE", "INVISIBLE", "SMALL", "LARGE", "intellij.android.nav.editor"})
    private static final class HandleState
    extends Enum<HandleState> {
        private final float innerRadius;
        private final float outerRadius;
        public static final /* enum */ HandleState INVISIBLE = new HandleState(AndroidLength.constructor-impl(0.0f), AndroidLength.constructor-impl(0.0f));
        public static final /* enum */ HandleState SMALL = new HandleState(NavDrawHelperKt.getINNER_RADIUS_SMALL(), NavDrawHelperKt.getOUTER_RADIUS_SMALL());
        public static final /* enum */ HandleState LARGE = new HandleState(NavDrawHelperKt.getINNER_RADIUS_LARGE(), NavDrawHelperKt.getOUTER_RADIUS_LARGE());
        private static final /* synthetic */ HandleState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private HandleState(float innerRadius, float outerRadius) {
            this.innerRadius = innerRadius;
            this.outerRadius = outerRadius;
        }

        public final float getInnerRadius-rgmicCE() {
            return this.innerRadius;
        }

        public final float getOuterRadius-rgmicCE() {
            return this.outerRadius;
        }

        public static HandleState[] values() {
            return (HandleState[])$VALUES.clone();
        }

        public static HandleState valueOf(String value) {
            return Enum.valueOf(HandleState.class, value);
        }

        @NotNull
        public static EnumEntries<HandleState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = handleStateArray = new HandleState[]{HandleState.INVISIBLE, HandleState.SMALL, HandleState.LARGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

