/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.adtui.common.SwingRectangle;
import com.android.tools.adtui.common.SwingX;
import com.android.tools.adtui.common.SwingY;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandBaseKt;
import com.android.tools.idea.naveditor.scene.NavColors;
import com.android.tools.idea.naveditor.scene.RefinableImage;
import com.android.tools.idea.naveditor.scene.draw.DrawNavScreenKt;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J*\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/naveditor/scene/draw/DrawNavScreen;", "Lcom/android/tools/idea/common/scene/draw/DrawCommandBase;", "rectangle", "Lcom/android/tools/adtui/common/SwingRectangle;", "image", "Lcom/android/tools/idea/naveditor/scene/RefinableImage;", "<init>", "(Ljava/awt/geom/Rectangle2D$Float;Lcom/android/tools/idea/naveditor/scene/RefinableImage;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "Ljava/awt/geom/Rectangle2D$Float;", "onPaint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "drawText", "text1", "", "text2", "intellij.android.nav.editor"})
public final class DrawNavScreen
extends DrawCommandBase {
    @NotNull
    private final Rectangle2D.Float rectangle;
    @NotNull
    private final RefinableImage image;

    private DrawNavScreen(Rectangle2D.Float rectangle, RefinableImage image) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super(0, 1, null);
        this.rectangle = rectangle;
        this.image = image;
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
        g.setRenderingHints(DrawCommandBaseKt.getHQ_RENDERING_HINTS());
        g.clip(this.rectangle);
        RefinableImage lastCompleted = this.image.getLastCompleted();
        Image image = lastCompleted.getImage();
        if (image != null) {
            AffineTransform transform = new AffineTransform();
            transform.translate(SwingX.toDouble-impl((float)SwingRectangle.getX-8nHqNe4((Rectangle2D.Float)this.rectangle)), SwingY.toDouble-impl((float)SwingRectangle.getY-2EVm2E8((Rectangle2D.Float)this.rectangle)));
            UIUtil.drawImage((Graphics)g, (Image)image, (int)SwingX.toInt-impl((float)SwingRectangle.getX-8nHqNe4((Rectangle2D.Float)this.rectangle)), (int)SwingY.toInt-impl((float)SwingRectangle.getY-2EVm2E8((Rectangle2D.Float)this.rectangle)), null);
        } else if (lastCompleted.getRefined() == null) {
            this.drawText("Preview", "Unavailable", g, sceneContext);
        } else {
            this.drawText("Loading...", null, g, sceneContext);
        }
        if (lastCompleted.getRefined() != null) {
            lastCompleted.getRefined().thenRun(() -> DrawNavScreen.onPaint$lambda$0(sceneContext));
        }
    }

    private final void drawText(String text1, String text2, Graphics2D g, SceneContext sceneContext) {
        g.setColor((Color)NavColors.INSTANCE.getPLACEHOLDER_BACKGROUND());
        Rectangle2D.Float textRectangle = this.rectangle;
        g.fill(textRectangle);
        g.setColor((Color)NavColors.INSTANCE.getPLACEHOLDER_TEXT());
        g.setFont(new Font("Default", 0, sceneContext.getSwingDimension(DrawNavScreenKt.access$getFONT_SIZE$p())));
        float x = textRectangle.x + (textRectangle.width - (float)g.getFontMetrics().stringWidth(text1)) / (float)2;
        int padding = sceneContext.getSwingDimension(DrawNavScreenKt.access$getTEXT_PADDING$p());
        float y = textRectangle.y + (textRectangle.height - (float)padding) / (float)2;
        g.drawString(text1, x, y);
        if (text2 != null) {
            x = textRectangle.x + (textRectangle.width - (float)g.getFontMetrics().stringWidth(text2)) / (float)2;
            g.drawString(text2, x, y += (float)(g.getFontMetrics().getAscent() + padding));
        }
    }

    private static final void onPaint$lambda$0(SceneContext $sceneContext) {
        $sceneContext.repaint();
    }

    public /* synthetic */ DrawNavScreen(Rectangle2D.Float rectangle, RefinableImage image, DefaultConstructorMarker $constructor_marker) {
        this(rectangle, image);
    }
}

