/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.NlDataProvider;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.compose.preview.analytics.ComposeResizeToolingUsageTracker;
import com.android.tools.idea.compose.preview.util.UtilsKt;
import com.android.tools.idea.uibuilder.analytics.ResizeTracker;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.google.wireless.android.sdk.stats.ResizeComposePreviewEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/compose/preview/analytics/ComposeResizeTracker;", "Lcom/android/tools/idea/uibuilder/analytics/ResizeTracker;", "<init>", "()V", "isApplicable", "", "sceneManager", "Lcom/android/tools/idea/common/scene/SceneManager;", "reportResizeStopped", "", "widthDp", "", "heightDp", "dpi", "intellij.android.compose-designer"})
@StabilityInferred(parameters=1)
public final class ComposeResizeTracker
implements ResizeTracker {
    public static final int $stable;

    @Override
    public boolean isApplicable(@NotNull SceneManager sceneManager) {
        Intrinsics.checkNotNullParameter((Object)sceneManager, (String)"sceneManager");
        NlDataProvider nlDataProvider = sceneManager.getModel().getDataProvider();
        return (nlDataProvider != null ? UtilsKt.previewElement(nlDataProvider) : null) != null;
    }

    @Override
    public void reportResizeStopped(@NotNull SceneManager sceneManager, int widthDp, int heightDp, int dpi) {
        Intrinsics.checkNotNullParameter((Object)sceneManager, (String)"sceneManager");
        LayoutlibSceneManager layoutlibSceneManager = sceneManager instanceof LayoutlibSceneManager ? (LayoutlibSceneManager)sceneManager : null;
        if (layoutlibSceneManager == null) {
            return;
        }
        LayoutlibSceneManager layoutlibSceneManager2 = layoutlibSceneManager;
        boolean showDecorations = layoutlibSceneManager2.getSceneRenderConfiguration().getShowDecorations();
        ResizeComposePreviewEvent.ResizeMode mode = showDecorations ? ResizeComposePreviewEvent.ResizeMode.DEVICE_RESIZE : ResizeComposePreviewEvent.ResizeMode.COMPOSABLE_RESIZE;
        ComposeResizeToolingUsageTracker.INSTANCE.logResizeStopped(((LayoutlibSceneManager)sceneManager).getDesignSurface(), mode, widthDp, heightDp, dpi, ResizeComposePreviewEvent.ResizeSource.DRAG);
    }
}

