/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.actions.glasses;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.scene.draw.DrawCommandBaseKt;
import com.android.tools.idea.compose.preview.actions.glasses.GlassesBackground;
import com.android.tools.idea.compose.preview.actions.glasses.GlassesBackgroundBlendModeKt;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/compose/preview/actions/glasses/GlassesBackgroundBlendMode;", "", "background", "Ljava/awt/image/BufferedImage;", "<init>", "(Ljava/awt/image/BufferedImage;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "applyBackground", "", "renderedImage", "blendRenderedImageAndBackground", "scaledBackgroundImage", "Companion", "intellij.android.compose-designer"})
@StabilityInferred(parameters=0)
public final class GlassesBackgroundBlendMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedImage background;
    @NotNull
    private final Logger log;
    public static final int $stable = 8;

    private GlassesBackgroundBlendMode(BufferedImage background) {
        this.background = background;
        Logger logger = Logger.getInstance(GlassesBackgroundBlendMode.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void applyBackground(@NotNull BufferedImage renderedImage) {
        Intrinsics.checkNotNullParameter((Object)renderedImage, (String)"renderedImage");
        if (!(renderedImage.getType() == 3)) {
            boolean $i$a$-require-GlassesBackgroundBlendMode$applyBackground$22 = false;
            String $i$a$-require-GlassesBackgroundBlendMode$applyBackground$22 = "Rendered image must support transparency";
            throw new IllegalArgumentException($i$a$-require-GlassesBackgroundBlendMode$applyBackground$22.toString());
        }
        int targetWidth = renderedImage.getWidth();
        int targetHeight = renderedImage.getHeight();
        BufferedImage scaledBackgroundImage = GlassesBackgroundBlendModeKt.access$scaleTo(this.background, targetWidth, targetHeight);
        BufferedImage blendedImage = this.blendRenderedImageAndBackground(renderedImage, scaledBackgroundImage);
        try {
            Graphics2D graphics2D = renderedImage.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
            Graphics2D g2d = graphics2D;
            g2d.setRenderingHints(DrawCommandBaseKt.getHQ_RENDERING_HINTS());
            try {
                boolean bl = g2d.drawImage((Image)blendedImage, 0, 0, null);
            }
            finally {
                g2d.dispose();
            }
        }
        catch (Exception e) {
            this.log.warn("Error applying screen blend in-place: " + e.getMessage());
        }
    }

    private final BufferedImage blendRenderedImageAndBackground(BufferedImage renderedImage, BufferedImage scaledBackgroundImage) {
        if (!(renderedImage.getWidth() == scaledBackgroundImage.getWidth() && renderedImage.getHeight() == scaledBackgroundImage.getHeight())) {
            boolean $i$a$-require-GlassesBackgroundBlendMode$blendRenderedImageAndBackground$22 = false;
            String $i$a$-require-GlassesBackgroundBlendMode$blendRenderedImageAndBackground$22 = StringsKt.trimIndent((String)("\n        Rendered image and background image must have the same dimensions.\n        Rendered image width: " + renderedImage.getWidth() + ", height: " + renderedImage.getHeight() + "\n        Background image width: " + scaledBackgroundImage.getWidth() + ", height: " + scaledBackgroundImage.getHeight() + "\n      "));
            throw new IllegalArgumentException($i$a$-require-GlassesBackgroundBlendMode$blendRenderedImageAndBackground$22.toString());
        }
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        BufferedImage blendedImage = new BufferedImage(width, height, 1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int renderedImagePixel = renderedImage.getRGB(x, y);
                int backgroundPixel = scaledBackgroundImage.getRGB(x, y);
                int imgRed = renderedImagePixel >> 16 & 0xFF;
                int imgGreen = renderedImagePixel >> 8 & 0xFF;
                int imgBlue = renderedImagePixel & 0xFF;
                int bgRed = backgroundPixel >> 16 & 0xFF;
                int bgGreen = backgroundPixel >> 8 & 0xFF;
                int bgBlue = backgroundPixel & 0xFF;
                int blendedRed = 255 - (255 - imgRed) * (255 - bgRed) / 255;
                int blendedGreen = 255 - (255 - imgGreen) * (255 - bgGreen) / 255;
                int blendedBlue = 255 - (255 - imgBlue) * (255 - bgBlue) / 255;
                int finalPixelValue = 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue;
                blendedImage.setRGB(x, y, finalPixelValue);
            }
        }
        return blendedImage;
    }

    public /* synthetic */ GlassesBackgroundBlendMode(BufferedImage background, DefaultConstructorMarker $constructor_marker) {
        this(background);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/compose/preview/actions/glasses/GlassesBackgroundBlendMode$Companion;", "", "<init>", "()V", "loadBackgroundImage", "Ljava/awt/image/BufferedImage;", "fileName", "", "getInstance", "Lcom/android/tools/idea/compose/preview/actions/glasses/GlassesBackgroundBlendMode;", "mode", "Lcom/android/tools/idea/compose/preview/actions/glasses/GlassesBackground;", "getInstanceForTest", "background", "intellij.android.compose-designer"})
    @SourceDebugExtension(value={"SMAP\nGlassesBackgroundBlendMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlassesBackgroundBlendMode.kt\ncom/android/tools/idea/compose/preview/actions/glasses/GlassesBackgroundBlendMode$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,190:1\n24#2:191\n24#2:192\n*S KotlinDebug\n*F\n+ 1 GlassesBackgroundBlendMode.kt\ncom/android/tools/idea/compose/preview/actions/glasses/GlassesBackgroundBlendMode$Companion\n*L\n161#1:191\n168#1:192\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final BufferedImage loadBackgroundImage(String fileName) {
            InputStream imageStream = GlassesBackgroundBlendMode.class.getClassLoader().getResourceAsStream("glassesPreview/" + fileName);
            if (imageStream == null) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Error: Background '" + fileName + "' not found.");
                return null;
            }
            try {
                return ImageIO.read(imageStream);
            }
            catch (Exception e) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Error reading image '" + fileName + "'. Details: " + e.getMessage());
                return null;
            }
        }

        @Nullable
        public final GlassesBackgroundBlendMode getInstance(@NotNull GlassesBackground mode) {
            BufferedImage image;
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            String string = mode.getFileName();
            if (string == null) {
                return null;
            }
            BufferedImage bufferedImage = image = this.loadBackgroundImage(string);
            if (bufferedImage == null) {
                return null;
            }
            return new GlassesBackgroundBlendMode(bufferedImage, null);
        }

        @TestOnly
        @NotNull
        public final GlassesBackgroundBlendMode getInstanceForTest(@NotNull BufferedImage background) {
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            return new GlassesBackgroundBlendMode(background, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

