/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.Bridge;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.MaterialDesignIcons;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.uibuilder.editor.multirepresentation.sourcecode.SourceCodePreview;
import com.google.common.io.CharStreams;
import com.intellij.ide.DataManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\r\u001a*\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\r2\b\b\u0001\u0010\u0015\u001a\u00020\rH\u0000\u001a0\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\rH\u0002\u001a\u001c\u0010\u001e\u001a\u00020\u000f*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001f2\u0006\u0010!\u001a\u00020\"\u001a\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&\u001a$\u0010(\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030 2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00070*H\u0007\u001a\u0012\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010 *\u00020-H\u0007\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006."}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "moduleContainsResource", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "type", "Lcom/android/resources/ResourceType;", "name", "", "copyVectorAssetToMainModuleSourceSet", "", "project", "Lcom/intellij/openapi/project/Project;", "asset", "copyLayoutToMainModuleSourceSet", "layout", "xml", "createResourceFile", "resourceDirectory", "resourceFileName", "resourceFileContent", "", "getResourceDirectoryChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "child", "handleLayoutlibNativeCrash", "Lcom/android/tools/adtui/workbench/WorkBench;", "Lcom/android/tools/idea/common/surface/DesignSurface;", "runnable", "Ljava/lang/Runnable;", "createZoomControlAutoHiddenListener", "Ljava/awt/event/AWTEventListener;", "zoomControlPaneOwner", "Ljavax/swing/JComponent;", "zoomControlComponent", "updateSceneViewVisibilities", "visibilityFunc", "Lkotlin/Function1;", "Lcom/android/tools/idea/common/surface/SceneView;", "getDesignSurface", "Lcom/intellij/openapi/fileEditor/FileEditor;", "intellij.android.designer"})
@JvmName(name="DesignSurfaceHelper")
@SourceDebugExtension(value={"SMAP\nDesignSurfaceHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignSurfaceHelper.kt\ncom/android/tools/idea/common/surface/DesignSurfaceHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1374#2:219\n1460#2,5:220\n1869#2,2:225\n*S KotlinDebug\n*F\n+ 1 DesignSurfaceHelper.kt\ncom/android/tools/idea/common/surface/DesignSurfaceHelper\n*L\n199#1:219\n199#1:220,5\n200#1:225,2\n*E\n"})
public final class DesignSurfaceHelper {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy(DesignSurfaceHelper::logger_delegate$lambda$0);

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    public static final boolean moduleContainsResource(@NotNull AndroidFacet facet, @NotNull ResourceType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StudioResourceRepositoryManager.getModuleResources((AndroidFacet)facet).hasResources(ResourceNamespace.TODO(), type, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyVectorAssetToMainModuleSourceSet(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull String asset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        String string = MaterialDesignIcons.getPathForBasename((String)asset);
        if (string == null) {
            boolean bl = false;
            DesignSurfaceHelper.getLogger().warn("Cannot find the material icon path for " + asset);
            return;
        }
        String path = string;
        try {
            InputStream inputStream = IconGenerator.class.getClassLoader().getResourceAsStream(path);
            if (inputStream == null) {
                boolean bl = false;
                DesignSurfaceHelper.getLogger().warn("Cannot load the material icon for " + asset);
                return;
            }
            InputStream inputStream2 = inputStream;
            Closeable closeable = new InputStreamReader(inputStream2, Charsets.UTF_8);
            Throwable throwable = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable;
                boolean bl = false;
                String string2 = asset + ".xml";
                String string3 = CharStreams.toString((Readable)reader);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                DesignSurfaceHelper.createResourceFile(project, facet, "drawable", string2, string3);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exception) {
            DesignSurfaceHelper.getLogger().warn((Throwable)exception);
        }
    }

    public static final void copyLayoutToMainModuleSourceSet(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull String layout, @Language(value="XML") @NotNull String xml) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        String message = "Do you want to copy layout " + layout + " to your main module source set?";
        if (Messages.showYesNoDialog((Project)project, (String)message, (String)"Copy Layout", (Icon)Messages.getQuestionIcon()) == 1) {
            return;
        }
        DesignSurfaceHelper.createResourceFile(project, facet, "layout", layout + ".xml", xml);
    }

    private static final void createResourceFile(Project project, AndroidFacet facet, String resourceDirectory, String resourceFileName, CharSequence resourceFileContent) {
        WriteCommandAction.runWriteCommandAction((Project)project, () -> DesignSurfaceHelper.createResourceFile$lambda$4(project, facet, resourceDirectory, resourceFileName, resourceFileContent));
    }

    private static final VirtualFile getResourceDirectoryChild(Project project, AndroidFacet facet, String child) throws IOException {
        VirtualFile resourceDirectory = ResourceFolderManager.Companion.getInstance(facet).getPrimaryFolder();
        if (resourceDirectory == null) {
            DesignSurfaceHelper.getLogger().warn("resourceDirectory is null");
            return null;
        }
        VirtualFile virtualFile = resourceDirectory.findChild(child);
        if (virtualFile == null) {
            return resourceDirectory.createChildDirectory((Object)project, child);
        }
        return virtualFile;
    }

    public static final void handleLayoutlibNativeCrash(@NotNull WorkBench<DesignSurface<?>> $this$handleLayoutlibNativeCrash, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter($this$handleLayoutlibNativeCrash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        String message = "The preview has been disabled following a crash in the rendering engine. If the problem persists, please report the issue.";
        ActionData actionData = new ActionData("Re-enable rendering", null, null, arg_0 -> DesignSurfaceHelper.handleLayoutlibNativeCrash$lambda$5($this$handleLayoutlibNativeCrash, runnable, arg_0), 6, null);
        $this$handleLayoutlibNativeCrash.loadingStopped(message, actionData);
    }

    @NotNull
    public static final AWTEventListener createZoomControlAutoHiddenListener(@NotNull JComponent zoomControlPaneOwner, @NotNull JComponent zoomControlComponent) {
        Intrinsics.checkNotNullParameter((Object)zoomControlPaneOwner, (String)"zoomControlPaneOwner");
        Intrinsics.checkNotNullParameter((Object)zoomControlComponent, (String)"zoomControlComponent");
        return arg_0 -> DesignSurfaceHelper.createZoomControlAutoHiddenListener$lambda$6(zoomControlPaneOwner, zoomControlComponent, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    public static final void updateSceneViewVisibilities(@NotNull DesignSurface<?> $this$updateSceneViewVisibilities, @NotNull Function1<? super SceneView, Boolean> visibilityFunc) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$updateSceneViewVisibilities, (String)"<this>");
        Intrinsics.checkNotNullParameter(visibilityFunc, (String)"visibilityFunc");
        Iterable $this$flatMap$iv = $this$updateSceneViewVisibilities.getSceneManagers();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SceneManager it = (SceneManager)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSceneViews();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List sceneViews = (List)destination$iv$iv;
        Iterable $this$forEach$iv = sceneViews;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneView view = (SceneView)element$iv;
            boolean bl = false;
            view.setVisible((Boolean)visibilityFunc.invoke((Object)view));
        }
        $this$updateSceneViewVisibilities.revalidateScrollArea();
    }

    @UiThread
    @Nullable
    public static final DesignSurface<?> getDesignSurface(@NotNull FileEditor $this$getDesignSurface) {
        DesignSurface designSurface2;
        Intrinsics.checkNotNullParameter((Object)$this$getDesignSurface, (String)"<this>");
        FileEditor fileEditor = $this$getDesignSurface;
        if (fileEditor instanceof TextEditorWithPreview) {
            designSurface2 = DesignSurfaceHelper.getDesignSurface(((TextEditorWithPreview)$this$getDesignSurface).getPreviewEditor());
        } else if (fileEditor instanceof SourceCodePreview) {
            Object object = ((SourceCodePreview)$this$getDesignSurface).getCurrentRepresentation();
            if (object != null && (object = object.getComponent()) != null) {
                Object it = object;
                boolean bl = false;
                designSurface2 = (DesignSurface)DataManager.getInstance().getDataContext((Component)it).getData(DesignerDataKeys.DESIGN_SURFACE);
            } else {
                designSurface2 = null;
            }
        } else {
            designSurface2 = (DesignSurface)DataManager.getInstance().getDataContext((Component)$this$getDesignSurface.getComponent()).getData(DesignerDataKeys.DESIGN_SURFACE);
        }
        return designSurface2;
    }

    private static final Logger logger_delegate$lambda$0() {
        Logger logger = Logger.getInstance((String)"DesignSurfaceHelper");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final void createResourceFile$lambda$4(Project $project, AndroidFacet $facet, String $resourceDirectory, String $resourceFileName, CharSequence $resourceFileContent) {
        try {
            VirtualFile virtualFile = DesignSurfaceHelper.getResourceDirectoryChild($project, $facet, $resourceDirectory);
            if (virtualFile == null) {
                return;
            }
            VirtualFile directory = virtualFile;
            Document document = FileDocumentManager.getInstance().getDocument(directory.createChildData((Object)$project, $resourceFileName));
            Intrinsics.checkNotNull((Object)document);
            Document document2 = document;
            if (document2 instanceof DocumentImpl && SystemInfo.isWindows) {
                ((DocumentImpl)document2).setAcceptSlashR(true);
            }
            document2.setText($resourceFileContent);
        }
        catch (IOException exception) {
            DesignSurfaceHelper.getLogger().warn((Throwable)exception);
        }
    }

    private static final Unit handleLayoutlibNativeCrash$lambda$5(WorkBench $this_handleLayoutlibNativeCrash, Runnable $runnable, InputEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Bridge.setNativeCrash((boolean)false);
        $this_handleLayoutlibNativeCrash.showLoading("Loading...");
        $runnable.run();
        return Unit.INSTANCE;
    }

    private static final void createZoomControlAutoHiddenListener$lambda$6(JComponent $zoomControlPaneOwner, JComponent $zoomControlComponent, AWTEvent event) {
        int id = event.getID();
        if (id == 504) {
            if (!$zoomControlPaneOwner.isShowing()) {
                $zoomControlComponent.setVisible(false);
                return;
            }
            Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type java.awt.event.MouseEvent");
            MouseEvent mouseEvent = (MouseEvent)event;
            Point location = mouseEvent.getLocationOnScreen();
            Point screenLocation = $zoomControlPaneOwner.getLocationOnScreen();
            Rectangle rect = $zoomControlPaneOwner.getVisibleRect();
            rect.translate(screenLocation.x, screenLocation.y);
            $zoomControlComponent.setVisible(rect.contains(location));
        }
    }
}

