/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.decorator;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneFrameFactory;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawComponentBackground;
import com.android.tools.idea.common.scene.draw.DrawComponentFrame;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SceneDecorator {
    private SceneFrameFactory myFrameFactory = (list, component, sceneContext) -> {
        Rectangle rect = new Rectangle();
        component.fillRect(rect);
        SceneComponent.DrawState mode = component.getDrawState();
        DrawComponentFrame.add(list, sceneContext, rect, mode.ordinal());
    };

    public void setFrameFactory(@NotNull SceneFrameFactory sceneFrameFactory) {
        this.myFrameFactory = sceneFrameFactory;
    }

    public void buildList(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        if (!component.isSelected() && component.isHighlighted()) {
            this.buildListComponent(list, time, sceneContext, component);
            this.buildListChildren(list, time, sceneContext, component);
            return;
        }
        if (sceneContext.showOnlySelection()) {
            this.addFrame(list, sceneContext, component);
            this.buildListTargets(list, time, sceneContext, component);
            this.buildListChildren(list, time, sceneContext, component);
            return;
        }
        this.buildListComponent(list, time, sceneContext, component);
        this.buildListTargets(list, time, sceneContext, component);
        this.buildListChildren(list, time, sceneContext, component);
    }

    public void buildListComponent(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        this.addBackground(list, sceneContext, component);
        this.addContent(list, time, sceneContext, component);
        this.addFrame(list, sceneContext, component);
    }

    protected void addContent(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
    }

    protected void addBackground(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        boolean wantToConnect = DecoratorUtilities.getTryingToConnectState(component.getAuthoritativeNlComponent()) != null;
        SceneComponent.DrawState state = component.getDrawState();
        if (!component.getAuthoritativeNlComponent().isRoot() && (sceneContext.getColorSet().drawBackground() || wantToConnect && state == SceneComponent.DrawState.HOVER)) {
            Rectangle rect = new Rectangle();
            component.fillRect(rect);
            DrawComponentBackground.add(list, sceneContext, rect, state.ordinal());
        }
    }

    protected void addFrame(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        this.myFrameFactory.addFrame(list, component, sceneContext);
    }

    protected void buildListChildren(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        List<SceneComponent> children = component.getChildren();
        if (!children.isEmpty()) {
            Rectangle rect = new Rectangle();
            component.fillRect(rect);
            list.pushClip(sceneContext, rect);
            for (SceneComponent child : children) {
                child.buildDisplayList(time, list, sceneContext);
            }
            list.popClip();
        }
    }

    protected void buildListTargets(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        component.getTargets().forEach(target -> target.render(list, sceneContext));
    }
}

