/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.model.ChangeType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.DefaultHitProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneComponentHierarchyProvider;
import com.android.tools.idea.common.scene.SceneManagerKt;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.rendering.RenderUtils;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 T2\u00020\u0001:\u0002STBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010,\u001a\u00020-H&J\b\u0010\u0015\u001a\u00020\tH\u0004J\b\u0010:\u001a\u00020-H\u0016J\b\u0010;\u001a\u00020-H\u0016J\u001e\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020B0DH\u0004J\u000e\u0010E\u001a\u00020-H\u00a6@\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u00020-H&J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020J0I2\u0006\u0010K\u001a\u00020\tH&J\u0010\u0010P\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020=H\u0016J\b\u0010Q\u001a\u00020\tH\u0016J\b\u0010R\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R(\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R(\u0010)\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020#0/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0012\u00102\u001a\u000203X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0013\u00106\u001a\u0004\u0018\u0001078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0016\u0010<\u001a\u0004\u0018\u00010=8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0012\u0010L\u001a\u00020MX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010O\u00a8\u0006U"}, d2={"Lcom/android/tools/idea/common/scene/SceneManager;", "Lcom/intellij/openapi/Disposable;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "designSurface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "sceneComponentProvider", "Lcom/android/tools/idea/common/scene/SceneComponentHierarchyProvider;", "listenToResourceChanges", "", "notificationExecutorServiceProvider", "Lkotlin/Function1;", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lcom/android/tools/idea/common/model/NlModel;Lcom/android/tools/idea/common/surface/DesignSurface;Lcom/android/tools/idea/common/scene/SceneComponentHierarchyProvider;ZLkotlin/jvm/functions/Function1;)V", "getModel", "()Lcom/android/tools/idea/common/model/NlModel;", "getDesignSurface", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "getNotificationExecutorServiceProvider", "()Lkotlin/jvm/functions/Function1;", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "scene", "Lcom/android/tools/idea/common/scene/Scene;", "getScene", "()Lcom/android/tools/idea/common/scene/Scene;", "hitProvider", "Lcom/android/tools/idea/common/scene/HitProvider;", "isActive", "resourceChangeListener", "Lcom/android/tools/idea/common/scene/SceneManager$ResourceChangeListenerImpl;", "getResourceChangeListener", "()Lcom/android/tools/idea/common/scene/SceneManager$ResourceChangeListenerImpl;", "value", "Lcom/android/tools/idea/common/surface/SceneView;", "sceneView", "getSceneView", "()Lcom/android/tools/idea/common/surface/SceneView;", "setSceneView", "(Lcom/android/tools/idea/common/surface/SceneView;)V", "secondarySceneView", "getSecondarySceneView", "setSecondarySceneView", "updateSceneViews", "", "sceneViews", "", "getSceneViews", "()Ljava/util/List;", "sceneScalingFactor", "", "getSceneScalingFactor", "()F", "viewObject", "", "getViewObject", "()Ljava/lang/Object;", "dispose", "update", "root", "Lcom/android/tools/idea/common/model/NlComponent;", "getRoot", "()Lcom/android/tools/idea/common/model/NlComponent;", "updateFromComponent", "component", "Lcom/android/tools/idea/common/scene/SceneComponent;", "seenComponents", "", "requestRenderAndWait", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requestRender", "requestLayoutAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "animate", "sceneDecoratorFactory", "Lcom/android/tools/idea/common/scene/decorator/SceneDecoratorFactory;", "getSceneDecoratorFactory", "()Lcom/android/tools/idea/common/scene/decorator/SceneDecoratorFactory;", "getHitProvider", "activate", "deactivate", "ResourceChangeListenerImpl", "Companion", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSceneManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SceneManager.kt\ncom/android/tools/idea/common/scene/SceneManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n1#2:324\n1869#3,2:325\n1869#3,2:327\n1869#3,2:329\n*S KotlinDebug\n*F\n+ 1 SceneManager.kt\ncom/android/tools/idea/common/scene/SceneManager\n*L\n206#1:325,2\n220#1:327,2\n241#1:329,2\n*E\n"})
public abstract class SceneManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NlModel model;
    @NotNull
    private final DesignSurface<?> designSurface;
    @NotNull
    private final SceneComponentHierarchyProvider sceneComponentProvider;
    private final boolean listenToResourceChanges;
    @NotNull
    private final Function1<Disposable, ExecutorService> notificationExecutorServiceProvider;
    @NotNull
    private final AtomicBoolean isDisposed;
    @NotNull
    private final Scene scene;
    @NotNull
    private final HitProvider hitProvider;
    @NotNull
    private final AtomicBoolean isActive;
    @NotNull
    private final ResourceChangeListenerImpl resourceChangeListener;
    @Nullable
    private SceneView sceneView;
    @Nullable
    private SceneView secondarySceneView;
    public static final int $stable = 8;

    public SceneManager(@NotNull NlModel model, @NotNull DesignSurface<?> designSurface2, @NotNull SceneComponentHierarchyProvider sceneComponentProvider, boolean listenToResourceChanges, @NotNull Function1<? super Disposable, ? extends ExecutorService> notificationExecutorServiceProvider) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(designSurface2, (String)"designSurface");
        Intrinsics.checkNotNullParameter((Object)sceneComponentProvider, (String)"sceneComponentProvider");
        Intrinsics.checkNotNullParameter(notificationExecutorServiceProvider, (String)"notificationExecutorServiceProvider");
        this.model = model;
        this.designSurface = designSurface2;
        this.sceneComponentProvider = sceneComponentProvider;
        this.listenToResourceChanges = listenToResourceChanges;
        this.notificationExecutorServiceProvider = notificationExecutorServiceProvider;
        this.isDisposed = new AtomicBoolean(false);
        this.hitProvider = new DefaultHitProvider();
        this.isActive = new AtomicBoolean(false);
        this.resourceChangeListener = new ResourceChangeListenerImpl(this.model, (ExecutorService)this.notificationExecutorServiceProvider.invoke((Object)this));
        Disposer.register((Disposable)this.model, (Disposable)this);
        this.scene = new Scene(this, this.getDesignSurface());
    }

    public /* synthetic */ SceneManager(NlModel nlModel, DesignSurface designSurface2, SceneComponentHierarchyProvider sceneComponentHierarchyProvider, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function1 = (Function1)new Function1<Disposable, ExecutorService>((Object)Companion){

                public final ExecutorService invoke(Disposable p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Companion)this.receiver).defaultNotificationExecutorService$intellij_android_designer(p0);
                }
            };
        }
        this(nlModel, designSurface2, sceneComponentHierarchyProvider, bl, (Function1<? super Disposable, ? extends ExecutorService>)function1);
    }

    @NotNull
    public final NlModel getModel() {
        return this.model;
    }

    @NotNull
    protected DesignSurface<?> getDesignSurface() {
        return this.designSurface;
    }

    @NotNull
    protected final Function1<Disposable, ExecutorService> getNotificationExecutorServiceProvider() {
        return this.notificationExecutorServiceProvider;
    }

    @NotNull
    public final Scene getScene() {
        return this.scene;
    }

    @NotNull
    protected final ResourceChangeListenerImpl getResourceChangeListener() {
        return this.resourceChangeListener;
    }

    @Nullable
    protected final SceneView getSceneView() {
        return this.sceneView;
    }

    protected final void setSceneView(@Nullable SceneView value) {
        SceneView sceneView = this.sceneView;
        if (sceneView != null) {
            SceneView it = sceneView;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.sceneView = value;
    }

    @Nullable
    protected final SceneView getSecondarySceneView() {
        return this.secondarySceneView;
    }

    protected final void setSecondarySceneView(@Nullable SceneView value) {
        SceneView sceneView = this.secondarySceneView;
        if (sceneView != null) {
            SceneView it = sceneView;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.secondarySceneView = value;
    }

    public abstract void updateSceneViews();

    @NotNull
    public final List<SceneView> getSceneViews() {
        if (this.sceneView == null) {
            boolean bl = false;
            String string = "updateSceneViews was not called";
            throw new IllegalStateException(string.toString());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        SceneView sceneView = this.sceneView;
        Intrinsics.checkNotNull((Object)sceneView);
        ImmutableList.Builder builder2 = builder.add((Object)sceneView);
        SceneView sceneView2 = this.secondarySceneView;
        if (sceneView2 != null) {
            SceneView it = sceneView2;
            boolean bl = false;
            builder2.add((Object)it);
        }
        ImmutableList immutableList = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return (List)immutableList;
    }

    public abstract float getSceneScalingFactor();

    @Nullable
    public final Object getViewObject() {
        NlComponent nlComponent = this.getRoot();
        return nlComponent != null && (nlComponent = NlComponentHelperKt.getViewInfo(nlComponent)) != null ? nlComponent.getViewObject() : null;
    }

    protected final boolean isDisposed() {
        return this.isDisposed.get();
    }

    public void dispose() {
        this.isDisposed.set(true);
        this.deactivate();
    }

    public void update() {
        Iterator it;
        Object object;
        List components = (List)this.model.getTreeReader().getComponents();
        if (components.isEmpty()) {
            this.scene.removeAllComponents();
            this.scene.setRoot(null);
            return;
        }
        Set usedComponents = new HashSet();
        Set oldComponents = new HashSet<SceneComponent>(this.scene.getSceneComponents());
        NlComponent modelRootComponent = this.getRoot();
        if (modelRootComponent == null) {
            Logger.getInstance(SceneManager.class).warn("Unexpected null model root component");
            return;
        }
        if (this.scene.getRoot() != null) {
            SceneComponent sceneComponent = this.scene.getRoot();
            Intrinsics.checkNotNull((Object)sceneComponent);
            if (modelRootComponent != sceneComponent.getNlComponent()) {
                this.scene.removeAllComponents();
                this.scene.setRoot(null);
            }
        }
        List<SceneComponent> hierarchy = this.sceneComponentProvider.createHierarchy(this, modelRootComponent);
        if (hierarchy.isEmpty()) {
            object = null;
        } else if (hierarchy.size() == 1) {
            object = (SceneComponent)CollectionsKt.first(hierarchy);
        } else {
            Iterator iterator = ((Iterable)hierarchy).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            SceneComponent it422 = (SceneComponent)iterator.next();
            boolean bl = false;
            int it422 = it422.getDrawX();
            while (iterator.hasNext()) {
                SceneComponent it32 = (SceneComponent)iterator.next();
                $i$a$-minOf-SceneManager$update$rootSceneComponent$minX$1 = false;
                int it32 = it32.getDrawX();
                if (it422 <= it32) continue;
                it422 = it32;
            }
            int minX = it422;
            Iterator it422 = ((Iterable)hierarchy).iterator();
            if (!it422.hasNext()) {
                throw new NoSuchElementException();
            }
            SceneComponent it22 = (SceneComponent)it422.next();
            boolean bl2 = false;
            int it22 = it22.getDrawY();
            while (it422.hasNext()) {
                SceneComponent it52 = (SceneComponent)it422.next();
                $i$a$-minOf-SceneManager$update$rootSceneComponent$minY$1 = false;
                int it52 = it52.getDrawY();
                if (it22 <= it52) continue;
                it22 = it52;
            }
            int minY = it22;
            it = ((Iterable)hierarchy).iterator();
            if (!it.hasNext()) {
                throw new NoSuchElementException();
            }
            SceneComponent it822 = (SceneComponent)it.next();
            boolean bl3 = false;
            int it822 = it822.getDrawX() + it822.getDrawWidth();
            while (it.hasNext()) {
                SceneComponent it72 = (SceneComponent)it.next();
                $i$a$-maxOf-SceneManager$update$rootSceneComponent$maxX$1 = false;
                int it72 = it72.getDrawX() + it72.getDrawWidth();
                if (it822 >= it72) continue;
                it822 = it72;
            }
            int maxX = it822;
            Iterator it822 = ((Iterable)hierarchy).iterator();
            if (!it822.hasNext()) {
                throw new NoSuchElementException();
            }
            SceneComponent it62 = (SceneComponent)it822.next();
            boolean bl4 = false;
            int it62 = it62.getDrawY() + it62.getDrawHeight();
            while (it822.hasNext()) {
                SceneComponent it92 = (SceneComponent)it822.next();
                $i$a$-maxOf-SceneManager$update$rootSceneComponent$maxY$1 = false;
                int it92 = it92.getDrawY() + it92.getDrawHeight();
                if (it62 >= it92) continue;
                it62 = it92;
            }
            int maxY = it62;
            Iterator $this$update_u24lambda_u249 = it = new SceneComponent(this.scene, modelRootComponent, this.scene.getSceneManager().getHitProvider(modelRootComponent));
            boolean bl5 = false;
            Iterable $this$forEach$iv = hierarchy;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SceneComponent it3 = (SceneComponent)element$iv;
                boolean bl6 = false;
                ((SceneComponent)((Object)$this$update_u24lambda_u249)).addChild(it3);
            }
            ((SceneComponent)((Object)$this$update_u24lambda_u249)).setPosition(minX, minY);
            ((SceneComponent)((Object)$this$update_u24lambda_u249)).setSize(maxX - minX, maxY - minY);
            object = it;
        }
        SceneComponent rootSceneComponent = object;
        this.scene.setRoot(rootSceneComponent);
        if (rootSceneComponent != null) {
            this.updateFromComponent(rootSceneComponent, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(arg_0 -> SceneManager.update$lambda$11(SceneManager::update$lambda$10, arg_0));
        Iterable $this$forEach$iv = oldComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SceneComponent)element$iv;
            boolean bl = false;
            this.scene.removeComponent((SceneComponent)((Object)it));
        }
        this.scene.needsRebuildList();
    }

    @Nullable
    protected NlComponent getRoot() {
        NlComponent nlComponent = (NlComponent)CollectionsKt.firstOrNull((List)((List)this.model.getTreeReader().getComponents()));
        return nlComponent != null ? nlComponent.getRoot() : null;
    }

    protected final void updateFromComponent(@NotNull SceneComponent component, @NotNull Set<SceneComponent> seenComponents) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(seenComponents, (String)"seenComponents");
        seenComponents.add(component);
        this.sceneComponentProvider.syncFromNlComponent(component);
        List<SceneComponent> list = component.getChildren();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneComponent it = (SceneComponent)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.updateFromComponent(it, seenComponents);
        }
    }

    @Nullable
    public abstract Object requestRenderAndWait(@NotNull Continuation<? super Unit> var1);

    public abstract void requestRender();

    @NotNull
    public abstract CompletableFuture<Void> requestLayoutAsync(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    @NotNull
    public HitProvider getHitProvider(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return this.hitProvider;
    }

    public boolean activate() {
        boolean bl;
        boolean isActivating = bl = !this.isActive.getAndSet(true);
        boolean bl2 = false;
        if (isActivating && this.listenToResourceChanges) {
            ResourceNotificationManager.Companion.getInstance(this.model.getProject()).addListener((ResourceNotificationManager.ResourceChangeListener)this.resourceChangeListener, this.model.getFacet(), this.model.getVirtualFile(), this.model.getConfiguration());
        }
        this.model.activate();
        return bl;
    }

    public boolean deactivate() {
        boolean bl;
        boolean isDeactivating = bl = this.isActive.getAndSet(false);
        boolean bl2 = false;
        if (isDeactivating && this.listenToResourceChanges) {
            ResourceNotificationManager.Companion.getInstance(this.model.getProject()).removeListener((ResourceNotificationManager.ResourceChangeListener)this.resourceChangeListener, this.model.getFacet(), this.model.getVirtualFile(), this.model.getConfiguration());
            boolean bl3 = Intrinsics.areEqual((Object)this.model.getConfiguration(), (Object)this.resourceChangeListener.getConfiguration());
            if (_Assertions.ENABLED && !bl3) {
                boolean bl4 = false;
                String string = "Configuration can not change when using listenToResourceChanges = true in SceneManager";
                throw new AssertionError((Object)string);
            }
        }
        this.model.deactivate();
        return bl;
    }

    private static final boolean update$lambda$10(SceneComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof TemporarySceneComponent;
    }

    private static final boolean update$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/common/scene/SceneManager$Companion;", "", "<init>", "()V", "defaultNotificationExecutorService", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "defaultNotificationExecutorService$intellij_android_designer", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutorService defaultNotificationExecutorService$intellij_android_designer(@NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"SceneManager resource listener", (Executor)AppExecutorUtil.getAppExecutorService(), (int)10, (Disposable)parentDisposable);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
            return executorService;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/common/scene/SceneManager$ResourceChangeListenerImpl;", "Lcom/android/tools/idea/res/ResourceNotificationManager$ResourceChangeListener;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "notificationExecutorService", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lcom/android/tools/idea/common/model/NlModel;Ljava/util/concurrent/ExecutorService;)V", "getModel", "()Lcom/android/tools/idea/common/model/NlModel;", "getNotificationExecutorService", "()Ljava/util/concurrent/ExecutorService;", "configuration", "Lcom/android/tools/configurations/Configuration;", "getConfiguration", "()Lcom/android/tools/configurations/Configuration;", "resourcesChanged", "", "reason", "Lcom/google/common/collect/ImmutableSet;", "Lcom/android/tools/idea/res/ResourceNotificationManager$Reason;", "intellij.android.designer"})
    @SourceDebugExtension(value={"SMAP\nSceneManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SceneManager.kt\ncom/android/tools/idea/common/scene/SceneManager$ResourceChangeListenerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n1563#2:324\n1634#2,3:325\n1761#2,3:328\n*S KotlinDebug\n*F\n+ 1 SceneManager.kt\ncom/android/tools/idea/common/scene/SceneManager$ResourceChangeListenerImpl\n*L\n80#1:324\n80#1:325,3\n81#1:328,3\n*E\n"})
    protected static final class ResourceChangeListenerImpl
    implements ResourceNotificationManager.ResourceChangeListener {
        @NotNull
        private final NlModel model;
        @VisibleForTesting
        @NotNull
        private final ExecutorService notificationExecutorService;
        @NotNull
        private final Configuration configuration;

        public ResourceChangeListenerImpl(@NotNull NlModel model, @NotNull ExecutorService notificationExecutorService) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)notificationExecutorService, (String)"notificationExecutorService");
            this.model = model;
            this.notificationExecutorService = notificationExecutorService;
            this.configuration = this.model.getConfiguration();
        }

        @NotNull
        public final NlModel getModel() {
            return this.model;
        }

        @NotNull
        public final ExecutorService getNotificationExecutorService() {
            return this.notificationExecutorService;
        }

        @NotNull
        public final Configuration getConfiguration() {
            return this.configuration;
        }

        /*
         * WARNING - void declaration
         */
        public void resourcesChanged(@NotNull ImmutableSet<ResourceNotificationManager.Reason> reason) {
            boolean shouldClearRenderCache;
            block5: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(reason, (String)"reason");
                Iterable $this$map$iv = (Iterable)reason;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResourceNotificationManager.Reason reason2 = (ResourceNotificationManager.Reason)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Map map2 = SceneManagerKt.access$getNL_MODEL_CHANGE_TYPE$p();
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(map2.getOrDefault(it, ChangeType.BUILD));
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ChangeType changeType = (ChangeType)((Object)element$iv);
                        boolean bl = false;
                        if (!(changeType == ChangeType.BUILD || changeType == ChangeType.RESOURCE_CHANGED)) continue;
                        v1 = true;
                        break block5;
                    }
                    v1 = shouldClearRenderCache = false;
                }
            }
            if (shouldClearRenderCache) {
                RenderUtils.clearCache((Collection)((Collection)ImmutableList.of((Object)this.model.getConfiguration())));
            }
            this.notificationExecutorService.submit(() -> ResourceChangeListenerImpl.resourcesChanged$lambda$2(this, reason));
        }

        private static final void resourcesChanged$lambda$2(ResourceChangeListenerImpl this$0, ImmutableSet $reason) {
            if (this$0.model.isDisposed()) {
                return;
            }
            ResourceNotificationManager.Reason reason = (ResourceNotificationManager.Reason)CollectionsKt.lastOrNull((Iterable)((Iterable)$reason));
            if (reason == null) {
                return;
            }
            this$0.model.notifyModified(SceneManagerKt.access$getNL_MODEL_CHANGE_TYPE$p().getOrDefault(reason, ChangeType.BUILD));
        }
    }
}

