/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.lint;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.common.lint.AttributeKey;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.NlTreeReaderKt;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintExternalAnnotator;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public class ModelLintIssueAnnotator {
    private final WeakReference<DesignSurface<?>> mySurfaceRef;
    private final Executor myExecutor;
    private final AtomicReference<Disposable> annotationComputation = new AtomicReference();

    public ModelLintIssueAnnotator(@NotNull DesignSurface<?> surface2) {
        this(surface2, AppExecutorUtil.getAppExecutorService());
    }

    public ModelLintIssueAnnotator(@NotNull DesignSurface<?> surface2, @NotNull Executor executor) {
        this.mySurfaceRef = new WeakReference(surface2);
        this.myExecutor = executor;
    }

    public void annotateRenderInformationToLint(@NotNull NlModel model) {
        DesignSurface surface2 = (DesignSurface)this.mySurfaceRef.get();
        if (surface2 == null || model.isDisposed()) {
            return;
        }
        Disposable computationToken = Disposer.newDisposable();
        if (!Disposer.tryRegister((Disposable)model, (Disposable)computationToken)) {
            return;
        }
        Disposable oldComputation = this.annotationComputation.getAndSet(computationToken);
        if (oldComputation != null) {
            Disposer.dispose((Disposable)oldComputation);
        }
        ReadAction.nonBlocking(() -> {
            if (this.annotationComputation.get() != computationToken) {
                return null;
            }
            return ModelLintIssueAnnotator.getAnnotations(model);
        }).finishOnUiThread(ModalityState.defaultModalityState(), lintAnnotationsModel -> ModelLintIssueAnnotator.updateLintAnnotationsModelToSurface(surface2, model, lintAnnotationsModel)).expireWith(computationToken).submit(this.myExecutor).onProcessed(lintAnnotationsModel -> {
            if (this.annotationComputation.compareAndSet(computationToken, null)) {
                Disposer.dispose((Disposable)computationToken);
            }
        });
    }

    private static void updateLintAnnotationsModelToSurface(@NotNull DesignSurface<?> surface2, @NotNull NlModel model, @NotNull LintAnnotationsModel annotationsModel) {
        model.setLintAnnotationsModel(annotationsModel);
        surface2.setLintAnnotationsModel(annotationsModel);
        surface2.repaint();
    }

    @NotNull
    private static LintAnnotationsModel getAnnotations(@NotNull NlModel model) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LintAnnotationsModel lintModel = new LintAnnotationsModel();
        XmlFile xmlFile = model.getFile();
        LintExternalAnnotator annotator = new LintExternalAnnotator();
        LintEditorResult lintResult = annotator.collectInformation((PsiFile)xmlFile);
        if (lintResult != null) {
            lintResult = annotator.doAnnotate(lintResult);
        }
        if (lintResult == null) {
            return lintModel;
        }
        for (LintProblemData problemData : lintResult.getProblems()) {
            AndroidLintInspectionBase inspection;
            NlComponent component;
            TextRange range = problemData.getTextRange();
            PsiElement startElement = xmlFile.findElementAt(range.getStartOffset());
            PsiElement endElement = xmlFile.findElementAt(range.getEndOffset());
            if (startElement == null || endElement == null || (component = model.getTreeReader().findViewByPsi(startElement)) == null) continue;
            ResourceReference attribute = NlTreeReaderKt.findAttributeByPsi(startElement);
            AttributeKey attributeKey = attribute != null ? new AttributeKey(component, attribute.getNamespace().getXmlNamespaceUri(), attribute.getName()) : null;
            Issue issue = problemData.getIssue();
            Pair pair = LintExternalAnnotator.Companion.getHighlightLevelAndInspection(xmlFile.getProject(), issue, (PsiElement)xmlFile);
            if (pair == null || (inspection = (AndroidLintInspectionBase)pair.getFirst()) == null) continue;
            HighlightDisplayLevel level = (HighlightDisplayLevel)pair.getSecond();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)inspection.getShortName());
            if (key == null) continue;
            SmartPsiElementPointer startElementPointer = SmartPointerManager.getInstance((Project)model.getProject()).createSmartPsiElementPointer(startElement, (PsiFile)xmlFile);
            SmartPsiElementPointer endElementPointer = SmartPointerManager.getInstance((Project)model.getProject()).createSmartPsiElementPointer(endElement, (PsiFile)xmlFile);
            Incident incident = problemData.getIncident();
            lintModel.addIssue(component, attributeKey, incident, issue, problemData.getMessage(), inspection, level, (SmartPsiElementPointer<PsiElement>)startElementPointer, (SmartPsiElementPointer<PsiElement>)endElementPointer, problemData.getQuickfixData());
        }
        return lintModel;
    }
}

