/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.DesignerCommonIssueNodeKt;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.MyOpenFileDescriptor;
import com.android.tools.idea.common.error.NlComponentIssueSource;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import com.intellij.util.ui.EmptyIcon;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000f\u0010\u0013\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0012H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/common/error/IssueNode;", "Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "issue", "Lcom/android/tools/idea/common/error/Issue;", "parent", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/common/error/Issue;Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getIssue", "()Lcom/android/tools/idea/common/error/Issue;", "getParent", "()Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "", "getVirtualFile", "Lorg/jetbrains/annotations/NotNull;", "getChildren", "", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "updatePresentation", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "createNodeDisplayText", "hashCode", "", "equals", "", "other", "", "toString", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesignerCommonIssueNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignerCommonIssueNode.kt\ncom/android/tools/idea/common/error/IssueNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,613:1\n1#2:614\n1310#3,2:615\n*S KotlinDebug\n*F\n+ 1 DesignerCommonIssueNode.kt\ncom/android/tools/idea/common/error/IssueNode\n*L\n387#1:615,2\n*E\n"})
public class IssueNode
extends DesignerCommonIssueNode {
    @Nullable
    private final VirtualFile file;
    @NotNull
    private final Issue issue;
    @Nullable
    private final DesignerCommonIssueNode parent;
    public static final int $stable = 8;

    public IssueNode(@Nullable VirtualFile file2, @NotNull Issue issue, @Nullable DesignerCommonIssueNode parent) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        DesignerCommonIssueNode designerCommonIssueNode = parent;
        super((Project)(designerCommonIssueNode != null ? designerCommonIssueNode.getProject() : null), (NodeDescriptor<DesignerCommonIssueNode>)((NodeDescriptor)parent));
        this.file = file2;
        this.issue = issue;
        this.parent = parent;
    }

    @Nullable
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final Issue getIssue() {
        return this.issue;
    }

    @Nullable
    public final DesignerCommonIssueNode getParent() {
        return this.parent;
    }

    @NotNull
    public LeafState getLeafState() {
        return LeafState.ALWAYS;
    }

    @Override
    @NotNull
    public String getName() {
        return this.createNodeDisplayText();
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = this.file;
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)this.file);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public List<DesignerCommonIssueNode> getChildren() {
        return CollectionsKt.emptyList();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Navigatable getNavigatable() {
        block7: {
            block6: {
                var3_1 = this.issue.getSource();
                v0 = var3_1 instanceof NlComponentIssueSource != false ? (NlComponentIssueSource)var3_1 : null;
                v1 = v0 != null && (v0 = v0.getComponent()) != null ? v0.getNavigatable() : (navigatable = null);
                if (navigatable != null) break block7;
                targetFile = this.getVirtualFile();
                if (this.getProject() == null || targetFile == null) break block7;
                var4_5 = this.issue.getThrowable();
                if (var4_5 == null || (var5_6 = var4_5.getStackTrace()) == null) ** GOTO lbl-1000
                var7_7 = var5_6;
                $i$f$firstOrNull = false;
                var10_10 = ((void)$this$firstOrNull$iv).length;
                for (var9_9 = 0; var9_9 < var10_10; ++var9_9) {
                    it = element$iv = $this$firstOrNull$iv[var9_9];
                    $i$a$-firstOrNull-IssueNode$getNavigatable$line$1 = false;
                    v2 = it.getFileName();
                    if (v2 != null) {
                        v3 = targetFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
                        v4 = StringsKt.endsWith$default((String)v2, (String)v3, (boolean)false, (int)2, null);
                    } else {
                        v4 = false;
                    }
                    if (!v4) continue;
                    v5 = element$iv;
                    break block6;
                }
                v5 = var6_15 = null;
            }
            if (var6_15 != null) {
                it = var6_15.getLineNumber();
                $i$a$-let-IssueNode$getNavigatable$line$2 = false;
                v6 = it - 1;
            } else lbl-1000:
            // 2 sources

            {
                v6 = -1;
            }
            line = v6;
            navigatable = (Navigatable)new OpenFileDescriptor(this.getProject(), targetFile, line, -1);
        }
        if (navigatable instanceof OpenFileDescriptor) {
            return (Navigatable)new MyOpenFileDescriptor((OpenFileDescriptor)navigatable);
        }
        return navigatable;
    }

    @Override
    protected void updatePresentation(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        String nodeDisplayText = this.createNodeDisplayText();
        Object object = HighlightDisplayLevel.Companion.find(this.issue.getSeverity());
        if (object == null || (object = object.getIcon()) == null) {
            Icon icon2;
            IssueNode it = this;
            boolean bl = false;
            int issueSeverityLevel = this.issue.getSeverity().myVal;
            Icon icon3 = null;
            for (HighlightSeverity severity : DesignerCommonIssueNodeKt.getDESCEND_ORDER_DEFAULT_SEVERITIES()) {
                if (issueSeverityLevel < severity.myVal) continue;
                HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.Companion.find(severity);
                icon3 = highlightDisplayLevel != null ? highlightDisplayLevel.getIcon() : null;
                break;
            }
            if ((icon2 = icon3) == null) {
                icon2 = EmptyIcon.ICON_16;
            }
            object = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"let(...)");
        }
        Object icon4 = object;
        presentation.setIcon((Icon)icon4);
        presentation.addText(nodeDisplayText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private final String createNodeDisplayText() {
        IssueSource source = this.issue.getSource();
        return source instanceof NlComponentIssueSource ? ((NlComponentIssueSource)source).getDisplayText() + ": " + this.issue.getSummary() : this.issue.getSummary();
    }

    public int hashCode() {
        Object[] objectArray = new Object[3];
        NodeDescriptor nodeDescriptor = this.getParentDescriptor();
        objectArray[0] = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
        objectArray[1] = this.file;
        objectArray[2] = this.issue;
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        IssueNode issueNode = other instanceof IssueNode ? (IssueNode)((Object)other) : null;
        if (issueNode == null) {
            return false;
        }
        IssueNode that = issueNode;
        NodeDescriptor nodeDescriptor = that.getParentDescriptor();
        NodeDescriptor nodeDescriptor2 = this.getParentDescriptor();
        return Intrinsics.areEqual((Object)(nodeDescriptor != null ? nodeDescriptor.getElement() : null), (Object)(nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null)) && Intrinsics.areEqual((Object)that.issue, (Object)this.issue);
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Object object = this.file;
        if (object != null && (object = object.getCanonicalPath()) != null) {
            Object it = object;
            boolean bl = false;
            builder.append((String)it).append(", ");
        }
        builder.append(this.issue.toString());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

