/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.idea.common.editor.ActionsToolbar;
import com.android.tools.idea.common.editor.DesignSurfaceFloatingActionsToolbarProvider;
import com.android.tools.idea.common.model.DisplaySettings;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SceneViewErrorsPanel;
import com.android.tools.idea.common.surface.sceneview.LabelPanel;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManagerUtilsKt;
import com.android.tools.rendering.ProblemSeverity;
import com.android.tools.rendering.RenderResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionManager<S extends DesignSurface<?>> {
    protected final S mySurface;
    @Nullable
    private JComponent surfaceToolbar;

    protected ActionManager(@NotNull S surface2) {
        this.mySurface = surface2;
    }

    protected static void registerAction(@NotNull AnAction action2, @NonNls String actionId, @NotNull JComponent component) {
        Arrays.stream(com.intellij.openapi.actionSystem.ActionManager.getInstance().getAction(actionId).getShortcutSet().getShortcuts()).filter(shortcut -> shortcut instanceof KeyboardShortcut && ((KeyboardShortcut)shortcut).getSecondKeyStroke() == null).forEach(shortcut -> ActionManager.registerAction(action2, ((KeyboardShortcut)shortcut).getFirstKeyStroke(), component));
    }

    protected static void registerAction(@NotNull AnAction action2, @NotNull KeyStroke keyStroke, @NotNull JComponent component) {
        KeyBindingKt.registerAnActionKey((JComponent)component, () -> action2, (KeyStroke)keyStroke, (String)action2.getClass().getSimpleName(), (int)1);
    }

    @NotNull
    public JComponent createToolbar() {
        return new ActionsToolbar((Disposable)this.mySurface, (DesignSurface<?>)this.mySurface).getToolbarComponent();
    }

    @NotNull
    public JComponent getDesignSurfaceToolbar() {
        if (this.surfaceToolbar == null) {
            this.surfaceToolbar = new DesignSurfaceFloatingActionsToolbarProvider((DesignSurface<?>)this.mySurface, (JComponent)this.mySurface, (Disposable)this.mySurface).getFloatingToolbar();
        }
        return this.surfaceToolbar;
    }

    @Nullable
    protected static AnAction getRegisteredActionByName(@NotNull String actionName) {
        return com.intellij.openapi.actionSystem.ActionManager.getInstance().getAction(actionName);
    }

    public abstract void registerActionsShortcuts(@NotNull JComponent var1);

    @NotNull
    public abstract DefaultActionGroup getPopupMenuActions(@Nullable NlComponent var1, @NotNull MouseEvent var2);

    @NotNull
    public abstract DefaultActionGroup getToolbarActions(@NotNull List<NlComponent> var1);

    public List<AnAction> getSceneViewContextToolbarActions() {
        return Collections.emptyList();
    }

    @NotNull
    public List<AnAction> getSceneViewContextToolbarOverflowActions() {
        return Collections.emptyList();
    }

    @Nullable
    public AnAction getSceneViewStatusIconAction() {
        return null;
    }

    @NotNull
    public LabelPanel createSceneViewLabel(@NotNull SceneView sceneView, CoroutineScope scope2, StateFlow<Boolean> isPartOfOrganizationGroup) {
        DisplaySettings displaySettings = sceneView.getSceneManager().getModel().getDisplaySettings();
        return new LabelPanel(displaySettings, scope2, isPartOfOrganizationGroup);
    }

    @NotNull
    private static List<Throwable> getErrorThrowables(@NotNull SceneView sceneView) {
        RenderResult result = LayoutlibSceneManagerUtilsKt.getRenderResultIfError(sceneView);
        if (result == null) {
            return Collections.emptyList();
        }
        return result.getLogger().getMessages().stream().filter(it -> it.getSeverity() == ProblemSeverity.ERROR && it.getThrowable() != null).map(it -> it.getThrowable()).collect(Collectors.toList());
    }

    @NotNull
    public JComponent createErrorPanel(@NotNull SceneView sceneView) {
        return new SceneViewErrorsPanel((Function0<? extends List<? extends Throwable>>)((Function0)() -> ActionManager.getErrorThrowables(sceneView)), (Function0<? extends SceneViewErrorsPanel.Style>)((Function0)() -> {
            if (LayoutlibSceneManagerUtilsKt.hasValidImage(sceneView)) {
                return SceneViewErrorsPanel.Style.HIDDEN;
            }
            if (LayoutlibSceneManagerUtilsKt.getRenderResultIfError(sceneView) != null) {
                return SceneViewErrorsPanel.Style.SOLID;
            }
            return SceneViewErrorsPanel.Style.HIDDEN;
        }));
    }

    @Nullable
    public JComponent getSceneViewLeftBar(@NotNull SceneView sceneView) {
        return null;
    }

    @Nullable
    public JComponent getSceneViewRightBar(@NotNull SceneView sceneView) {
        return null;
    }
}

