/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.actions.DeviceChangeListener;
import com.android.tools.idea.actions.DeviceMenuAction;
import com.android.tools.idea.actions.SetDeviceAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0014\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/actions/SetWearDeviceAction;", "Lcom/android/tools/idea/actions/SetDeviceAction;", "title", "", "updatePresentationCallback", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "deviceChangeListener", "Lcom/android/tools/idea/actions/DeviceChangeListener;", "device", "Lcom/android/sdklib/devices/Device;", "defaultIcon", "Ljavax/swing/Icon;", "selected", "", "<init>", "(Ljava/lang/String;Ljava/util/function/Consumer;Lcom/android/tools/idea/actions/DeviceChangeListener;Lcom/android/sdklib/devices/Device;Ljavax/swing/Icon;Z)V", "updateConfiguration", "", "configuration", "Lcom/android/tools/configurations/Configuration;", "commit", "intellij.android.designer"})
final class SetWearDeviceAction
extends SetDeviceAction {
    public SetWearDeviceAction(@NotNull String title, @NotNull Consumer<AnActionEvent> updatePresentationCallback, @NotNull DeviceChangeListener deviceChangeListener, @NotNull Device device, @Nullable Icon defaultIcon, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(updatePresentationCallback, (String)"updatePresentationCallback");
        Intrinsics.checkNotNullParameter((Object)deviceChangeListener, (String)"deviceChangeListener");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        super(title, updatePresentationCallback, deviceChangeListener, device, defaultIcon, selected);
    }

    @Override
    protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Device prevDevice = configuration.getCachedDevice();
        String newState = null;
        if (this.getDevice().getChinSize() != 0) {
            State state = this.getDevice().getState(ScreenOrientation.LANDSCAPE.getShortDisplayValue());
            if (state != null) {
                newState = state.getName();
                configuration.setDeviceState(state);
            } else {
                Logger.getLogger(DeviceMenuAction.class.getName()).warning("A wear chin device must have landscape state");
            }
        } else {
            State state = this.getDevice().getState(ScreenOrientation.PORTRAIT.getShortDisplayValue());
            if (state != null) {
                newState = state.getName();
                configuration.setDeviceState(state);
            } else {
                Logger.getLogger(DeviceMenuAction.class.getName()).warning("A wear round or square device must have portrait state");
            }
        }
        if (newState != null) {
            configuration.setDeviceStateName(newState);
        }
        if (commit) {
            configuration.getSettings().selectDevice(this.getDevice());
        }
        configuration.setDevice(this.getDevice(), true);
        this.getDeviceChangeListener().onDeviceChanged(prevDevice, this.getDevice());
    }
}

