/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.annotationprocessor.BindableBag;
import android.databinding.annotationprocessor.ProcessBindable;
import android.databinding.annotationprocessor.ProcessExpressions;
import android.databinding.annotationprocessor.ProcessMethodAdapters;
import android.databinding.tool.CompilerArguments;
import android.databinding.tool.CompilerChef;
import android.databinding.tool.Context;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.store.GenClassInfoLog;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.AnnotationJavaFileWriter;
import android.databinding.tool.writer.JavaFileWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.xml.bind.JAXBException;

@SupportedAnnotationTypes(value={"androidx.databinding.Bindable", "androidx.databinding.BindingAdapter", "androidx.databinding.BindingBuildInfo", "androidx.databinding.BindingConversion", "androidx.databinding.BindingMethod", "androidx.databinding.BindingMethods", "androidx.databinding.InverseBindingAdapter", "androidx.databinding.InverseBindingMethod", "androidx.databinding.InverseBindingMethods", "androidx.databinding.InverseMethod", "androidx.databinding.Untaggable", "android.databinding.Bindable", "android.databinding.BindingAdapter", "android.databinding.BindingBuildInfo", "android.databinding.BindingConversion", "android.databinding.BindingMethod", "android.databinding.BindingMethods", "android.databinding.InverseBindingAdapter", "android.databinding.InverseBindingMethod", "android.databinding.InverseBindingMethods", "android.databinding.InverseMethod", "android.databinding.Untaggable"})
public class ProcessDataBinding
extends AbstractProcessor {
    private static final String AGGREGATING_ANNOTATION_PROCESSORS_INDICATOR = "org.gradle.annotation.processing.aggregating";
    private List<ProcessingStep> mProcessingSteps;
    private CompilerArguments mCompilerArgs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            boolean bl = this.doProcess(roundEnv);
            return bl;
        }
        finally {
            if (roundEnv.processingOver()) {
                Context.fullClear(this.processingEnv);
            }
        }
    }

    private boolean doProcess(RoundEnvironment roundEnv) {
        if (this.mProcessingSteps == null) {
            this.readArguments();
            this.initProcessingSteps(this.processingEnv);
        }
        if (this.mCompilerArgs == null) {
            return false;
        }
        if (this.mCompilerArgs.isTestVariant() && !this.mCompilerArgs.isEnabledForTests() && !this.mCompilerArgs.isLibrary()) {
            L.d("data binding processor is invoked but not enabled, skipping...", new Object[0]);
            return false;
        }
        boolean done = true;
        Context.init(this.processingEnv, this.mCompilerArgs);
        for (ProcessingStep step : this.mProcessingSteps) {
            try {
                done = step.runStep(roundEnv, this.processingEnv, this.mCompilerArgs) && done;
            }
            catch (JAXBException e) {
                L.e(e, "Exception while handling step %s", step);
            }
        }
        if (roundEnv.processingOver()) {
            for (ProcessingStep step : this.mProcessingSteps) {
                step.onProcessingOver(roundEnv, this.processingEnv, this.mCompilerArgs);
            }
        }
        if (roundEnv.processingOver()) {
            Scope.assertNoError();
        }
        return done;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void initProcessingSteps(final ProcessingEnvironment processingEnv) {
        final ProcessBindable processBindable = new ProcessBindable();
        this.mProcessingSteps = Arrays.asList(new ProcessMethodAdapters(), new ProcessExpressions(), processBindable);
        Callback dataBinderWriterCallback = new Callback(){
            CompilerChef mChef;
            List<String> mModulePackages;
            BindableBag.BRMapping mBRVariableLookup;
            boolean mWrittenMapper = false;

            @Override
            public void onChefReady(CompilerChef chef, GenClassInfoLog classInfoLog) {
                Preconditions.checkNull(this.mChef, "Cannot set compiler chef twice", new Object[0]);
                chef.addBRVariables(processBindable);
                this.mChef = chef;
                this.considerWritingMapper();
            }

            private void considerWritingMapper() {
                boolean justLibrary;
                if (this.mWrittenMapper || this.mChef == null || this.mBRVariableLookup == null) {
                    return;
                }
                boolean bl = justLibrary = ProcessDataBinding.this.mCompilerArgs.isLibrary() && !ProcessDataBinding.this.mCompilerArgs.isTestVariant();
                if (justLibrary && !ProcessDataBinding.this.mCompilerArgs.isEnableV2()) {
                    return;
                }
                this.mWrittenMapper = true;
                this.mChef.writeDataBinderMapper(processingEnv, ProcessDataBinding.this.mCompilerArgs, this.mBRVariableLookup, this.mModulePackages);
            }

            @Override
            public void onBrWriterReady(BindableBag.BRMapping brWithValues, List<String> brPackages) {
                Preconditions.checkNull(this.mBRVariableLookup, "Cannot set br writer twice", new Object[0]);
                this.mBRVariableLookup = brWithValues;
                this.mModulePackages = brPackages;
                this.considerWritingMapper();
            }
        };
        AnnotationJavaFileWriter javaFileWriter = new AnnotationJavaFileWriter(processingEnv);
        for (ProcessingStep step : this.mProcessingSteps) {
            step.mJavaFileWriter = javaFileWriter;
            step.mCallback = dataBinderWriterCallback;
        }
    }

    private synchronized void readArguments() {
        if (this.mCompilerArgs != null) {
            return;
        }
        try {
            this.mCompilerArgs = CompilerArguments.readFromOptions(this.processingEnv.getOptions());
            L.setDebugLog(this.mCompilerArgs.getEnableDebugLogs());
            L.d("processor args: %s", this.mCompilerArgs);
            ScopedException.encodeOutput(this.mCompilerArgs.getPrintEncodedErrorLogs());
        }
        catch (Throwable t) {
            String allParam = this.processingEnv.getOptions().entrySet().stream().map(entry -> (String)entry.getKey() + " : " + (String)entry.getValue()).collect(Collectors.joining("\n"));
            throw new RuntimeException("Failed to parse data binding compiler options. Params:\n" + allParam, t);
        }
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> supportedOptions = new HashSet<String>(CompilerArguments.ALL_PARAMS);
        if (this.processingEnv.getOptions().containsKey("android.databinding.incremental")) {
            this.readArguments();
            if (this.mCompilerArgs.getIncremental()) {
                supportedOptions.add(AGGREGATING_ANNOTATION_PROCESSORS_INDICATOR);
            }
        }
        return supportedOptions;
    }

    public static abstract class ProcessingStep {
        private boolean mDone;
        private JavaFileWriter mJavaFileWriter;
        Callback mCallback;

        protected JavaFileWriter getWriter() {
            return this.mJavaFileWriter;
        }

        private boolean runStep(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, CompilerArguments args) throws JAXBException {
            if (this.mDone) {
                return true;
            }
            this.mDone = this.onHandleStep(roundEnvironment, processingEnvironment, args);
            return this.mDone;
        }

        public abstract boolean onHandleStep(RoundEnvironment var1, ProcessingEnvironment var2, CompilerArguments var3) throws JAXBException;

        public abstract void onProcessingOver(RoundEnvironment var1, ProcessingEnvironment var2, CompilerArguments var3);
    }

    static interface Callback {
        public void onChefReady(CompilerChef var1, GenClassInfoLog var2);

        public void onBrWriterReady(BindableBag.BRMapping var1, List<String> var2);
    }
}

