/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\f\u0010\u0004\u001a\u00020\u0002*\u00020\u0002H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"CHARACTERS_PLAIN", "", "", "CHARACTERS_HTML", "toHtml", "firebase"})
public final class HtmlUtilsKt {
    @NotNull
    private static final List<String> CHARACTERS_PLAIN;
    @NotNull
    private static final List<String> CHARACTERS_HTML;

    @NotNull
    public static final String toHtml(@NotNull String $this$toHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        String string = StringUtil.replace((String)$this$toHtml, CHARACTERS_PLAIN, CHARACTERS_HTML);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
        String resolvedText = string;
        StringBuffer sb = new StringBuffer("<html><body>");
        Matcher matcher = URLUtil.URL_PATTERN.matcher(resolvedText);
        while (matcher.find()) {
            if (matcher.groupCount() <= 0) continue;
            String url = matcher.group(0);
            matcher.appendReplacement(sb, "<a href='" + url + "'>" + url + "</a>");
        }
        matcher.appendTail(sb);
        sb.append("</body></html>");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    static {
        Object[] objectArray = new String[]{"<", ">", "&", "'", "\"", "\r\n", "\n"};
        CHARACTERS_PLAIN = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;", "<p>", "<p>"};
        CHARACTERS_HTML = CollectionsKt.listOf((Object[])objectArray);
    }
}

