/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights;

import com.android.tools.idea.insights.persistence.TosPersistence;
import com.google.common.io.ByteStreams;
import com.google.services.firebase.consolereceiver.CancellableReceiver;
import com.google.services.firebase.consolereceiver.ReceiverResult;
import com.google.services.firebase.consolereceiver.callback.CancellableReceiverHandlerFactory;
import com.google.services.firebase.consolereceiver.callback.ReceiverCallback;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.handler.AbstractHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/services/firebase/insights/FirebaseTosRedirector;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "firebaseProjectId", "", "user", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "callbackHandlerFactory", "Lcom/google/services/firebase/consolereceiver/callback/CancellableReceiverHandlerFactory;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "firebase"})
@SourceDebugExtension(value={"SMAP\nFirebaseTosRedirector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseTosRedirector.kt\ncom/google/services/firebase/insights/FirebaseTosRedirector\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n40#2,3:91\n24#3:94\n24#3:95\n*S KotlinDebug\n*F\n+ 1 FirebaseTosRedirector.kt\ncom/google/services/firebase/insights/FirebaseTosRedirector\n*L\n78#1:91,3\n82#1:94\n86#1:95\n*E\n"})
public final class FirebaseTosRedirector
extends Task.Modal {
    @NotNull
    private final String firebaseProjectId;
    @NotNull
    private final String user;
    @NotNull
    private final CancellableReceiverHandlerFactory callbackHandlerFactory;

    public FirebaseTosRedirector(@NotNull Project project, @NotNull String firebaseProjectId, @NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)firebaseProjectId, (String)"firebaseProjectId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        super(project, "Launching ToS Acceptance Flow", true);
        this.firebaseProjectId = firebaseProjectId;
        this.user = user;
        this.callbackHandlerFactory = FirebaseTosRedirector::callbackHandlerFactory$lambda$0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        try {
            AutoCloseable autoCloseable = new CancellableReceiver(this.callbackHandlerFactory);
            Throwable throwable = null;
            try {
                Object object;
                CancellableReceiver server = (CancellableReceiver)autoCloseable;
                boolean bl = false;
                server.start();
                String string = "https://console.firebase.google.com/project/%s/overview?authuser=%s&dlAction=AndroidStudioGeminiTos&localhostPath=%s";
                Object[] objectArray = new Object[]{this.firebaseProjectId, this.user, String.valueOf(server.getPort())};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                BrowserUtil.browse((String)string2);
                ReceiverResult result = server.waitForRequest(() -> FirebaseTosRedirector.run$lambda$5$lambda$1(indicator));
                if (result.status == ReceiverResult.Status.SUCCESS) {
                    boolean $i$f$service22 = false;
                    Class<TosPersistence> serviceClass$iv = TosPersistence.class;
                    Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object2 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    Object $i$f$service22 = object2;
                    TosPersistence $this$run_u24lambda_u245_u24lambda_u244 = (TosPersistence)$i$f$service22;
                    boolean bl2 = false;
                    $this$run_u24lambda_u245_u24lambda_u244.getState().getUserProjectMap().computeIfAbsent(this.user, arg_0 -> FirebaseTosRedirector.run$lambda$5$lambda$4$lambda$3(FirebaseTosRedirector::run$lambda$5$lambda$4$lambda$2, arg_0)).add(this.firebaseProjectId);
                    object = $i$f$service22;
                } else {
                    FirebaseTosRedirector $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(FirebaseTosRedirector.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("Firebase in Gemini Terms of Service not accepted");
                    object = Unit.INSTANCE;
                }
                server = object;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            FirebaseTosRedirector $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FirebaseTosRedirector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Exception while accepting Firebase in Gemini Terms of Service", (Throwable)e);
        }
    }

    private static final Handler callbackHandlerFactory$lambda$0(ReceiverCallback callback) {
        return (Handler)new AbstractHandler(callback){
            final /* synthetic */ ReceiverCallback $callback;
            {
                this.$callback = $callback;
            }

            public void handle(String url, HttpServletRequest request, HttpServletResponse response2, int port) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                response2.setStatus(200);
                this.respondWithSuccess(response2);
                response2.flushBuffer();
                this.$callback.onSuccess("ToS accepted");
            }

            private final void respondWithSuccess(HttpServletResponse response2) {
                response2.setContentType("text/html");
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/console_tos_accept_success.html");
                if (inputStream == null) {
                    throw new IOException("Could not find success page");
                }
                InputStream inputStream2 = inputStream;
                ServletOutputStream $this$respondWithSuccess_u24lambda_u240 = response2.getOutputStream();
                boolean bl = false;
                ByteStreams.copy((InputStream)inputStream2, (OutputStream)((OutputStream)$this$respondWithSuccess_u24lambda_u240));
                $this$respondWithSuccess_u24lambda_u240.flush();
            }
        };
    }

    private static final boolean run$lambda$5$lambda$1(ProgressIndicator $indicator) {
        return $indicator.isCanceled();
    }

    private static final Set run$lambda$5$lambda$4$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set run$lambda$5$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }
}

