/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.insights.AppInsightsConfigurationManager;
import com.android.tools.idea.insights.analytics.AppInsightsTracker;
import com.android.tools.idea.insights.client.AiInsightClient;
import com.android.tools.idea.insights.client.AppInsightsCache;
import com.android.tools.idea.insights.client.AppInsightsCacheImpl;
import com.android.tools.idea.insights.client.GeminiAiInsightClient;
import com.android.tools.idea.insights.client.GrpcUtilsKt;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.LoginFeature;
import com.google.services.firebase.FirebaseLoginFeature;
import com.google.services.firebase.insights.CrashlyticsConfigurationManager;
import com.google.services.firebase.insights.client.CrashlyticsClientImpl;
import com.google.services.firebase.insights.config.FirebaseAppManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.IncorrectOperationException;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/google/services/firebase/insights/CrashlyticsConfigurationService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/android/tools/idea/insights/client/AppInsightsCacheImpl;", "manager", "Lcom/android/tools/idea/insights/AppInsightsConfigurationManager;", "getManager", "()Lcom/android/tools/idea/insights/AppInsightsConfigurationManager;", "dispose", "", "firebase"})
@SourceDebugExtension(value={"SMAP\nCrashlyticsConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashlyticsConfigurationManager.kt\ncom/google/services/firebase/insights/CrashlyticsConfigurationService\n+ 2 LoginFeature.kt\ncom/google/gct/login2/LoginFeature$Companion\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,238:1\n48#2,4:239\n30#3,2:243\n30#3,2:245\n*S KotlinDebug\n*F\n+ 1 CrashlyticsConfigurationManager.kt\ncom/google/services/firebase/insights/CrashlyticsConfigurationService\n*L\n103#1:239,4\n116#1:243,2\n108#1:245,2\n*E\n"})
public final class CrashlyticsConfigurationService
implements Disposable {
    @NotNull
    private final AppInsightsCacheImpl cache;
    @NotNull
    private final AppInsightsConfigurationManager manager;

    public CrashlyticsConfigurationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.cache = new AppInsightsCacheImpl(AppInsightsTracker.ProductType.CRASHLYTICS, 0, 2, null);
        Function0 channelProvider = () -> CrashlyticsConfigurationService._init_$lambda$3(this);
        LoginFeature.Companion this_$iv = LoginFeature.Companion;
        boolean $i$f$feature = false;
        LoginFeature loginFeature = (LoginFeature)this_$iv.getEP_NAME().findExtension(FirebaseLoginFeature.class);
        if (loginFeature == null) {
            throw new RuntimeException("Couldn't find " + Reflection.getOrCreateKotlinClass(FirebaseLoginFeature.class) + ". Is your extension registered properly?");
        }
        CrashlyticsClientImpl client = new CrashlyticsClientImpl(channelProvider, (AppInsightsCache)this.cache, GoogleLoginService.Companion.getInstance().getActiveUserAuthInterceptor(loginFeature), null, null, (AiInsightClient)new GeminiAiInsightClient(project, (AppInsightsCache)this.cache, null, 4, null), arg_0 -> CrashlyticsConfigurationService._init_$lambda$4(project, arg_0), 24, null);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<FirebaseAppManager> serviceClass$iv = FirebaseAppManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.manager = new CrashlyticsConfigurationManager(project, (FirebaseAppManager)object, (AppInsightsCache)this.cache, client, null, 1.INSTANCE, 16, null);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.manager));
    }

    @NotNull
    public final AppInsightsConfigurationManager getManager() {
        return this.manager;
    }

    public void dispose() {
    }

    private static final void lambda$3$lambda$2$lambda$1(ManagedChannel $it) {
        $it.shutdown();
        $it.awaitTermination(1L, TimeUnit.SECONDS);
    }

    private static final ManagedChannel _init_$lambda$3(CrashlyticsConfigurationService this$0) {
        NettyChannelBuilder nettyChannelBuilder;
        String address = (String)StudioFlags.CRASHLYTICS_GRPC_SERVER.get();
        Logger.getInstance(CrashlyticsConfigurationService.class).info("App Quality Insights gRpc server connected at " + address);
        Intrinsics.checkNotNull((Object)address);
        NettyChannelBuilder $this$lambda_u243_u24lambda_u240 = nettyChannelBuilder = GrpcUtilsKt.channelBuilderForAddress((String)address);
        boolean bl = false;
        NettyChannelBuilder nettyChannelBuilder2 = (Boolean)StudioFlags.CRASHLYTICS_INTEGRATION_TEST_MODE.get() != false ? $this$lambda_u243_u24lambda_u240.usePlaintext() : $this$lambda_u243_u24lambda_u240.useTransportSecurity();
        $this$lambda_u243_u24lambda_u240.maxInboundMessageSize(Integer.MAX_VALUE);
        NettyChannelBuilder it = nettyChannelBuilder = nettyChannelBuilder.build();
        boolean bl2 = false;
        try {
            Disposer.register((Disposable)this$0, () -> CrashlyticsConfigurationService.lambda$3$lambda$2$lambda$1((ManagedChannel)it));
        }
        catch (IncorrectOperationException incorrectOperationException) {
            it.shutdownNow();
        }
        return nettyChannelBuilder;
    }

    private static final Unit _init_$lambda$4(Project $project, Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof GoogleJsonResponseException && ((GoogleJsonResponseException)e).getStatusCode() == 401) {
            ComponentManager $this$service$iv = (ComponentManager)$project;
            boolean $i$f$service = false;
            Class<CrashlyticsConfigurationService> serviceClass$iv = CrashlyticsConfigurationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((CrashlyticsConfigurationService)object).manager.refreshConfiguration();
        }
        return Unit.INSTANCE;
    }
}

