/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.dependency;

import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.RecipeMetadata;
import com.android.tools.idea.assistant.RecipeUtils;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.FirebasePluginDisposable;
import com.google.services.firebase.FirebaseTutorialBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyStateManager
extends AssistActionStateManager {
    static final String ANALYTICS_DEP_NAME = "firebase-core";
    private final Map<ActionData, DefaultActionState> myStateMap = new HashMap<ActionData, DefaultActionState>();
    private final Map<ActionData, String> myStateMessageMap = new HashMap<ActionData, String>();
    private final Set<Project> myRegisteredProjects = new HashSet<Project>();

    private static Logger getLog() {
        return Logger.getInstance(DependencyStateManager.class);
    }

    @NotNull
    private DefaultActionState getDependencyState(@NotNull ActionData actionData, @NotNull Project project) {
        if (!(actionData instanceof FirebaseTutorialBundle.Action)) {
            throw new RuntimeException("This should be impossible, malformed actiondata");
        }
        FirebaseTutorialBundle.Action castAction = (FirebaseTutorialBundle.Action)actionData;
        this.myStateMessageMap.remove(actionData);
        if (castAction.getRecipe() == null) {
            DependencyStateManager.getLog().error("Unable to retrieve dependency configuration");
            return DefaultActionState.INCOMPLETE;
        }
        List recipeMetadata = RecipeUtils.getRecipeMetadata((Function2)castAction.getRecipe(), (Project)project);
        Iterator iterator = recipeMetadata.iterator();
        if (!iterator.hasNext()) {
            return DefaultActionState.INCOMPLETE;
        }
        RecipeMetadata sampleMetadata = (RecipeMetadata)iterator.next();
        if (!DependencyStateManager.getPendingClasspaths(project, sampleMetadata).isEmpty()) {
            return DefaultActionState.INCOMPLETE;
        }
        int numCompleted = 0;
        for (RecipeMetadata metadata : recipeMetadata) {
            GradleBuildModel gradleBuildModel = GradleBuildModel.get((Module)metadata.getModule());
            if (gradleBuildModel == null || !DependencyStateManager.getPendingPlugins(metadata).isEmpty() || !DependencyStateManager.getPendingDependencies(metadata, gradleBuildModel).isEmpty()) continue;
            ++numCompleted;
        }
        if (numCompleted == 0) {
            return DefaultActionState.INCOMPLETE;
        }
        if (numCompleted != recipeMetadata.size()) {
            this.myStateMessageMap.put(actionData, FirebaseBundle.message("dependencies.add.partiallyCompleted", numCompleted, recipeMetadata.size()));
            return DefaultActionState.PARTIALLY_COMPLETE;
        }
        return DefaultActionState.COMPLETE;
    }

    @NotNull
    public String getId() {
        return "firebase.add_dependencies";
    }

    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        this.myStateMap.put(actionData, this.getDependencyState(actionData, project));
        if (this.myRegisteredProjects.contains(project)) {
            return;
        }
        this.myRegisteredProjects.add(project);
        GradleSyncState.subscribe((Project)project, (GradleSyncListener)new GradleSyncListener(){

            public void syncSucceeded(@NotNull Project project) {
                DependencyStateManager.this.refreshDependencyStateIfNeeded(project);
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                DependencyStateManager.this.refreshDependencyStateIfNeeded(project);
            }
        }, (Disposable)FirebasePluginDisposable.getInstance(project));
    }

    public DefaultActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        if (!this.myStateMap.containsKey(actionData)) {
            return DefaultActionState.INCOMPLETE;
        }
        return this.myStateMap.get(actionData);
    }

    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String successMessage) {
        String message = this.myStateMessageMap.containsKey(actionData) ? this.myStateMessageMap.get(actionData) : successMessage;
        return new StatefulButtonMessage(message, (AssistActionState)this.getState(project, actionData));
    }

    private void refreshDependencyStateIfNeeded(final @NotNull Project project) {
        Task.Backgroundable refreshTask2 = new Task.Backgroundable(project, "Update Dependency State"){

            public void run(@NotNull ProgressIndicator indicator) {
                DependencyStateManager.getLog().info("Refreshing dependency state");
                boolean stateChanged = false;
                for (Map.Entry<ActionData, DefaultActionState> entry : DependencyStateManager.this.myStateMap.entrySet()) {
                    String newMessage;
                    DefaultActionState state = entry.getValue();
                    ActionData actionData = entry.getKey();
                    String oldMessage = DependencyStateManager.this.myStateMessageMap.get(actionData);
                    DefaultActionState newValue = DependencyStateManager.this.getDependencyState(actionData, project);
                    if (!state.equals((Object)newValue)) {
                        entry.setValue(newValue);
                        stateChanged = true;
                    }
                    if ((newMessage = DependencyStateManager.this.myStateMessageMap.get(actionData)) == null || newMessage.equals(oldMessage)) continue;
                    stateChanged = true;
                }
                if (!stateChanged) {
                    return;
                }
                DependencyStateManager.this.refreshDependencyState(project);
            }
        };
        ApplicationManager.getApplication().executeOnPooledThread(() -> ((Task.Backgroundable)refreshTask2).queue());
    }

    static List<String> getPendingDependencies(@NotNull RecipeMetadata metadata, @Nullable GradleBuildModel buildModel) {
        if (buildModel == null) {
            return Collections.emptyList();
        }
        DependenciesModel dependenciesModel = buildModel.dependencies();
        if (dependenciesModel == null) {
            return Collections.emptyList();
        }
        return DependencyStateManager.findMissingDependencies(metadata.getDependencies(), dependenciesModel.artifacts());
    }

    @NotNull
    static List<String> getPendingClasspaths(@NotNull Project project, RecipeMetadata recipeMetadata) {
        GradleBuildModel projectGradleBuildModel = GradleBuildModel.get((Project)project);
        if (projectGradleBuildModel == null) {
            DependencyStateManager.getLog().warn("Unable to get gradle model to access current dependencies");
            return Collections.emptyList();
        }
        DependenciesModel dependencies = projectGradleBuildModel.buildscript().dependencies();
        return DependencyStateManager.findMissingDependencies(recipeMetadata.getClasspathEntries(), dependencies.artifacts("classpath"));
    }

    @NotNull
    private static List<String> findMissingDependencies(@NotNull List<String> depsToFind, @NotNull List<? extends ArtifactDependencyModel> existingDeps) {
        ArrayList<String> pendingDependencies = new ArrayList<String>();
        for (String dependencyValue : depsToFind) {
            ArtifactDependencySpec requiredDepSpec = ArtifactDependencySpec.create((String)dependencyValue);
            if (requiredDepSpec == null) {
                return pendingDependencies;
            }
            boolean found = false;
            for (ArtifactDependencyModel artifactDependencyModel : existingDeps) {
                ArtifactDependencySpec foundDepSpec = artifactDependencyModel.getSpec();
                if (!foundDepSpec.equalsIgnoreVersion((Object)requiredDepSpec) || VersionComparatorUtil.compare((String)foundDepSpec.getVersion(), (String)requiredDepSpec.getVersion()) < 0) continue;
                found = true;
            }
            if (found) continue;
            pendingDependencies.add(dependencyValue);
        }
        return pendingDependencies;
    }

    @NotNull
    static List<String> getPendingPlugins(@NotNull RecipeMetadata metadata) {
        ArrayList<String> pendingPlugins = new ArrayList<String>();
        GradleBuildModel gradleBuildModel = GradleBuildModel.get((Module)metadata.getModule());
        if (gradleBuildModel == null) {
            return pendingPlugins;
        }
        List plugins = PluginModel.extractNames((List)gradleBuildModel.plugins());
        for (String plugin : metadata.getPlugins()) {
            if (!plugins.contains(plugin)) {
                DependencyStateManager.getLog().info("did not find plugin: " + plugin);
                pendingPlugins.add(plugin);
                continue;
            }
            DependencyStateManager.getLog().debug("found plugin: " + plugin);
        }
        return pendingPlugins;
    }

    static boolean hasAnalytics(@Nullable GradleBuildModel buildModel) {
        if (buildModel == null) {
            return false;
        }
        DependenciesModel dependenciesModel = buildModel.dependencies();
        if (dependenciesModel == null) {
            return false;
        }
        for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
            if (!dependency.name().forceString().contains(ANALYTICS_DEP_NAME)) continue;
            return true;
        }
        return false;
    }
}

