/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.google.services.firebase.ModuleState;
import com.google.services.firebase.ModuleStateService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/google/services/firebase/ModuleStateServiceImpl;", "Lcom/google/services/firebase/ModuleStateService;", "<init>", "()V", "moduleState", "Ljava/util/HashMap;", "", "Lcom/google/services/firebase/ModuleState;", "Lkotlin/collections/HashMap;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "flow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getModuleState", "module", "Lcom/intellij/openapi/module/Module;", "requestProjectModuleStateUpdate", "project", "Lcom/intellij/openapi/project/Project;", "updateModuleState", "newIsCompletableState", "", "requestModuleStatusUpdate", "stateCompletionFlow", "Lkotlinx/coroutines/flow/Flow;", "getStateCompletionFlow", "()Lkotlinx/coroutines/flow/Flow;", "getOrCreateModuleState", "firebase"})
@SourceDebugExtension(value={"SMAP\nModuleStateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleStateService.kt\ncom/google/services/firebase/ModuleStateServiceImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,96:1\n3829#2:97\n4344#2,2:98\n1869#3,2:100\n382#4,7:102\n*S KotlinDebug\n*F\n+ 1 ModuleStateService.kt\ncom/google/services/firebase/ModuleStateServiceImpl\n*L\n67#1:97\n67#1:98,2\n68#1:100,2\n94#1:102,7\n*E\n"})
public final class ModuleStateServiceImpl
implements ModuleStateService {
    @NotNull
    private final HashMap<Integer, ModuleState> moduleState = new HashMap();
    @NotNull
    private final Logger log;
    @NotNull
    private final MutableSharedFlow<Unit> flow;
    @NotNull
    private final Flow<Unit> stateCompletionFlow;

    public ModuleStateServiceImpl() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.flow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.stateCompletionFlow = (Flow)this.flow;
    }

    @Override
    @Nullable
    public ModuleState getModuleState(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.moduleState.get(module.hashCode());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void requestProjectModuleStateUpdate(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Module[] $this$filter$iv = ModuleManager.Companion.getInstance(project).getModules();
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!this.moduleState.containsKey(it.hashCode())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            this.requestModuleStatusUpdate(it);
        }
    }

    @Override
    public void updateModuleState(@NotNull Module module, boolean newIsCompletableState) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.log.debug("Updating module state: " + newIsCompletableState);
        ModuleState moduleState = this.getOrCreateModuleState(module);
        if (moduleState.isCompletable() != newIsCompletableState) {
            this.log.debug("Sending refresh notification Stateful button.");
            moduleState.setCompletable(newIsCompletableState);
            MessageBus messageBus = module.getProject().getMessageBus();
            Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
            MessageBus bus = messageBus;
            Topic topic = StatefulButtonNotifier.BUTTON_STATE_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"BUTTON_STATE_TOPIC");
            StatefulButtonNotifier publisher = (StatefulButtonNotifier)bus.syncPublisher(topic);
            publisher.stateUpdated();
            this.flow.tryEmit((Object)Unit.INSTANCE);
        } else {
            this.log.debug("Module state did not change.");
        }
    }

    @Override
    public void requestModuleStatusUpdate(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.getOrCreateModuleState(module).startRefreshTask(module);
    }

    @Override
    @NotNull
    public Flow<Unit> getStateCompletionFlow() {
        return this.stateCompletionFlow;
    }

    /*
     * WARNING - void declaration
     */
    private final ModuleState getOrCreateModuleState(Module module) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = this.moduleState;
        Integer key$iv = module.hashCode();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ModuleState answer$iv = new ModuleState();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ModuleState)object;
    }
}

