/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali.Adaptors.Debug;

import com.android.tools.smali.baksmali.Adaptors.ClassDefinition;
import com.android.tools.smali.baksmali.Adaptors.Debug.BeginEpilogueMethodItem;
import com.android.tools.smali.baksmali.Adaptors.Debug.EndLocalMethodItem;
import com.android.tools.smali.baksmali.Adaptors.Debug.EndPrologueMethodItem;
import com.android.tools.smali.baksmali.Adaptors.Debug.LineNumberMethodItem;
import com.android.tools.smali.baksmali.Adaptors.Debug.RestartLocalMethodItem;
import com.android.tools.smali.baksmali.Adaptors.Debug.SetSourceFileMethodItem;
import com.android.tools.smali.baksmali.Adaptors.Debug.StartLocalMethodItem;
import com.android.tools.smali.baksmali.Adaptors.MethodItem;
import com.android.tools.smali.baksmali.Adaptors.RegisterFormatter;
import com.android.tools.smali.dexlib2.iface.debug.DebugItem;
import com.android.tools.smali.dexlib2.iface.debug.EndLocal;
import com.android.tools.smali.dexlib2.iface.debug.LineNumber;
import com.android.tools.smali.dexlib2.iface.debug.RestartLocal;
import com.android.tools.smali.dexlib2.iface.debug.SetSourceFile;
import com.android.tools.smali.dexlib2.iface.debug.StartLocal;
import com.android.tools.smali.util.ExceptionWithContext;

public abstract class DebugMethodItem
extends MethodItem {
    private final int sortOrder;

    protected DebugMethodItem(int codeAddress, int sortOrder) {
        super(codeAddress);
        this.sortOrder = sortOrder;
    }

    @Override
    public double getSortOrder() {
        return this.sortOrder;
    }

    public static DebugMethodItem build(ClassDefinition classDef, RegisterFormatter registerFormatter, DebugItem debugItem) {
        int codeAddress = debugItem.getCodeAddress();
        switch (debugItem.getDebugItemType()) {
            case 3: {
                return new StartLocalMethodItem(classDef, codeAddress, -1, registerFormatter, (StartLocal)debugItem);
            }
            case 5: {
                return new EndLocalMethodItem(codeAddress, -1, registerFormatter, (EndLocal)debugItem);
            }
            case 6: {
                return new RestartLocalMethodItem(classDef, codeAddress, -1, registerFormatter, (RestartLocal)debugItem);
            }
            case 8: {
                return new BeginEpilogueMethodItem(codeAddress, -4);
            }
            case 7: {
                return new EndPrologueMethodItem(codeAddress, -4);
            }
            case 9: {
                return new SetSourceFileMethodItem(codeAddress, -3, (SetSourceFile)debugItem);
            }
            case 10: {
                return new LineNumberMethodItem(codeAddress, -2, (LineNumber)debugItem);
            }
        }
        throw new ExceptionWithContext("Invalid debug item type: %d", new Object[]{debugItem.getDebugItemType()});
    }
}

