/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.ILogger;
import java.io.PrintStream;

public class StdLogger
implements ILogger {
    private final Level mLevel;

    public StdLogger(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("level cannot be null");
        }
        this.mLevel = level;
    }

    @Override
    public void error(Throwable t, String errorFormat, Object ... args) {
        if (errorFormat != null) {
            String msg = String.format("Error: " + errorFormat, args);
            this.printMessage(msg, System.err);
        }
        if (t != null) {
            System.err.println(String.format("Error: %1$s", t.getMessage()));
        }
    }

    @Override
    public void warning(String warningFormat, Object ... args) {
        if (this.mLevel.mLevel > Level.WARNING.mLevel) {
            return;
        }
        String msg = String.format("Warning: " + warningFormat, args);
        this.printMessage(msg, System.out);
    }

    @Override
    public void info(String msgFormat, Object ... args) {
        if (this.mLevel.mLevel > Level.INFO.mLevel) {
            return;
        }
        String msg = String.format(msgFormat, args);
        this.printMessage(msg, System.out);
    }

    @Override
    public void verbose(String msgFormat, Object ... args) {
        if (this.mLevel.mLevel > Level.VERBOSE.mLevel) {
            return;
        }
        String msg = String.format(msgFormat, args);
        this.printMessage(msg, System.out);
    }

    private void printMessage(String msg, PrintStream stream) {
        if (SdkConstants.CURRENT_PLATFORM == 2 && !msg.endsWith("\r\n") && msg.endsWith("\n")) {
            msg = msg.substring(0, msg.length() - 1);
        }
        if (msg.endsWith("\n")) {
            stream.print(msg);
        } else {
            stream.println(msg);
        }
    }

    public static enum Level {
        VERBOSE(0),
        INFO(1),
        WARNING(2),
        ERROR(3);

        private final int mLevel;

        private Level(int level) {
            this.mLevel = level;
        }
    }
}

