/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DFARawTuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClangParseResponseImpl
extends UserDataHolderBase
implements ClangParseResponse {
    private static final int MAX_NUMBER_OF_ATTACHED_REPARSES = 512;
    @NotNull
    private final String myUrl;
    private final int myVersion;
    private final int myPreambleVersion;
    private final boolean myIsCancellable;
    @NotNull
    private final AtomicReference<ClangParseResponse.OpState> myOperationState;
    @NotNull
    private final List<ClangInteractionPromise> myAssociatedReparses;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangDiagnostic>>> myDiagnostics;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangHighlighting>>> myHighlightings;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> myOurTidyDiagnostics;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> myTidyDiagnostics;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangDiagnostic>>> myClazyDiagnostics;
    @NotNull
    private final CompletableFuture<Supplier<List<DFARawTuple>>> myDFAInput;

    public ClangParseResponseImpl(@NotNull String url, @NotNull String path, int version, int preambleVersion, boolean isCancellable) {
        if (url == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(1);
        }
        this.myOperationState = new AtomicReference<ClangParseResponse.OpState>(ClangParseResponse.OpState.None);
        this.myAssociatedReparses = new ArrayList<ClangInteractionPromise>();
        this.myDiagnostics = new CompletableFuture();
        this.myHighlightings = new CompletableFuture();
        this.myOurTidyDiagnostics = new CompletableFuture();
        this.myTidyDiagnostics = new CompletableFuture();
        this.myClazyDiagnostics = new CompletableFuture();
        this.myDFAInput = new CompletableFuture();
        this.myUrl = url;
        this.myVersion = version;
        this.myPreambleVersion = preambleVersion;
        this.myIsCancellable = isCancellable;
        if (ClangDebugLevel.isTraceOrMore()) {
            long startTime = System.currentTimeMillis();
            String fileName = new File(path).getName();
            this.myDiagnostics.thenAccept(res -> {
                long diagnosticsCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of diagnostics for " + fileName + " took " + diagnosticsCalculationDuration + " ms");
            });
            this.myHighlightings.thenAccept(res -> {
                long highlightingsCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of highlightings for " + fileName + " took " + highlightingsCalculationDuration + " ms");
            });
            this.myOurTidyDiagnostics.thenAccept(res -> {
                long calculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of our clang-tidy diagnostics for " + fileName + " took " + calculationDuration + " ms");
            });
            this.myTidyDiagnostics.thenAccept(res -> {
                long tidyDiagnosticsCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of clang-tidy diagnostics for " + fileName + " took " + tidyDiagnosticsCalculationDuration + " ms");
            });
            this.myClazyDiagnostics.thenAccept(res -> {
                long calculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of our clazy diagnostics for " + fileName + " took " + calculationDuration + " ms");
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<ClangInteractionPromise> attachReparseNotification(@NotNull ClangInteractionPromise reparse) {
        if (reparse == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(2);
        }
        AtomicReference<ClangParseResponse.OpState> atomicReference = this.myOperationState;
        synchronized (atomicReference) {
            boolean canAttach;
            ClangParseResponse.OpState curState = this.myOperationState.get();
            boolean bl = canAttach = curState == ClangParseResponse.OpState.None || curState == ClangParseResponse.OpState.Fake && this.myAssociatedReparses.isEmpty();
            if (!canAttach) {
                return null;
            }
            if (this.myAssociatedReparses.size() >= 512) {
                return null;
            }
            ArrayList<ClangInteractionPromise> prevReparses = new ArrayList<ClangInteractionPromise>(this.myAssociatedReparses);
            this.myAssociatedReparses.add(reparse);
            return prevReparses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirstReparseNotification(@Nullable ClangInteractionPromise reparse) {
        AtomicReference<ClangParseResponse.OpState> atomicReference = this.myOperationState;
        synchronized (atomicReference) {
            return !this.myAssociatedReparses.isEmpty() && this.myAssociatedReparses.get(0) == reparse;
        }
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public int getVersion() {
        return Math.abs(this.myVersion);
    }

    @Override
    public int getPreambleVersion() {
        return this.myPreambleVersion;
    }

    @Override
    public boolean isCancellable() {
        return this.myIsCancellable;
    }

    @Override
    @NotNull
    public ClangParseResponse.OpState getOpState() {
        ClangParseResponse.OpState opState = this.myOperationState.get();
        if (opState == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(4);
        }
        return opState;
    }

    @Override
    public boolean nextOpState(@NotNull ClangParseResponse.OpState next) {
        if (next == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(5);
        }
        return this.nextOpState(next, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nextOpState(@NotNull ClangParseResponse.OpState next, @Nullable Predicate<List<ClangInteractionPromise>> condition) {
        if (next == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(6);
        }
        assert (next != ClangParseResponse.OpState.None) : "Why resetting state?";
        AtomicReference<ClangParseResponse.OpState> atomicReference = this.myOperationState;
        synchronized (atomicReference) {
            if (condition != null && !condition.test(this.myAssociatedReparses)) {
                return false;
            }
            if (!this.myOperationState.compareAndSet(ClangParseResponse.OpState.None, next)) {
                return false;
            }
            for (ClangInteractionPromise promise : this.myAssociatedReparses) {
                if (promise.getInteraction().isDone()) continue;
                promise.getInteraction().cancel(false);
            }
            return true;
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getDiagnostics() {
        CompletableFuture<Supplier<List<ClangDiagnostic>>> completableFuture = this.myDiagnostics;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangHighlighting>>> getHighlightings() {
        CompletableFuture<Supplier<List<ClangHighlighting>>> completableFuture = this.myHighlightings;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(8);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getOurTidyDiagnostics() {
        CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> completableFuture = this.myOurTidyDiagnostics;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getTidyDiagnostics() {
        CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> completableFuture = this.myTidyDiagnostics;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getClazyDiagnostics() {
        CompletableFuture<Supplier<List<ClangDiagnostic>>> completableFuture = this.myClazyDiagnostics;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<DFARawTuple>>> getDFAInput() {
        CompletableFuture<Supplier<List<DFARawTuple>>> completableFuture = this.myDFAInput;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    public String toString() {
        return this.getUrl() + "[" + this.getVersion() + "]";
    }

    @TestOnly
    public static int getMaxNumberOfAttachedReparses() {
        return 512;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparse";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangParseResponseImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangParseResponseImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnostics";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOurTidyDiagnostics";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTidyDiagnostics";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getClazyDiagnostics";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDFAInput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attachReparseNotification";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nextOpState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

