/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.LightIndexNavigationItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.LightSymbolInfo;
import icons.CidrLangIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020!H\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR\u0011\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/LightIndexNavigationItem;", "Lcom/intellij/navigation/NavigationItem;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "maybeQualifiedName", "", "lightInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/LightSymbolInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/LightSymbolInfo;Lcom/intellij/openapi/project/Project;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getMaybeQualifiedName", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "kind", "Lorg/eclipse/lsp4j/SymbolKind;", "getKind", "()Lorg/eclipse/lsp4j/SymbolKind;", "position", "Lkotlin/Pair;", "", "getPosition", "()Lkotlin/Pair;", "shortName", "getShortName", "namespace", "getNamespace", "getName", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "intellij.cidr.clangd"})
public final class LightIndexNavigationItem
implements NavigationItem {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final String maybeQualifiedName;
    @NotNull
    private final Project project;
    @NotNull
    private final SymbolKind kind;
    @NotNull
    private final Pair<Integer, Integer> position;
    @NotNull
    private final String shortName;
    @NotNull
    private final String namespace;

    public LightIndexNavigationItem(@NotNull VirtualFile file, @NotNull String maybeQualifiedName, @NotNull LightSymbolInfo lightInfo, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)maybeQualifiedName, (String)"maybeQualifiedName");
        Intrinsics.checkNotNullParameter((Object)lightInfo, (String)"lightInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.file = file;
        this.maybeQualifiedName = maybeQualifiedName;
        this.project = project;
        this.kind = lightInfo.getKind();
        this.position = TuplesKt.to((Object)RangesKt.coerceAtLeast((int)(lightInfo.getLine() - 1), (int)0), (Object)RangesKt.coerceAtLeast((int)(lightInfo.getColumn() - 1), (int)0));
        this.shortName = StringsKt.substringAfterLast$default((String)this.maybeQualifiedName, (String)"::", null, (int)2, null);
        this.namespace = StringsKt.substringBeforeLast$default((String)this.maybeQualifiedName, (String)"::", null, (int)2, null);
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final String getMaybeQualifiedName() {
        return this.maybeQualifiedName;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final SymbolKind getKind() {
        return this.kind;
    }

    @NotNull
    public final Pair<Integer, Integer> getPosition() {
        return this.position;
    }

    @NotNull
    public final String getShortName() {
        return this.shortName;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public String getName() {
        return this.shortName;
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.project, this.file, ((Number)this.position.getFirst()).intValue(), ((Number)this.position.getSecond()).intValue());
        FileEditorManager.getInstance((Project)this.project).openTextEditor(descriptor, requestFocus);
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        Document document = FileDocumentManager.getInstance().getDocument(this.file);
        if (document == null) {
            return null;
        }
        Document doc = document;
        int offset = doc.getLineStartOffset(((Number)this.position.getFirst()).intValue()) + ((Number)this.position.getSecond()).intValue();
        return NavigationRequest.Companion.sourceNavigationRequest(this.project, this.file, offset);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(this){
            final /* synthetic */ LightIndexNavigationItem this$0;
            {
                this.this$0 = $receiver;
            }

            public String getPresentableText() {
                return "\u26a1\ufe0f" + this.this$0.getShortName();
            }

            public String getLocationString() {
                return this.this$0.getNamespace();
            }

            public Icon getIcon(boolean unused) {
                return switch (getPresentation.WhenMappings.$EnumSwitchMapping$0[this.this$0.getKind().ordinal()]) {
                    case 1 -> CidrLangIcons.CodeAssistantNamespace;
                    case 2, 3 -> CidrLangIcons.CodeAssistantStruct;
                    case 4 -> CidrLangIcons.CodeAssistantEnum;
                    case 5 -> CidrLangIcons.CodeAssistantFunction;
                    case 6 -> CidrLangIcons.CodeAssistantGlobal;
                    default -> null;
                };
            }
        };
    }
}

