/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.ClangLightIndexExternalizer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.ClangLightSymbolInfoResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.LightSymbolInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u0006\u001a#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00030\u00030\u0007\u00a2\u0006\u0002\b\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/ClangLightIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/LightSymbolInfo;", "<init>", "()V", "getName", "Lcom/intellij/util/indexing/ID;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getVersion", "", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "dependsOnFileContent", "", "getKeyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "getValueExternalizer", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/ClangLightIndexExternalizer;", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "Util", "intellij.cidr.clangd"})
@SourceDebugExtension(value={"SMAP\nClangLightIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangLightIndex.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/ClangLightIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1267#2,4:49\n*S KotlinDebug\n*F\n+ 1 ClangLightIndex.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/ClangLightIndex\n*L\n43#1:49,4\n*E\n"})
public final class ClangLightIndex
extends FileBasedIndexExtension<String, LightSymbolInfo> {
    @NotNull
    public ID<String, LightSymbolInfo> getName() {
        return Util.INSTANCE.getOurId();
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return (FileBasedIndex.InputFilter)Util.INSTANCE.getOurInputFilter();
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
        return (KeyDescriptor)enumeratorStringDescriptor;
    }

    @NotNull
    public ClangLightIndexExternalizer getValueExternalizer() {
        return Util.INSTANCE.getOurValueExternalizer();
    }

    @NotNull
    public DataIndexer<String, LightSymbolInfo, FileContent> getIndexer() {
        return ClangLightIndex::getIndexer$lambda$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getIndexer$lambda$1(FileContent inputData) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        boolean bl = Registry.Companion.is("com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.enable");
        if (bl) {
            void destination$iv;
            void $this$associateTo$iv;
            Project project = inputData.getProject();
            VirtualFile virtualFile = inputData.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile vFile = virtualFile;
            ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getOrStart(project);
            if (clangLanguageService == null) {
                throw new RuntimeException("Cannot access clangd service");
            }
            ClangLanguageService clangdService = clangLanguageService;
            CompletableFuture<List<ClangLightSymbolInfoResponse>> completableFuture = clangdService.clionLightIndex(vFile);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"clionLightIndex(...)");
            CompletableFuture<List<ClangLightSymbolInfoResponse>> clionLightIndexFuture = completableFuture;
            List<ClangLightSymbolInfoResponse> list = clionLightIndexFuture.get();
            Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
            Iterable iterable = list;
            Map map2 = new LinkedHashMap();
            boolean $i$f$associateTo = false;
            for (Object element$iv : $this$associateTo$iv) {
                void var11_11 = destination$iv;
                ClangLightSymbolInfoResponse it = (ClangLightSymbolInfoResponse)element$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)it.getName(), (Object)new LightSymbolInfo(it.getKind(), it.getStart().getLine(), it.getStart().getCharacter()));
                var11_11.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv;
        } else if (!bl) {
            map = new LinkedHashMap();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R2\u0010\b\u001a#\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f0\t\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/ClangLightIndex$Util;", "", "<init>", "()V", "ourInputFilter", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "getOurInputFilter", "()Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "ourId", "Lcom/intellij/util/indexing/ID;", "", "kotlin.jvm.PlatformType", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/LightSymbolInfo;", "Lorg/jetbrains/annotations/NotNull;", "getOurId", "()Lcom/intellij/util/indexing/ID;", "ourValueExternalizer", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/ClangLightIndexExternalizer;", "getOurValueExternalizer", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/navigationLight/ClangLightIndexExternalizer;", "intellij.cidr.clangd"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        @NotNull
        private static final DefaultFileTypeSpecificInputFilter ourInputFilter;
        @NotNull
        private static final ID<String, LightSymbolInfo> ourId;
        @NotNull
        private static final ClangLightIndexExternalizer ourValueExternalizer;

        private Util() {
        }

        @NotNull
        public final DefaultFileTypeSpecificInputFilter getOurInputFilter() {
            return ourInputFilter;
        }

        @NotNull
        public final ID<String, LightSymbolInfo> getOurId() {
            return ourId;
        }

        @NotNull
        public final ClangLightIndexExternalizer getOurValueExternalizer() {
            return ourValueExternalizer;
        }

        static {
            FileType[] fileTypeArray = new FileType[]{OCFileType.INSTANCE};
            ourInputFilter = new DefaultFileTypeSpecificInputFilter(fileTypeArray);
            ID iD = ID.create((String)"clang.format.lightIndex");
            Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"create(...)");
            ourId = iD;
            ourValueExternalizer = new ClangLightIndexExternalizer();
        }
    }
}

