/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdInlayHint;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTypehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.InlayHintsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTReadRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdInlayHintData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.InlayHintKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.InlayHintKindKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangInlayHintsRequest
extends ClangASTReadRequest<InlayHintsParams, CachingSupplier<ClangdInlayHintData>> {
    @NotNull
    final ClangDaemonContext myContext;
    @NotNull
    final VirtualFile myVirtualFile;

    public ClangInlayHintsRequest(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull VirtualFile virtualFile, @NotNull TextDocumentIdentifier docIdent, @Nullable ClionClangNamehintConfigParams parameterConfig, @Nullable ClionClangTypehintConfigParams typeConfig) {
        if (context == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(0);
        }
        if (url == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(2);
        }
        if (docIdent == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(3);
        }
        super(url, new InlayHintsParams(docIdent, parameterConfig, typeConfig));
        this.myContext = context;
        this.myVirtualFile = virtualFile;
    }

    @Override
    @Nullable
    protected CompletableFuture<CachingSupplier<ClangdInlayHintData>> sendRequestImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (server == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(4);
        }
        if (ws == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(5);
        }
        return server.clangdInlayHints((InlayHintsParams)this.myParams).thenApply(it -> new CachingSupplier<ClangdInlayHintData>(() -> this.toClangdInlayHintData((List<ClangdInlayHint>)it)));
    }

    @Nullable
    private ClangdInlayHintData toClangdInlayHintData(@Nullable List<ClangdInlayHint> hints) {
        if (ContainerUtil.isEmpty(hints)) {
            return null;
        }
        Document document = this.myContext.getIdeFacade().getDocument(this.myVirtualFile);
        if (document == null) {
            return null;
        }
        int numLinesInDocument = document.getLineCount();
        HashMap<Integer, ClangdInlayHint> paramHints = new HashMap<Integer, ClangdInlayHint>();
        HashMap<Integer, ClangdInlayHint> typeHints = new HashMap<Integer, ClangdInlayHint>();
        for (ClangdInlayHint inlayHint : hints) {
            Range range;
            Position hintPos;
            int hintLine;
            InlayHintKind kind = InlayHintKindKt.toInlayHintKind(inlayHint.getKind());
            if (kind == null || !ClangInlayHintsRequest.isSupportedHintKind(kind) || (hintLine = (hintPos = ClangInlayHintsRequest.getHintPosition(kind, range = Objects.requireNonNull(inlayHint.getRange()))).getLine()) < 0 || hintLine >= numLinesInDocument) continue;
            int offset = ClangLanguageServiceUtils.lspPos2Offset(document, hintPos);
            if (kind == InlayHintKind.Parameter || kind == InlayHintKind.Designator) {
                paramHints.put(offset, inlayHint);
                continue;
            }
            if (kind != InlayHintKind.Type) continue;
            typeHints.put(offset, inlayHint);
        }
        return new ClangdInlayHintData(paramHints, typeHints);
    }

    private static boolean isSupportedHintKind(@NotNull InlayHintKind kind) {
        if (kind == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(6);
        }
        return kind == InlayHintKind.Parameter || kind == InlayHintKind.Designator || kind == InlayHintKind.Type;
    }

    @NotNull
    private static Position getHintPosition(@NotNull InlayHintKind kind, @NotNull Range range) {
        if (kind == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(7);
        }
        if (range == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(8);
        }
        Position position = kind == InlayHintKind.Parameter || kind == InlayHintKind.Designator ? range.getStart() : range.getEnd();
        if (position == null) {
            ClangInlayHintsRequest.$$$reportNull$$$0(9);
        }
        return position;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docIdent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ws";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangInlayHintsRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangInlayHintsRequest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHintPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedHintKind";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHintPosition";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

