/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports;

import com.intellij.cidr.cpp.lexer.CidrLexerUtils;
import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.Compressor;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangPreprocessedReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangReportUtils {
    private static final Logger LOG = Logger.getInstance(ClangReportUtils.class);

    private ClangReportUtils() {
        throw new AssertionError((Object)"Do not instantiate");
    }

    @NotNull
    public static Map<String, String> preparePreprocessedReport(@NotNull ClangLanguageService service, @NotNull List<String> fileUrls, boolean obfuscate) throws IOException {
        if (service == null) {
            ClangReportUtils.$$$reportNull$$$0(0);
        }
        if (fileUrls == null) {
            ClangReportUtils.$$$reportNull$$$0(1);
        }
        HashMap<String, String> file2Content = new HashMap<String, String>();
        ClangPreprocessedReport report = ClangReportUtils.doPreprocess(service, fileUrls);
        if (report == null || report.getPreprocessedFiles().isEmpty()) {
            HashMap<String, String> hashMap = file2Content;
            if (hashMap == null) {
                ClangReportUtils.$$$reportNull$$$0(2);
            }
            return hashMap;
        }
        Obfuscator obfuscator = obfuscate ? ClangdBridge.getObfuscator() : null;
        for (ClangPreprocessedReport.PreprocessedFile ppFile : report.getPreprocessedFiles()) {
            String mainFileName = PathUtilRt.getFileName((String)ppFile.getTargetPath(obfuscator));
            ClangReportUtils.putCustomFile(file2Content, "CompilationInfo.txt", mainFileName, null, ppFile.getCompilationInfoAsString(obfuscator));
            if (ppFile.lastDiagnostics != null) {
                ClangReportUtils.putCustomFile(file2Content, "LastDiagnostics.txt", mainFileName, null, ppFile.lastDiagnostics);
            }
            ClangReportUtils.putCustomFile(file2Content, "preprocessed.txt", mainFileName, null, ppFile.getContent(obfuscator));
        }
        HashMap<String, String> hashMap = file2Content;
        if (hashMap == null) {
            ClangReportUtils.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, String> prepareAsIsReport(@NotNull ClangLanguageService service, @NotNull List<String> fileUrls) throws IOException {
        if (service == null) {
            ClangReportUtils.$$$reportNull$$$0(4);
        }
        if (fileUrls == null) {
            ClangReportUtils.$$$reportNull$$$0(5);
        }
        HashMap<String, String> file2Content = new HashMap<String, String>();
        ClangReportUtils.prepareAsIsReportImpl(new HashSet<String>(), service, fileUrls, null, nestedFile2Content -> {
            for (Map.Entry fileAndContent : nestedFile2Content.entrySet()) {
                String fileName = (String)fileAndContent.getKey();
                if (file2Content.containsKey(fileName)) continue;
                file2Content.put(fileName, (String)fileAndContent.getValue());
            }
        });
        HashMap<String, String> hashMap = file2Content;
        if (hashMap == null) {
            ClangReportUtils.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    public static byte[] makeZipArchive(@NotNull Map<String, String> file2Content) throws IOException {
        if (file2Content == null) {
            ClangReportUtils.$$$reportNull$$$0(7);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (Compressor.Zip zip = new Compressor.Zip((OutputStream)baos);){
            for (Map.Entry<String, String> entry : file2Content.entrySet()) {
                zip.addFile(ClangReportUtils.convertWindowsPath(entry.getKey()), entry.getValue().getBytes(StandardCharsets.UTF_8));
            }
        }
        return baos.toByteArray();
    }

    @NotNull
    public static String convertWindowsPath(@NotNull String path) {
        if (path == null) {
            ClangReportUtils.$$$reportNull$$$0(8);
        }
        if (OSAgnosticPathUtil.startsWithWindowsDrive((String)path)) {
            String string = "/drive_" + path.charAt(0) + path.substring(2);
            if (string == null) {
                ClangReportUtils.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            ClangReportUtils.$$$reportNull$$$0(10);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withCrashLanguageService(@NotNull ClangDaemonContext context, @NotNull Consumer<? super ClangLanguageService> crashServiceConsumer) {
        block9: {
            ClangDaemonContextImpl crashContext;
            block8: {
                if (context == null) {
                    ClangReportUtils.$$$reportNull$$$0(11);
                }
                if (crashServiceConsumer == null) {
                    ClangReportUtils.$$$reportNull$$$0(12);
                }
                crashContext = null;
                ClangdLanguageService service = null;
                try {
                    crashContext = new ClangDaemonContextImpl.Builder("crash", context.getProject()).create();
                    ClangRemoteWorkspace crashRemoteWorkspace = crashContext.getRemoteWorkspace();
                    List<String> allRegisteredUrls = context.getRemoteWorkspace().getRegisteredUrls();
                    context.getRemoteWorkspace().modify(allRegisteredUrls, mapOfFiles -> mapOfFiles.forEach((url, rf) -> crashRemoteWorkspace.modify((String)url, crf -> {
                        crf.put(RemoteWorkspaceFile.VERSION, 0);
                        crf.put(RemoteWorkspaceFile.IS_OPENED, rf.isOpened());
                        crf.put(RemoteWorkspaceFile.REMOTE_COMPILATION_COMMAND, rf.getReparseParams());
                        crf.put(RemoteWorkspaceFile.IS_SAVED, rf.isSaved());
                        crf.put(RemoteWorkspaceFile.CONTENT, rf.getContent());
                    })));
                    service = new ClangdLanguageService(crashContext);
                    crashServiceConsumer.accept(service);
                    if (service == null) break block8;
                }
                catch (Throwable throwable) {
                    if (service != null) {
                        ClangReportUtils.stopService(service);
                    } else if (crashContext != null) {
                        Disposer.dispose((Disposable)crashContext);
                    }
                    throw throwable;
                }
                ClangReportUtils.stopService(service);
                break block9;
            }
            if (crashContext != null) {
                Disposer.dispose((Disposable)crashContext);
            }
        }
    }

    private static void stopService(@NotNull ClangLanguageService service) {
        if (service == null) {
            ClangReportUtils.$$$reportNull$$$0(13);
        }
        ClangStopData stopData = service.stop();
        try {
            stopData.exitCode.get(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.warn((Throwable)ex);
        }
        catch (TimeoutException ex) {
            LOG.info((Throwable)ex);
            stopData.killRunnable.run();
        }
    }

    private static void prepareAsIsReportImpl(@NotNull Set<String> processedFileUrls, @NotNull ClangLanguageService service, @NotNull List<String> fileUrls, @Nullable String moduleName, @NotNull Consumer<Map<String, String>> handler) throws IOException {
        if (processedFileUrls == null) {
            ClangReportUtils.$$$reportNull$$$0(14);
        }
        if (service == null) {
            ClangReportUtils.$$$reportNull$$$0(15);
        }
        if (fileUrls == null) {
            ClangReportUtils.$$$reportNull$$$0(16);
        }
        if (handler == null) {
            ClangReportUtils.$$$reportNull$$$0(17);
        }
        ArrayList<String> toProcess = new ArrayList<String>();
        for (String file : fileUrls) {
            if (!processedFileUrls.add(file)) continue;
            toProcess.add(file);
        }
        if (toProcess.isEmpty()) {
            return;
        }
        ClangPreprocessedReport report = ClangReportUtils.doPreprocess(service, toProcess);
        if (report != null) {
            for (ClangPreprocessedReport.PreprocessedFile ppFile : report.getPreprocessedFiles()) {
                if (ppFile.content == null) continue;
                Set<String> importedModules = ClangReportUtils.extractImportedModules(ppFile.content, moduleName);
                HashSet<String> paths = new HashSet<String>();
                Pattern regex = Pattern.compile("#\\s[0-9]+\\s\"([^\"]*?)\"");
                Matcher matcher = regex.matcher(ppFile.content);
                while (matcher.find()) {
                    String path = matcher.group(1);
                    if (StringUtil.isEmpty((String)path) || path.startsWith("<")) continue;
                    paths.add(Paths.get(ClangLanguageServiceUtils.unescapePath(path), new String[0]).normalize().toFile().getPath());
                }
                String mainFileName = PathUtilRt.getFileName((String)ppFile.getTargetPath(null));
                HashMap<String, String> file2Content = new HashMap<String, String>();
                ClangReportUtils.putCustomFile(file2Content, "CompilationInfo.txt", mainFileName, moduleName, ppFile.getCompilationInfoAsString(null));
                if (ppFile.lastDiagnostics != null) {
                    ClangReportUtils.putCustomFile(file2Content, "LastDiagnostics.txt", mainFileName, moduleName, ppFile.lastDiagnostics);
                }
                ClangReportUtils.putCustomFile(file2Content, "preprocessed.txt", mainFileName, moduleName, ppFile.getContent(null));
                ClangReportUtils.putCustomFile(file2Content, "clion_macros.txt", mainFileName, moduleName, ppFile.macros);
                ClangReportUtils.putCustomFile(file2Content, "clion_cpp20module.modulemap", mainFileName, moduleName, ppFile.cpp20ModuleMap);
                ClangReportUtils.putCustomFile(file2Content, "clion_module.modulemap", mainFileName, moduleName, ppFile.stdModuleMap);
                ClangReportUtils.collectFiles(ppFile, paths, file2Content);
                handler.accept(file2Content);
                Map<String, String> cpp20ModMap = ClangReportUtils.parseModuleMap(ppFile.cpp20ModuleMap);
                Map<String, String> stdModMap = ClangReportUtils.parseModuleMap(ppFile.stdModuleMap);
                for (String module : importedModules) {
                    VirtualFile entryVf;
                    String entryFile = cpp20ModMap.containsKey(module) ? cpp20ModMap.get(module) : stdModMap.get(module);
                    if (entryFile == null || (entryVf = VirtualFileManager.getInstance().findFileByNioPath(new File(entryFile).toPath())) == null) continue;
                    ClangReportUtils.prepareAsIsReportImpl(processedFileUrls, service, Collections.singletonList(entryVf.getUrl()), module, handler);
                }
            }
        }
    }

    private static void putCustomFile(@NotNull Map<String, String> file2Content, @NotNull String customFileName, @NotNull String mainFileName, @Nullable String moduleName, @NotNull String content) {
        if (file2Content == null) {
            ClangReportUtils.$$$reportNull$$$0(18);
        }
        if (customFileName == null) {
            ClangReportUtils.$$$reportNull$$$0(19);
        }
        if (mainFileName == null) {
            ClangReportUtils.$$$reportNull$$$0(20);
        }
        if (content == null) {
            ClangReportUtils.$$$reportNull$$$0(21);
        }
        String fileNameWithoutExt = FileUtilRt.getNameWithoutExtension((String)customFileName);
        String fileExt = FileUtilRt.getExtension((String)customFileName);
        String newFileName = fileNameWithoutExt + "_" + mainFileName + "." + fileExt;
        if (moduleName != null) {
            newFileName = "module_" + moduleName.replace(':', '.') + "/" + newFileName;
        }
        file2Content.put(newFileName, content);
    }

    @NotNull
    private static Set<String> extractImportedModules(@NotNull String ppContent, @Nullable String currentModule) {
        if (ppContent == null) {
            ClangReportUtils.$$$reportNull$$$0(22);
        }
        HashSet<String> modules = new HashSet<String>();
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.CPP).allowAvailabilityExpression().allowGccAutoType().allowMsvcExtensions().allowNullabilityKeywords().setLanguageStandard(OCLanguageStandard.latestCpp()).build());
        lexer.start((CharSequence)ppContent);
        IElementType tt = lexer.getTokenType();
        while (tt != null) {
            if (tt == OCLexerTokenTypes.IMPORT_MODULE_KEYWORD) {
                tt = CidrLexerUtils.goToNextSignificantToken((OCLexer)lexer);
                StringBuilder sb = new StringBuilder();
                if (tt == OCLexerTokenTypes.COLON && currentModule != null) {
                    sb.append(currentModule).append(lexer.getTokenText());
                    tt = CidrLexerUtils.goToNextSignificantToken((OCLexer)lexer);
                }
                while (tt == OCLexerTokenTypes.IDENTIFIER || tt == OCLexerTokenTypes.DOT) {
                    sb.append(lexer.getTokenText());
                    tt = CidrLexerUtils.goToNextSignificantToken((OCLexer)lexer);
                }
                if (tt != OCLexerTokenTypes.SEMICOLON || sb.isEmpty()) continue;
                modules.add(sb.toString());
                continue;
            }
            lexer.advance();
            tt = lexer.getTokenType();
        }
        Pattern regex = Pattern.compile("#pragma clang module import \"([\\w.]+?)\"");
        Matcher matcher = regex.matcher(ppContent);
        while (matcher.find()) {
            String module = matcher.group(1);
            if (StringUtil.isEmpty((String)module)) continue;
            modules.add(module);
        }
        HashSet<String> hashSet = modules;
        if (hashSet == null) {
            ClangReportUtils.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, String> parseModuleMap(@NotNull String moduleMapContent) {
        if (moduleMapContent == null) {
            ClangReportUtils.$$$reportNull$$$0(24);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern regex = Pattern.compile("module ([\\w.:]+) \\{\\s+header \"(.*?)\"\\s+}");
        Matcher matcher = regex.matcher(moduleMapContent);
        while (matcher.find()) {
            String module = matcher.group(1);
            String entryFile = matcher.group(2);
            if (StringUtil.isEmpty((String)module) || StringUtil.isEmpty((String)entryFile)) continue;
            map.put(module, entryFile);
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            ClangReportUtils.$$$reportNull$$$0(25);
        }
        return hashMap;
    }

    @Nullable
    private static ClangPreprocessedReport doPreprocess(@NotNull ClangLanguageService service, @NotNull List<String> fileUrls) {
        if (service == null) {
            ClangReportUtils.$$$reportNull$$$0(26);
        }
        if (fileUrls == null) {
            ClangReportUtils.$$$reportNull$$$0(27);
        }
        try {
            return (ClangPreprocessedReport)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(service.generatePreprocessedReport(fileUrls, true), (String)"preprocessed report");
        }
        catch (ExecutionException ex) {
            ClangUtils.LOG.warn((Throwable)ex);
            return null;
        }
    }

    private static void collectFiles(@NotNull ClangPreprocessedReport.PreprocessedFile ppFile, @NotNull Collection<String> paths, @NotNull Map<String, String> file2Content) throws IOException {
        if (ppFile == null) {
            ClangReportUtils.$$$reportNull$$$0(28);
        }
        if (paths == null) {
            ClangReportUtils.$$$reportNull$$$0(29);
        }
        if (file2Content == null) {
            ClangReportUtils.$$$reportNull$$$0(30);
        }
        for (String path : paths) {
            if (ClangRequestsHelper.isMacroPath(path)) {
                file2Content.put(path, ppFile.macros);
                continue;
            }
            if (!FileUtil.exists((String)path)) continue;
            file2Content.put(path, FileUtilRt.loadFile((File)new File(path)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 9, 10, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 5: 
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrls";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangReportUtils";
                break;
            }
            case 7: 
            case 18: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2Content";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crashServiceConsumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedFileUrls";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customFileName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainFileName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ppContent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMapContent";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ppFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangReportUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePreprocessedReport";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareAsIsReport";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWindowsPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "extractImportedModules";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseModuleMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preparePreprocessedReport";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 23: 
            case 25: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareAsIsReport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "makeZipArchive";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertWindowsPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withCrashLanguageService";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stopService";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareAsIsReportImpl";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putCustomFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractImportedModules";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseModuleMap";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doPreprocess";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 9, 10, 23, 25 -> new IllegalStateException(string);
        };
    }
}

