/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool.sdkmanager;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.sdklib.tool.sdkmanager.InstallAction;
import com.android.sdklib.tool.sdkmanager.SdkAction;
import com.android.sdklib.tool.sdkmanager.SdkManagerCliSettings;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class UpdateAction
extends InstallAction {
    public static final String ACTION_ARG = "--update";

    private UpdateAction(SdkManagerCliSettings settings) {
        super(settings);
    }

    @Override
    public List<String> getPaths(RepoManager mgr) {
        List<String> toUpdate = mgr.getPackages().getUpdatedPkgs().stream().filter(p -> this.mSettings.includeObsolete() || !p.getRemote().obsolete()).map(p -> p.getRepresentative().getPath()).collect(Collectors.toList());
        PrintStream out = this.mSettings.getOutputStream();
        out.println();
        out.flush();
        if (toUpdate.isEmpty()) {
            out.println("No updates available");
        } else {
            out.println("Updating:");
            for (String pack : toUpdate) {
                out.println(pack);
            }
        }
        out.flush();
        return toUpdate;
    }

    @Override
    boolean consumeArgument(String arg, ProgressIndicator progress2) {
        return false;
    }

    public static void register(Map<String, Function<SdkManagerCliSettings, SdkAction>> argToFactory) {
        argToFactory.put(ACTION_ARG, UpdateAction::new);
    }
}

