/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.annotations.concurrency.Slow;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.Revision;
import com.android.repository.api.ConstantSourceProvider;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemoteListSourceProvider;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.sources.LocalSourceProvider;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.AndroidSdkHandlerKt;
import com.android.sdklib.repository.legacy.LegacyLocalRepoLoader;
import com.android.sdklib.repository.legacy.LegacyRemoteRepoLoader;
import com.android.sdklib.repository.meta.AddonFactory;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.meta.RepoFactory;
import com.android.sdklib.repository.meta.SdkCommonFactory;
import com.android.sdklib.repository.meta.SysImgFactory;
import com.android.sdklib.repository.sources.RemoteSiteType;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.sdklib.repository.targets.SystemImageManager;
import com.android.sdklib.util.CacheByCanonicalPath;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 62\u00020\u0001:\u00043456B5\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017J0\u0010!\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020 2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017J0\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\"\u001a\u00020 2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010,\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010-\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'J(\u0010-\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010&\u001a\u00020'J\u0018\u0010.\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u000202J\u000e\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020 R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/sdklib/repository/AndroidSdkHandler;", "", "location", "Ljava/nio/file/Path;", "androidFolder", "repoManager", "Lcom/android/repository/api/RepoManager;", "userSourceProvider", "Lcom/android/repository/impl/sources/LocalSourceProvider;", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/android/repository/api/RepoManager;Lcom/android/repository/impl/sources/LocalSourceProvider;)V", "getLocation", "()Ljava/nio/file/Path;", "getAndroidFolder", "lock", "systemImageManager", "Lcom/android/sdklib/repository/targets/SystemImageManager;", "androidTargetManager", "Lcom/android/sdklib/repository/targets/AndroidTargetManager;", "latestBuildTool", "Lcom/android/sdklib/BuildToolInfo;", "getRepoManagerAndLoadSynchronously", "progress", "Lcom/android/repository/api/ProgressIndicator;", "getRepoManager", "getSystemImageManager", "clearSystemImageManagerCache", "", "getAndroidTargetManager", "getLocalPackage", "Lcom/android/repository/api/LocalPackage;", "path", "", "getLatestLocalPackageForPrefix", "prefix", "filter", "Ljava/util/function/Predicate;", "Lcom/android/repository/Revision;", "allowPreview", "", "getLatestRemotePackageForPrefix", "Lcom/android/repository/api/RemotePackage;", "getRemoteListSourceProvider", "Lcom/android/repository/api/RemoteListSourceProvider;", "getUserSourceProvider", "getLatestBuildTool", "getBuildToolInfo", "revision", "toCompatiblePath", "file", "Ljava/io/File;", "RepoConfig", "InstanceProvider", "DefaultInstanceProvider", "Companion", "android.sdktools.sdklib"})
@SourceDebugExtension(value={"SMAP\nAndroidSdkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSdkHandler.kt\ncom/android/sdklib/repository/AndroidSdkHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,647:1\n1#2:648\n*E\n"})
public final class AndroidSdkHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path location;
    @Nullable
    private final Path androidFolder;
    @Nullable
    private RepoManager repoManager;
    @Nullable
    private LocalSourceProvider userSourceProvider;
    @NotNull
    private final Object lock;
    @Nullable
    private SystemImageManager systemImageManager;
    @Nullable
    private AndroidTargetManager androidTargetManager;
    @Nullable
    private BuildToolInfo latestBuildTool;
    @NotNull
    private static final SchemaModule<AddonFactory> addonModule = new SchemaModule("com.android.sdklib.repository.generated.addon.v%d.ObjectFactory", "/xsd/sdk-addon-%02d.xsd", AndroidSdkHandler.class);
    @NotNull
    private static final SchemaModule<RepoFactory> repositoryModule = new SchemaModule("com.android.sdklib.repository.generated.repository.v%d.ObjectFactory", "/xsd/sdk-repository-%02d.xsd", AndroidSdkHandler.class);
    @NotNull
    private static final SchemaModule<SysImgFactory> sysImgModule = new SchemaModule("com.android.sdklib.repository.generated.sysimg.v%d.ObjectFactory", "/xsd/sdk-sys-img-%02d.xsd", AndroidSdkHandler.class);
    @NotNull
    private static final SchemaModule<SdkCommonFactory> commonModule = new SchemaModule("com.android.sdklib.repository.generated.common.v%d.ObjectFactory", "/xsd/sdk-common-%02d.xsd", AndroidSdkHandler.class);
    @NotNull
    private static final String URL_GOOGLE_SDK_SITE = "https://dl.google.com/android/repository/";
    @NotNull
    private static final String CUSTOM_SOURCE_PROPERTY = "android.sdk.custom.url";
    @NotNull
    public static final String SDK_TEST_BASE_URL_ENV_VAR = "SDK_TEST_BASE_URL";
    @NotNull
    public static final String SDK_TEST_BASE_URL_PROPERTY = "sdk.test.base.url";
    @NotNull
    public static final String LOCAL_ADDONS_FILENAME = "repositories.cfg";
    @NotNull
    private static final String DEFAULT_SITE_LIST_FILENAME_PATTERN = "addons_list-%d.xml";
    @NotNull
    private static InstanceProvider instanceProvider = DefaultInstanceProvider.INSTANCE;
    @Nullable
    private static RepoConfig repoConfig;

    @VisibleForTesting
    @JvmOverloads
    public AndroidSdkHandler(@Nullable Path location, @Nullable Path androidFolder, @Nullable RepoManager repoManager, @Nullable LocalSourceProvider userSourceProvider) {
        this.location = location;
        this.androidFolder = androidFolder;
        this.repoManager = repoManager;
        this.userSourceProvider = userSourceProvider;
        this.lock = new Object();
    }

    public /* synthetic */ AndroidSdkHandler(Path path, Path path2, RepoManager repoManager, LocalSourceProvider localSourceProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            repoManager = null;
        }
        if ((n & 8) != 0) {
            localSourceProvider = null;
        }
        this(path, path2, repoManager, localSourceProvider);
    }

    @Nullable
    public final Path getLocation() {
        return this.location;
    }

    @Nullable
    public final Path getAndroidFolder() {
        return this.androidFolder;
    }

    @Slow
    @NotNull
    public final RepoManager getRepoManagerAndLoadSynchronously(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        RepoManager result = this.getRepoManager(progress2);
        if (this.location != null) {
            result.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress2, null, null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RepoManager getRepoManager(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                RepoManager repoManager = this.repoManager;
                if (repoManager == null) break block4;
                RepoManager it = repoManager;
                boolean bl2 = false;
                RepoManager repoManager2 = it;
                return repoManager2;
            }
            this.systemImageManager = null;
            this.androidTargetManager = null;
            this.latestBuildTool = null;
            RepoManager newRepoManager = AndroidSdkHandler.Companion.getRepoConfig(progress2).createRepoManager(this.location, this.getUserSourceProvider(progress2));
            newRepoManager.addLocalChangeListener(arg_0 -> AndroidSdkHandler.getRepoManager$lambda$3$lambda$2(this, arg_0));
            this.repoManager = newRepoManager;
            RepoManager repoManager = newRepoManager;
            return repoManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SystemImageManager getSystemImageManager(@NotNull ProgressIndicator progress2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        Object object2 = this.lock;
        synchronized (object2) {
            block8: {
                boolean bl = false;
                SystemImageManager systemImageManager = this.systemImageManager;
                if (systemImageManager == null) break block8;
                SystemImageManager it = systemImageManager;
                boolean bl2 = false;
                SystemImageManager systemImageManager2 = it;
                return systemImageManager2;
            }
            object = null;
        }
        RepoManager rm = this.getRepoManagerAndLoadSynchronously(progress2);
        object = this.lock;
        synchronized (object) {
            boolean bl = false;
            SystemImageManager systemImageManager = this.systemImageManager;
            if (systemImageManager == null) {
                SystemImageManager systemImageManager3;
                SystemImageManager it = systemImageManager3 = new SystemImageManager(rm, (SysImgFactory)sysImgModule.createLatestFactory());
                boolean bl3 = false;
                this.systemImageManager = it;
                systemImageManager = systemImageManager3;
            }
            SystemImageManager systemImageManager4 = systemImageManager;
            return systemImageManager4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearSystemImageManagerCache() {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            SystemImageManager systemImageManager = this.systemImageManager;
            if (systemImageManager != null) {
                systemImageManager.clearCache();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AndroidTargetManager getAndroidTargetManager(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            AndroidTargetManager androidTargetManager = this.androidTargetManager;
            if (androidTargetManager == null) {
                AndroidTargetManager androidTargetManager2;
                AndroidTargetManager it = androidTargetManager2 = new AndroidTargetManager(this);
                boolean bl2 = false;
                this.androidTargetManager = it;
                androidTargetManager = androidTargetManager2;
            }
            AndroidTargetManager androidTargetManager3 = androidTargetManager;
            return androidTargetManager3;
        }
    }

    @Nullable
    public final LocalPackage getLocalPackage(@NotNull String path, @NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        return (LocalPackage)this.getRepoManagerAndLoadSynchronously(progress2).getPackages().getLocalPackages().get(path);
    }

    @Nullable
    public final LocalPackage getLatestLocalPackageForPrefix(@NotNull String prefix, @Nullable Predicate<Revision> filter, boolean allowPreview, @NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        Collection collection = this.getRepoManagerAndLoadSynchronously(progress2).getPackages().getLocalPackagesForPrefix(prefix);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLocalPackagesForPrefix(...)");
        return (LocalPackage)Companion.getLatestPackageFromPrefixCollection(collection, (Function1<? super Revision, Boolean>)AndroidSdkHandlerKt.access$toFunction(filter), allowPreview, getLatestLocalPackageForPrefix.1.INSTANCE);
    }

    @Nullable
    public final RemotePackage getLatestRemotePackageForPrefix(@NotNull String prefix, @Nullable Predicate<Revision> filter, boolean allowPreview, @NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        Collection collection = this.getRepoManager(progress2).getPackages().getRemotePackagesForPrefix(prefix);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRemotePackagesForPrefix(...)");
        return (RemotePackage)Companion.getLatestPackageFromPrefixCollection(collection, (Function1<? super Revision, Boolean>)AndroidSdkHandlerKt.access$toFunction(filter), allowPreview, getLatestRemotePackageForPrefix.1.INSTANCE);
    }

    @VisibleForTesting
    @NotNull
    public final RemoteListSourceProvider getRemoteListSourceProvider(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        return AndroidSdkHandler.Companion.getRepoConfig(progress2).getRemoteListSourceProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final LocalSourceProvider getUserSourceProvider(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.userSourceProvider == null && this.androidFolder != null) {
                LocalSourceProvider localSourceProvider;
                LocalSourceProvider localSourceProvider2 = localSourceProvider = Companion.createUserSourceProvider(this.androidFolder);
                AndroidSdkHandler androidSdkHandler = this;
                boolean bl2 = false;
                RepoManager repoManager = this.repoManager;
                if (repoManager != null) {
                    void it;
                    RepoManager p0 = repoManager;
                    boolean bl3 = false;
                    it.setRepoManager(p0);
                }
                androidSdkHandler.userSourceProvider = localSourceProvider;
            }
            LocalSourceProvider localSourceProvider = this.userSourceProvider;
            return localSourceProvider;
        }
    }

    @Nullable
    public final BuildToolInfo getLatestBuildTool(@NotNull ProgressIndicator progress2, boolean allowPreview) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        return this.getLatestBuildTool(progress2, null, allowPreview);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final BuildToolInfo getLatestBuildTool(@NotNull ProgressIndicator progress2, @Nullable Predicate<Revision> filter, boolean allowPreview) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        Object object = this.lock;
        synchronized (object) {
            block9: {
                boolean bl = false;
                if (allowPreview || this.latestBuildTool == null) break block9;
                BuildToolInfo buildToolInfo = this.latestBuildTool;
                return buildToolInfo;
            }
            Unit unit = Unit.INSTANCE;
        }
        LocalPackage localPackage = this.getLatestLocalPackageForPrefix("build-tools", filter, allowPreview, progress2);
        if (localPackage == null) {
            return null;
        }
        LocalPackage latestBuildToolPackage = localPackage;
        BuildToolInfo buildToolInfo = BuildToolInfo.fromLocalPackage(latestBuildToolPackage);
        Intrinsics.checkNotNullExpressionValue((Object)buildToolInfo, (String)"fromLocalPackage(...)");
        BuildToolInfo latestBuildTool = buildToolInfo;
        if (!latestBuildToolPackage.getVersion().isPreview()) {
            Object object2 = this.lock;
            synchronized (object2) {
                boolean bl = false;
                this.latestBuildTool = latestBuildTool;
                Unit unit = Unit.INSTANCE;
            }
        }
        return latestBuildTool;
    }

    @Nullable
    public final BuildToolInfo getBuildToolInfo(@NotNull Revision revision, @NotNull ProgressIndicator progress2) {
        BuildToolInfo buildToolInfo;
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        LocalPackage localPackage = (LocalPackage)this.getRepoManagerAndLoadSynchronously(progress2).getPackages().getLocalPackages().get(DetailsTypes.getBuildToolsPath(revision));
        if (localPackage != null) {
            LocalPackage it = localPackage;
            boolean bl = false;
            buildToolInfo = BuildToolInfo.fromLocalPackage(it);
        } else {
            buildToolInfo = null;
        }
        return buildToolInfo;
    }

    @NotNull
    public final Path toCompatiblePath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.location != null) {
            Path path = this.location.getFileSystem().getPath(file.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
            return path;
        }
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @NotNull
    public final Path toCompatiblePath(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.location != null) {
            Path path = this.location.getFileSystem().getPath(file, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
            return path;
        }
        Path path = Paths.get(file, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @VisibleForTesting
    @JvmOverloads
    public AndroidSdkHandler(@Nullable Path location, @Nullable Path androidFolder, @Nullable RepoManager repoManager) {
        this(location, androidFolder, repoManager, null, 8, null);
    }

    @VisibleForTesting
    @JvmOverloads
    public AndroidSdkHandler(@Nullable Path location, @Nullable Path androidFolder) {
        this(location, androidFolder, null, null, 12, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getRepoManager$lambda$3$lambda$2(AndroidSdkHandler this$0, RepositoryPackages it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            this$0.systemImageManager = null;
            this$0.androidTargetManager = null;
            this$0.latestBuildTool = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public static final SchemaModule<AddonFactory> getAddonModule() {
        return Companion.getAddonModule();
    }

    @NotNull
    public static final SchemaModule<RepoFactory> getRepositoryModule() {
        return Companion.getRepositoryModule();
    }

    @NotNull
    public static final SchemaModule<SysImgFactory> getSysImgModule() {
        return Companion.getSysImgModule();
    }

    @NotNull
    public static final SchemaModule<SdkCommonFactory> getCommonModule() {
        return Companion.getCommonModule();
    }

    @JvmStatic
    @NotNull
    public static final AndroidSdkHandler getInstance(@NotNull AndroidLocationsProvider locationProvider, @Nullable Path localPath) {
        return Companion.getInstance(locationProvider, localPath);
    }

    @JvmStatic
    public static final void reset() {
        Companion.reset();
    }

    @JvmStatic
    @Nullable
    public static final <P extends RepoPackage, T extends Comparable<? super T>> P getLatestPackageFromPrefixCollection(@NotNull Collection<? extends P> packages, @NotNull Function1<? super Revision, Boolean> filter, boolean allowPreview, @NotNull Function1<? super String, ? extends T> mapper) {
        return Companion.getLatestPackageFromPrefixCollection(packages, filter, allowPreview, mapper);
    }

    @JvmStatic
    @Nullable
    public static final <P extends RepoPackage, T extends Comparable<? super T>> P getLatestPackageFromPrefixCollection(@NotNull Collection<? extends P> packages, boolean allowPreview, @NotNull Function1<? super String, ? extends T> mapper) {
        return Companion.getLatestPackageFromPrefixCollection(packages, allowPreview, mapper);
    }

    @JvmStatic
    @NotNull
    public static final List<SchemaModule<?>> getAllModules() {
        return Companion.getAllModules();
    }

    @JvmStatic
    @NotNull
    public static final LocalSourceProvider createUserSourceProvider(@NotNull Path androidFolder) {
        return Companion.createUserSourceProvider(androidFolder);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0007J\b\u0010-\u001a\u00020.H\u0007Ji\u0010/\u001a\u0004\u0018\u0001H0\"\b\b\u0000\u00100*\u000201\"\u000e\b\u0001\u00102*\b\u0012\u0004\u0012\u0002H2032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H0052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000209072\u0006\u0010:\u001a\u0002092\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u0001H207H\u0007\u00a2\u0006\u0002\u0010<JU\u0010/\u001a\u0004\u0018\u0001H0\"\b\b\u0000\u00100*\u000201\"\u000e\b\u0001\u00102*\b\u0012\u0004\u0012\u0002H2032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H0052\u0006\u0010:\u001a\u0002092\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u0001H207H\u0007\u00a2\u0006\u0002\u0010=J\u0012\u0010>\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050?H\u0007J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020,H\u0007J\u0010\u0010C\u001a\u00020&2\u0006\u0010D\u001a\u00020EH\u0002R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\tR\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\tR\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\tR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u00020\u00178\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u0003R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/android/sdklib/repository/AndroidSdkHandler$Companion;", "", "<init>", "()V", "addonModule", "Lcom/android/repository/api/SchemaModule;", "Lcom/android/sdklib/repository/meta/AddonFactory;", "getAddonModule$annotations", "getAddonModule", "()Lcom/android/repository/api/SchemaModule;", "repositoryModule", "Lcom/android/sdklib/repository/meta/RepoFactory;", "getRepositoryModule$annotations", "getRepositoryModule", "sysImgModule", "Lcom/android/sdklib/repository/meta/SysImgFactory;", "getSysImgModule$annotations", "getSysImgModule", "commonModule", "Lcom/android/sdklib/repository/meta/SdkCommonFactory;", "getCommonModule$annotations", "getCommonModule", "URL_GOOGLE_SDK_SITE", "", "CUSTOM_SOURCE_PROPERTY", "SDK_TEST_BASE_URL_ENV_VAR", "SDK_TEST_BASE_URL_PROPERTY", "LOCAL_ADDONS_FILENAME", "getLOCAL_ADDONS_FILENAME$annotations", "DEFAULT_SITE_LIST_FILENAME_PATTERN", "value", "Lcom/android/sdklib/repository/AndroidSdkHandler$InstanceProvider;", "instanceProvider", "getInstanceProvider$android_sdktools_sdklib", "()Lcom/android/sdklib/repository/AndroidSdkHandler$InstanceProvider;", "setInstanceProvider$android_sdktools_sdklib", "(Lcom/android/sdklib/repository/AndroidSdkHandler$InstanceProvider;)V", "repoConfig", "Lcom/android/sdklib/repository/AndroidSdkHandler$RepoConfig;", "getInstance", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "locationProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "localPath", "Ljava/nio/file/Path;", "reset", "", "getLatestPackageFromPrefixCollection", "P", "Lcom/android/repository/api/RepoPackage;", "T", "", "packages", "", "filter", "Lkotlin/Function1;", "Lcom/android/repository/Revision;", "", "allowPreview", "mapper", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;ZLkotlin/jvm/functions/Function1;)Lcom/android/repository/api/RepoPackage;", "(Ljava/util/Collection;ZLkotlin/jvm/functions/Function1;)Lcom/android/repository/api/RepoPackage;", "getAllModules", "", "createUserSourceProvider", "Lcom/android/repository/impl/sources/LocalSourceProvider;", "androidFolder", "getRepoConfig", "progress", "Lcom/android/repository/api/ProgressIndicator;", "android.sdktools.sdklib"})
    @SourceDebugExtension(value={"SMAP\nAndroidSdkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSdkHandler.kt\ncom/android/sdklib/repository/AndroidSdkHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,647:1\n774#2:648\n865#2,2:649\n1617#2,9:651\n1869#2:660\n1870#2:663\n1626#2:664\n1999#2,14:665\n1#3:661\n1#3:662\n*S KotlinDebug\n*F\n+ 1 AndroidSdkHandler.kt\ncom/android/sdklib/repository/AndroidSdkHandler$Companion\n*L\n597#1:648\n597#1:649,2\n598#1:651,9\n598#1:660\n598#1:663\n598#1:664\n602#1:665,14\n598#1:662\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SchemaModule<AddonFactory> getAddonModule() {
            return addonModule;
        }

        @JvmStatic
        public static /* synthetic */ void getAddonModule$annotations() {
        }

        @NotNull
        public final SchemaModule<RepoFactory> getRepositoryModule() {
            return repositoryModule;
        }

        @JvmStatic
        public static /* synthetic */ void getRepositoryModule$annotations() {
        }

        @NotNull
        public final SchemaModule<SysImgFactory> getSysImgModule() {
            return sysImgModule;
        }

        @JvmStatic
        public static /* synthetic */ void getSysImgModule$annotations() {
        }

        @NotNull
        public final SchemaModule<SdkCommonFactory> getCommonModule() {
            return commonModule;
        }

        @JvmStatic
        public static /* synthetic */ void getCommonModule$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getLOCAL_ADDONS_FILENAME$annotations() {
        }

        @NotNull
        public final InstanceProvider getInstanceProvider$android_sdktools_sdklib() {
            return instanceProvider;
        }

        @TestOnly
        public final void setInstanceProvider$android_sdktools_sdklib(@NotNull InstanceProvider instanceProvider) {
            Intrinsics.checkNotNullParameter((Object)instanceProvider, (String)"<set-?>");
            AndroidSdkHandler.instanceProvider = instanceProvider;
        }

        @JvmStatic
        @NotNull
        public final AndroidSdkHandler getInstance(@NotNull AndroidLocationsProvider locationProvider, @Nullable Path localPath) {
            Intrinsics.checkNotNullParameter((Object)locationProvider, (String)"locationProvider");
            return this.getInstanceProvider$android_sdktools_sdklib().getInstance(locationProvider, localPath);
        }

        @JvmStatic
        public final void reset() {
            this.getInstanceProvider$android_sdktools_sdklib().reset();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final <P extends RepoPackage, T extends Comparable<? super T>> P getLatestPackageFromPrefixCollection(@NotNull Collection<? extends P> packages, @NotNull Function1<? super Revision, Boolean> filter, boolean allowPreview, @NotNull Function1<? super String, ? extends T> mapper) {
            Object v3;
            void $this$maxByOrNull$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter(packages, (String)"packages");
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            Iterable iterable = packages;
            boolean $i$f$filter = false;
            void var8_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (RepoPackage)element$iv$iv;
                boolean bl = false;
                Revision revision = it.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"getVersion(...)");
                if (!((Boolean)filter.invoke((Object)revision) != false && (allowPreview || !it.getVersion().isPreview()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                Pair pair;
                String suffix;
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl = false;
                RepoPackage pkg = (RepoPackage)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)pkg.getPath(), (String)"getPath(...)");
                String string2 = pkg.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                int n = StringsKt.lastIndexOf$default((CharSequence)string2, (char)';', (int)0, (boolean)false, (int)6, null) + 1;
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(n), (String)"substring(...)");
                if ((Comparable)mapper.invoke((Object)suffix) != null) {
                    Comparable it2;
                    boolean bl3 = false;
                    pair = TuplesKt.to((Object)pkg, (Object)it2);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = maxElem$iv;
                } else {
                    Pair it3 = (Pair)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = (Comparable)it3.getSecond();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it4 = (Pair)e$iv;
                        $i$a$-maxByOrNull-AndroidSdkHandler$Companion$getLatestPackageFromPrefixCollection$3 = false;
                        Comparable v$iv = (Comparable)it4.getSecond();
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = maxElem$iv;
                }
            }
            Pair pair = v3;
            return (P)(pair != null ? (RepoPackage)pair.getFirst() : null);
        }

        @JvmStatic
        @Nullable
        public final <P extends RepoPackage, T extends Comparable<? super T>> P getLatestPackageFromPrefixCollection(@NotNull Collection<? extends P> packages, boolean allowPreview, @NotNull Function1<? super String, ? extends T> mapper) {
            Intrinsics.checkNotNullParameter(packages, (String)"packages");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            return this.getLatestPackageFromPrefixCollection(packages, (Function1<? super Revision, Boolean>)((Function1)Companion::getLatestPackageFromPrefixCollection$lambda$4), allowPreview, mapper);
        }

        @JvmStatic
        @NotNull
        public final List<SchemaModule<?>> getAllModules() {
            Object[] objectArray = new SchemaModule[]{this.getRepositoryModule(), this.getAddonModule(), this.getSysImgModule(), this.getCommonModule(), RepoManager.Companion.getCommonModule(), RepoManager.Companion.getGenericModule()};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @JvmStatic
        @NotNull
        public final LocalSourceProvider createUserSourceProvider(@NotNull Path androidFolder) {
            Intrinsics.checkNotNullParameter((Object)androidFolder, (String)"androidFolder");
            Object[] objectArray = new SchemaModule[]{this.getSysImgModule(), this.getAddonModule()};
            Collection collection = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new SchemaModule[]{this.getSysImgModule(), this.getAddonModule(), this.getRepositoryModule(), this.getCommonModule()};
            return new LocalSourceProvider(androidFolder.resolve(AndroidSdkHandler.LOCAL_ADDONS_FILENAME), collection, (Collection)CollectionsKt.listOf((Object[])objectArray));
        }

        private final synchronized RepoConfig getRepoConfig(ProgressIndicator progress2) {
            RepoConfig repoConfig = repoConfig;
            if (repoConfig == null) {
                RepoConfig repoConfig2;
                RepoConfig it = repoConfig2 = new RepoConfig(progress2);
                boolean bl = false;
                AndroidSdkHandler.repoConfig = it;
                repoConfig = repoConfig2;
            }
            return repoConfig;
        }

        private static final boolean getLatestPackageFromPrefixCollection$lambda$4(Revision revision) {
            Intrinsics.checkNotNullParameter((Object)revision, (String)"<unused var>");
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/sdklib/repository/AndroidSdkHandler$DefaultInstanceProvider;", "Lcom/android/sdklib/repository/AndroidSdkHandler$InstanceProvider;", "<init>", "()V", "instances", "Lcom/android/sdklib/util/CacheByCanonicalPath;", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "getInstance", "locationProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "localPath", "Ljava/nio/file/Path;", "reset", "", "android.sdktools.sdklib"})
    @SourceDebugExtension(value={"SMAP\nAndroidSdkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSdkHandler.kt\ncom/android/sdklib/repository/AndroidSdkHandler$DefaultInstanceProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,647:1\n1#2:648\n*E\n"})
    public static final class DefaultInstanceProvider
    implements InstanceProvider {
        @NotNull
        public static final DefaultInstanceProvider INSTANCE = new DefaultInstanceProvider();
        @NotNull
        private static final CacheByCanonicalPath<AndroidSdkHandler> instances = new CacheByCanonicalPath();

        private DefaultInstanceProvider() {
        }

        @Override
        @NotNull
        public AndroidSdkHandler getInstance(@NotNull AndroidLocationsProvider locationProvider, @Nullable Path localPath) {
            Intrinsics.checkNotNullParameter((Object)locationProvider, (String)"locationProvider");
            return instances.computeIfAbsent(localPath, (Function1<Path, AndroidSdkHandler>)((Function1)arg_0 -> DefaultInstanceProvider.getInstance$lambda$1(locationProvider, arg_0)));
        }

        @Override
        public void reset() {
            instances.clear();
        }

        private static final AndroidSdkHandler getInstance$lambda$1(AndroidLocationsProvider $locationProvider, Path canonicalKey) {
            Object object;
            Object object2 = INSTANCE;
            try {
                DefaultInstanceProvider $this$getInstance_u24lambda_u241_u24lambda_u240 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)$locationProvider.getPrefsLocation());
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            Path androidFolder = (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
            return new AndroidSdkHandler(canonicalKey, androidFolder, null, null, 12, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/android/sdklib/repository/AndroidSdkHandler$InstanceProvider;", "", "getInstance", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "locationProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "localPath", "Ljava/nio/file/Path;", "reset", "", "android.sdktools.sdklib"})
    public static interface InstanceProvider {
        @NotNull
        public AndroidSdkHandler getInstance(@NotNull AndroidLocationsProvider var1, @Nullable Path var2);

        default public void reset() {
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static void reset(@NotNull InstanceProvider $this) {
                $this.reset();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/android/sdklib/repository/AndroidSdkHandler$RepoConfig;", "", "progress", "Lcom/android/repository/api/ProgressIndicator;", "<init>", "(Lcom/android/repository/api/ProgressIndicator;)V", "addonsListSourceProvider", "Lcom/android/repository/api/RemoteListSourceProvider;", "repositorySourceProvider", "Lcom/android/repository/api/ConstantSourceProvider;", "prevRepositorySourceProvider", "remoteListSourceProvider", "getRemoteListSourceProvider", "()Lcom/android/repository/api/RemoteListSourceProvider;", "createRepoManager", "Lcom/android/repository/api/RepoManager;", "localLocation", "Ljava/nio/file/Path;", "userProvider", "Lcom/android/repository/impl/sources/LocalSourceProvider;", "Companion", "android.sdktools.sdklib"})
    @SourceDebugExtension(value={"SMAP\nAndroidSdkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSdkHandler.kt\ncom/android/sdklib/repository/AndroidSdkHandler$RepoConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,647:1\n1#2:648\n*E\n"})
    private static final class RepoConfig {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final RemoteListSourceProvider addonsListSourceProvider;
        @NotNull
        private final ConstantSourceProvider repositorySourceProvider;
        @Nullable
        private final ConstantSourceProvider prevRepositorySourceProvider;

        /*
         * WARNING - void declaration
         */
        public RepoConfig(@NotNull ProgressIndicator progress2) {
            ConstantSourceProvider constantSourceProvider;
            SchemaModule[] schemaModuleArray;
            RepoConfig repoConfig;
            Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
            SchemaModule addonListModule = new SchemaModule("com.android.sdklib.repository.sources.generated.v%d.ObjectFactory", "/xsd/sources/sdk-sites-list-%d.xsd", RemoteSiteType.class);
            RepoConfig repoConfig2 = this;
            try {
                repoConfig = repoConfig2;
                schemaModuleArray = new RemoteListSourceProvider[]{TuplesKt.to(RemoteSiteType.AddonSiteType.class, (Object)SetsKt.setOf(Companion.getAddonModule())), TuplesKt.to(RemoteSiteType.SysImgSiteType.class, (Object)SetsKt.setOf(Companion.getSysImgModule()))};
                schemaModuleArray = RemoteListSourceProvider.create((String)RepoConfig.Companion.getAddonListUrl(progress2), (SchemaModule)addonListModule, (Map)MapsKt.mapOf((Pair[])schemaModuleArray));
            }
            catch (URISyntaxException uRISyntaxException) {
                void e;
                repoConfig = repoConfig2;
                progress2.logError("Failed to set up addons source provider", (Throwable)e);
                schemaModuleArray = null;
            }
            repoConfig.addonsListSourceProvider = schemaModuleArray;
            schemaModuleArray = new SchemaModule[]{Companion.getRepositoryModule(), RepoManager.Companion.getGenericModule()};
            this.repositorySourceProvider = new ConstantSourceProvider(RepoConfig.Companion.getRepoUrl(progress2, Companion.getRepositoryModule().getNamespaceVersionMap().size()), "Android Repository", (Collection)SetsKt.setOf((Object[])schemaModuleArray));
            int prevRev = Companion.getRepositoryModule().getNamespaceVersionMap().size() - 1;
            if (prevRev <= 0) {
                constantSourceProvider = null;
            } else {
                Object[] objectArray = new SchemaModule[]{Companion.getRepositoryModule(), RepoManager.Companion.getGenericModule()};
                ConstantSourceProvider constantSourceProvider2 = new ConstantSourceProvider(RepoConfig.Companion.getRepoUrl(progress2, prevRev), "Android Repository v" + prevRev, (Collection)SetsKt.setOf((Object[])objectArray));
                constantSourceProvider = constantSourceProvider2;
            }
            this.prevRepositorySourceProvider = constantSourceProvider;
        }

        @NotNull
        public final RemoteListSourceProvider getRemoteListSourceProvider() {
            RemoteListSourceProvider remoteListSourceProvider = this.addonsListSourceProvider;
            Intrinsics.checkNotNull((Object)remoteListSourceProvider);
            return remoteListSourceProvider;
        }

        /*
         * WARNING - void declaration
         */
        @Slow
        @NotNull
        public final RepoManager createRepoManager(@Nullable Path localLocation, @Nullable LocalSourceProvider userProvider) {
            RepoManager result;
            block6: {
                LegacyLocalRepoLoader legacyLocalRepoLoader;
                ConstantSourceProvider it;
                Object[] objectArray = new RepositorySourceProvider[]{this.repositorySourceProvider};
                List sourceProviders = CollectionsKt.mutableListOf((Object[])objectArray);
                ConstantSourceProvider constantSourceProvider = this.prevRepositorySourceProvider;
                if (constantSourceProvider != null) {
                    it = constantSourceProvider;
                    boolean bl = false;
                    sourceProviders.add(it);
                }
                String customSourceUrl = System.getProperty(AndroidSdkHandler.CUSTOM_SOURCE_PROPERTY);
                CharSequence charSequence = customSourceUrl;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    sourceProviders.add(new ConstantSourceProvider(customSourceUrl, "Custom Provider", (Collection)Companion.getAllModules()));
                }
                RemoteListSourceProvider remoteListSourceProvider = this.addonsListSourceProvider;
                if (remoteListSourceProvider != null) {
                    RemoteListSourceProvider it2 = remoteListSourceProvider;
                    boolean bl = false;
                    sourceProviders.add(it2);
                }
                LocalSourceProvider localSourceProvider = userProvider;
                if (localSourceProvider != null) {
                    it = localSourceProvider;
                    boolean bl = false;
                    sourceProviders.add(it);
                }
                RepoManager.Companion companion = RepoManager.Companion;
                Path path = localLocation;
                List<SchemaModule<?>> list = Companion.getAllModules();
                List list2 = sourceProviders;
                Path path2 = localLocation;
                if (path2 != null) {
                    void it3;
                    Path bl = path2;
                    List list3 = list2;
                    List<SchemaModule<?>> list4 = list;
                    Path path3 = path;
                    RepoManager.Companion companion2 = companion;
                    boolean bl2 = false;
                    LegacyLocalRepoLoader legacyLocalRepoLoader2 = new LegacyLocalRepoLoader((Path)it3);
                    companion = companion2;
                    path = path3;
                    list = list4;
                    list2 = list3;
                    legacyLocalRepoLoader = legacyLocalRepoLoader2;
                } else {
                    legacyLocalRepoLoader = null;
                }
                result = companion.createRepoManager(path, list, list2, (FallbackLocalRepoLoader)legacyLocalRepoLoader, (FallbackRemoteRepoLoader)new LegacyRemoteRepoLoader());
                LocalSourceProvider localSourceProvider2 = userProvider;
                if (localSourceProvider2 == null) break block6;
                localSourceProvider2.setRepoManager(result);
            }
            return result;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/android/sdklib/repository/AndroidSdkHandler$RepoConfig$Companion;", "", "<init>", "()V", "getBaseUrl", "", "progress", "Lcom/android/repository/api/ProgressIndicator;", "getAddonListUrl", "getRepoUrl", "version", "", "android.sdktools.sdklib"})
        public static final class Companion {
            private Companion() {
            }

            private final String getBaseUrl(ProgressIndicator progress2) {
                String baseUrl;
                String string = System.getenv(AndroidSdkHandler.SDK_TEST_BASE_URL_ENV_VAR);
                if (string == null) {
                    string = System.getProperty(AndroidSdkHandler.SDK_TEST_BASE_URL_PROPERTY);
                }
                if ((baseUrl = string) != null) {
                    if (((CharSequence)baseUrl).length() > 0 && StringsKt.endsWith$default((String)baseUrl, (String)"/", (boolean)false, (int)2, null)) {
                        return baseUrl;
                    }
                    progress2.logWarning("Ignoring invalid SDK_TEST_BASE_URL: " + baseUrl);
                }
                return AndroidSdkHandler.URL_GOOGLE_SDK_SITE;
            }

            private final String getAddonListUrl(ProgressIndicator progress2) {
                return this.getBaseUrl(progress2) + AndroidSdkHandler.DEFAULT_SITE_LIST_FILENAME_PATTERN;
            }

            private final String getRepoUrl(ProgressIndicator progress2, int version) {
                return this.getBaseUrl(progress2) + "repository2-" + version + ".xml";
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

