/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.ConfigEnum;

public enum GpuMode implements ConfigEnum
{
    AUTO("auto"),
    HOST("host"),
    SWIFT("software"),
    OFF("off");

    private final String mySetting;

    private GpuMode(String setting) {
        this.mySetting = setting;
    }

    public static GpuMode getSoftwareGpuMode(ISystemImage image) {
        return GpuMode.emulatorUsesSwiftFor(image) ? SWIFT : OFF;
    }

    private static boolean emulatorUsesSwiftFor(ISystemImage image) {
        Abi abi = Abi.getEnum(image.getPrimaryAbiType());
        return image.getAndroidVersion().getFeatureLevel() > 22 && abi != null && abi.supportsMultipleCpuCores() && image.hasGoogleApis();
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "Automatic";
            }
            case 1: {
                return "Hardware";
            }
        }
        return "Software";
    }

    public static GpuMode fromGpuSetting(String setting) {
        for (GpuMode mode : GpuMode.values()) {
            if (!mode.mySetting.equals(setting)) continue;
            return mode;
        }
        return OFF;
    }

    public String getGpuSetting() {
        return this.mySetting;
    }

    @Override
    public String getAsParameter() {
        return this.getGpuSetting();
    }
}

