/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.zipcache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.jetbrains.cidr.lang.util.TeamCityLogApi;
import com.jetbrains.cidr.zipcache.CidrZipBackedCache;
import com.jetbrains.cidr.zipcache.CidrZipCache;
import com.jetbrains.cidr.zipcache.InitializationHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 H*\u0006\b\u0000\u0010\u0001 \u0000*\u0006\b\u0001\u0010\u0002 \u0001*\u0006\b\u0002\u0010\u0003 \u00002\u00020\u0004:\u0002GHB\u001f\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0014H\u0014J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\b\u0010(\u001a\u00020\u0016H\u0016J\u0017\u0010)\u001a\u0004\u0018\u00018\u00012\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+J\u0017\u0010,\u001a\u0004\u0018\u00010\"2\u0006\u0010*\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010-J\u001f\u0010.\u001a\u0004\u0018\u00018\u00012\u0006\u0010/\u001a\u00020\u00142\u0006\u0010*\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00100J\f\u00101\u001a\u00020\"*\u00020\"H\u0004J\u000e\u00102\u001a\u000203H\u0097@\u00a2\u0006\u0002\u00104J\u0016\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u0016H\u00a4@\u00a2\u0006\u0002\u00109J\u0016\u0010:\u001a\u0002032\u0006\u0010;\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010<J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010>\u001a\u0002032\u0006\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u00020AH\u0007J\u0010\u0010B\u001a\u0002032\u0006\u0010@\u001a\u00020AH\u0007J\b\u0010C\u001a\u000203H\u0005J\u0010\u0010D\u001a\u0002032\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010E\u001a\u0002032\u000e\b\u0002\u0010F\u001a\b\u0012\u0004\u0012\u0002030\u0006H\u0004R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010#\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u0014\u00105\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006I"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache;", "Key", "Value", "CachingValue", "Lcom/jetbrains/cidr/zipcache/CidrZipCache;", "zipFileNameComputable", "Lkotlin/Function0;", "", "zipCacheVersion", "", "<init>", "(Lkotlin/jvm/functions/Function0;I)V", "getZipCacheVersion", "()I", "zipFileName", "getZipFileName", "()Ljava/lang/String;", "zipFileName$delegate", "Lkotlin/Lazy;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isZipCacheDisabledInTests", "", "initializationHandler", "Lcom/jetbrains/cidr/zipcache/InitializationHandler;", "getInitializationHandler", "()Lcom/jetbrains/cidr/zipcache/InitializationHandler;", "zipCacheRoot", "getZipCacheRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "checkZipIsAcceptable", "zipVirtualFile", "getResourceFolders", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/Path;", "resourcesFolder", "getResourcesFolder", "()Ljava/nio/file/Path;", "downloadedFolder", "getDownloadedFolder", "needsToDownloadCache", "getValue", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getRelativePath", "(Ljava/lang/Object;)Ljava/nio/file/Path;", "readValue", "dir", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;)Ljava/lang/Object;", "withVersion", "initialize", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isInitialized", "()Z", "additionalInitialization", "isFirstInitialization", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "installNewZip", "zip", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "defaultZipLocations", "setZipCacheRootInTests", "path", "disposableParent", "Lcom/intellij/openapi/Disposable;", "disableZipCacheRootInTests", "assertBackgroundThreadForTestMethods", "revertToInitialStateOnDisposal", "revertToInitialState", "additionalAction", "InitializationSession", "Companion", "intellij.cidr.util"})
@SourceDebugExtension(value={"SMAP\nCidrZipBackedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrZipBackedCache.kt\ncom/jetbrains/cidr/zipcache/CidrZipBackedCache\n+ 2 InitializationHandler.kt\ncom/jetbrains/cidr/zipcache/InitializationHandler\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,190:1\n22#2,19:191\n54#2:210\n75#2:211\n89#2:212\n55#2,12:213\n67#2:226\n41#2:227\n40#2:228\n54#2:229\n75#2:230\n89#2:231\n55#2,12:232\n67#2:245\n41#2:246\n19#3:225\n19#3:244\n14#4:247\n*S KotlinDebug\n*F\n+ 1 CidrZipBackedCache.kt\ncom/jetbrains/cidr/zipcache/CidrZipBackedCache\n*L\n77#1:191,19\n77#1:210\n77#1:211\n77#1:212\n77#1:213,12\n77#1:226\n77#1:227\n94#1:228\n94#1:229\n94#1:230\n94#1:231\n94#1:232,12\n94#1:245\n94#1:246\n77#1:225\n94#1:244\n188#1:247\n*E\n"})
public abstract class CidrZipBackedCache<Key, Value, CachingValue>
implements CidrZipCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int zipCacheVersion;
    @NotNull
    private final Lazy zipFileName$delegate;
    @Nullable
    private volatile VirtualFile root;
    private volatile boolean isZipCacheDisabledInTests;
    @NotNull
    private final InitializationHandler initializationHandler;
    @NotNull
    public static final String AUTOMATICALLY_DOWNLOAD_KEY = "com.jetbrains.cidr.ZipCacheDownloader.shouldDownload";
    @JvmField
    public static volatile boolean buildingCache;
    @NotNull
    private static final Logger LOG;

    public CidrZipBackedCache(@NotNull Function0<String> zipFileNameComputable, int zipCacheVersion) {
        Intrinsics.checkNotNullParameter(zipFileNameComputable, (String)"zipFileNameComputable");
        this.zipCacheVersion = zipCacheVersion;
        this.zipFileName$delegate = LazyKt.lazy(zipFileNameComputable);
        this.initializationHandler = new InitializationHandler((Disposable)this);
    }

    @Override
    public int getZipCacheVersion() {
        return this.zipCacheVersion;
    }

    @Override
    @Nullable
    public String getZipFileName() {
        Lazy lazy = this.zipFileName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    protected final InitializationHandler getInitializationHandler() {
        return this.initializationHandler;
    }

    @Override
    @Nullable
    public VirtualFile getZipCacheRoot() {
        return this.root;
    }

    protected boolean checkZipIsAcceptable(@NotNull VirtualFile zipVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)zipVirtualFile, (String)"zipVirtualFile");
        return true;
    }

    private final Sequence<Path> getResourceFolders() {
        Sequence sequence;
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (bl) {
            Object[] objectArray = new Path[2];
            Intrinsics.checkNotNullExpressionValue((Object)Path.of(TeamCityLogApi.Companion.getInstance().getTempDirectory(), new String[0]).resolve("zipCaches"), (String)"resolve(...)");
            objectArray[1] = this.getResourcesFolder();
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (!bl) {
            sequence = SequencesKt.sequenceOf((Object)this.getResourcesFolder());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sequence;
    }

    @NotNull
    public final Path getResourcesFolder() {
        Path path = Path.of(PathManager.getHomePath(), new String[0]).resolve("Resources");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Override
    @NotNull
    public Path getDownloadedFolder() {
        Path path = PathManager.getSystemDir().resolve("DownloadedCaches");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return this.withVersion(path);
    }

    @Override
    public boolean needsToDownloadCache() {
        return !this.isZipCacheDisabledInTests && this.root == null && this.getZipFileName() != null;
    }

    @Nullable
    public Value getValue(Key key) {
        if (!this.isInitialized()) {
            LOG.error("using not initialized cache " + this);
        }
        VirtualFile virtualFile = this.root;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        Path path = this.getRelativePath(key);
        if (path == null) {
            return null;
        }
        Path path2 = path;
        VirtualFile virtualFile2 = root.findFileByRelativePath(((Object)path2).toString());
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile cacheDir = virtualFile2;
        return this.readValue(cacheDir, key);
    }

    @Nullable
    protected abstract Path getRelativePath(Key var1);

    @Nullable
    protected abstract Value readValue(@NotNull VirtualFile var1, Key var2);

    @NotNull
    protected final Path withVersion(@NotNull Path $this$withVersion) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$withVersion, (String)"<this>");
        if (this.getZipCacheVersion() == 1) {
            path = $this$withVersion;
        } else {
            Path path2 = $this$withVersion.resolve(String.valueOf(this.getZipCacheVersion()));
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        }
        return path;
    }

    @Override
    @RequiresReadLockAbsence
    @Nullable
    public Object initialize(@NotNull Continuation<? super Unit> $completion) {
        return CidrZipBackedCache.initialize$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @RequiresReadLockAbsence
    static /* synthetic */ <Key, Value, CachingValue> Object initialize$suspendImpl(CidrZipBackedCache<? super Key, ? extends Value, ? super CachingValue> $this, Continuation<? super Unit> $completion) {
        block16: {
            block17: {
                block18: {
                    block15: {
                        if (!($completion instanceof initialize.1)) ** GOTO lbl-1000
                        var15_2 = $completion;
                        if ((var15_2.label & -2147483648) != 0) {
                            var15_2.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl($this, $completion){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                Object L$4;
                                Object L$5;
                                Object L$6;
                                Object L$7;
                                int I$0;
                                int I$1;
                                int I$2;
                                /* synthetic */ Object result;
                                final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return CidrZipBackedCache.initialize$suspendImpl(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                                }
                            };
                        }
                        $result = $continuation.result;
                        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this_$iv = $this.initializationHandler;
                                $i$f$initialize = 0;
                                state$iv = this_$iv.getInitializationState().get();
                                if (!Intrinsics.areEqual((Object)state$iv, (Object)InitializationHandler.State.Broken.INSTANCE) && !Intrinsics.areEqual((Object)state$iv, (Object)InitializationHandler.State.Initialized.INSTANCE)) {
                                    if (!(state$iv instanceof InitializationHandler.State.Initializing)) break;
                                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)state$iv);
                                    $continuation.I$0 = $i$f$initialize;
                                    $continuation.label = 1;
                                    v0 = ((InitializationHandler.State.Initializing)state$iv).getJob().join($continuation);
                                    if (v0 == var16_4) {
                                        return var16_4;
                                    }
                                }
                                break block16;
                            }
                            case 1: {
                                $i$f$initialize = $continuation.I$0;
                                state$iv = (InitializationHandler.State)$continuation.L$2;
                                this_$iv = (InitializationHandler)$continuation.L$1;
                                $this = (CidrZipBackedCache)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                break block16;
                            }
                        }
                        if (Intrinsics.areEqual((Object)state$iv, (Object)InitializationHandler.State.NotInitialized.INSTANCE)) {
                            this_$iv$iv = this_$iv;
                            $i$f$doInitializationSafely = 0;
                            this_$iv$iv$iv = this_$iv$iv;
                            $i$f$doInitializationSafely = 0;
                            this_$iv$iv$iv$iv = this_$iv$iv$iv;
                            $i$f$createLazyInitializationJob = false;
                            initializationJob$iv$iv$iv = BuildersKt.launch$default((CoroutineScope)this_$iv$iv$iv$iv.getCoroutineScope(), null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this_$iv$iv$iv$iv, null, $this){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ InitializationHandler this$0$inline_fun;
                                final /* synthetic */ CidrZipBackedCache this$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0$inline_fun = $receiver;
                                    this.this$0 = cidrZipBackedCache;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = (CoroutineScope)this.L$0;
                                    var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var4_4 = (Continuation)this;
                                            $this$initialize_u24lambda_u241 = $this$launch;
                                            $i$a$-initialize-CidrZipBackedCache$initialize$2 = 0;
                                            v0 = this.this$0.getZipFileName();
                                            if (v0 == null) ** GOTO lbl19
                                            zipFileName = v0;
                                            $i$a$-let-CidrZipBackedCache$initialize$2$defaultLocations$1 = false;
                                            v1 = CidrZipBackedCache.access$defaultZipLocations(this.this$0, zipFileName);
                                            v0 = v1;
                                            if (v1 != null) ** GOTO lbl20
lbl19:
                                            // 2 sources

                                            v0 = SequencesKt.emptySequence();
lbl20:
                                            // 2 sources

                                            defaultLocations = v0;
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$initialize_u24lambda_u241);
                                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)defaultLocations);
                                            this.I$0 = $i$a$-initialize-CidrZipBackedCache$initialize$2;
                                            this.label = 1;
                                            v2 = new InitializationSession(this.this$0, (Sequence)defaultLocations, false, 2, null).run((Continuation<? super Boolean>)this);
                                            ** if (v2 != var3_3) goto lbl30
lbl29:
                                            // 1 sources

                                            return var3_3;
lbl30:
                                            // 1 sources

                                            ** GOTO lbl41
                                        }
                                        case 1: {
                                            $i$a$-initialize-CidrZipBackedCache$initialize$2 = this.I$0;
                                            defaultLocations = (Sequence)this.L$3;
                                            $this$initialize_u24lambda_u241 = (CoroutineScope)this.L$2;
                                            $completion = (Continuation)this.L$1;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v2 = $result;
lbl41:
                                                // 2 sources

                                                var11_16 = result = ((Boolean)v2).booleanValue();
                                                var12_17 = this.this$0$inline_fun.getInitializationState();
                                                $i$a$-doInitializationSafely-InitializationHandler$doInitializationSafely$2 = false;
                                                var12_17.set(result != false ? (InitializationHandler.State)InitializationHandler.State.Initialized.INSTANCE : (InitializationHandler.State)InitializationHandler.State.Broken.INSTANCE);
                                            }
                                            catch (Throwable e) {
                                                this.this$0$inline_fun.getInitializationState().set(InitializationHandler.State.Broken.INSTANCE);
                                                if (e instanceof ControlFlowException) {
                                                    throw e;
                                                }
                                                CidrZipBackedCache.Companion.getLOG().error(e);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null);
                            initializingState$iv$iv$iv = new InitializationHandler.State.Initializing(initializationJob$iv$iv$iv);
lbl45:
                            // 4 sources

                            while (true) {
                                if (!this_$iv$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.NotInitialized.INSTANCE, initializingState$iv$iv$iv) && !this_$iv$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Initialized.INSTANCE, initializingState$iv$iv$iv) && !this_$iv$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Broken.INSTANCE, initializingState$iv$iv$iv)) break block15;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)state$iv);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv$iv);
                                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)initializingState$iv$iv$iv);
                                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)initializationJob$iv$iv$iv);
                                $continuation.L$7 = null;
                                $continuation.I$0 = $i$f$initialize;
                                $continuation.I$1 = $i$f$doInitializationSafely;
                                $continuation.I$2 = $i$f$doInitializationSafely;
                                $continuation.label = 2;
                                v1 = initializationJob$iv$iv$iv.join($continuation);
                                if (v1 == var16_4) {
                                    return var16_4;
                                }
                                break block16;
                                break;
                            }
                        }
                        break block17;
                        {
                            case 2: {
                                $i$f$doInitializationSafely = $continuation.I$2;
                                $i$f$doInitializationSafely = $continuation.I$1;
                                $i$f$initialize = $continuation.I$0;
                                initializationJob$iv$iv$iv = (Job)$continuation.L$6;
                                initializingState$iv$iv$iv = (InitializationHandler.State.Initializing)$continuation.L$5;
                                this_$iv$iv$iv = (InitializationHandler)$continuation.L$4;
                                this_$iv$iv = (InitializationHandler)$continuation.L$3;
                                state$iv = (InitializationHandler.State)$continuation.L$2;
                                this_$iv = (InitializationHandler)$continuation.L$1;
                                $this = (CidrZipBackedCache)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                break block16;
                            }
                        }
                    }
                    $this$asSafely$iv$iv$iv$iv = this_$iv$iv$iv.getInitializationState().get();
                    $i$f$asSafely = false;
                    v2 = $this$asSafely$iv$iv$iv$iv;
                    if (!(v2 instanceof InitializationHandler.State.Initializing)) {
                        v2 = null;
                    }
                    v3 = (InitializationHandler.State.Initializing)v2;
                    v4 = currentInitializationJob$iv$iv$iv = v3 != null ? v3.getJob() : null;
                    if (v4 == null) break block18;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)state$iv);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                    $continuation.L$4 = this_$iv$iv$iv;
                    $continuation.L$5 = initializingState$iv$iv$iv;
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)currentInitializationJob$iv$iv$iv);
                    $continuation.L$7 = initializationJob$iv$iv$iv;
                    $continuation.I$0 = $i$f$initialize;
                    $continuation.I$1 = $i$f$doInitializationSafely;
                    $continuation.I$2 = $i$f$doInitializationSafely;
                    $continuation.label = 3;
                    v5 = v4.join($continuation);
                    if (v5 == var16_4) {
                        return var16_4;
                    }
                    ** GOTO lbl45
                    {
                        case 3: {
                            $i$f$doInitializationSafely = $continuation.I$2;
                            $i$f$doInitializationSafely = $continuation.I$1;
                            $i$f$initialize = $continuation.I$0;
                            initializationJob$iv$iv$iv = (Job)$continuation.L$7;
                            currentInitializationJob$iv$iv$iv = (Job)$continuation.L$6;
                            initializingState$iv$iv$iv = (InitializationHandler.State.Initializing)$continuation.L$5;
                            this_$iv$iv$iv = (InitializationHandler)$continuation.L$4;
                            this_$iv$iv = (InitializationHandler)$continuation.L$3;
                            state$iv = (InitializationHandler.State)$continuation.L$2;
                            this_$iv = (InitializationHandler)$continuation.L$1;
                            $this = (CidrZipBackedCache)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
                            ** GOTO lbl45
                        }
                    }
                }
                ** while (true)
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean isInitialized() {
        return this.initializationHandler.isInitialized();
    }

    @Nullable
    protected abstract Object additionalInitialization(boolean var1, @NotNull Continuation<? super Boolean> var2);

    @Override
    @Nullable
    public Object installNewZip(@NotNull Path zip, @NotNull Continuation<? super Unit> $completion) {
        return CidrZipBackedCache.installNewZip$suspendImpl(this, zip, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ <Key, Value, CachingValue> Object installNewZip$suspendImpl(CidrZipBackedCache<? super Key, ? extends Value, ? super CachingValue> $this, Path zip, Continuation<? super Unit> $completion) {
        block12: {
            block13: {
                if (!($completion instanceof installNewZip.1)) ** GOTO lbl-1000
                var13_3 = $completion;
                if ((var13_3.label & -2147483648) != 0) {
                    var13_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl($this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        int I$0;
                        int I$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return CidrZipBackedCache.installNewZip$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if ($this.getZipFileName() == null) {
                            CidrZipBackedCache.LOG.error("trying to install a zip for " + $this + " which cannot have a zip");
                            return Unit.INSTANCE;
                        }
                        this_$iv = $this.initializationHandler;
                        $i$f$doInitializationSafely = 0;
                        this_$iv$iv = this_$iv;
                        $i$f$doInitializationSafely = 0;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$createLazyInitializationJob = false;
                        initializationJob$iv$iv = BuildersKt.launch$default((CoroutineScope)this_$iv$iv$iv.getCoroutineScope(), null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this_$iv$iv$iv, null, $this, zip){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ InitializationHandler this$0$inline_fun;
                            final /* synthetic */ CidrZipBackedCache this$0;
                            final /* synthetic */ Path $zip$inlined;
                            Object L$1;
                            Object L$2;
                            int I$0;
                            {
                                this.this$0$inline_fun = $receiver;
                                this.this$0 = cidrZipBackedCache;
                                this.$zip$inlined = path;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (CoroutineScope)this.L$0;
                                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var4_4 = (Continuation)this;
                                        $this$installNewZip_u24lambda_u242 = $this$launch;
                                        $i$a$-doInitializationSafely-CidrZipBackedCache$installNewZip$2 = 0;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$installNewZip_u24lambda_u242);
                                        this.I$0 = $i$a$-doInitializationSafely-CidrZipBackedCache$installNewZip$2;
                                        this.label = 1;
                                        v0 = new InitializationSession(this.this$0, (Sequence<? extends Path>)SequencesKt.sequenceOf((Object)this.$zip$inlined), false).run((Continuation<? super Boolean>)this);
                                        ** if (v0 != var3_3) goto lbl19
lbl18:
                                        // 1 sources

                                        return var3_3;
lbl19:
                                        // 1 sources

                                        ** GOTO lbl29
                                    }
                                    case 1: {
                                        $i$a$-doInitializationSafely-CidrZipBackedCache$installNewZip$2 = this.I$0;
                                        $this$installNewZip_u24lambda_u242 = (CoroutineScope)this.L$2;
                                        $completion = (Continuation)this.L$1;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl29:
                                            // 2 sources

                                            var8_12 = result = ((Boolean)v0).booleanValue();
                                            var9_13 = this.this$0$inline_fun.getInitializationState();
                                            $i$a$-doInitializationSafely-InitializationHandler$doInitializationSafely$2 = false;
                                            var9_13.set(result != false ? (InitializationHandler.State)InitializationHandler.State.Initialized.INSTANCE : (InitializationHandler.State)InitializationHandler.State.Broken.INSTANCE);
                                        }
                                        catch (Throwable e) {
                                            this.this$0$inline_fun.getInitializationState().set(InitializationHandler.State.Broken.INSTANCE);
                                            if (e instanceof ControlFlowException) {
                                                throw e;
                                            }
                                            CidrZipBackedCache.Companion.getLOG().error(e);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        initializingState$iv$iv = new InitializationHandler.State.Initializing(initializationJob$iv$iv);
lbl25:
                        // 4 sources

                        while (true) {
                            if (!this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.NotInitialized.INSTANCE, initializingState$iv$iv) && !this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Initialized.INSTANCE, initializingState$iv$iv) && !this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Broken.INSTANCE, initializingState$iv$iv)) break block0;
                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)zip);
                            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)initializingState$iv$iv);
                            $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)initializationJob$iv$iv);
                            $continuation.L$6 = null;
                            $continuation.I$0 = $i$f$doInitializationSafely;
                            $continuation.I$1 = $i$f$doInitializationSafely;
                            $continuation.label = 1;
                            v0 = initializationJob$iv$iv.join($continuation);
                            if (v0 == var14_5) {
                                return var14_5;
                            }
                            break block12;
                            break;
                        }
                    }
                    case 1: {
                        $i$f$doInitializationSafely = $continuation.I$1;
                        $i$f$doInitializationSafely = $continuation.I$0;
                        initializationJob$iv$iv = (Job)$continuation.L$5;
                        initializingState$iv$iv = (InitializationHandler.State.Initializing)$continuation.L$4;
                        this_$iv$iv = (InitializationHandler)$continuation.L$3;
                        this_$iv = (InitializationHandler)$continuation.L$2;
                        zip = (Path)$continuation.L$1;
                        $this = (CidrZipBackedCache)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        break block12;
                    }
                }
                $this$asSafely$iv$iv$iv = this_$iv$iv.getInitializationState().get();
                $i$f$asSafely = false;
                v1 = $this$asSafely$iv$iv$iv;
                if (!(v1 instanceof InitializationHandler.State.Initializing)) {
                    v1 = null;
                }
                v2 = (InitializationHandler.State.Initializing)v1;
                v3 = currentInitializationJob$iv$iv = v2 != null ? v2.getJob() : null;
                if (v3 == null) break block13;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)zip);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                $continuation.L$3 = this_$iv$iv;
                $continuation.L$4 = initializingState$iv$iv;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)currentInitializationJob$iv$iv);
                $continuation.L$6 = initializationJob$iv$iv;
                $continuation.I$0 = $i$f$doInitializationSafely;
                $continuation.I$1 = $i$f$doInitializationSafely;
                $continuation.label = 2;
                v4 = v3.join($continuation);
                if (v4 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl25
                {
                    case 2: {
                        $i$f$doInitializationSafely = $continuation.I$1;
                        $i$f$doInitializationSafely = $continuation.I$0;
                        initializationJob$iv$iv = (Job)$continuation.L$6;
                        currentInitializationJob$iv$iv = (Job)$continuation.L$5;
                        initializingState$iv$iv = (InitializationHandler.State.Initializing)$continuation.L$4;
                        this_$iv$iv = (InitializationHandler)$continuation.L$3;
                        this_$iv = (InitializationHandler)$continuation.L$2;
                        zip = (Path)$continuation.L$1;
                        $this = (CidrZipBackedCache)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        ** GOTO lbl25
                    }
                }
            }
            ** while (true)
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Sequence<Path> defaultZipLocations(String zipFileName) {
        return SequencesKt.map((Sequence)SequencesKt.plus(this.getResourceFolders(), (Sequence)SequencesKt.sequenceOf((Object)this.getDownloadedFolder())), arg_0 -> CidrZipBackedCache.defaultZipLocations$lambda$3(zipFileName, arg_0));
    }

    @TestOnly
    public final void setZipCacheRootInTests(@NotNull Path path, @NotNull Disposable disposableParent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        this.revertToInitialStateOnDisposal(disposableParent);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, path, null){
            int label;
            final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
            final /* synthetic */ Path $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.installNewZip(this.$path, (Continuation<Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @TestOnly
    @RequiresBackgroundThread
    public final void disableZipCacheRootInTests(@NotNull Disposable disposableParent) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        this.assertBackgroundThreadForTestMethods();
        this.revertToInitialStateOnDisposal(disposableParent);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block11: {
                    block12: {
                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block0 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = this.this$0.initialize((Continuation<Unit>)((Continuation)this));
                                if (v0 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                var2_3 = this.this$0.getInitializationHandler();
                                var3_5 = this.this$0;
                                $i$f$doInitializationSafely = 0;
                                this_$iv$iv = this_$iv;
                                $i$f$doInitializationSafely = 0;
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$createLazyInitializationJob = false;
                                initializationJob$iv$iv = BuildersKt.launch$default((CoroutineScope)this_$iv$iv$iv.getCoroutineScope(), null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((InitializationHandler)this_$iv$iv$iv, null, var3_5){
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ InitializationHandler this$0$inline_fun;
                                    final /* synthetic */ CidrZipBackedCache this$0;
                                    {
                                        this.this$0$inline_fun = $receiver;
                                        this.this$0 = cidrZipBackedCache;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                try {
                                                    void result;
                                                    boolean result2;
                                                    void $this$launch;
                                                    Continuation continuation = (Continuation)this;
                                                    void $this$invokeSuspend_u24lambda_u240 = $this$launch;
                                                    boolean bl = false;
                                                    CidrZipBackedCache.access$setRoot$p(this.this$0, null);
                                                    CidrZipBackedCache.access$setZipCacheDisabledInTests$p(this.this$0, true);
                                                    boolean bl2 = result2 = true;
                                                    AtomicReference<InitializationHandler.State> atomicReference = this.this$0$inline_fun.getInitializationState();
                                                    boolean bl3 = false;
                                                    atomicReference.set(result != false ? (InitializationHandler.State)InitializationHandler.State.Initialized.INSTANCE : (InitializationHandler.State)InitializationHandler.State.Broken.INSTANCE);
                                                }
                                                catch (Throwable e) {
                                                    this.this$0$inline_fun.getInitializationState().set(InitializationHandler.State.Broken.INSTANCE);
                                                    if (e instanceof ControlFlowException) {
                                                        throw e;
                                                    }
                                                    CidrZipBackedCache.Companion.getLOG().error(e);
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)1, null);
                                initializingState$iv$iv = new InitializationHandler.State.Initializing(initializationJob$iv$iv);
lbl24:
                                // 4 sources

                                while (true) {
                                    if (!this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.NotInitialized.INSTANCE, initializingState$iv$iv) && !this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Initialized.INSTANCE, initializingState$iv$iv) && !this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Broken.INSTANCE, initializingState$iv$iv)) break block0;
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)initializingState$iv$iv);
                                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)initializationJob$iv$iv);
                                    this.L$4 = null;
                                    this.I$0 = $i$f$doInitializationSafely;
                                    this.I$1 = $i$f$doInitializationSafely;
                                    this.label = 2;
                                    v1 = initializationJob$iv$iv.join((Continuation)this);
                                    if (v1 == var12_2) {
                                        return var12_2;
                                    }
                                    break block11;
                                    break;
                                }
                            }
                            case 2: {
                                $i$f$doInitializationSafely = this.I$1;
                                $i$f$doInitializationSafely = this.I$0;
                                initializationJob$iv$iv = (Job)this.L$3;
                                initializingState$iv$iv = (InitializationHandler.State.Initializing)this.L$2;
                                this_$iv$iv = (InitializationHandler)this.L$1;
                                this_$iv = (InitializationHandler)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                break block11;
                            }
                        }
                        $this$asSafely$iv$iv$iv = this_$iv$iv.getInitializationState().get();
                        $i$f$asSafely = false;
                        v2 = $this$asSafely$iv$iv$iv;
                        if (!(v2 instanceof InitializationHandler.State.Initializing)) {
                            v2 = null;
                        }
                        v3 = (InitializationHandler.State.Initializing)v2;
                        v4 = currentInitializationJob$iv$iv = v3 != null ? v3.getJob() : null;
                        if (v4 == null) break block12;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                        this.L$1 = this_$iv$iv;
                        this.L$2 = initializingState$iv$iv;
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)currentInitializationJob$iv$iv);
                        this.L$4 = initializationJob$iv$iv;
                        this.I$0 = $i$f$doInitializationSafely;
                        this.I$1 = $i$f$doInitializationSafely;
                        this.label = 3;
                        v5 = v4.join((Continuation)this);
                        if (v5 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl24
                        {
                            case 3: {
                                $i$f$doInitializationSafely = this.I$1;
                                $i$f$doInitializationSafely = this.I$0;
                                initializationJob$iv$iv = (Job)this.L$4;
                                currentInitializationJob$iv$iv = (Job)this.L$3;
                                initializingState$iv$iv = (InitializationHandler.State.Initializing)this.L$2;
                                this_$iv$iv = (InitializationHandler)this.L$1;
                                this_$iv = (InitializationHandler)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
                                ** GOTO lbl24
                            }
                        }
                    }
                    ** while (true)
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @TestOnly
    protected final void assertBackgroundThreadForTestMethods() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
    }

    private final void revertToInitialStateOnDisposal(Disposable disposableParent) {
        Disposer.register((Disposable)disposableParent, () -> CidrZipBackedCache.revertToInitialStateOnDisposal$lambda$4(this));
    }

    protected final void revertToInitialState(@NotNull Function0<Unit> additionalAction) {
        Intrinsics.checkNotNullParameter(additionalAction, (String)"additionalAction");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, additionalAction, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
            final /* synthetic */ Function0<Unit> $additionalAction;
            {
                this.this$0 = $receiver;
                this.$additionalAction = $additionalAction;
                super(2, $completion);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                Object object;
                Job currentInitializationJob$iv$iv;
                Object object2;
                InitializationHandler.State.Initializing initializingState$iv$iv;
                Job initializationJob$iv$iv;
                int $i$f$doInitializationSafely;
                InitializationHandler this_$iv$iv;
                InitializationHandler this_$iv;
                int $i$f$revertToInitialState;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        InitializationHandler initializationHandler = this.this$0.getInitializationHandler();
                        CidrZipBackedCache<Key, Value, CachingValue> cidrZipBackedCache = this.this$0;
                        Function0<Unit> function0 = this.$additionalAction;
                        $i$f$revertToInitialState = 0;
                        this_$iv$iv = this_$iv;
                        $i$f$doInitializationSafely = 0;
                        void this_$iv$iv$iv = this_$iv$iv;
                        boolean $i$f$createLazyInitializationJob = false;
                        initializationJob$iv$iv = BuildersKt.launch$default((CoroutineScope)this_$iv$iv$iv.getCoroutineScope(), null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((InitializationHandler)this_$iv$iv$iv, null, cidrZipBackedCache, function0){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ InitializationHandler this$0$inline_fun;
                            final /* synthetic */ CidrZipBackedCache this$0;
                            final /* synthetic */ Function0 $additionalAction$inlined;
                            {
                                this.this$0$inline_fun = $receiver;
                                this.this$0 = cidrZipBackedCache;
                                this.$additionalAction$inlined = function0;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        try {
                                            boolean result;
                                            void $this$launch;
                                            Continuation continuation = (Continuation)this;
                                            void $this$invokeSuspend_u24lambda_u240 = $this$launch;
                                            boolean bl = false;
                                            CidrZipBackedCache.access$setZipCacheDisabledInTests$p(this.this$0, false);
                                            this.$additionalAction$inlined.invoke();
                                            boolean bl2 = result = true;
                                            AtomicReference<InitializationHandler.State> atomicReference = this.this$0$inline_fun.getInitializationState();
                                            boolean bl3 = false;
                                            atomicReference.set(InitializationHandler.State.NotInitialized.INSTANCE);
                                        }
                                        catch (Throwable e) {
                                            this.this$0$inline_fun.getInitializationState().set(InitializationHandler.State.Broken.INSTANCE);
                                            if (e instanceof ControlFlowException) {
                                                throw e;
                                            }
                                            CidrZipBackedCache.Companion.getLOG().error(e);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        initializingState$iv$iv = new InitializationHandler.State.Initializing(initializationJob$iv$iv);
                        break;
                    }
                    case 1: {
                        int $i$f$doInitializationSafely2 = this.I$1;
                        int $i$f$revertToInitialState2 = this.I$0;
                        Job initializationJob$iv$iv2 = (Job)this.L$3;
                        InitializationHandler.State.Initializing initializingState$iv$iv2 = (InitializationHandler.State.Initializing)this.L$2;
                        InitializationHandler this_$iv$iv2 = (InitializationHandler)this.L$1;
                        InitializationHandler this_$iv2 = (InitializationHandler)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object2 = $result;
                        return Unit.INSTANCE;
                    }
                    case 2: {
                        $i$f$doInitializationSafely = this.I$1;
                        $i$f$revertToInitialState = this.I$0;
                        initializationJob$iv$iv = (Job)this.L$4;
                        currentInitializationJob$iv$iv = (Job)this.L$3;
                        initializingState$iv$iv = (InitializationHandler.State.Initializing)this.L$2;
                        this_$iv$iv = (InitializationHandler)this.L$1;
                        this_$iv = (InitializationHandler)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (true) {
                    if (this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.NotInitialized.INSTANCE, initializingState$iv$iv) || this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Initialized.INSTANCE, initializingState$iv$iv) || this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Broken.INSTANCE, initializingState$iv$iv)) {
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv$iv);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)initializingState$iv$iv);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)initializationJob$iv$iv);
                        this.L$4 = null;
                        this.I$0 = $i$f$revertToInitialState;
                        this.I$1 = $i$f$doInitializationSafely;
                        this.label = 1;
                        Object object4 = initializationJob$iv$iv.join((Continuation)this);
                        object2 = object4;
                        if (object4 != object3) return Unit.INSTANCE;
                        return object3;
                    }
                    InitializationHandler.State $this$asSafely$iv$iv$iv = this_$iv$iv.getInitializationState().get();
                    boolean $i$f$asSafely = false;
                    InitializationHandler.State state = $this$asSafely$iv$iv$iv;
                    if (!(state instanceof InitializationHandler.State.Initializing)) {
                        state = null;
                    }
                    InitializationHandler.State.Initializing initializing = (InitializationHandler.State.Initializing)state;
                    Job job = currentInitializationJob$iv$iv = initializing != null ? initializing.getJob() : null;
                    if (job == null) continue;
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                    this.L$1 = this_$iv$iv;
                    this.L$2 = initializingState$iv$iv;
                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)currentInitializationJob$iv$iv);
                    this.L$4 = initializationJob$iv$iv;
                    this.I$0 = $i$f$revertToInitialState;
                    this.I$1 = $i$f$doInitializationSafely;
                    this.label = 2;
                    object = job.join((Continuation)this);
                    if (object == object3) break;
                }
                return object3;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void revertToInitialState$default(CidrZipBackedCache cidrZipBackedCache, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: revertToInitialState");
        }
        if ((n & 1) != 0) {
            function0 = CidrZipBackedCache::revertToInitialState$lambda$5;
        }
        cidrZipBackedCache.revertToInitialState((Function0<Unit>)function0);
    }

    private static final Path defaultZipLocations$lambda$3(String $zipFileName, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.resolve($zipFileName);
    }

    private static final void revertToInitialStateOnDisposal$lambda$4(CidrZipBackedCache this$0) {
        CidrZipBackedCache.revertToInitialState$default(this$0, null, 1, null);
    }

    private static final Unit revertToInitialState$lambda$5() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setZipCacheDisabledInTests$p(CidrZipBackedCache $this, boolean bl) {
        $this.isZipCacheDisabledInTests = bl;
    }

    public static final /* synthetic */ Sequence access$defaultZipLocations(CidrZipBackedCache $this, String zipFileName) {
        return $this.defaultZipLocations(zipFileName);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CidrZipBackedCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache$Companion;", "", "<init>", "()V", "AUTOMATICALLY_DOWNLOAD_KEY", "", "buildingCache", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cidr.util"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\u0006H\u0086@\u00a2\u0006\u0002\u0010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0003R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache$InitializationSession;", "", "possibleZipLocations", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/Path;", "isFirstInitialization", "", "<init>", "(Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache;Lkotlin/sequences/Sequence;Z)V", "getPossibleZipLocations", "()Lkotlin/sequences/Sequence;", "()Z", "run", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeZip", "Lcom/intellij/openapi/vfs/VirtualFile;", "getZipVirtualFile", "zip", "intellij.cidr.util"})
    @SourceDebugExtension(value={"SMAP\nCidrZipBackedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrZipBackedCache.kt\ncom/jetbrains/cidr/zipcache/CidrZipBackedCache$InitializationSession\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n183#2,2:191\n1#3:193\n*S KotlinDebug\n*F\n+ 1 CidrZipBackedCache.kt\ncom/jetbrains/cidr/zipcache/CidrZipBackedCache$InitializationSession\n*L\n114#1:191,2\n*E\n"})
    private final class InitializationSession {
        @NotNull
        private final Sequence<Path> possibleZipLocations;
        private final boolean isFirstInitialization;
        final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;

        public InitializationSession(@NotNull CidrZipBackedCache this$0, Sequence<? extends Path> possibleZipLocations, boolean isFirstInitialization) {
            Intrinsics.checkNotNullParameter(possibleZipLocations, (String)"possibleZipLocations");
            this.this$0 = this$0;
            this.possibleZipLocations = possibleZipLocations;
            this.isFirstInitialization = isFirstInitialization;
        }

        public /* synthetic */ InitializationSession(CidrZipBackedCache cidrZipBackedCache, Sequence sequence, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(cidrZipBackedCache, (Sequence<? extends Path>)sequence, bl);
        }

        @NotNull
        public final Sequence<Path> getPossibleZipLocations() {
            return this.possibleZipLocations;
        }

        public final boolean isFirstInitialization() {
            return this.isFirstInitialization;
        }

        @Nullable
        public final Object run(@NotNull Continuation<? super Boolean> $completion) {
            Companion.getLOG().assertTrue(!this.this$0.isZipCacheDisabledInTests, (Object)"should never happen");
            this.this$0.root = this.initializeZip();
            return this.this$0.additionalInitialization(this.isFirstInitialization, $completion);
        }

        private final VirtualFile initializeZip() {
            Object object;
            Object v1;
            block4: {
                Sequence<Path> $this$firstOrNull$iv = this.possibleZipLocations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            Path path = v1;
            if (path == null) {
                return null;
            }
            Path zip = path;
            VirtualFile virtualFile = this.getZipVirtualFile(zip);
            if (virtualFile != null) {
                VirtualFile virtualFile2 = virtualFile;
                CidrZipBackedCache cidrZipBackedCache = this.this$0;
                VirtualFile it = virtualFile2;
                boolean bl = false;
                object = cidrZipBackedCache.checkZipIsAcceptable(it) ? virtualFile2 : null;
            } else {
                object = null;
            }
            return object;
        }

        @RequiresReadLockAbsence
        private final VirtualFile getZipVirtualFile(Path zip) {
            VirtualFile virtualFile = VfsUtil.findFile((Path)zip, (boolean)true);
            if (virtualFile == null) {
                InitializationSession initializationSession = this;
                CidrZipBackedCache cidrZipBackedCache = this.this$0;
                InitializationSession $this$getZipVirtualFile_u24lambda_u242 = initializationSession;
                boolean bl = false;
                Companion.getLOG().error("Failed to get virtual file of " + cidrZipBackedCache.getZipFileName());
                return null;
            }
            VirtualFile zipVF = virtualFile;
            VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(zipVF);
            if (virtualFile2 == null) {
                InitializationSession initializationSession = this;
                CidrZipBackedCache cidrZipBackedCache = this.this$0;
                InitializationSession $this$getZipVirtualFile_u24lambda_u243 = initializationSession;
                boolean bl = false;
                Companion.getLOG().error("Failed to get jar root for " + cidrZipBackedCache.getZipFileName());
                return null;
            }
            VirtualFile cacheRoot = virtualFile2;
            Companion.getLOG().info(this.this$0.getClass().getSimpleName() + " uses zip cache " + cacheRoot.getCanonicalPath());
            return cacheRoot;
        }
    }
}

